/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.crud.mongo;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.redhat.lightblue.crud.CRUDOperationContext;
import com.redhat.lightblue.crud.CRUDUpdateResponse;
import com.redhat.lightblue.crud.DocCtx;
import com.redhat.lightblue.crud.Operation;
import com.redhat.lightblue.crud.mongo.DocUpdater;
import com.redhat.lightblue.crud.mongo.Translator;
import com.redhat.lightblue.eval.FieldAccessRoleEvaluator;
import com.redhat.lightblue.eval.Projector;
import com.redhat.lightblue.interceptor.InterceptPoint;
import com.redhat.lightblue.metadata.EntityMetadata;
import com.redhat.lightblue.mongo.hystrix.FindAndModifyCommand;
import com.redhat.lightblue.mongo.hystrix.FindCommand;
import com.redhat.lightblue.util.Error;
import com.redhat.lightblue.util.Path;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicIterateUpdate
implements DocUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtomicIterateUpdate.class);
    private final JsonNodeFactory nodeFactory;
    private final FieldAccessRoleEvaluator roleEval;
    private final Translator translator;
    private final DBObject mongoUpdateExpr;
    private final Projector projector;
    private final Set<Path> updatedFields;

    public AtomicIterateUpdate(JsonNodeFactory nodeFactory, FieldAccessRoleEvaluator roleEval, Translator translator, DBObject mongoUpdateExpr, Projector projector, Set<Path> updatedFields) {
        this.nodeFactory = nodeFactory;
        this.roleEval = roleEval;
        this.translator = translator;
        this.mongoUpdateExpr = mongoUpdateExpr;
        this.projector = projector;
        this.updatedFields = updatedFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(CRUDOperationContext ctx, DBCollection collection, EntityMetadata md, CRUDUpdateResponse response, DBObject query) {
        LOGGER.debug("atomicIterateUpdate: start");
        Set inaccessibleFields = this.roleEval.getInaccessibleFields(FieldAccessRoleEvaluator.Operation.update);
        for (Path x : inaccessibleFields) {
            if (!this.updatedFields.contains(x)) continue;
            ctx.addError(Error.get((String)"update", (String)"crud:update:NoFieldAccess", (String)x.toString()));
        }
        int numFailed = 0;
        int numUpdated = 0;
        if (!ctx.hasErrors()) {
            LOGGER.debug("Computing the result set for {}", (Object)query);
            int docIndex = 0;
            try (DBCursor cursor = null;){
                ctx.getFactory().getInterceptors().callInterceptors(InterceptPoint.PRE_CRUD_UPDATE_RESULTSET, ctx);
                cursor = (DBCursor)new FindCommand(collection, query, null).execute();
                LOGGER.debug("Found {} documents", (Object)cursor.count());
                ctx.getFactory().getInterceptors().callInterceptors(InterceptPoint.POST_CRUD_UPDATE_RESULTSET, ctx);
                while (cursor.hasNext()) {
                    DBObject document = cursor.next();
                    DocCtx doc = ctx.addDocument(this.translator.toJson(document));
                    try {
                        Object id = document.get("_id");
                        LOGGER.debug("Retrieved doc {} id={}", (Object)docIndex, id);
                        ctx.getFactory().getInterceptors().callInterceptors(InterceptPoint.PRE_CRUD_UPDATE_DOC, ctx, doc);
                        DBObject modifiedDoc = (DBObject)new FindAndModifyCommand(collection, (DBObject)new BasicDBObject("_id", id), null, null, false, this.mongoUpdateExpr, true, false).execute();
                        if (this.projector != null) {
                            LOGGER.debug("Projecting document {}", (Object)docIndex);
                            doc.setOutputDocument(this.projector.project(this.translator.toJson(modifiedDoc), this.nodeFactory));
                            doc.setOperationPerformed(Operation.UPDATE);
                        }
                        ctx.getFactory().getInterceptors().callInterceptors(InterceptPoint.POST_CRUD_UPDATE_DOC, ctx, doc);
                        ++numUpdated;
                    }
                    catch (MongoException e) {
                        LOGGER.warn("Update exception for document {}: {}", (Object)docIndex, (Object)e);
                        doc.addError(Error.get((String)"mongo-crud:UpdateError", (String)e.toString()));
                        ++numFailed;
                    }
                    ++docIndex;
                }
            }
        }
        response.setNumUpdated(numUpdated);
        response.setNumFailed(numFailed);
    }
}

