/*
 * Decompiled with CFR 0.152.
 */
package redgatesqlci;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import redgatesqlci.GenerateTestData;
import redgatesqlci.RunTestSet;
import redgatesqlci.Server;
import redgatesqlci.SqlChangeAutomationVersionOption;
import redgatesqlci.SqlContinuousIntegrationBuilder;
import redgatesqlci.TestSource;

public class TestBuilder
extends SqlContinuousIntegrationBuilder {
    private final TestSource.TestSourceOption testSource;
    private final String projectPath;
    private final String packageid;
    private final String tempServer;
    private final String serverName;
    private final String dbName;
    private final String serverAuth;
    private final String username;
    private Secret password;
    private final boolean encryptConnection;
    private final boolean trustServerCertificate;
    private final String options;
    private final String dataOptions;
    private final String filter;
    private final String runOnlyParams;
    private final String runTestSet;
    private final String generateTestData;
    private final String sqlgenPath;
    private final String packageVersion;
    private final SqlChangeAutomationVersionOption sqlChangeAutomationVersionOption;

    public TestSource.TestSourceOption getTestSource() {
        return Optional.ofNullable(this.testSource).orElse(TestSource.TestSourceOption.socartifact);
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public String getPackageid() {
        return this.packageid;
    }

    public String getTempServer() {
        return this.tempServer;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getServerAuth() {
        return this.serverAuth;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(Secret password) {
        this.password = password;
    }

    public Secret getPassword() {
        return this.password;
    }

    public boolean getEncryptConnection() {
        return this.encryptConnection;
    }

    public boolean getTrustServerCertificate() {
        return this.trustServerCertificate;
    }

    public String getOptions() {
        return this.options;
    }

    public String getDataOptions() {
        return this.dataOptions;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getRunOnlyParams() {
        return this.runOnlyParams;
    }

    public String getRunTestSet() {
        return this.runTestSet;
    }

    public String getGenerateTestData() {
        return this.generateTestData;
    }

    public String getSqlgenPath() {
        return this.sqlgenPath;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public SqlChangeAutomationVersionOption getSqlChangeAutomationVersionOption() {
        return this.sqlChangeAutomationVersionOption;
    }

    @DataBoundConstructor
    public TestBuilder(String packageid, Server tempServer, RunTestSet runTestSet, GenerateTestData generateTestData, String options, String dataOptions, String filter, String packageVersion, SqlChangeAutomationVersionOption sqlChangeAutomationVersionOption, TestSource testSource) {
        if (testSource == null) {
            this.testSource = TestSource.TestSourceOption.socartifact;
            this.projectPath = null;
            this.packageid = packageid;
            this.packageVersion = packageVersion;
        } else {
            this.testSource = testSource.getOption();
            this.projectPath = testSource.getProjectPath();
            this.packageid = testSource.getPackageid();
            this.packageVersion = testSource.getProjectPath();
        }
        this.tempServer = tempServer.getvalue();
        this.runTestSet = runTestSet.getvalue();
        this.generateTestData = generateTestData == null ? null : "true";
        this.sqlChangeAutomationVersionOption = sqlChangeAutomationVersionOption;
        if ("sqlServer".equals(this.tempServer)) {
            this.dbName = tempServer.getDbName();
            this.serverName = tempServer.getServerName();
            this.serverAuth = tempServer.getServerAuth().getvalue();
            this.username = tempServer.getServerAuth().getUsername();
            this.password = tempServer.getServerAuth().getPassword();
            this.encryptConnection = tempServer.getEncryptConnection();
            this.trustServerCertificate = tempServer.getTrustServerCertificate();
        } else {
            this.dbName = "";
            this.serverName = "";
            this.serverAuth = null;
            this.username = "";
            this.password = Secret.fromString((String)"");
            this.encryptConnection = false;
            this.trustServerCertificate = false;
        }
        this.runOnlyParams = "runOnlyTest".equals(this.runTestSet) ? runTestSet.getRunOnlyParams() : "";
        this.sqlgenPath = this.generateTestData != null ? generateTestData.getSqlgenPath() : "";
        this.options = options;
        this.dataOptions = dataOptions;
        this.filter = filter;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        ArrayList<String> params = new ArrayList<String>();
        String buildNumber = "1.0." + Integer.toString(build.getNumber());
        if (StringUtils.isNotEmpty((String)this.getPackageVersion())) {
            buildNumber = this.getPackageVersion();
        }
        params.add("Test");
        FilePath checkOutPath = build.getWorkspace();
        if (checkOutPath == null) {
            return false;
        }
        this.addTestSourceParameter(params, checkOutPath, buildNumber);
        if ("sqlServer".equals(this.getTempServer())) {
            params.add("-temporaryDatabaseServer");
            params.add(this.getServerName());
            if (StringUtils.isNotEmpty((String)this.getDbName())) {
                params.add("-temporaryDatabaseName");
                params.add(this.getDbName());
            }
            if ("sqlServerAuth".equals(this.getServerAuth())) {
                params.add("-temporaryDatabaseUserName");
                params.add(this.getUsername());
                params.add("-temporaryDatabasePassword");
                params.add(this.getPassword().getPlainText());
            }
            if (this.encryptConnection) {
                params.add("-temporaryDatabaseEncryptConnection");
            }
            if (this.trustServerCertificate) {
                params.add("-temporaryDatabaseTrustServerCertificate");
            }
        }
        if ("runOnlyTest".equals(this.getRunTestSet())) {
            params.add("-runOnly");
            params.add(this.getRunOnlyParams());
        }
        if (this.getGenerateTestData() != null) {
            params.add("-sqlDataGenerator");
            params.add(this.getSqlgenPath());
        }
        if (StringUtils.isNotEmpty((String)this.options)) {
            params.add("-Options");
            params.add(this.options);
        }
        if (StringUtils.isNotEmpty((String)this.dataOptions)) {
            params.add("-DataOptions");
            params.add(this.dataOptions);
        }
        if (StringUtils.isNotEmpty((String)this.getFilter())) {
            params.add("-filter");
            params.add(this.getFilter());
        }
        this.addProductVersionParameter(params, this.sqlChangeAutomationVersionOption);
        return this.runSqlContinuousIntegrationCmdlet(build, launcher, (TaskListener)listener, params);
    }

    private void addTestSourceParameter(Collection<String> params, FilePath checkOutPath, String buildNumber) {
        params.add("-package");
        switch (this.getTestSource()) {
            case scaproject: {
                Path projectPath = Paths.get(checkOutPath.getRemote(), this.projectPath);
                params.add(projectPath.toString());
                break;
            }
            case socartifact: {
                String packageFileName = SqlContinuousIntegrationBuilder.constructPackageFileName(this.getPackageid(), buildNumber);
                params.add(packageFileName);
            }
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckPackageid(@QueryParameter String packageid) {
            if (StringUtils.isEmpty((String)packageid)) {
                return FormValidation.error((String)"Enter a package ID");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Redgate SQL Change Automation: Test a database using tSQLt";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }
}

