/*
 * Decompiled with CFR 0.152.
 */
package redgatesqlci;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.util.ArrayList;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import redgatesqlci.SqlChangeAutomationVersionOption;
import redgatesqlci.SqlContinuousIntegrationBuilder;

public class PublishBuilder
extends SqlContinuousIntegrationBuilder {
    private final String packageid;
    private final String nugetFeedUrl;
    private Secret nugetFeedApiKey;
    private final String packageVersion;
    private final SqlChangeAutomationVersionOption sqlChangeAutomationVersionOption;

    public String getPackageid() {
        return this.packageid;
    }

    public String getNugetFeedUrl() {
        return this.nugetFeedUrl;
    }

    public void setNugetFeedApiKey(Secret nugetFeedApiKey) {
        this.nugetFeedApiKey = nugetFeedApiKey;
    }

    public Secret getNugetFeedApiKey() {
        return this.nugetFeedApiKey;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public SqlChangeAutomationVersionOption getSqlChangeAutomationVersionOption() {
        return this.sqlChangeAutomationVersionOption;
    }

    @DataBoundConstructor
    public PublishBuilder(String packageid, String nugetFeedUrl, Secret nugetFeedApiKey, String packageVersion, SqlChangeAutomationVersionOption sqlChangeAutomationVersionOption) {
        this.packageid = packageid;
        this.nugetFeedUrl = nugetFeedUrl;
        this.nugetFeedApiKey = nugetFeedApiKey;
        this.packageVersion = packageVersion;
        this.sqlChangeAutomationVersionOption = sqlChangeAutomationVersionOption;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        ArrayList<String> params = new ArrayList<String>();
        String buildNumber = "1.0." + Integer.toString(build.getNumber());
        if (StringUtils.isNotEmpty((String)this.getPackageVersion())) {
            buildNumber = this.getPackageVersion();
        }
        String packageFileName = SqlContinuousIntegrationBuilder.constructPackageFileName(this.getPackageid(), buildNumber);
        params.add("Publish");
        params.add("-package");
        params.add(packageFileName);
        params.add("-nugetFeedUrl");
        params.add(this.getNugetFeedUrl());
        String nugetKey = this.getNugetFeedApiKey().getPlainText();
        if (StringUtils.isNotEmpty((String)nugetKey)) {
            params.add("-nugetFeedApiKey");
            params.add(nugetKey);
        }
        this.addProductVersionParameter(params, this.sqlChangeAutomationVersionOption);
        return this.runSqlContinuousIntegrationCmdlet(build, launcher, (TaskListener)listener, params);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckPackageid(@QueryParameter String value) {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.error((String)"Enter a package ID");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckNugetFeedUrl(@QueryParameter String nugetFeedUrl) {
            if (StringUtils.isEmpty((String)nugetFeedUrl)) {
                return FormValidation.error((String)"Enter a NuGet package feed URL");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Redgate SQL Change Automation: Publish a database package";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }
}

