/*
 * Decompiled with CFR 0.152.
 */
package redgatesqlci;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.util.ArrayList;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import redgatesqlci.SqlChangeAutomationVersionOption;
import redgatesqlci.SqlContinuousIntegrationBuilder;

public class PublishBuilder
extends SqlContinuousIntegrationBuilder {
    private final String packageid;
    private final String nugetFeedUrl;
    private final String nugetFeedApiKey;
    private final String packageVersion;
    private final SqlChangeAutomationVersionOption sqlChangeAutomationVersionOption;

    public String getPackageid() {
        return this.packageid;
    }

    public String getNugetFeedUrl() {
        return this.nugetFeedUrl;
    }

    public String getNugetFeedApiKey() {
        return this.nugetFeedApiKey;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public SqlChangeAutomationVersionOption getSqlChangeAutomationVersionOption() {
        return this.sqlChangeAutomationVersionOption;
    }

    @DataBoundConstructor
    public PublishBuilder(String packageid, String nugetFeedUrl, String nugetFeedApiKey, String packageVersion, SqlChangeAutomationVersionOption sqlChangeAutomationVersionOption) {
        this.packageid = packageid;
        this.nugetFeedUrl = nugetFeedUrl;
        this.nugetFeedApiKey = nugetFeedApiKey;
        this.packageVersion = packageVersion;
        this.sqlChangeAutomationVersionOption = sqlChangeAutomationVersionOption;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        ArrayList<String> params = new ArrayList<String>();
        String buildNumber = "1.0." + Integer.toString(build.getNumber());
        if (this.getPackageVersion() != null && !this.getPackageVersion().isEmpty()) {
            buildNumber = this.getPackageVersion();
        }
        String packageFileName = SqlContinuousIntegrationBuilder.constructPackageFileName(this.getPackageid(), buildNumber);
        params.add("Publish");
        params.add("-package");
        params.add(packageFileName);
        params.add("-nugetFeedUrl");
        params.add(this.getNugetFeedUrl());
        if (!this.getNugetFeedApiKey().isEmpty()) {
            params.add("-nugetFeedApiKey");
            params.add(this.getNugetFeedApiKey());
        }
        this.addProductVersionParameter(params, this.sqlChangeAutomationVersionOption);
        return this.runSqlContinuousIntegrationCmdlet(build, launcher, (TaskListener)listener, params);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckPackageid(@QueryParameter String value) {
            if (value.isEmpty()) {
                return FormValidation.error((String)"Enter a package ID");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckNugetFeedUrl(@QueryParameter String nugetFeedUrl) {
            if (nugetFeedUrl.isEmpty()) {
                return FormValidation.error((String)"Enter a NuGet package feed URL");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Redgate SQL Change Automation: Publish a database package";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }
}

