/*
 * Decompiled with CFR 0.152.
 */
package redgatesqlci;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import redgatesqlci.DbFolder;
import redgatesqlci.DlmDashboard;
import redgatesqlci.Server;
import redgatesqlci.SqlChangeAutomationVersionOption;
import redgatesqlci.SqlContinuousIntegrationBuilder;

public class BuildBuilder
extends SqlContinuousIntegrationBuilder {
    private final DbFolder.ProjectOption dbFolder;
    private final String subfolder;
    private final String projectPath;
    private final String packageid;
    private final String tempServer;
    private final String serverName;
    private final String dbName;
    private final String serverAuth;
    private final String username;
    private final String password;
    private final String options;
    private final String filter;
    private final String packageVersion;
    private final boolean sendToDlmDashboard;
    private final String dlmDashboardHost;
    private final String dlmDashboardPort;
    private final SqlChangeAutomationVersionOption sqlChangeAutomationVersionOption;

    public DbFolder.ProjectOption getDbFolder() {
        return this.dbFolder;
    }

    public String getSubfolder() {
        return this.subfolder;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public String getPackageid() {
        return this.packageid;
    }

    public String getTempServer() {
        return this.tempServer;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getServerAuth() {
        return this.serverAuth;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getOptions() {
        return this.options;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public boolean getSendToDlmDashboard() {
        return this.sendToDlmDashboard;
    }

    public String getDlmDashboardHost() {
        return this.dlmDashboardHost;
    }

    public String getDlmDashboardPort() {
        return this.dlmDashboardPort;
    }

    public SqlChangeAutomationVersionOption getSqlChangeAutomationVersionOption() {
        return this.sqlChangeAutomationVersionOption;
    }

    @DataBoundConstructor
    public BuildBuilder(DbFolder dbFolder, String packageid, Server tempServer, String options, String filter, String packageVersion, DlmDashboard dlmDashboard, SqlChangeAutomationVersionOption sqlChangeAutomationVersionOption) {
        this.dbFolder = dbFolder.getValue();
        this.subfolder = dbFolder.getSubfolder();
        this.projectPath = dbFolder.getProjectPath();
        this.packageid = packageid;
        this.tempServer = tempServer.getvalue();
        this.sqlChangeAutomationVersionOption = sqlChangeAutomationVersionOption;
        if ("sqlServer".equals(this.tempServer)) {
            this.dbName = tempServer.getDbName();
            this.serverName = tempServer.getServerName();
            this.serverAuth = tempServer.getServerAuth().getvalue();
            this.username = tempServer.getServerAuth().getUsername();
            this.password = tempServer.getServerAuth().getPassword();
        } else {
            this.dbName = "";
            this.serverName = "";
            this.serverAuth = null;
            this.username = "";
            this.password = "";
        }
        this.options = options;
        this.filter = filter;
        this.packageVersion = packageVersion;
        boolean bl = this.sendToDlmDashboard = dlmDashboard != null;
        if (this.getSendToDlmDashboard()) {
            this.dlmDashboardHost = dlmDashboard.getDlmDashboardHost();
            this.dlmDashboardPort = dlmDashboard.getDlmDashboardPort();
        } else {
            this.dlmDashboardHost = null;
            this.dlmDashboardPort = null;
        }
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        ArrayList<String> params = new ArrayList<String>();
        FilePath checkOutPath = build.getWorkspace();
        if (checkOutPath == null) {
            return false;
        }
        params.add("Build");
        this.addProjectOptionParams(params, checkOutPath);
        params.add("-packageId");
        params.add(this.getPackageid());
        if (this.getPackageVersion() == null || this.getPackageVersion().isEmpty()) {
            params.add("-packageVersion");
            params.add("1.0." + build.getNumber());
        } else {
            params.add("-packageVersion");
            params.add(this.getPackageVersion());
        }
        if (!this.options.isEmpty()) {
            params.add("-Options");
            params.add(BuildBuilder.getEscapedOptions(this.getOptions()));
        }
        if (!this.filter.isEmpty()) {
            params.add("-filter");
            params.add(this.getFilter());
        }
        if ("sqlServer".equals(this.getTempServer())) {
            params.add("-temporaryDatabaseServer");
            params.add(this.getServerName());
            if (!this.getDbName().isEmpty()) {
                params.add("-temporaryDatabaseName");
                params.add(this.getDbName());
            }
            if ("sqlServerAuth".equals(this.getServerAuth())) {
                params.add("-temporaryDatabaseUserName");
                params.add(this.getUsername());
                params.add("-temporaryDatabasePassword");
                params.add(this.getPassword());
            }
        }
        if (this.getSendToDlmDashboard()) {
            params.add("-dlmDashboardHost");
            params.add(this.getDlmDashboardHost());
            params.add("-dlmDashboardPort");
            params.add(this.getDlmDashboardPort());
        }
        this.addProductVersionParameter(params, this.sqlChangeAutomationVersionOption);
        return this.runSqlContinuousIntegrationCmdlet(build, launcher, (TaskListener)listener, params);
    }

    private void addProjectOptionParams(Collection<String> params, FilePath checkOutPath) {
        params.add("-scriptsFolder");
        switch (this.dbFolder) {
            case scaproject: {
                Path projectPath = Paths.get(checkOutPath.getRemote(), this.projectPath);
                params.add(projectPath.toString());
                break;
            }
            case vcsroot: {
                params.add(checkOutPath.getRemote());
                break;
            }
            case subfolder: {
                Path subfolderPath = Paths.get(checkOutPath.getRemote(), this.subfolder);
                params.add(subfolderPath.toString());
            }
        }
    }

    private static String getEscapedOptions(String options) {
        if (options.trim().startsWith("-")) {
            StringBuilder sb = new StringBuilder(options);
            return sb.insert(0, ',').toString();
        }
        return options;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckPackageid(@QueryParameter String value) {
            if (value.isEmpty()) {
                return FormValidation.error((String)"Enter a package ID.");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Redgate SQL Change Automation: Build a database package";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }
}

