/*
 * Decompiled with CFR 0.152.
 */
package redgatesqlci;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import redgatesqlci.DbFolder;
import redgatesqlci.Server;
import redgatesqlci.Utils;

public class BuildBuilder
extends Builder {
    private String dbFolder;
    private String subfolder;
    private final String packageid;
    private final String tempServer;
    private final String serverName;
    private final String dbName;
    private final String serverAuth;
    private final String username;
    private final String password;
    private final String additionalParams;

    public String getDbFolder() {
        return this.dbFolder;
    }

    public String getSubfolder() {
        return this.subfolder;
    }

    public String getPackageid() {
        return this.packageid;
    }

    public String getTempServer() {
        return this.tempServer;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getServerAuth() {
        return this.serverAuth;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getAdditionalParams() {
        return this.additionalParams;
    }

    @DataBoundConstructor
    public BuildBuilder(DbFolder dbFolder, String packageid, Server tempServer, String additionalParams) {
        this.dbFolder = dbFolder.getvalue();
        this.subfolder = dbFolder.getsubfolder();
        this.packageid = packageid;
        this.tempServer = tempServer.getvalue();
        if (this.tempServer.equals("sqlServer")) {
            this.dbName = tempServer.getDbName();
            this.serverName = tempServer.getServerName();
            this.serverAuth = tempServer.getServerAuth().getvalue();
            this.username = tempServer.getServerAuth().getUsername();
            this.password = tempServer.getServerAuth().getPassword();
        } else {
            this.dbName = "";
            this.serverName = "";
            this.serverAuth = "";
            this.username = "";
            this.password = "";
        }
        this.additionalParams = additionalParams;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        ArrayList<String> params = new ArrayList<String>();
        FilePath checkOutPath = build.getWorkspace();
        params.add("BUILD");
        if (this.getDbFolder().equals("subfolder")) {
            params.add("/scriptsFolder=" + checkOutPath.getRemote() + this.getSubfolder());
        } else {
            params.add("/scriptsFolder=" + checkOutPath.getRemote());
        }
        params.add("/packageId=" + this.getPackageid());
        params.add("/packageVersion=0." + build.getNumber());
        if (!this.additionalParams.isEmpty()) {
            params.add("/additionalCompareArgs=" + this.getAdditionalParams());
        }
        if (this.getTempServer().equals("sqlServer")) {
            params.add("/temporaryDatabaseServer=" + this.getServerName());
            params.add("/temporaryDatabaseName=" + this.getDbName());
            if (this.getServerAuth().equals("sqlServerAuth")) {
                params.add("/temporaryDatabaseUserName=" + this.getUsername());
                params.add("/temporaryDatabasePassword=" + this.getPassword());
            }
        }
        return Utils.runSQLCIWithParams(build, launcher, listener, params);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckPackageid(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Enter a package ID.");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Redgate SQL CI: Build a database package";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }
}

