/*
 * Decompiled with CFR 0.152.
 */
package com.recurve.navigation;

import android.content.Intent;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.MenuItem;
import androidx.arch.core.util.Function;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Transformations;
import androidx.navigation.NavController;
import androidx.navigation.NavDestination;
import androidx.navigation.NavGraph;
import androidx.navigation.fragment.NavHostFragment;
import com.google.android.material.bottomnavigation.BottomNavigationView;
import com.recurve.navigation.NavigationExtensionsKt;
import com.recurve.navigation.R;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000f\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a(\u0010\r\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0002\u001a\u0014\u0010\u0011\u001a\u00020\u0007*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\nH\u0002\u001a:\u0010\u0013\u001a\u00020\u0001*\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a*\u0010\u001b\u001a\u00020\u0001*\u00020\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001ar\u0010\u001e\u001aD\u0012@\u0012>\u00124\u00122\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b($\u0012\u0013\u0012\u00110%\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b(&\u0012\u0004\u0012\u00020\u00010!\u0012\u0004\u0012\u00020\u00010 0\u001f*\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a\u00a8\u0006'"}, d2={"attachNavHostFragment", "", "fragmentManager", "Landroidx/fragment/app/FragmentManager;", "navHostFragment", "Landroidx/navigation/fragment/NavHostFragment;", "isPrimaryNavFragment", "", "detachNavHostFragment", "getFragmentTag", "", "index", "", "obtainNavHostFragment", "fragmentTag", "navGraphId", "containerId", "isOnBackStack", "backStackName", "setupDeepLinks", "Lcom/google/android/material/bottomnavigation/BottomNavigationView;", "navGraphIds", "", "itemIdToGraphId", "Landroid/util/SparseIntArray;", "intent", "Landroid/content/Intent;", "setupItemReselected", "graphIdToTagMap", "Landroid/util/SparseArray;", "setupWithNavController", "Landroidx/lifecycle/LiveData;", "Lkotlin/Function1;", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "firstInit", "Landroidx/navigation/NavController;", "navController", "bottom-navigation-ktx_release"})
public final class NavigationExtensionsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final LiveData<Function1<Function2<? super Boolean, ? super NavController, Unit>, Unit>> setupWithNavController(@NotNull BottomNavigationView $this$setupWithNavController, @NotNull List<Integer> navGraphIds, @NotNull FragmentManager fragmentManager, int containerId, @NotNull Intent intent) {
        void isOnFirstFragment;
        void selectedItemTag;
        void firstFragmentGraphId;
        Intrinsics.checkParameterIsNotNull((Object)$this$setupWithNavController, (String)"$this$setupWithNavController");
        Intrinsics.checkParameterIsNotNull(navGraphIds, (String)"navGraphIds");
        Intrinsics.checkParameterIsNotNull((Object)fragmentManager, (String)"fragmentManager");
        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
        SparseArray graphIdToTagMap = new SparseArray();
        MutableLiveData selectedNavController = new MutableLiveData();
        SparseIntArray itemIdToGraphId = new SparseIntArray();
        SparseIntArray firstInitSet = new SparseIntArray(navGraphIds.size());
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        Iterable $this$forEachIndexed$iv = navGraphIds;
        boolean $i$f$forEachIndexed = false;
        int index$iv22 = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void key$iv;
            SparseArray $receiver$iv;
            void navGraphId;
            int n = index$iv22++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            int n3 = ((Number)item$iv).intValue();
            int index = n2;
            boolean bl2 = false;
            String fragmentTag = NavigationExtensionsKt.getFragmentTag(index);
            NavHostFragment navHostFragment = NavigationExtensionsKt.obtainNavHostFragment(fragmentManager, fragmentTag, (int)navGraphId, containerId);
            NavController navController = navHostFragment.getNavController();
            Intrinsics.checkExpressionValueIsNotNull((Object)navController, (String)"navHostFragment.navController");
            NavGraph navGraph = navController.getGraph();
            Intrinsics.checkExpressionValueIsNotNull((Object)navGraph, (String)"navHostFragment.navController.graph");
            int graphId = navGraph.getId();
            SparseIntArray sparseIntArray = itemIdToGraphId;
            MenuItem menuItem = $this$setupWithNavController.getMenu().getItem(index);
            Intrinsics.checkExpressionValueIsNotNull((Object)menuItem, (String)"menu.getItem(index)");
            int n4 = menuItem.getItemId();
            int value$iv = graphId;
            $receiver$iv.put((int)key$iv, value$iv);
            if (index == 0) {
                firstFragmentGraphId.element = graphId;
            }
            $receiver$iv = graphIdToTagMap;
            String value$iv2 = fragmentTag;
            $receiver$iv.put(graphId, (Object)value$iv2);
            if (itemIdToGraphId.get($this$setupWithNavController.getSelectedItemId()) == graphId) {
                selectedNavController.setValue((Object)navHostFragment.getNavController());
                NavigationExtensionsKt.attachNavHostFragment(fragmentManager, navHostFragment, index == 0);
                continue;
            }
            NavigationExtensionsKt.detachNavHostFragment(fragmentManager, navHostFragment);
        }
        $this$forEachIndexed$iv = new Ref.ObjectRef();
        ((Ref.ObjectRef)$this$forEachIndexed$iv).element = (String)graphIdToTagMap.get(itemIdToGraphId.get($this$setupWithNavController.getSelectedItemId()));
        String firstFragmentTag = (String)graphIdToTagMap.get(firstFragmentGraphId.element);
        Ref.BooleanRef index$iv22 = new Ref.BooleanRef();
        index$iv22.element = Intrinsics.areEqual((Object)((String)selectedItemTag.element), (Object)firstFragmentTag);
        $this$setupWithNavController.setOnNavigationItemSelectedListener(new BottomNavigationView.OnNavigationItemSelectedListener(fragmentManager, graphIdToTagMap, itemIdToGraphId, (Ref.ObjectRef)selectedItemTag, firstFragmentTag, (Ref.BooleanRef)isOnFirstFragment, selectedNavController){
            final /* synthetic */ FragmentManager $fragmentManager;
            final /* synthetic */ SparseArray $graphIdToTagMap;
            final /* synthetic */ SparseIntArray $itemIdToGraphId;
            final /* synthetic */ Ref.ObjectRef $selectedItemTag;
            final /* synthetic */ String $firstFragmentTag;
            final /* synthetic */ Ref.BooleanRef $isOnFirstFragment;
            final /* synthetic */ MutableLiveData $selectedNavController;

            /*
             * WARNING - void declaration
             */
            public final boolean onNavigationItemSelected(@NotNull MenuItem item) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                if (this.$fragmentManager.isStateSaved()) {
                    bl = false;
                } else {
                    String newlySelectedItemTag = (String)this.$graphIdToTagMap.get(this.$itemIdToGraphId.get(item.getItemId()));
                    if (Intrinsics.areEqual((Object)((String)this.$selectedItemTag.element), (Object)newlySelectedItemTag) ^ true) {
                        this.$fragmentManager.popBackStack(this.$firstFragmentTag, 1);
                        Fragment fragment = this.$fragmentManager.findFragmentByTag(newlySelectedItemTag);
                        if (fragment == null) {
                            throw new TypeCastException("null cannot be cast to non-null type androidx.navigation.fragment.NavHostFragment");
                        }
                        NavHostFragment selectedFragment = (NavHostFragment)fragment;
                        if (Intrinsics.areEqual((Object)this.$firstFragmentTag, (Object)newlySelectedItemTag) ^ true) {
                            FragmentTransaction fragmentTransaction = this.$fragmentManager.beginTransaction().show((Fragment)selectedFragment).setPrimaryNavigationFragment((Fragment)selectedFragment);
                            boolean bl2 = false;
                            boolean bl3 = false;
                            FragmentTransaction $this$apply = fragmentTransaction;
                            boolean bl4 = false;
                            SparseArray $receiver$iv = this.$graphIdToTagMap;
                            int n = 0;
                            int n2 = $receiver$iv.size();
                            while (n < n2) {
                                void fragmentTagIter;
                                void index$iv;
                                String string = (String)$receiver$iv.valueAt((int)index$iv);
                                int $noName_0 = $receiver$iv.keyAt((int)index$iv);
                                boolean bl5 = false;
                                if (Intrinsics.areEqual((Object)fragmentTagIter, (Object)newlySelectedItemTag) ^ true) {
                                    Fragment fragment2 = this.$fragmentManager.findFragmentByTag(this.$firstFragmentTag);
                                    if (fragment2 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    $this$apply.hide(fragment2);
                                }
                                ++index$iv;
                            }
                            fragmentTransaction.addToBackStack(this.$firstFragmentTag).setCustomAnimations(R.anim.nav_default_enter_anim, R.anim.nav_default_exit_anim, R.anim.nav_default_pop_enter_anim, R.anim.nav_default_pop_exit_anim).setReorderingAllowed(true).commit();
                        }
                        this.$selectedItemTag.element = newlySelectedItemTag;
                        this.$isOnFirstFragment.element = Intrinsics.areEqual((Object)((String)this.$selectedItemTag.element), (Object)this.$firstFragmentTag);
                        this.$selectedNavController.setValue((Object)selectedFragment.getNavController());
                        bl = true;
                    } else {
                        bl = false;
                    }
                }
                return bl;
            }
            {
                this.$fragmentManager = fragmentManager;
                this.$graphIdToTagMap = sparseArray;
                this.$itemIdToGraphId = sparseIntArray;
                this.$selectedItemTag = objectRef;
                this.$firstFragmentTag = string;
                this.$isOnFirstFragment = booleanRef;
                this.$selectedNavController = mutableLiveData;
            }
        });
        NavigationExtensionsKt.setupItemReselected($this$setupWithNavController, (SparseArray<String>)graphIdToTagMap, itemIdToGraphId, fragmentManager);
        NavigationExtensionsKt.setupDeepLinks($this$setupWithNavController, navGraphIds, itemIdToGraphId, fragmentManager, containerId, intent);
        fragmentManager.addOnBackStackChangedListener(new FragmentManager.OnBackStackChangedListener($this$setupWithNavController, (Ref.BooleanRef)isOnFirstFragment, fragmentManager, firstFragmentTag, (Ref.IntRef)firstFragmentGraphId, itemIdToGraphId, selectedNavController){
            final /* synthetic */ BottomNavigationView $this_setupWithNavController;
            final /* synthetic */ Ref.BooleanRef $isOnFirstFragment;
            final /* synthetic */ FragmentManager $fragmentManager;
            final /* synthetic */ String $firstFragmentTag;
            final /* synthetic */ Ref.IntRef $firstFragmentGraphId;
            final /* synthetic */ SparseIntArray $itemIdToGraphId;
            final /* synthetic */ MutableLiveData $selectedNavController;

            /*
             * WARNING - void declaration
             */
            public final void onBackStackChanged() {
                block3: {
                    int n;
                    NavController navController;
                    if (!this.$isOnFirstFragment.element) {
                        String string = this.$firstFragmentTag;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"firstFragmentTag");
                        if (!NavigationExtensionsKt.access$isOnBackStack(this.$fragmentManager, string)) {
                            void key$iv;
                            void $receiver$iv;
                            navController = this.$itemIdToGraphId;
                            n = this.$this_setupWithNavController.getSelectedItemId();
                            int value$iv = this.$firstFragmentGraphId.element;
                            $receiver$iv.put((int)key$iv, value$iv);
                        }
                    }
                    NavController navController2 = (NavController)this.$selectedNavController.getValue();
                    if (navController2 == null) break block3;
                    navController = navController2;
                    n = 0;
                    boolean bl = false;
                    NavController controller = navController;
                    boolean bl2 = false;
                    NavController navController3 = controller;
                    Intrinsics.checkExpressionValueIsNotNull((Object)navController3, (String)"controller");
                    if (navController3.getCurrentDestination() == null) {
                        NavGraph navGraph = controller.getGraph();
                        Intrinsics.checkExpressionValueIsNotNull((Object)navGraph, (String)"controller.graph");
                        controller.navigate(navGraph.getId());
                    }
                }
            }
            {
                this.$this_setupWithNavController = bottomNavigationView;
                this.$isOnFirstFragment = booleanRef;
                this.$fragmentManager = fragmentManager;
                this.$firstFragmentTag = string;
                this.$firstFragmentGraphId = intRef;
                this.$itemIdToGraphId = sparseIntArray;
                this.$selectedNavController = mutableLiveData;
            }
        });
        Function1 isFirstInitFun2 = (Function1)new Function1<Integer, Boolean>(firstInitSet){
            final /* synthetic */ SparseIntArray $firstInitSet;

            public final boolean invoke(int graphId) {
                SparseIntArray $receiver$iv = this.$firstInitSet;
                return !($receiver$iv.indexOfKey(graphId) >= 0);
            }
            {
                this.$firstInitSet = sparseIntArray;
                super(1);
            }
        };
        LiveData liveData = Transformations.map((LiveData)((LiveData)selectedNavController), (Function)new Function<X, Y>(isFirstInitFun2, firstInitSet){
            final /* synthetic */ Function1 $isFirstInitFun;
            final /* synthetic */ SparseIntArray $firstInitSet;

            @NotNull
            public final Function1<Function2<? super Boolean, ? super NavController, Unit>, Unit> apply(NavController navController) {
                return (Function1)new Function1<Function2<? super Boolean, ? super NavController, ? extends Unit>, Unit>(this, navController){
                    final /* synthetic */ setupWithNavController.4 this$0;
                    final /* synthetic */ NavController $navController;

                    public final void invoke(@NotNull Function2<? super Boolean, ? super NavController, Unit> observerNavController) {
                        Intrinsics.checkParameterIsNotNull(observerNavController, (String)"observerNavController");
                        NavController navController = this.$navController;
                        Intrinsics.checkExpressionValueIsNotNull((Object)navController, (String)"navController");
                        NavDestination navDestination = navController.getCurrentDestination();
                        int currentId = navDestination != null ? navDestination.getId() : 0;
                        boolean isFirstInit = (Boolean)this.this$0.$isFirstInitFun.invoke((Object)currentId);
                        Boolean bl = isFirstInit;
                        NavController navController2 = this.$navController;
                        Intrinsics.checkExpressionValueIsNotNull((Object)navController2, (String)"navController");
                        observerNavController.invoke((Object)bl, (Object)navController2);
                        StringBuilder stringBuilder = new StringBuilder().append("isFirstInit = ").append(isFirstInit).append(", destination = ");
                        NavController navController3 = this.$navController;
                        Intrinsics.checkExpressionValueIsNotNull((Object)navController3, (String)"navController");
                        NavDestination navDestination2 = navController3.getCurrentDestination();
                        Log.d((String)"NavigationExtensions", (String)stringBuilder.append(navDestination2 != null ? navDestination2.getLabel() : null).toString());
                        this.this$0.$firstInitSet.put(currentId, currentId);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$navController = navController;
                        super(1);
                    }
                };
            }
            {
                this.$isFirstInitFun = function1;
                this.$firstInitSet = sparseIntArray;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData, (String)"Transformations.map(sele\u2026urrentId)\n        }\n    }");
        return liveData;
    }

    /*
     * WARNING - void declaration
     */
    private static final void setupDeepLinks(@NotNull BottomNavigationView $this$setupDeepLinks, List<Integer> navGraphIds, SparseIntArray itemIdToGraphId, FragmentManager fragmentManager, int containerId, Intent intent) {
        Iterable $this$forEachIndexed$iv = navGraphIds;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void key$iv;
            void $receiver$iv;
            void navGraphId;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            int n3 = ((Number)item$iv).intValue();
            int index = n2;
            boolean bl2 = false;
            String fragmentTag = NavigationExtensionsKt.getFragmentTag(index);
            NavHostFragment navHostFragment = NavigationExtensionsKt.obtainNavHostFragment(fragmentManager, fragmentTag, (int)navGraphId, containerId);
            if (!navHostFragment.getNavController().handleDeepLink(intent)) continue;
            int n4 = $this$setupDeepLinks.getSelectedItemId();
            NavController navController = navHostFragment.getNavController();
            Intrinsics.checkExpressionValueIsNotNull((Object)navController, (String)"navHostFragment.navController");
            NavGraph navGraph = navController.getGraph();
            Intrinsics.checkExpressionValueIsNotNull((Object)navGraph, (String)"navHostFragment.navController.graph");
            if (n4 == navGraph.getId()) continue;
            SparseIntArray sparseIntArray = itemIdToGraphId;
            int n5 = $this$setupDeepLinks.getSelectedItemId();
            NavController navController2 = navHostFragment.getNavController();
            Intrinsics.checkExpressionValueIsNotNull((Object)navController2, (String)"navHostFragment.navController");
            NavGraph navGraph2 = navController2.getGraph();
            Intrinsics.checkExpressionValueIsNotNull((Object)navGraph2, (String)"navHostFragment.navController.graph");
            int value$iv = navGraph2.getId();
            $receiver$iv.put((int)key$iv, value$iv);
        }
    }

    private static final void setupItemReselected(@NotNull BottomNavigationView $this$setupItemReselected, SparseArray<String> graphIdToTagMap, SparseIntArray itemIdToGraphId, FragmentManager fragmentManager) {
        $this$setupItemReselected.setOnNavigationItemReselectedListener(new BottomNavigationView.OnNavigationItemReselectedListener(graphIdToTagMap, itemIdToGraphId, fragmentManager){
            final /* synthetic */ SparseArray $graphIdToTagMap;
            final /* synthetic */ SparseIntArray $itemIdToGraphId;
            final /* synthetic */ FragmentManager $fragmentManager;

            public final void onNavigationItemReselected(@NotNull MenuItem item) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                String newlySelectedItemTag = (String)this.$graphIdToTagMap.get(this.$itemIdToGraphId.get(item.getItemId()));
                Fragment fragment = this.$fragmentManager.findFragmentByTag(newlySelectedItemTag);
                if (fragment == null) {
                    throw new TypeCastException("null cannot be cast to non-null type androidx.navigation.fragment.NavHostFragment");
                }
                NavHostFragment selectedFragment = (NavHostFragment)fragment;
                NavController navController = selectedFragment.getNavController();
                Intrinsics.checkExpressionValueIsNotNull((Object)navController, (String)"selectedFragment.navController");
                NavController navController2 = navController;
                NavGraph navGraph = navController2.getGraph();
                Intrinsics.checkExpressionValueIsNotNull((Object)navGraph, (String)"navController.graph");
                navController2.popBackStack(navGraph.getStartDestination(), false);
            }
            {
                this.$graphIdToTagMap = sparseArray;
                this.$itemIdToGraphId = sparseIntArray;
                this.$fragmentManager = fragmentManager;
            }
        });
    }

    private static final void detachNavHostFragment(FragmentManager fragmentManager, NavHostFragment navHostFragment) {
        fragmentManager.beginTransaction().hide((Fragment)navHostFragment).commitNow();
    }

    private static final void attachNavHostFragment(FragmentManager fragmentManager, NavHostFragment navHostFragment, boolean isPrimaryNavFragment) {
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction().show((Fragment)navHostFragment);
        boolean bl = false;
        boolean bl2 = false;
        FragmentTransaction $this$apply = fragmentTransaction;
        boolean bl3 = false;
        if (isPrimaryNavFragment) {
            $this$apply.setPrimaryNavigationFragment((Fragment)navHostFragment);
        }
        fragmentTransaction.commitNow();
    }

    private static final NavHostFragment obtainNavHostFragment(FragmentManager fragmentManager, String fragmentTag, int navGraphId, int containerId) {
        NavHostFragment existingFragment;
        NavHostFragment navHostFragment = existingFragment = (NavHostFragment)fragmentManager.findFragmentByTag(fragmentTag);
        if (navHostFragment != null) {
            NavHostFragment navHostFragment2 = navHostFragment;
            boolean bl = false;
            boolean bl2 = false;
            NavHostFragment it = navHostFragment2;
            boolean bl3 = false;
            return it;
        }
        NavHostFragment navHostFragment3 = NavHostFragment.create((int)navGraphId);
        Intrinsics.checkExpressionValueIsNotNull((Object)navHostFragment3, (String)"NavHostFragment.create(navGraphId)");
        NavHostFragment navHostFragment4 = navHostFragment3;
        fragmentManager.beginTransaction().add(containerId, (Fragment)navHostFragment4, fragmentTag).commitNow();
        return navHostFragment4;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isOnBackStack(@NotNull FragmentManager $this$isOnBackStack, String backStackName) {
        int backStackCount = $this$isOnBackStack.getBackStackEntryCount();
        int n = 0;
        int n2 = backStackCount;
        while (n < n2) {
            void index;
            FragmentManager.BackStackEntry backStackEntry = $this$isOnBackStack.getBackStackEntryAt((int)index);
            Intrinsics.checkExpressionValueIsNotNull((Object)backStackEntry, (String)"getBackStackEntryAt(index)");
            if (Intrinsics.areEqual((Object)backStackEntry.getName(), (Object)backStackName)) {
                return true;
            }
            ++index;
        }
        return false;
    }

    private static final String getFragmentTag(int index) {
        return "bottomNavigation#" + index;
    }

    public static final /* synthetic */ boolean access$isOnBackStack(FragmentManager $this$access_u24isOnBackStack, String backStackName) {
        return NavigationExtensionsKt.isOnBackStack($this$access_u24isOnBackStack, backStackName);
    }
}

