/*
 * Decompiled with CFR 0.152.
 */
package com.reach5.identity.sdk.core.models.responses.webAuthn;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.fido.fido2.api.common.Attachment;
import com.google.android.gms.fido.fido2.api.common.AttestationConveyancePreference;
import com.google.android.gms.fido.fido2.api.common.AuthenticatorSelectionCriteria;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialCreationOptions;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialParameters;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialRpEntity;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialUserEntity;
import com.google.gson.annotations.SerializedName;
import com.reach5.identity.sdk.core.models.responses.webAuthn.CredentialCreationOptions;
import com.reach5.identity.sdk.core.models.responses.webAuthn.R5AuthenticatorSelectionCriteria;
import com.reach5.identity.sdk.core.models.responses.webAuthn.R5PublicKeyCredentialCreationOptions;
import com.reach5.identity.sdk.core.models.responses.webAuthn.R5PublicKeyCredentialDescriptor;
import com.reach5.identity.sdk.core.models.responses.webAuthn.R5PublicKeyCredentialParameter;
import com.reach5.identity.sdk.core.utils.WebAuthn;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.android.parcel.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u000fH\u00d6\u0001J\u0006\u0010\u0015\u001a\u00020\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000fH\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lcom/reach5/identity/sdk/core/models/responses/webAuthn/RegistrationOptions;", "Landroid/os/Parcelable;", "friendlyName", "", "options", "Lcom/reach5/identity/sdk/core/models/responses/webAuthn/CredentialCreationOptions;", "(Ljava/lang/String;Lcom/reach5/identity/sdk/core/models/responses/webAuthn/CredentialCreationOptions;)V", "getFriendlyName", "()Ljava/lang/String;", "getOptions", "()Lcom/reach5/identity/sdk/core/models/responses/webAuthn/CredentialCreationOptions;", "component1", "component2", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toFido2Model", "Lcom/google/android/gms/fido/fido2/api/common/PublicKeyCredentialCreationOptions;", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "sdk-core_release"})
@Parcelize
public final class RegistrationOptions
implements Parcelable {
    @SerializedName(value="friendly_name")
    @NotNull
    private final String friendlyName;
    @NotNull
    private final CredentialCreationOptions options;
    public static final Parcelable.Creator CREATOR = new Creator();

    @NotNull
    public final PublicKeyCredentialCreationOptions toFido2Model() {
        PublicKeyCredentialParameters publicKeyCredentialParameters;
        Collection<PublicKeyCredentialParameters> collection;
        PublicKeyCredentialParameters publicKeyCredentialParameters2;
        R5PublicKeyCredentialDescriptor it;
        Collection<PublicKeyCredentialParameters> collection2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        R5PublicKeyCredentialCreationOptions publicKey = this.options.getPublicKey();
        Object object = publicKey.getUser().getId();
        PublicKeyCredentialCreationOptions.Builder builder = new PublicKeyCredentialCreationOptions.Builder().setRp(new PublicKeyCredentialRpEntity(publicKey.getRp().getId(), publicKey.getRp().getName(), null));
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string = object;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        String string2 = publicKey.getUser().getDisplayName();
        String string3 = null;
        String string4 = publicKey.getUser().getName();
        byte[] byArray3 = byArray2;
        object = publicKey.getPubKeyCredParams();
        builder = builder.setUser(new PublicKeyCredentialUserEntity(byArray3, string4, string3, string2)).setChallenge(WebAuthn.INSTANCE.decodeBase64(publicKey.getChallenge()));
        boolean $i$f$map = false;
        void var4_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            R5PublicKeyCredentialParameter r5PublicKeyCredentialParameter = (R5PublicKeyCredentialParameter)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl2 = false;
            publicKeyCredentialParameters2 = new PublicKeyCredentialParameters(((R5PublicKeyCredentialParameter)((Object)it)).getType(), ((R5PublicKeyCredentialParameter)((Object)it)).getAlg());
            collection2.add(publicKeyCredentialParameters2);
        }
        collection2 = (List)destination$iv$iv;
        Integer n = publicKey.getTimeout();
        PublicKeyCredentialCreationOptions.Builder builder2 = builder.setParameters((List)collection2).setTimeoutSeconds(n != null ? Double.valueOf((double)n.intValue() / (double)1000) : null);
        List<R5PublicKeyCredentialDescriptor> list = publicKey.getExcludeCredentials();
        if (list != null) {
            $this$map$iv = list;
            builder = builder2;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (R5PublicKeyCredentialDescriptor)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl3 = false;
                publicKeyCredentialParameters2 = it.toPublicKeyCredentialDescriptor();
                collection2.add(publicKeyCredentialParameters2);
            }
            collection2 = (List)destination$iv$iv;
            builder2 = builder;
            collection = collection2;
        } else {
            collection = null;
        }
        PublicKeyCredentialCreationOptions.Builder builder3 = builder2.setExcludeList(collection);
        Object object2 = new AuthenticatorSelectionCriteria.Builder();
        Object object3 = publicKey.getAuthenticatorSelection();
        if (object3 != null && (object3 = ((R5AuthenticatorSelectionCriteria)object3).getAuthenticatorAttachment()) != null) {
            object = object3;
            collection2 = object2;
            builder = builder3;
            boolean bl4 = false;
            boolean bl5 = false;
            Object it2 = object;
            boolean bl6 = false;
            publicKeyCredentialParameters2 = Attachment.valueOf((String)it2);
            builder3 = builder;
            object2 = collection2;
            publicKeyCredentialParameters = publicKeyCredentialParameters2;
        } else {
            publicKeyCredentialParameters = null;
        }
        PublicKeyCredentialCreationOptions publicKeyCredentialCreationOptions = builder3.setAuthenticatorSelection(object2.setAttachment(publicKeyCredentialParameters).build()).setAttestationConveyancePreference(AttestationConveyancePreference.fromString((String)publicKey.getAttestation())).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)publicKeyCredentialCreationOptions, (String)"PublicKeyCredentialCreat\u2026on))\n            .build()");
        return publicKeyCredentialCreationOptions;
    }

    @NotNull
    public final String getFriendlyName() {
        return this.friendlyName;
    }

    @NotNull
    public final CredentialCreationOptions getOptions() {
        return this.options;
    }

    public RegistrationOptions(@NotNull String friendlyName, @NotNull CredentialCreationOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)friendlyName, (String)"friendlyName");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        this.friendlyName = friendlyName;
        this.options = options;
    }

    @NotNull
    public final String component1() {
        return this.friendlyName;
    }

    @NotNull
    public final CredentialCreationOptions component2() {
        return this.options;
    }

    @NotNull
    public final RegistrationOptions copy(@NotNull String friendlyName, @NotNull CredentialCreationOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)friendlyName, (String)"friendlyName");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        return new RegistrationOptions(friendlyName, options);
    }

    public static /* synthetic */ RegistrationOptions copy$default(RegistrationOptions registrationOptions, String string, CredentialCreationOptions credentialCreationOptions, int n, Object object) {
        if ((n & 1) != 0) {
            string = registrationOptions.friendlyName;
        }
        if ((n & 2) != 0) {
            credentialCreationOptions = registrationOptions.options;
        }
        return registrationOptions.copy(string, credentialCreationOptions);
    }

    @NotNull
    public String toString() {
        return "RegistrationOptions(friendlyName=" + this.friendlyName + ", options=" + this.options + ")";
    }

    public int hashCode() {
        String string = this.friendlyName;
        CredentialCreationOptions credentialCreationOptions = this.options;
        return (string != null ? string.hashCode() : 0) * 31 + (credentialCreationOptions != null ? ((Object)credentialCreationOptions).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof RegistrationOptions)) break block3;
                RegistrationOptions registrationOptions = (RegistrationOptions)object;
                if (!Intrinsics.areEqual((Object)this.friendlyName, (Object)registrationOptions.friendlyName) || !Intrinsics.areEqual((Object)this.options, (Object)registrationOptions.options)) break block3;
            }
            return true;
        }
        return false;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel parcel, int flags) {
        Intrinsics.checkParameterIsNotNull((Object)parcel, (String)"parcel");
        parcel.writeString(this.friendlyName);
        this.options.writeToParcel(parcel, 0);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=3)
    public static final class Creator
    implements Parcelable.Creator {
        @NotNull
        public final Object[] newArray(int size) {
            return new RegistrationOptions[size];
        }

        @NotNull
        public final Object createFromParcel(@NotNull Parcel in) {
            Intrinsics.checkParameterIsNotNull((Object)in, (String)"in");
            return new RegistrationOptions(in.readString(), (CredentialCreationOptions)CredentialCreationOptions.CREATOR.createFromParcel(in));
        }
    }
}

