/*
 * Decompiled with CFR 0.152.
 */
package com.reach5.identity.sdk.core;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Intent;
import android.util.Log;
import com.google.android.gms.fido.Fido;
import com.google.android.gms.fido.fido2.Fido2ApiClient;
import com.google.android.gms.fido.fido2.api.common.AuthenticatorAttestationResponse;
import com.google.android.gms.fido.fido2.api.common.AuthenticatorErrorResponse;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.reach5.identity.sdk.core.ReachFiveWebAuthn;
import com.reach5.identity.sdk.core.models.ReachFiveError;
import com.reach5.identity.sdk.core.models.requests.webAuthn.RegistrationPublicKeyCredential;
import com.reach5.identity.sdk.core.models.requests.webAuthn.WebAuthnRegistration;
import com.reach5.identity.sdk.core.models.responses.webAuthn.RegistrationOptions;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J;\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2+\u0010\u000b\u001a'\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\b0\fj\b\u0012\u0004\u0012\u00020\r`\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lcom/reach5/identity/sdk/core/ReachFiveWebAuthn;", "", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;)V", "getActivity", "()Landroid/app/Activity;", "extractFIDO2Error", "", "intent", "Landroid/content/Intent;", "failure", "Lkotlin/Function1;", "Lcom/reach5/identity/sdk/core/models/ReachFiveError;", "Lkotlin/ParameterName;", "name", "error", "Lcom/reach5/identity/sdk/core/utils/Failure;", "extractRegistrationPublicKeyCredential", "Lcom/reach5/identity/sdk/core/models/requests/webAuthn/RegistrationPublicKeyCredential;", "startFIDO2RegisterTask", "registrationOptions", "Lcom/reach5/identity/sdk/core/models/responses/webAuthn/RegistrationOptions;", "requestCode", "", "Companion", "sdk-core_release"})
public final class ReachFiveWebAuthn {
    @NotNull
    private final Activity activity;
    private static final String TAG = "Reach5";
    public static final Companion Companion = new Companion(null);

    public final void startFIDO2RegisterTask(@NotNull RegistrationOptions registrationOptions, int requestCode) {
        Intrinsics.checkParameterIsNotNull((Object)registrationOptions, (String)"registrationOptions");
        Fido2ApiClient fido2ApiClient = Fido.getFido2ApiClient((Activity)this.activity);
        Task fido2PendingIntentTask = fido2ApiClient.getRegisterPendingIntent(registrationOptions.toFido2Model());
        fido2PendingIntentTask.addOnSuccessListener((OnSuccessListener)new OnSuccessListener<PendingIntent>(this, requestCode){
            final /* synthetic */ ReachFiveWebAuthn this$0;
            final /* synthetic */ int $requestCode;

            public final void onSuccess(PendingIntent fido2PendingIntent) {
                if (fido2PendingIntent != null) {
                    Log.d((String)"Reach5", (String)"Launching Fido2 Pending Intent");
                    this.this$0.getActivity().startIntentSenderForResult(fido2PendingIntent.getIntentSender(), this.$requestCode, null, 0, 0, 0);
                }
            }
            {
                this.this$0 = reachFiveWebAuthn;
                this.$requestCode = n;
            }
        });
        fido2PendingIntentTask.addOnFailureListener((OnFailureListener)startFIDO2RegisterTask.2.INSTANCE);
    }

    public final void extractFIDO2Error(@NotNull Intent intent, @NotNull Function1<? super ReachFiveError, Unit> failure) {
        AuthenticatorErrorResponse authenticatorErrorResponse;
        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
        Intrinsics.checkParameterIsNotNull(failure, (String)"failure");
        byte[] errorBytes = intent.getByteArrayExtra("FIDO2_ERROR_EXTRA");
        AuthenticatorErrorResponse authenticatorErrorResponse2 = authenticatorErrorResponse = AuthenticatorErrorResponse.deserializeFromBytes((byte[])errorBytes);
        Intrinsics.checkExpressionValueIsNotNull((Object)authenticatorErrorResponse2, (String)"authenticatorErrorResponse");
        String string = authenticatorErrorResponse2.getErrorMessage();
        if (string == null) {
            string = "Unexpected error during FIDO2 registration";
        }
        ReachFiveError reachFiveError = new ReachFiveError(string, authenticatorErrorResponse.getErrorCodeAsInt(), null, null, 12, null);
        failure.invoke((Object)reachFiveError);
    }

    @NotNull
    public final RegistrationPublicKeyCredential extractRegistrationPublicKeyCredential(@NotNull Intent intent) {
        AuthenticatorAttestationResponse authenticatorAttestationResponse;
        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
        byte[] fido2Response = intent.getByteArrayExtra("FIDO2_RESPONSE_EXTRA");
        AuthenticatorAttestationResponse authenticatorAttestationResponse2 = authenticatorAttestationResponse = AuthenticatorAttestationResponse.deserializeFromBytes((byte[])fido2Response);
        Intrinsics.checkExpressionValueIsNotNull((Object)authenticatorAttestationResponse2, (String)"authenticatorAttestationResponse");
        return WebAuthnRegistration.INSTANCE.createRegistrationPublicKeyCredential(authenticatorAttestationResponse2);
    }

    @NotNull
    public final Activity getActivity() {
        return this.activity;
    }

    public ReachFiveWebAuthn(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        this.activity = activity;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/reach5/identity/sdk/core/ReachFiveWebAuthn$Companion;", "", "()V", "TAG", "", "sdk-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

