/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.content.Context;
import android.net.Uri;
import com.razorpay.AnalyticsUtil;
import com.razorpay.BaseConfig;
import com.razorpay.BaseUtils;
import com.razorpay.CoreConfig;
import com.razorpay.GlobalUrlConfig;
import com.razorpay.Logger;
import com.razorpay.R;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

class ConfigCheckout
extends BaseConfig {
    private static ConfigCheckout sConfig;
    static String SDK_TYPE;
    static String SDK_VERSION;
    static int SDK_VERSION_CODE;
    static String CONFIG_AUTH_KEY;
    static String CONFIG_VERSION;
    static boolean IS_MAGIC_ENABLED;
    private ArrayList<String> mCheckoutAppendKeys = new ArrayList();
    private Map<String, String> mCheckoutUrlConfig = new HashMap<String, String>();
    private boolean mCardSavingBroadcastReceiverFlowEnabled;
    private boolean mCardSavingSharedPreferencesFlowEnabled;
    private boolean mCardSavingLocalEnabled;
    private String mNativeLoaderColor;
    private boolean mNativeLoaderEnabled;
    private Boolean mRetryEnabled;
    private int mRetryMaxCount;
    private boolean retrySetFromOptions = false;
    private boolean mBackButtonAlertEnabled;
    private String mBackButtonAlertMessage;
    private String mBackButtonNegativeText;
    private String mBackButtonPositiveText;
    private boolean mVerboseLoggingEnabled;
    private JSONObject configJson;

    private ConfigCheckout() {
    }

    public static ConfigCheckout getInstance() {
        if (sConfig == null) {
            sConfig = new ConfigCheckout();
            CoreConfig.setInstance((BaseConfig)sConfig);
        }
        return sConfig;
    }

    public void init(Context context) {
        context = ConfigCheckout.getConfigJson(context);
        this.setConfig((JSONObject)context);
    }

    public void setRetryConfigFromOptions(JSONObject jSONObject) {
        try {
            this.setRetryConfig(jSONObject, true);
            return;
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError((String)((Object)((Object)this)).getClass().getName(), (String)"S1", (String)exception.getLocalizedMessage());
            return;
        }
    }

    private static JSONObject getConfigJson(Context context) {
        return BaseConfig.getConfig((Context)context, (int)R.raw.rzp_config_checkout);
    }

    private void setCheckoutConfig(JSONObject jSONObject) throws Exception {
        Object object = (JSONArray)BaseUtils.getJsonValue((String)"checkout.append_keys", (JSONObject)jSONObject, (Object)new JSONArray());
        this.mCheckoutAppendKeys = BaseUtils.jsonStringArrayToArrayList((JSONArray)object);
        jSONObject = (JSONObject)BaseUtils.getJsonValue((String)"checkout.url_config", (JSONObject)jSONObject, (Object)new JSONObject());
        object = jSONObject.keys();
        while (object.hasNext()) {
            String string = (String)object.next();
            this.mCheckoutUrlConfig.put(string, jSONObject.getString(string));
        }
    }

    private void setCardSavingConfig(JSONObject jSONObject) throws Exception {
        this.mCardSavingBroadcastReceiverFlowEnabled = (Boolean)BaseUtils.getJsonValue((String)"card_saving.broadcast_receiver_flow", (JSONObject)jSONObject, (Object)Boolean.FALSE);
        this.mCardSavingSharedPreferencesFlowEnabled = (Boolean)BaseUtils.getJsonValue((String)"card_saving.shared_preferences_flow", (JSONObject)jSONObject, (Object)Boolean.FALSE);
        this.mCardSavingLocalEnabled = (Boolean)BaseUtils.getJsonValue((String)"card_saving.local", (JSONObject)jSONObject, (Object)Boolean.FALSE);
    }

    private void setNativeLoaderConfig(JSONObject jSONObject) throws Exception {
        this.mNativeLoaderColor = (String)BaseUtils.getJsonValue((String)"native_loader.color", (JSONObject)jSONObject, (Object)"");
        this.mNativeLoaderEnabled = (Boolean)BaseUtils.getJsonValue((String)"native_loader.enable", (JSONObject)jSONObject, (Object)"");
    }

    private void setRetryConfig(JSONObject jSONObject, boolean bl) throws Exception {
        if (!this.retrySetFromOptions) {
            this.mRetryEnabled = (boolean)((Boolean)BaseUtils.getJsonValue((String)"retry.enabled", (JSONObject)jSONObject, (Object)Boolean.TRUE));
            this.mRetryMaxCount = (Integer)BaseUtils.getJsonValue((String)"retry.max_count", (JSONObject)jSONObject, (Object)-1);
        }
        this.retrySetFromOptions = bl;
    }

    public Boolean getPrefetchEnabled() {
        return (boolean)((Boolean)BaseUtils.getJsonValue((String)"performance.prefetch", (JSONObject)this.configJson, (Object)Boolean.TRUE));
    }

    public Boolean getPreloadEnabled() {
        return (boolean)((Boolean)BaseUtils.getJsonValue((String)"performance.preload", (JSONObject)this.configJson, (Object)Boolean.TRUE));
    }

    public Boolean getAppStartupUsageEnabled() {
        return (boolean)((Boolean)BaseUtils.getJsonValue((String)"performance.app_startup", (JSONObject)this.configJson, (Object)Boolean.TRUE));
    }

    private void setBankButtonConfig(JSONObject jSONObject) throws Exception {
        this.mBackButtonAlertMessage = (String)BaseUtils.getJsonValue((String)"back_button.alert_message", (JSONObject)jSONObject, (Object)"");
        this.mBackButtonAlertEnabled = (Boolean)BaseUtils.getJsonValue((String)"back_button.enable", (JSONObject)jSONObject, (Object)Boolean.FALSE);
        this.mBackButtonPositiveText = (String)BaseUtils.getJsonValue((String)"back_button.positive_text", (JSONObject)jSONObject, (Object)"");
        this.mBackButtonNegativeText = (String)BaseUtils.getJsonValue((String)"back_button.negative_text", (JSONObject)jSONObject, (Object)"");
    }

    private void setVerboseLoggingConfig(JSONObject jSONObject) throws Exception {
        this.mVerboseLoggingEnabled = (Boolean)BaseUtils.getJsonValue((String)"feature_flags.verbose_logging.enabled", (JSONObject)jSONObject, (Object)Boolean.FALSE);
    }

    public void setConfig(JSONObject jSONObject) {
        try {
            this.setCheckoutConfig(jSONObject);
            this.setCardSavingConfig(jSONObject);
            this.setNativeLoaderConfig(jSONObject);
            this.setRetryConfig(jSONObject, false);
            this.setBankButtonConfig(jSONObject);
            this.setVerboseLoggingConfig(jSONObject);
            this.configJson = jSONObject;
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError((String)((Object)((Object)this)).getClass().getName(), (String)"S2", (String)exception.getMessage());
            Logger.e((String)("Error in setting Config, ErrorMessage=" + exception.getMessage()));
            exception.printStackTrace();
        }
        super.setConfig(jSONObject);
    }

    public boolean isCardSavingLocalEnabled() {
        return this.mCardSavingLocalEnabled;
    }

    public String getNativeLoaderColor() {
        return this.mNativeLoaderColor;
    }

    public boolean isNativeLoaderEnabled() {
        return this.mNativeLoaderEnabled;
    }

    public boolean isRetryEnabled() {
        return this.mRetryEnabled;
    }

    public int getRetryMaxCount() {
        return this.mRetryMaxCount;
    }

    public Map<String, String> getCheckoutUrlConfig() {
        return this.mCheckoutUrlConfig;
    }

    public ArrayList<String> getCheckoutAppendKeys() {
        return this.mCheckoutAppendKeys;
    }

    public String getBackButtonNegativeText() {
        return this.mBackButtonNegativeText;
    }

    public String getBackButtonPositiveText() {
        return this.mBackButtonPositiveText;
    }

    public boolean isBackButtonAlertEnabled() {
        return this.mBackButtonAlertEnabled;
    }

    public String getBackButtonAlertMessage() {
        return this.mBackButtonAlertMessage;
    }

    public boolean isCardSavingBroadcastReceiverFlowEnabled() {
        return this.mCardSavingBroadcastReceiverFlowEnabled;
    }

    public boolean isCardSavingSharedPreferencesFlowEnabled() {
        return this.mCardSavingSharedPreferencesFlowEnabled;
    }

    public boolean isVerboseLoggingEnabled() {
        return this.mVerboseLoggingEnabled;
    }

    static void fetchConfig(Context context, String string) {
        if (!ConfigCheckout.getInstance().isConfigEnabled()) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("AuthKey", CONFIG_AUTH_KEY);
        hashMap.put("Content-type", "application/json");
        hashMap.put("CurrentSettingVersion", ConfigCheckout.getCurrentConfigVersion(context));
        BaseConfig.fetchConfig((String)ConfigCheckout.getFetchConfigUrl(context, string), hashMap, (Context)context);
    }

    private static String getFetchConfigUrl(Context context, String string) {
        Uri.Builder builder = Uri.parse((String)GlobalUrlConfig.instance().getButlerUrl()).buildUpon().appendQueryParameter("tenant", "android_checkout").appendQueryParameter("sdk_version", SDK_VERSION).appendQueryParameter("sdk_type", SDK_TYPE).appendQueryParameter("magic_enabled", String.valueOf(IS_MAGIC_ENABLED)).appendQueryParameter("sdk_version_code", String.valueOf(SDK_VERSION_CODE)).appendQueryParameter("app_version", "1.7.3").appendQueryParameter("version", ConfigCheckout.getCurrentConfigVersionTag((String)ConfigCheckout.getCurrentConfigVersion(context)));
        BaseConfig.getFetchConfigBuilder((Uri.Builder)builder, (Context)context, (String)string);
        return builder.build().toString();
    }

    private static String getCurrentConfigVersion(Context object) {
        if ((object = BaseConfig.getBaseCurrentConfigVersion((Context)object)) == null) {
            object = CONFIG_VERSION;
        }
        return object;
    }

    static {
        SDK_TYPE = "standard";
        SDK_VERSION = "1.7.3";
        SDK_VERSION_CODE = 173;
        CONFIG_AUTH_KEY = "2HujvzmUo2nuRLLqhIHIV4sCEmRw9FIc";
        CONFIG_VERSION = "3.0.5";
        IS_MAGIC_ENABLED = true;
    }
}

