/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.webkit.CookieManager;
import android.webkit.ValueCallback;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.widget.LinearLayout;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsUtil;
import com.razorpay.BaseUtils;
import com.razorpay.Callback;
import com.razorpay.CardSaving;
import com.razorpay.CheckoutOptions;
import com.razorpay.CircularProgressView;
import com.razorpay.ConfigCheckout;
import com.razorpay.CoreConfig;
import com.razorpay.GlobalUrlConfig;
import com.razorpay.Logger;
import com.razorpay.Owl;
import com.razorpay.PerformanceUtil;
import com.razorpay.R;
import com.razorpay.ResponseObject;
import com.razorpay.SharedPreferenceUtil;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class CheckoutUtils {
    private static Dialog dialog;
    private static boolean isHostedOptimizerEnabled;

    CheckoutUtils() {
    }

    static void addAddons(Context context, String string) {
        AnalyticsUtil.setup((Context)context, (String)string, (String)ConfigCheckout.SDK_TYPE, (int)ConfigCheckout.SDK_VERSION_CODE, (String)ConfigCheckout.SDK_VERSION);
    }

    static String getCheckoutUrlWithOptions(CheckoutOptions checkoutOptions) {
        String string = GlobalUrlConfig.instance().getCheckoutUrl();
        string = CheckoutUtils.addParamToUrl(string, "version", ConfigCheckout.SDK_VERSION);
        Map<String, String> object3 = ConfigCheckout.getInstance().getCheckoutUrlConfig();
        ArrayList<String> arrayList = object3.keySet();
        for (String string2 : arrayList) {
            string = CheckoutUtils.addParamToUrl(string, string2, object3.get(string2));
        }
        arrayList = ConfigCheckout.getInstance().getCheckoutAppendKeys();
        for (String string3 : arrayList) {
            if (!checkoutOptions.has(string3)) continue;
            string = CheckoutUtils.addParamToUrl(string, string3, (String)checkoutOptions.get(string3));
        }
        Logger.d((String)("Modified Url: " + string));
        return string;
    }

    static boolean isDynamicUrlConfigUsed(Bundle object) {
        if (object == null) {
            return false;
        }
        object = new CheckoutOptions(object.getString("OPTIONS"));
        return object.getAsJson().has("hosted_config");
    }

    static void isFeatureEnabled(String string, final String string2, final Callback callback) {
        final ResponseObject responseObject = new ResponseObject();
        Owl.post((String)("https://api.razorpay.com/v2/preferences?key_id=" + string), (String)"{\"query\":[{\"resource\":\"merchant_features\"}],\"action\":\"get\"}", (Callback)new Callback(){

            public void run(ResponseObject responseObject2) {
                try {
                    if (responseObject2 != null) {
                        if (responseObject2.getResponseCode() >= 400) {
                            isHostedOptimizerEnabled = false;
                            return;
                        }
                        if (responseObject2.getResponseResult() != null && (responseObject2 = new JSONObject(responseObject2.getResponseResult())).has("features") && (responseObject2 = responseObject2.getJSONObject("features")).has("data") && (responseObject2 = responseObject2.getJSONObject("data")).has(string2)) {
                            responseObject.setResponseResult(String.valueOf(responseObject2.getBoolean(string2)));
                            callback.run(responseObject);
                        }
                    }
                    return;
                }
                catch (JSONException jSONException) {
                    AnalyticsUtil.reportError((String)CheckoutUtils.class.getName(), (String)"S0", (String)jSONException.getMessage());
                    responseObject.setResponseResult("false");
                    callback.run(responseObject);
                    return;
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    static String getCheckoutUrlWithOptions(CheckoutOptions checkoutOptions, String object4) {
        Object object = checkoutOptions.getAsJson();
        if (object4 != null) {
            object = object4;
            if (!((String)object4).contains(".html")) {
                object = CheckoutUtils.addParamToUrl((String)object, "version", ConfigCheckout.SDK_VERSION);
            }
            Map<String, String> i = ConfigCheckout.getInstance().getCheckoutUrlConfig();
            ArrayList<String> arrayList = i.keySet();
            for (String string : arrayList) {
                object = CheckoutUtils.addParamToUrl((String)object, string, i.get(string));
            }
            arrayList = ConfigCheckout.getInstance().getCheckoutAppendKeys();
            for (String string : arrayList) {
                if (!checkoutOptions.has(string)) continue;
                object = CheckoutUtils.addParamToUrl((String)object, string, (String)checkoutOptions.get(string));
            }
            Logger.d((String)("Modified Url: " + (String)object));
            return object;
        }
        if (checkoutOptions.has("hosted_config")) {
            try {
                void var1_8;
                object = object.getJSONObject("hosted_config");
                String string = object.getString("frame");
                CharSequence charSequence = CheckoutUtils.getHostedFrameBaseUrl(string);
                String string2 = (String)charSequence + CoreConfig.getInstance().getHostedFrameBuild();
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append(string2);
                boolean bl = true;
                boolean bl2 = false;
                while (var1_8 < object.length()) {
                    String string3 = object.names().getString((int)var1_8);
                    if (!string3.equals("frame")) {
                        boolean bl3;
                        if (bl3) {
                            ((StringBuilder)charSequence).append("?");
                            bl3 = false;
                        } else {
                            ((StringBuilder)charSequence).append("&");
                        }
                        String string4 = URLEncoder.encode(string3, "UTF-8");
                        string3 = URLEncoder.encode(object.getString(string3), "UTF-8");
                        ((StringBuilder)charSequence).append(string4).append("=").append(string3);
                    }
                    ++var1_8;
                }
                return CheckoutUtils.getCheckoutUrlWithOptions(checkoutOptions, ((StringBuilder)charSequence).toString());
            }
            catch (UnsupportedEncodingException | JSONException throwable) {
                return CheckoutUtils.getCheckoutUrlWithOptions(checkoutOptions);
            }
        }
        return CheckoutUtils.getCheckoutUrlWithOptions(checkoutOptions);
    }

    public static String getHostedFrameBaseUrl(String object) {
        try {
            object = new URL((String)object);
            return ((URL)object).getProtocol() + "://" + ((URL)object).getHost();
        }
        catch (Exception exception) {
            return "";
        }
    }

    static boolean isCheckoutUrl(WebView object) {
        object = object.getTag() == null ? "" : object.getTag().toString();
        return object.contains(GlobalUrlConfig.instance().getBaseUrl());
    }

    static String addParamToUrl(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            return string;
        }
        string = string + (string.contains("?") ? "&" : "?") + string2;
        if (string3 == null) {
            return string;
        }
        return string + "=" + string3;
    }

    static void disableFullScreenMode(Activity activity) {
        activity.getWindow().addFlags(2048);
        activity.getWindow().clearFlags(1024);
    }

    static boolean shouldRetryPayment(int n) {
        int n2 = ConfigCheckout.getInstance().getRetryMaxCount();
        return ConfigCheckout.getInstance().isRetryEnabled() && (n2 == -1 || n2 >= n);
    }

    static String getBase64FromCurrentAppsResource(Activity activity, int n) {
        activity = activity.getResources();
        return BaseUtils.getBase64FromResource((Resources)activity, (int)n);
    }

    static void setUserEmail(Context context, String string) {
        SharedPreferenceUtil.setProtectedValue((Context)context, (String)"rzp_user_email", (String)string, null);
    }

    static void setMerchantOptions(Context context, String string, String string2) {
        if (string2 == null) {
            SharedPreferenceUtil.removeValue((Context)context, (String)("pref_merchant_options_" + string));
            return;
        }
        SharedPreferenceUtil.setProtectedValue((Context)context, (String)("pref_merchant_options_" + string), (String)string2, null);
    }

    static String getMerchantOptions(Context context, String string) {
        return SharedPreferenceUtil.getProtectedValue((Context)context, (String)("pref_merchant_options_" + string), null);
    }

    static void setUserContact(Context context, String string) {
        SharedPreferenceUtil.setProtectedValue((Context)context, (String)"rzp_user_contact", (String)string, null);
    }

    static String getUserEmail(Context context) {
        return SharedPreferenceUtil.getProtectedValue((Context)context, (String)"rzp_user_email", null);
    }

    static String getUserContact(Context context) {
        return SharedPreferenceUtil.getProtectedValue((Context)context, (String)"rzp_user_contact", null);
    }

    static void showDialog(Context context, String string, String string2, String string3, final BackButtonDialogCallback backButtonDialogCallback) {
        new AlertDialog.Builder(context).setMessage((CharSequence)string).setPositiveButton((CharSequence)string2, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                backButtonDialogCallback.onPositiveButtonClick();
            }
        }).setNegativeButton((CharSequence)string3, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                backButtonDialogCallback.onNegativeButtonClick();
            }
        }).show();
    }

    static JSONObject isPackageInstalled(Context context, String string) {
        try {
            PackageManager packageManager = context.getPackageManager();
            ResolveInfo resolveInfo = new ResolveInfo();
            new ResolveInfo().resolvePackageName = packageManager.getPackageInfo((String)string, (int)0).packageName;
            return CheckoutUtils.getAppExistenceDataInJson(context, resolveInfo);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    static JSONObject getAppExistenceDataInJson(Context object, ResolveInfo resolveInfo) {
        object = new JSONObject();
        try {
            if (resolveInfo.resolvePackageName.equalsIgnoreCase("com.dreamplug.androidapp")) {
                object.put("shortcode", (Object)"cred");
                object.put("uri", (Object)"credpay");
                object.put("package_name", (Object)resolveInfo.resolvePackageName);
            } else if (resolveInfo.resolvePackageName.equalsIgnoreCase("in.org.npci.upiapp")) {
                object.put("shortcode", (Object)"bhim");
                object.put("uri", (Object)"upi://pay");
                object.put("package_name", (Object)resolveInfo.resolvePackageName);
            } else {
                object.put("package_name", (Object)resolveInfo.resolvePackageName);
            }
            return object;
        }
        catch (JSONException jSONException) {
            object = jSONException;
            AnalyticsUtil.reportError((String)jSONException.getLocalizedMessage(), (String)"S2", (String)object.getMessage());
            object.printStackTrace();
            return null;
        }
    }

    static JSONArray getUpiIntentsDataInJsonArray(Context context) {
        Object object = BaseUtils.getListOfAppsWhichHandleDeepLink((Context)context, (String)"upi://pay");
        if (object != null && object.size() > 0) {
            JSONArray jSONArray = new JSONArray();
            object = object.iterator();
            while (object.hasNext()) {
                ResolveInfo resolveInfo = (ResolveInfo)object.next();
                jSONArray.put((Object)CheckoutUtils.getIntentDataInJson(context, resolveInfo));
            }
            return jSONArray;
        }
        return null;
    }

    static JSONArray getAppIntentDataInJsonArray(Context context) {
        Object object = new ArrayList<String>();
        JSONArray jSONArray = new JSONArray();
        object.add("credpay://checkout");
        object.add("truecallersdk://truesdk");
        object = object.iterator();
        while (object.hasNext()) {
            Iterator iterator = (String)object.next();
            if ((iterator = BaseUtils.getListOfAppsWhichHandleDeepLink((Context)context, (String)((Object)iterator))) == null || iterator.size() <= 0) continue;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                ResolveInfo resolveInfo = (ResolveInfo)iterator.next();
                jSONArray.put((Object)CheckoutUtils.getAppIntentDataInJson(context, resolveInfo));
            }
        }
        if (jSONArray.length() == 0) {
            return null;
        }
        return jSONArray;
    }

    static JSONObject getAppIntentDataInJson(Context object, ResolveInfo resolveInfo) {
        object = new JSONObject();
        try {
            if (resolveInfo.activityInfo.packageName.contains("com.dreamplug.androidapp")) {
                object.put("package_name", (Object)"com.dreamplug.androidapp");
                object.put("shortcode", (Object)"cred");
                object.put("uri", (Object)"credpay");
            } else if (resolveInfo.activityInfo.packageName.contains("com.truecaller")) {
                object.put("package_name", (Object)"com.truecaller");
                object.put("shortcode", null);
                object.put("uri", null);
            }
            return object;
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            AnalyticsUtil.reportError((String)((Throwable)object).getMessage(), (String)"S1", (String)((Throwable)object).getMessage());
            return null;
        }
    }

    static JSONObject getIntentDataInJson(Context context, ResolveInfo resolveInfo) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("package_name", (Object)resolveInfo.activityInfo.packageName);
            String string = BaseUtils.getAppNameOfResolveInfo((ResolveInfo)resolveInfo, (Context)context);
            jSONObject.put("app_name", (Object)string);
            jSONObject.put("app_icon", (Object)BaseUtils.getBase64FromOtherAppsResource((Context)context, (String)resolveInfo.activityInfo.packageName));
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            AnalyticsUtil.reportError((String)exception.getMessage(), (String)"S2", (String)exception2.getMessage());
            exception2.printStackTrace();
        }
        return jSONObject;
    }

    static void showLoader(Context context) {
        if (!ConfigCheckout.getInstance().isNativeLoaderEnabled()) {
            return;
        }
        if (context == null || ((Activity)context).isFinishing()) {
            return;
        }
        if (dialog != null && dialog.isShowing()) {
            return;
        }
        dialog = new Dialog(context);
        dialog.requestWindowFeature(1);
        dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        dialog.setContentView(R.layout.rzp_loader);
        context = (CircularProgressView)dialog.findViewById(R.id.progressBar);
        context.setColor(Color.parseColor((String)ConfigCheckout.getInstance().getNativeLoaderColor()));
        context = (LinearLayout)dialog.findViewById(R.id.ll_loader);
        context.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CheckoutUtils.dismissLoader();
            }
        });
        try {
            dialog.show();
            return;
        }
        catch (Exception exception) {
            Logger.e((String)"Error showing loader", (Throwable)exception);
            return;
        }
    }

    static void showLoaderForMagicX(Context context, String string) {
        if (context == null || ((Activity)context).isFinishing()) {
            return;
        }
        if (dialog != null && dialog.isShowing()) {
            return;
        }
        dialog = new Dialog(context);
        dialog.requestWindowFeature(1);
        dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        dialog.setContentView(R.layout.rzp_loader);
        context = (CircularProgressView)dialog.findViewById(R.id.progressBar);
        context.setColor(Color.parseColor((String)string));
        context = (LinearLayout)dialog.findViewById(R.id.ll_loader);
        context.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CheckoutUtils.dismissLoader();
            }
        });
        try {
            dialog.show();
            return;
        }
        catch (Exception exception) {
            Logger.e((String)"Error showing loader", (Throwable)exception);
            return;
        }
    }

    static boolean isDialogShowing() {
        if (dialog == null) {
            return false;
        }
        return dialog.isShowing();
    }

    static void dismissLoader() {
        if (dialog == null) {
            return;
        }
        if (dialog.isShowing()) {
            try {
                dialog.dismiss();
            }
            catch (Exception exception) {
                Logger.e((String)"Error dismissing loader", (Throwable)exception);
            }
        }
        dialog = null;
    }

    static void clearUserData(Context context) {
        CheckoutUtils.setUserContact(context, null);
        CheckoutUtils.setUserEmail(context, null);
        CardSaving.setDeviceToken(context, null);
        CheckoutUtils.clearUserRelatedCookies();
    }

    static void clearUserRelatedCookies() {
        CookieManager cookieManager = CookieManager.getInstance();
        cookieManager.setCookie("https://api.razorpay.com", "razorpay_api_session=");
        WebStorage.getInstance().deleteAllData();
        if (Build.VERSION.SDK_INT >= 21) {
            cookieManager.removeSessionCookies((ValueCallback)new ValueCallback<Boolean>(){

                public void onReceiveValue(Boolean bl) {
                    if (bl.booleanValue()) {
                        CookieManager.getInstance().removeAllCookies(null);
                        CookieManager.getInstance().flush();
                    }
                }
            });
            return;
        }
        cookieManager.removeAllCookie();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void toggleWebviewBackground(WebView webView, boolean bl) {
        if (webView == null) return;
        if (bl) {
            webView.setBackgroundColor(Color.parseColor((String)"#99000000"));
            return;
        }
        Drawable drawable2 = webView.getBackground();
        if (!(drawable2 instanceof ColorDrawable)) {
            webView.setBackgroundColor(Color.parseColor((String)"#99000000"));
            return;
        }
        int n = ((ColorDrawable)drawable2).getColor();
        if (Color.alpha((int)n) != 0 && n != Color.parseColor((String)"#99000000")) {
            webView.setBackgroundColor(Color.parseColor((String)"#99000000"));
            return;
        }
        webView.setBackgroundColor(-1);
    }

    public static Bundle getCheckoutActivityStateBundle(Activity object) {
        try {
            object = SharedPreferenceUtil.getValue((Context)object, (String)"SAVED_STATE_BUNDLE_MAP");
            if (object == null) {
                return null;
            }
            object = new JSONObject((String)object);
            Bundle bundle = new Bundle();
            if (object.has("OPTIONS")) {
                bundle.putString("OPTIONS", object.getString("OPTIONS"));
            }
            if (object.has("DASH_OPTIONS")) {
                bundle.putString("DASH_OPTIONS", object.getString("DASH_OPTIONS"));
            }
            if (object.has("IMAGE")) {
                bundle.putInt("IMAGE", object.getInt("IMAGE"));
            }
            if (object.has("DISABLE_FULL_SCREEN")) {
                bundle.putBoolean("DISABLE_FULL_SCREEN", object.getBoolean("DISABLE_FULL_SCREEN"));
            }
            return bundle;
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError((String)"CheckoutUtils.getCheckoutActivityStateBundle()", (String)"S1", (String)exception.getMessage());
            return null;
        }
    }

    public static JSONObject checkoutActivityStateBundleToJSONObject(Bundle bundle) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("OPTIONS", (Object)bundle.getString("OPTIONS"));
            jSONObject.put("DASH_OPTIONS", (Object)bundle.getString("DASH_OPTIONS"));
            if (bundle.containsKey("IMAGE")) {
                jSONObject.put("IMAGE", bundle.getInt("IMAGE"));
            }
            if (bundle.containsKey("DISABLE_FULL_SCREEN")) {
                jSONObject.put("DISABLE_FULL_SCREEN", bundle.getBoolean("DISABLE_FULL_SCREEN"));
            }
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError((String)"CheckoutUtils.checkoutActivityStateBundleToJSONObject()", (String)"S1", (String)exception.getMessage());
            return null;
        }
        return jSONObject;
    }

    static boolean shouldDisableHardwareAcceleration(Context context, CheckoutOptions checkoutOptions) {
        try {
            if (context == null || checkoutOptions == null) {
                Logger.d((String)"context or checkout options null, keeping HW accel enabled");
                return false;
            }
            String string = Build.MANUFACTURER;
            int n = PerformanceUtil.getPerformanceClass((Context)context);
            boolean bl = PerformanceUtil.isLowEndDevice((Context)context);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("manufacturer", string);
            hashMap.put("performance_class", n);
            hashMap.put("is_low_end_device", bl);
            hashMap.put("merchant_flag_enabled", checkoutOptions.shouldDisableHardwareAccelerationForLowEndDevices());
            if (!checkoutOptions.shouldDisableHardwareAccelerationForLowEndDevices()) {
                hashMap.put("hw_acceleration_status", "enabled");
                hashMap.put("reason", "merchant_flag_not_set");
                AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CHECKOUT_HARDWARE_ACCELERATION_CHECK, (JSONObject)AnalyticsUtil.getJSONResponse(hashMap));
                return false;
            }
            if (!bl) {
                hashMap.put("hw_acceleration_status", "enabled");
                hashMap.put("reason", "high_end_device");
                AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CHECKOUT_HARDWARE_ACCELERATION_CHECK, (JSONObject)AnalyticsUtil.getJSONResponse(hashMap));
                return false;
            }
            if (string == null || !string.equalsIgnoreCase("OPPO")) {
                hashMap.put("hw_acceleration_status", "enabled");
                hashMap.put("reason", "not_oppo_manufacturer");
                AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CHECKOUT_HARDWARE_ACCELERATION_CHECK, (JSONObject)AnalyticsUtil.getJSONResponse(hashMap));
                return false;
            }
            hashMap.put("hw_acceleration_status", "disabled");
            hashMap.put("reason", "oppo_low_end_device");
            AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CHECKOUT_HARDWARE_ACCELERATION_CHECK, (JSONObject)AnalyticsUtil.getJSONResponse(hashMap));
            Logger.d((String)"Hardware acceleration disabled: OPPO low-end device detected");
            return true;
        }
        catch (Exception exception) {
            Logger.e((String)("Error in shouldDisableHardwareAcceleration: " + exception.getMessage()));
            return false;
        }
    }

    static {
        isHostedOptimizerEnabled = false;
    }

    static interface BackButtonDialogCallback {
        public void onPositiveButtonClick();

        public void onNegativeButtonClick();
    }
}

