/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.content.Context;
import androidx.annotation.NonNull;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsUtil;
import com.razorpay.Logger;
import com.razorpay.Owl;
import com.razorpay.ResponseObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONObject;

public class CheckoutCacheManager {
    private static CheckoutCacheManager instance;
    public boolean areAllFilesDownloaded = false;
    public boolean isCachingDisabled = false;
    private boolean shouldClearCache = false;
    public String buildNumber;
    public String publicPageResponse;
    public String checkoutPublicUrl;
    public boolean isFetchedPublicPageUsed = false;
    public HashMap<String, String> files = new HashMap();
    private Context context;
    private HashMap<String, String> fileLocations = new HashMap();
    Map<String, Object> props = new HashMap<String, Object>();

    private CheckoutCacheManager() {
    }

    public static CheckoutCacheManager getInstance() {
        if (instance == null) {
            instance = new CheckoutCacheManager();
        }
        return instance;
    }

    public void startPrefetchForPublicPage() {
        this.checkoutPublicUrl = "https://api.razorpay.com/v1/checkout/public?platform=android&version=1.7.3&library=checkoutjs";
        Owl.get((String)this.checkoutPublicUrl, responseObject -> {
            if (responseObject.getResponseCode() > 400) {
                this.isCachingDisabled = true;
                return;
            }
            this.publicPageResponse = responseObject.getResponseResult();
        });
    }

    public void startPrefetch(Context context) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.execute(() -> {
            this.context = context;
            this.startPrefetch();
        });
    }

    private void trackEvent(AnalyticsEvent analyticsEvent, String string, Object object) {
        this.props.clear();
        this.props.put(string, object);
        AnalyticsUtil.trackEvent((AnalyticsEvent)analyticsEvent, this.props);
    }

    public void startPrefetch() {
        Logger.d((String)("LOAD_TIME Merchant initialized checkout: " + System.currentTimeMillis()));
        this.trackEvent(AnalyticsEvent.CHECKOUT_PREFETCH_STARTED, "timestamp", System.currentTimeMillis());
        Owl.get((String)"https://checkout.razorpay.com/v1/prefetch.json", object -> {
            this.trackEvent(AnalyticsEvent.CHECKOUT_PREFETCH_FILE_DOWNLOADED, "timestamp", System.currentTimeMillis());
            if (!this.isErrorOrIsCachingDisabled(object)) {
                try {
                    Object object2;
                    int n;
                    Object object3;
                    object = new JSONObject(object.getResponseResult());
                    this.buildNumber = object.getString("build");
                    JSONArray jSONArray = object.getJSONArray("files");
                    object = object.optString("traffic_env");
                    this.checkoutPublicUrl = "https://api.razorpay.com/v1/checkout/public?platform=android&version=1.7.3&library=checkoutjs&build=" + this.buildNumber;
                    if (!((String)object).isEmpty()) {
                        this.checkoutPublicUrl = this.checkoutPublicUrl + "&traffic_env=" + (String)object;
                    }
                    this.trackEvent(AnalyticsEvent.CHECKOUT_PREFETCH_PUBLIC_PAGE_DOWNLOAD_START, "timestamp", System.currentTimeMillis());
                    Owl.get((String)this.checkoutPublicUrl, responseObject -> {
                        this.trackEvent(AnalyticsEvent.CHECKOUT_PREFETCH_PUBLIC_PAGE_DOWNLOAD_COMPLETE, "timestamp", System.currentTimeMillis());
                        if (responseObject.getResponseCode() > 400) {
                            this.trackEvent(AnalyticsEvent.CHECKOUT_PREFETCH_PUBLIC_PAGE_DOWNLOAD_FAILED, "timestamp", System.currentTimeMillis());
                            this.isCachingDisabled = true;
                            return;
                        }
                        this.publicPageResponse = responseObject.getResponseResult();
                    });
                    CheckoutCacheManager checkoutCacheManager = this;
                    if (checkoutCacheManager.doesBuildNumberExist(checkoutCacheManager.buildNumber)) {
                        AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CHECKOUT_PREFETCH_BUILD_EXISTS);
                        object = this.context.getFilesDir() + "/razorpay/" + this.buildNumber;
                        object3 = new File((String)object);
                        for (n = 0; n < jSONArray.length(); ++n) {
                            Logger.d((String)"build number exists");
                            object2 = jSONArray.getString(n);
                            object = ((String)object2).substring(((String)object2).lastIndexOf("/") + 1);
                            object2 = this.getFileIfBuildExists((String)object);
                            if (object2 == null || ((String)object2).isEmpty()) {
                                AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CHECKOUT_PREFETCH_BUILD_EXISTS_FILE_ERROR);
                                this.deleteRecursive((File)object3);
                                Logger.d((String)("File data is empty or null for file " + (String)object));
                                this.startPrefetch();
                                break;
                            }
                            this.files.put((String)object, (String)object2);
                            Logger.d((String)this.files.toString());
                        }
                        if (this.files != null) {
                            this.trackEvent(AnalyticsEvent.CHECKOUT_PREFETCH_BUILD_LOCAL_ASSETS_LOADED, "timestamp", System.currentTimeMillis());
                            return;
                        }
                    }
                    this.trackEvent(AnalyticsEvent.CHECKOUT_PREFETCH_ASSET_FILES_DOWNLOAD_START, "timestamp", System.currentTimeMillis());
                    int n2 = 0;
                    while (n2 < jSONArray.length()) {
                        Logger.d((String)("FileName: " + jSONArray.getString(n2)));
                        object3 = jSONArray.getString(n2);
                        n = n2++;
                        object2 = new HashMap<String, String>();
                        object2.put("accept-encoding", "gzip");
                        Owl.get((String)object3, (Map)object2, arg_0 -> this.lambda$startPrefetch$3((String)object3, n, jSONArray, arg_0));
                    }
                    return;
                }
                catch (Exception exception) {}
            }
        });
    }

    private boolean doesBuildNumberExist(String object) {
        if (this.context != null) {
            object = this.context.getFilesDir() + "/razorpay/" + (String)object;
            object = new File((String)object);
            return ((File)object).exists();
        }
        return false;
    }

    private boolean isErrorOrIsCachingDisabled(@NonNull ResponseObject responseObject) {
        if (responseObject.getResponseCode() > 400) {
            if (responseObject.getResponseCode() == 404) {
                this.clearCacheFilesWhenActivityIsAvailable();
            }
            return true;
        }
        try {
            responseObject = new JSONObject(responseObject.getResponseResult());
            if (!responseObject.getBoolean("enabled")) {
                this.clearCacheFilesWhenActivityIsAvailable();
                return true;
            }
        }
        catch (Exception exception) {
            this.clearCacheFilesWhenActivityIsAvailable();
            return true;
        }
        return false;
    }

    private void clearCacheFilesWhenActivityIsAvailable() {
        this.isCachingDisabled = true;
        this.shouldClearCache = true;
        if (this.context != null) {
            File file = new File(this.context.getFilesDir() + "/razorpay");
            this.deleteRecursive(file);
            this.reset();
        }
    }

    public void saveFilesToCache(Context object) {
        this.trackEvent(AnalyticsEvent.CHECKOUT_PREFETCH_ASSET_FILES_STORING_START, "timestamp", System.currentTimeMillis());
        Logger.d((String)("LOAD_TIME saveFilesToCache with context: " + System.currentTimeMillis()));
        this.context = object;
        if (this.isCachingDisabled) {
            if (this.shouldClearCache) {
                File file = new File(object.getFilesDir() + "/razorpay");
                this.deleteRecursive(file);
                this.reset();
                return;
            }
            return;
        }
        Object object2 = object.getFilesDir() + "/razorpay/";
        File file = new File((String)(object = object.getFilesDir() + "/razorpay/" + this.buildNumber));
        if (file.exists()) {
            return;
        }
        if (this.areAllFilesDownloaded) {
            File[] object32 = ((File)(object2 = new File((String)object2))).listFiles();
            if (object32 != null && object32.length >= 3) {
                this.deleteRecursive((File)object2);
            }
            file.mkdirs();
            for (Map.Entry entry : this.files.entrySet()) {
                Object object3;
                if (entry.getValue() == null || ((String)entry.getValue()).isEmpty()) {
                    this.deleteRecursive((File)object2);
                    return;
                }
                if (entry.getValue() == null) {
                    return;
                }
                this.fileLocations.put((String)entry.getKey(), (String)object + "/" + (String)entry.getKey());
                try {
                    object3 = new File((String)object + "/" + (String)entry.getKey());
                    ((File)object3).createNewFile();
                    object3 = new FileOutputStream((File)object3);
                    ((FileOutputStream)object3).write(((String)entry.getValue()).getBytes());
                    ((FileOutputStream)object3).close();
                }
                catch (Exception exception) {
                    object3 = new HashMap<String, Object>();
                    object3.put("filename", entry.getKey());
                    object3.put("timestamp", System.currentTimeMillis());
                    AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CHECKOUT_PREFETCH_ASSET_FILES_STORING_FAILED, object3);
                }
            }
            this.trackEvent(AnalyticsEvent.CHECKOUT_PREFETCH_ASSET_FILES_STORING_END, "timestamp", System.currentTimeMillis());
        }
    }

    private void deleteRecursive(File file) {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                this.deleteRecursive(file2);
            }
        }
        file.delete();
    }

    public String getFileIfBuildExists(String string) {
        if (this.isCachingDisabled) {
            return "";
        }
        try {
            int n;
            if (this.files.get(string) != null) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("filename", string);
                hashMap.put("timestamp", System.currentTimeMillis());
                AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CHECKOUT_PREFETCH_LOCAL_ASSET_FILE_LOADED, hashMap);
                Logger.d((String)("file " + string + " found in fileSet: loading from cache"));
                return this.files.get(string);
            }
            Object object = this.context.getFilesDir() + "/razorpay/";
            if (((File)(object = new File((String)object))).exists() && (n = ((File[])(object = ((File)object).listFiles())).length) > 0) {
                object = object[0];
                Comparable<File> comparable = new File((String)(object = ((File)object).getPath() + "/" + string));
                if (((File)comparable).exists()) {
                    Logger.d((String)("checkFileName:" + (String)object));
                    try {
                        String string2;
                        object = new FileInputStream((File)comparable);
                        object = new InputStreamReader((InputStream)object);
                        object = new BufferedReader((Reader)object);
                        comparable = new StringBuilder();
                        while ((string2 = ((BufferedReader)object).readLine()) != null) {
                            ((StringBuilder)comparable).append(string2);
                        }
                        object = ((StringBuilder)comparable).toString();
                        Logger.d((String)("fileContents for " + string + ": \n" + (String)object));
                        return object;
                    }
                    catch (IOException iOException) {
                        Logger.e((String)("fileNotFoundException : " + iOException.getLocalizedMessage()));
                        String string3 = "";
                        Logger.d((String)("fileContents for " + string + ": \n" + string3));
                        AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CHECKOUT_PREFETCH_LOCAL_ASSET_FILE_LOADED, this.props);
                        return string3;
                    }
                }
                AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CHECKOUT_PREFETCH_LOCAL_ASSET_FILE_LOAD_FAILED, this.props);
                return "";
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            return "";
        }
        return "";
    }

    public void reset() {
        this.areAllFilesDownloaded = false;
        this.shouldClearCache = false;
        this.buildNumber = null;
        this.publicPageResponse = null;
        this.files = new HashMap();
        this.checkoutPublicUrl = null;
        this.publicPageResponse = null;
        this.isFetchedPublicPageUsed = false;
    }

    private /* synthetic */ void lambda$startPrefetch$3(String string, int n, JSONArray jSONArray, ResponseObject responseObject) {
        if (responseObject.getResponseResult() == null) {
            this.trackEvent(AnalyticsEvent.CHECKOUT_PREFETCH_ASSET_FILES_DOWNLOAD_INTERRUPTED, "filename", string);
            return;
        }
        try {
            Logger.d((String)responseObject.getResponseResult());
            String string2 = string;
            this.files.put(string2.substring(string2.lastIndexOf("/") + 1), responseObject.getResponseResult());
            Logger.d((String)string);
            if (n == jSONArray.length() - 1) {
                Logger.d((String)("LOAD_TIME all files are downloaded " + System.currentTimeMillis()));
                this.trackEvent(AnalyticsEvent.CHECKOUT_PREFETCH_ASSET_FILES_DOWNLOAD_END, "timestamp", System.currentTimeMillis());
                this.areAllFilesDownloaded = true;
                if (this.context != null) {
                    CheckoutCacheManager checkoutCacheManager = this;
                    checkoutCacheManager.saveFilesToCache(checkoutCacheManager.context);
                }
            }
            return;
        }
        catch (Exception exception) {
            this.trackEvent(AnalyticsEvent.CHECKOUT_PREFETCH_DECOMPRESS_FAILED, "filename", string);
            return;
        }
    }
}

