/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.RelativeLayout;
import com.razorpay.ResizeWidthAnimation;

final class RZPProgressBar {
    private Context context;
    private ViewGroup container;
    private View progressBar;
    private float screenWidth;
    private int defaultHeight;
    private String color;

    public RZPProgressBar(Context context, ViewGroup viewGroup) {
        this(context, viewGroup, null);
    }

    public RZPProgressBar(Context context, ViewGroup viewGroup, String string) {
        this.color = string;
        this.context = context;
        this.container = viewGroup;
        this.getScreenDimensions();
        this.defaultHeight = this.convertDPtoInt(4);
        this.insertView();
    }

    private void getScreenDimensions() {
        DisplayMetrics displayMetrics = this.context.getResources().getDisplayMetrics();
        this.screenWidth = (float)displayMetrics.widthPixels / displayMetrics.density;
    }

    private int getThemeAccentColor() {
        int n = Build.VERSION.SDK_INT >= 21 ? 16843829 : this.context.getResources().getIdentifier("colorAccent", "attr", this.context.getPackageName());
        TypedValue typedValue = new TypedValue();
        boolean bl = this.context.getTheme().resolveAttribute(n, typedValue, true);
        n = bl ? 1 : 0;
        if (bl) {
            return typedValue.data;
        }
        return Color.parseColor((String)"#4aa3df");
    }

    private void insertView() {
        int n;
        this.progressBar = new View(this.context);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(0, this.defaultHeight);
        this.progressBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (TextUtils.isEmpty((CharSequence)this.color)) {
            n = this.getThemeAccentColor();
        } else {
            try {
                n = Color.parseColor((String)this.color);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                n = this.getThemeAccentColor();
            }
        }
        float[] fArray = new float[3];
        Color.colorToHSV((int)n, (float[])fArray);
        fArray[2] = fArray[2] * 0.8f;
        int n2 = Color.HSVToColor((float[])fArray);
        GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{n, n2});
        gradientDrawable.setCornerRadius(0.0f);
        this.progressBar.setBackgroundDrawable((Drawable)gradientDrawable);
        this.container.addView(this.progressBar);
    }

    private int convertDPtoInt(int n) {
        return (int)TypedValue.applyDimension((int)1, (float)n, (DisplayMetrics)this.context.getResources().getDisplayMetrics());
    }

    final void show(int n) {
        if (n == 100) {
            this.hide();
            return;
        }
        this.animateTo(n, 500);
    }

    final void hide() {
        this.animateToEnd(200);
    }

    private void animateTo(int n, int n2) {
        n = (int)(this.screenWidth * (float)n / 100.0f);
        n = this.convertDPtoInt(n);
        ResizeWidthAnimation resizeWidthAnimation = new ResizeWidthAnimation(this.progressBar, n);
        resizeWidthAnimation.setDuration(n2);
        this.progressBar.startAnimation((Animation)resizeWidthAnimation);
        resizeWidthAnimation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationEnd(Animation animation) {
            }

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
    }

    private void animateToEnd(int n) {
        int n2 = (int)this.screenWidth;
        n2 = this.convertDPtoInt(n2);
        ResizeWidthAnimation resizeWidthAnimation = new ResizeWidthAnimation(this.progressBar, n2);
        resizeWidthAnimation.setDuration(n);
        this.progressBar.startAnimation((Animation)resizeWidthAnimation);
        resizeWidthAnimation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationEnd(Animation animation) {
                RZPProgressBar.this.animateTo(0, 10);
            }

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
    }
}

