/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.app.Activity;
import com.razorpay.AnalyticsUtil;
import com.razorpay.BaseUtils;
import com.razorpay.Callback;
import com.razorpay.ConfigCheckout;
import com.razorpay.Owl;
import com.razorpay.ResponseObject;

class MagicData {
    Activity activity;
    private String magicJs;
    public static String versionKey = "magic_version";

    MagicData(Activity activity) {
        this.activity = activity;
    }

    void checkForUpdates() {
        Owl.get((String)ConfigCheckout.getInstance().getMagicVersionUrl(), (Callback)new Callback(){

            public void run(ResponseObject object) {
                if (object.getResponseResult() == null) {
                    return;
                }
                try {
                    object = BaseUtils.getVersionFromJsonString((String)object.getResponseResult(), (String)versionKey);
                    String string = BaseUtils.getLocalVersion((Activity)MagicData.this.activity, (String)versionKey);
                    if (!string.equals(object)) {
                        MagicData.this.updateMagic((String)object);
                    }
                    return;
                }
                catch (Exception exception) {
                    AnalyticsUtil.reportError((String)this.getClass().getName(), (String)"S1", (String)"Could not extract version from server json");
                    return;
                }
            }
        });
    }

    private void updateMagic(final String string) {
        Owl.get((String)ConfigCheckout.getInstance().getMagicJsUrl(), (Callback)new Callback(){

            public void run(ResponseObject responseObject) {
                String string3;
                String string2;
                if (responseObject.getResponseResult() != null && (string2 = BaseUtils.decryptFile((String)responseObject.getResponseResult())) != null && BaseUtils.storeFileInInternal((Activity)MagicData.this.activity, (String)(string3 = BaseUtils.getVersionedAssetName((String)string, (String)ConfigCheckout.getInstance().getMagicJsFileName())), (String)responseObject.getResponseResult())) {
                    MagicData.this.magicJs = string2;
                    BaseUtils.updateLocalVersion((Activity)MagicData.this.activity, (String)versionKey, (String)string);
                }
            }
        });
    }

    String getMagicJs() {
        if (this.magicJs == null) {
            String string = BaseUtils.getLocalVersion((Activity)this.activity, (String)versionKey);
            if (string.equals(BaseUtils.getVersionFromJsonString((String)ConfigCheckout.getVersionJSON(), (String)versionKey))) {
                this.magicJs = ConfigCheckout.getMagicJs();
            } else {
                try {
                    this.magicJs = BaseUtils.getFileFromInternal((Activity)this.activity, (String)ConfigCheckout.getInstance().getMagicJsFileName(), (String)versionKey);
                }
                catch (Exception exception) {
                    this.magicJs = ConfigCheckout.getMagicJs();
                }
            }
        }
        return this.magicJs;
    }
}

