/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.razorpay.AnalyticsProperty;
import com.razorpay.AnalyticsUtil;
import com.razorpay.CheckoutUtils;
import com.razorpay.Logger;
import org.json.JSONException;
import org.json.JSONObject;

class CheckoutOptions {
    private JSONObject options;

    CheckoutOptions(String string) {
        try {
            this.options = new JSONObject(string);
            return;
        }
        catch (JSONException jSONException) {
            AnalyticsUtil.reportError((String)"CheckoutOptions", (String)"S0", (String)jSONException.getMessage());
            return;
        }
    }

    String getMerchantKey() {
        try {
            return this.options.getString("key");
        }
        catch (JSONException jSONException) {
            Logger.e((String)"Error reading options!", (Throwable)jSONException);
            AnalyticsUtil.reportError((String)"CheckoutOptions", (String)"S0", (String)jSONException.getMessage());
            return null;
        }
    }

    boolean shouldSendHashForSms() {
        try {
            if (this.options.has("send_sms_hash")) {
                return this.options.getBoolean("send_sms_hash");
            }
            return true;
        }
        catch (JSONException jSONException) {
            Logger.e((String)"Error reading options!", (Throwable)jSONException);
            AnalyticsUtil.reportError((String)this.getClass().getName(), (String)"error:exception", (String)jSONException.getMessage());
            return true;
        }
    }

    boolean allowRotation() {
        try {
            if (this.options.has("allow_rotation")) {
                return this.options.getBoolean("allow_rotation");
            }
            return false;
        }
        catch (JSONException jSONException) {
            Logger.e((String)"Error reading options!", (Throwable)jSONException);
            AnalyticsUtil.reportError((String)this.getClass().getName(), (String)"error:exception", (String)jSONException.getMessage());
            return true;
        }
    }

    boolean shouldDisableHardwareAccelerationForLowEndDevices() {
        try {
            if (this.options.has("disable_hardware_acceleration")) {
                return this.options.getBoolean("disable_hardware_acceleration");
            }
            return false;
        }
        catch (JSONException jSONException) {
            Logger.e((String)"Error reading options!", (Throwable)jSONException);
            AnalyticsUtil.reportError((String)this.getClass().getName(), (String)"error:exception", (String)jSONException.getMessage());
            return false;
        }
    }

    JSONObject getAsJson() {
        return this.options;
    }

    String getAsString() {
        return this.options.toString();
    }

    String getOrderId() {
        try {
            if (this.options.has("order_id")) {
                return this.options.getString("order_id");
            }
            return null;
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            jSONException.printStackTrace();
            return null;
        }
    }

    JSONObject getPrefill() {
        return this.options.optJSONObject("prefill");
    }

    JSONObject getOtpElfPreferences() {
        return this.options.optJSONObject("otpelf_preferences");
    }

    void logMerchantOptions() {
        try {
            JSONObject jSONObject = new JSONObject(this.options.toString());
            if (jSONObject.has("prefill")) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("prefill");
                jSONObject2.remove("card");
                jSONObject2.remove("card[number]");
                jSONObject2.remove("card[expiry]");
                jSONObject2.remove("card[cvv]");
                jSONObject.put("prefill", (Object)jSONObject2);
            }
            jSONObject.remove("image");
            AnalyticsUtil.addProperty((String)"merchant options", (AnalyticsProperty)new AnalyticsProperty(jSONObject, AnalyticsProperty.Scope.ORDER));
            return;
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError((String)this.getClass().getName(), (String)"S2", (String)exception.getMessage());
            return;
        }
    }

    void modifyMerchantOptions(Activity object, int n) {
        String string;
        String string2;
        this.put("redirect", Boolean.TRUE);
        if (n != 0 && (string2 = CheckoutUtils.getBase64FromCurrentAppsResource(object, n)) != null) {
            this.put("image", string2);
        }
        if (!TextUtils.isEmpty((CharSequence)(string = CheckoutUtils.getUserEmail((Context)object)))) {
            this.prefillEmail(string);
        }
        if (!TextUtils.isEmpty((CharSequence)(object = CheckoutUtils.getUserContact((Context)object)))) {
            this.prefillContact((String)object);
        }
    }

    String getOptionsWithoutImage() {
        this.put("image", null);
        return this.options.toString();
    }

    private void prefillContact(String string) {
        if (this.getPrefill() != null && this.getPrefill().has("contact")) {
            return;
        }
        this.putPrefill("contact", string);
    }

    private void prefillEmail(String string) {
        if (this.getPrefill() != null && this.getPrefill().has("email")) {
            return;
        }
        this.putPrefill("email", string);
    }

    void putPrefill(String string, Object object) {
        JSONObject jSONObject = new JSONObject();
        if (this.getPrefill() != null) {
            jSONObject = this.getPrefill();
        }
        try {
            jSONObject.put(string, object);
        }
        catch (JSONException jSONException) {
            AnalyticsUtil.reportError((String)this.getClass().getName(), (String)"S1", (String)jSONException.getMessage());
        }
        try {
            this.options.put("prefill", (Object)jSONObject);
            return;
        }
        catch (JSONException jSONException) {
            AnalyticsUtil.reportError((String)this.getClass().getName(), (String)"S1", (String)jSONException.getMessage());
            return;
        }
    }

    private void put(String string, Object object) {
        try {
            this.options.put(string, object);
            return;
        }
        catch (JSONException jSONException) {
            AnalyticsUtil.reportError((String)this.getClass().getName(), (String)"S1", (String)jSONException.getMessage());
            return;
        }
    }

    boolean has(String string) {
        return this.options.has(string);
    }

    String getPrefilledContact() {
        if (this.getPrefill() == null) {
            return null;
        }
        return this.getPrefill().optString("contact");
    }

    String getPrefilledEmail() {
        if (this.getPrefill() == null) {
            return null;
        }
        return this.getPrefill().optString("email");
    }

    public boolean hasExternalWallet(String string) {
        try {
            if (this.options.has("external")) {
                JSONObject jSONObject = this.options.getJSONObject("external");
                if ((jSONObject = jSONObject.getJSONArray("wallets")).toString().contains(string)) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError((String)this.getClass().getName(), (String)"S2", (String)exception.getMessage());
        }
        return false;
    }

    public String getColor() {
        try {
            JSONObject jSONObject = this.getAsJson();
            if (jSONObject.has("theme") && jSONObject.getJSONObject("theme").has("color")) {
                return jSONObject.getJSONObject("theme").getString("color");
            }
            return null;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    <T> T get(String object) {
        if ((object = this.options.opt((String)object)) == null) {
            return null;
        }
        return (T)object.getClass().cast(object);
    }
}

