/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import androidx.annotation.Keep;
import com.razorpay.StorageBridge;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0003J\b\u0010\u000e\u001a\u00020\u0004H\u0007J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\u0011\u001a\u00020\u0004H\u0007\u00a8\u0006\u0012"}, d2={"Lcom/razorpay/UpiTurboUtilities;", "", "()V", "clearCheckoutLocalData", "", "context", "Landroid/content/Context;", "clearSDKState", "clearTurboLocalData", "clearTurboRuntimeState", "activity", "Landroid/app/Activity;", "clearTwoPartySDKState", "clearUISDKState", "destroyUiData", "isDeviceOnboarded", "", "releaseUiActivityReference", "core_release"})
public final class UpiTurboUtilities {
    @NotNull
    public static final UpiTurboUtilities INSTANCE = new UpiTurboUtilities();

    private UpiTurboUtilities() {
    }

    public final boolean isDeviceOnboarded(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        try {
            Object[] objectArray = Class.forName("com.razorpay.upi.RazorpayUpi");
            objectArray = objectArray.getDeclaredField("Companion").get(null);
            Class[] classArray = new Class[1];
            Object object = classArray;
            classArray[0] = Activity.class;
            object = objectArray.getClass().getMethod("isDeviceOnboarded", (Class<?>)object);
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = activity;
            Object object2 = object.invoke((Object)objectArray2, objectArray);
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
            }
            boolean bl = (Boolean)object2;
            return bl;
        }
        catch (Exception exception) {
            Log.e((String)"isDeviceOnboarded", (String)("Exception: " + exception.getMessage()));
            return false;
        }
    }

    public final void clearSDKState(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.clearTwoPartySDKState(context);
        this.clearTurboLocalData(context);
        this.clearCheckoutLocalData(context);
        this.clearUISDKState(context);
    }

    @Keep
    private final void clearUISDKState(Context context) {
        try {
            Object object = Class.forName("com.razorpay.upi.turbo_view.RazorpayTurboUI");
            Object[] objectArray = ((Class)object).getDeclaredMethod("getInstance", new Class[0]);
            object = objectArray.invoke(object, new Object[0]);
            Class[] classArray = new Class[1];
            objectArray = classArray;
            classArray[0] = Context.class;
            Method method = object.getClass().getDeclaredMethod("clearSDKState", (Class<?>[])objectArray);
            objectArray = method;
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = context;
            method.invoke(object, objectArray);
            Log.d((String)"clearUISDKState", (String)"Success");
            return;
        }
        catch (Exception exception) {
            Log.e((String)"clearUISDKState", (String)("Exception: " + exception.getMessage()));
            return;
        }
    }

    @Keep
    public final void releaseUiActivityReference() {
        try {
            Object object = Class.forName("com.razorpay.upi.turbo_view.RazorpayTurboUI");
            Object object2 = ((Class)object).getDeclaredMethod("getInstance", new Class[0]);
            object = object2.invoke(object, new Object[0]);
            Class[] classArray = new Class[1];
            object2 = classArray;
            classArray[0] = Activity.class;
            object2 = object.getClass().getDeclaredMethod("releaseActivityReference", (Class<?>)object2);
            object2.invoke(object, new Object[0]);
            Log.d((String)"releaseUiActivityRef", (String)"Success");
            return;
        }
        catch (Exception exception) {
            Log.e((String)"releaseUiActivityRef", (String)("Exception: " + exception.getMessage()));
            return;
        }
    }

    @Keep
    public final void destroyUiData() {
        try {
            Object object = Class.forName("com.razorpay.upi.turbo_view.RazorpayTurboUI");
            Object object2 = ((Class)object).getDeclaredMethod("getInstance", new Class[0]);
            object = object2.invoke(object, new Object[0]);
            Class[] classArray = new Class[1];
            object2 = classArray;
            classArray[0] = Activity.class;
            object2 = object.getClass().getDeclaredMethod("destroy", (Class<?>)object2);
            object2.invoke(object, new Object[0]);
            Log.d((String)"destroyUiData", (String)"Success");
            return;
        }
        catch (Exception exception) {
            Log.e((String)"destroyUiData", (String)("Exception: " + exception.getMessage()));
            return;
        }
    }

    private final void clearTurboRuntimeState(Activity activity) {
        try {
            Object object = Class.forName("com.razorpay.upi.RazorpayUpi");
            object = ((Class)object).getDeclaredField("Companion").get(null);
            Class[] classArray = new Class[1];
            Object[] objectArray = classArray;
            classArray[0] = Activity.class;
            Method method = object.getClass().getMethod("destroy", (Class<?>[])objectArray);
            objectArray = method;
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = activity;
            method.invoke(object, objectArray);
            return;
        }
        catch (Exception exception) {
            Log.e((String)"clearTurboRuntimeState", (String)("Exception: " + exception.getMessage()));
            return;
        }
    }

    private final void clearCheckoutLocalData(Context context) {
        try {
            String string = new StorageBridge(context).getString("Consent");
            new StorageBridge((Context)context).editor.clear().apply();
            Object object = Class.forName("com.razorpay.upi.CheckoutTwoPartyPreferenceHelper");
            object = ((Class)object).getDeclaredField("INSTANCE");
            object = ((Field)object).get(null);
            Class[] classArray = new Class[1];
            Object[] objectArray = classArray;
            classArray[0] = Context.class;
            Method method = object.getClass().getDeclaredMethod("clearAllPrefs", (Class<?>[])objectArray);
            objectArray = method;
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = context;
            method.invoke(object, objectArray);
            new StorageBridge(context).setString("Consent", string);
            return;
        }
        catch (Exception exception) {
            Log.e((String)"clearCheckoutLocalData", (String)("Exception: " + exception.getMessage()));
            return;
        }
    }

    private final void clearTurboLocalData(Context context) {
        try {
            Object object = Class.forName("com.razorpay.upi.RazorpayUpi");
            object = ((Class)object).getDeclaredField("Companion").get(null);
            Class[] classArray = new Class[1];
            Object[] objectArray = classArray;
            classArray[0] = Context.class;
            Method method = object.getClass().getMethod("clearLocalData", (Class<?>[])objectArray);
            objectArray = method;
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = context;
            method.invoke(object, objectArray);
            return;
        }
        catch (Exception exception) {
            Log.e((String)"clearTurboLocalData", (String)("Exception: " + exception.getMessage()));
            return;
        }
    }

    private final void clearTwoPartySDKState(Context context) {
        try {
            Object object = Class.forName("com.razorpay.upi.twoParty.sdk.RazorpayUpi2p");
            object = ((Class)object).getDeclaredField("INSTANCE");
            object = ((Field)object).get(null);
            Class[] classArray = new Class[1];
            Object[] objectArray = classArray;
            classArray[0] = Context.class;
            Method method = object.getClass().getDeclaredMethod("clearSDKState", (Class<?>[])objectArray);
            objectArray = method;
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = context;
            method.invoke(object, objectArray);
            return;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null) {
                string = "NA";
            }
            Log.e((String)"clearSDKState-2P", (String)string);
            return;
        }
    }
}

