/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import com.razorpay.Addon;
import com.razorpay.ApiClient;
import com.razorpay.RazorpayException;
import com.razorpay.Subscription;
import java.util.List;
import org.json.JSONObject;

public class SubscriptionClient
extends ApiClient {
    SubscriptionClient(String auth) {
        super(auth);
    }

    public Subscription create(JSONObject request) throws RazorpayException {
        return (Subscription)this.post("v1", "subscriptions", request);
    }

    public Subscription fetch(String id) throws RazorpayException {
        return (Subscription)this.get("v1", String.format("subscriptions/%s", id), null);
    }

    public List<Subscription> fetchAll() throws RazorpayException {
        return this.fetchAll(null);
    }

    public List<Subscription> fetchAll(JSONObject request) throws RazorpayException {
        return this.getCollection("v1", "subscriptions", request);
    }

    public Subscription cancel(String id) throws RazorpayException {
        return this.cancel(id, null);
    }

    public Subscription cancel(String id, JSONObject request) throws RazorpayException {
        return (Subscription)this.post("v1", String.format("subscriptions/%s/cancel", id), request);
    }

    public Addon createAddon(String id, JSONObject request) throws RazorpayException {
        return (Addon)this.post("v1", String.format("subscriptions/%s/addons", id), request);
    }

    public Subscription update(String id, JSONObject request) throws RazorpayException {
        return (Subscription)this.patch("v1", String.format("subscriptions/%s", id), request);
    }

    public Subscription fetchPendingUpdate(String id) throws RazorpayException {
        return (Subscription)this.get("v1", String.format("subscriptions/%s/retrieve_scheduled_changes", id), null);
    }

    public Subscription cancelPendingUpdate(String id) throws RazorpayException {
        return (Subscription)this.post("v1", String.format("subscriptions/%s/cancel_scheduled_changes", id), null);
    }

    public Subscription pause(String id, JSONObject request) throws RazorpayException {
        return (Subscription)this.post("v1", String.format("subscriptions/%s/pause", id), request);
    }

    public Subscription resume(String id, JSONObject request) throws RazorpayException {
        return (Subscription)this.post("v1", String.format("subscriptions/%s/resume", id), request);
    }

    public Subscription deleteSubscriptionOffer(String subId, String offerId) throws RazorpayException {
        return (Subscription)this.delete("v1", String.format("subscriptions/%s/%s", subId, offerId), null);
    }
}

