/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import com.razorpay.Account;
import com.razorpay.ApiClient;
import com.razorpay.RazorpayException;
import com.razorpay.Stakeholder;
import java.util.List;
import org.json.JSONObject;

public class StakeholderClient
extends ApiClient {
    StakeholderClient(String auth) {
        super(auth);
    }

    public Stakeholder create(String id, JSONObject request) throws RazorpayException {
        return (Stakeholder)this.post("v2", String.format("accounts/%s/stakeholders", id), request);
    }

    public Stakeholder fetch(String id, String stakeholder_id) throws RazorpayException {
        return (Stakeholder)this.get("v2", String.format("accounts/%s/stakeholders/%s", id, stakeholder_id), null);
    }

    public List<Stakeholder> fetchAll(String id) throws RazorpayException {
        return this.getCollection("v2", String.format("accounts/%s/stakeholders", id), null);
    }

    public Stakeholder edit(String id, String stakeholder_id, JSONObject request) throws RazorpayException {
        return (Stakeholder)this.patch("v2", String.format("accounts/%s/stakeholders/%s", id, stakeholder_id), request);
    }

    public Account uploadStakeholderDoc(String id, String stakeholder_id, JSONObject request) throws RazorpayException {
        return (Account)this.post("v2", String.format("accounts/%s/stakeholders/%s/documents", id, stakeholder_id), request);
    }

    public Account fetchStakeholderDoc(String id, String stakeholder_id) throws RazorpayException {
        return (Account)this.get("v2", String.format("accounts/%s/stakeholders/%s/documents", id, stakeholder_id), null);
    }
}

