/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import com.razorpay.ApiClient;
import com.razorpay.ApiUtils;
import com.razorpay.OauthToken;
import com.razorpay.PayloadValidator;
import com.razorpay.RazorpayException;
import com.razorpay.ValidationConfig;
import com.razorpay.ValidationType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import okhttp3.HttpUrl;
import org.json.JSONArray;
import org.json.JSONObject;

public class OAuthTokenClient
extends ApiClient {
    static final String CLIENT_ID = "client_id";
    static final String CLIENT_SECRET = "client_secret";
    static final String GRANT_TYPE = "grant_type";
    static final String REFRESH_TOKEN = "refresh_token";
    static final String TOKEN = "token";
    static final String TOKEN_TYPE_HINT = "token_type_hint";
    static final String REDIRECT_URI = "redirect_uri";
    static final String SCOPES = "scopes";
    static final String STATE = "state";
    static final String MODE = "mode";
    private final PayloadValidator payloadValidator;

    public OAuthTokenClient() throws RazorpayException {
        ApiUtils.createHttpClientInstance(false);
        this.payloadValidator = new PayloadValidator();
    }

    public String getAuthURL(JSONObject request) throws RazorpayException {
        this.validateAuthURLRequest(request);
        String clientId = request.getString(CLIENT_ID);
        String redirectUri = request.getString(REDIRECT_URI);
        String state = request.getString(STATE);
        String[] scopes = this.jsonArrayToStringArray(request.getJSONArray(SCOPES));
        HttpUrl.Builder httpUrlBuilder = new HttpUrl.Builder().scheme("https").host("auth.razorpay.com").addPathSegment("authorize").addQueryParameter("response_type", "code").addQueryParameter(CLIENT_ID, clientId).addQueryParameter(REDIRECT_URI, redirectUri).addQueryParameter(STATE, state);
        for (String scope : scopes) {
            httpUrlBuilder.addQueryParameter("scope[]=", scope);
        }
        if (request.has("onboarding_signature")) {
            httpUrlBuilder.addQueryParameter("onboarding_signature", request.getString("onboarding_signature"));
        }
        return httpUrlBuilder.build().toString();
    }

    public OauthToken getAccessToken(JSONObject request) throws RazorpayException {
        this.validateAccessTokenRequest(request);
        return (OauthToken)this.post(null, "/token", request, "AUTH");
    }

    public OauthToken refreshToken(JSONObject request) throws RazorpayException {
        request.put(GRANT_TYPE, (Object)REFRESH_TOKEN);
        this.validateRefreshTokenRequest(request);
        return (OauthToken)this.post(null, "/token", request, "AUTH");
    }

    public OauthToken revokeToken(JSONObject request) throws RazorpayException {
        this.validateRevokeTokenRequest(request);
        return (OauthToken)this.post(null, "/revoke", request, "AUTH");
    }

    private String[] jsonArrayToStringArray(JSONArray jsonArray) {
        String[] array = new String[jsonArray.length()];
        for (int i = 0; i < jsonArray.length(); ++i) {
            array[i] = jsonArray.getString(i);
        }
        return array;
    }

    private void validateAuthURLRequest(JSONObject request) throws RazorpayException {
        this.payloadValidator.validate(request, this.getValidationsForAuthRequestURL());
    }

    private void validateAccessTokenRequest(JSONObject request) throws RazorpayException {
        this.payloadValidator.validate(request, this.getValidationsForAccessTokenRequest());
    }

    private void validateRefreshTokenRequest(JSONObject request) throws RazorpayException {
        this.payloadValidator.validate(request, this.getValidationsForRefreshTokenRequest());
    }

    private void validateRevokeTokenRequest(JSONObject request) throws RazorpayException {
        this.payloadValidator.validate(request, this.getValidationsForRevokeTokenRequest());
    }

    private List<ValidationConfig> getValidationsForAuthRequestURL() {
        return Arrays.asList(new ValidationConfig(CLIENT_ID, Collections.singletonList(ValidationType.ID)), new ValidationConfig(REDIRECT_URI, Arrays.asList(ValidationType.NON_EMPTY_STRING, ValidationType.URL)), new ValidationConfig(SCOPES, Collections.singletonList(ValidationType.NON_NULL)), new ValidationConfig(STATE, Collections.singletonList(ValidationType.NON_EMPTY_STRING)));
    }

    private List<ValidationConfig> getValidationsForAccessTokenRequest() {
        return Arrays.asList(new ValidationConfig(CLIENT_ID, Collections.singletonList(ValidationType.ID)), new ValidationConfig(CLIENT_SECRET, Collections.singletonList(ValidationType.NON_EMPTY_STRING)), new ValidationConfig(REDIRECT_URI, Arrays.asList(ValidationType.NON_EMPTY_STRING, ValidationType.URL)), new ValidationConfig(GRANT_TYPE, Collections.singletonList(ValidationType.TOKEN_GRANT)));
    }

    private List<ValidationConfig> getValidationsForRefreshTokenRequest() {
        return Arrays.asList(new ValidationConfig(CLIENT_ID, Collections.singletonList(ValidationType.ID)), new ValidationConfig(CLIENT_SECRET, Collections.singletonList(ValidationType.NON_EMPTY_STRING)), new ValidationConfig(REFRESH_TOKEN, Collections.singletonList(ValidationType.NON_EMPTY_STRING)), new ValidationConfig(GRANT_TYPE, Collections.singletonList(ValidationType.TOKEN_GRANT)));
    }

    private List<ValidationConfig> getValidationsForRevokeTokenRequest() {
        return Arrays.asList(new ValidationConfig(CLIENT_ID, Collections.singletonList(ValidationType.ID)), new ValidationConfig(CLIENT_SECRET, Collections.singletonList(ValidationType.NON_EMPTY_STRING)), new ValidationConfig(TOKEN, Collections.singletonList(ValidationType.NON_EMPTY_STRING)), new ValidationConfig(TOKEN_TYPE_HINT, Collections.singletonList(ValidationType.NON_EMPTY_STRING)));
    }
}

