/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.content.Context;
import android.content.SharedPreferences;
import android.webkit.JavascriptInterface;
import com.razorpay.SharedPreferenceUtil;

class StorageBridge {
    SharedPreferences preferences;
    SharedPreferences.Editor editor;

    StorageBridge(Context context) {
        this.preferences = SharedPreferenceUtil.getStorageBridgePrefs(context);
        this.editor = SharedPreferenceUtil.getStorageBridgeEditor(context);
    }

    @JavascriptInterface
    public void setString(String string, String string2) {
        try {
            this.editor.putString(string, string2);
            this.editor.commit();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    @JavascriptInterface
    public void setBoolean(String string, boolean bl) {
        try {
            this.editor.putBoolean(string, bl);
            this.editor.commit();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    @JavascriptInterface
    public void setInt(String string, int n) {
        try {
            this.editor.putInt(string, n);
            this.editor.commit();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    @JavascriptInterface
    public void setFloat(String string, float f) {
        try {
            this.editor.putFloat(string, f);
            this.editor.commit();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    @JavascriptInterface
    public String getString(String string) {
        try {
            return this.preferences.getString(string, null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @JavascriptInterface
    public boolean getBoolean(String string) {
        try {
            return this.preferences.getBoolean(string, false);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @JavascriptInterface
    public float getFloat(String string) {
        try {
            return this.preferences.getFloat(string, 0.0f);
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    @JavascriptInterface
    public int getInt(String string) {
        try {
            return this.preferences.getInt(string, 0);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void remove(String string) {
        try {
            this.editor.remove(string);
            this.editor.commit();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

