/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.IntentFilter;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsUtil;
import com.razorpay.SmsAgentInterface;
import com.razorpay.SmsReceiver;
import java.util.ArrayList;

class SmsAgent {
    private SmsReceiver smsBroadcastReceiver;
    static final int READ_SMS_PERMISSION_CODE = 1;
    static SmsAgent sSmsAgent;
    ArrayList<SmsAgentInterface> interfaceArrayList = new ArrayList();

    static SmsAgent getSmsAgentInstance() {
        if (sSmsAgent == null) {
            sSmsAgent = new SmsAgent();
        }
        return sSmsAgent;
    }

    SmsAgent() {
    }

    void registerForCallbacks(SmsAgentInterface smsAgentInterface) {
    }

    void deregisterForCallbacks(SmsAgentInterface smsAgentInterface) {
    }

    boolean takeActionsIfPermissionsAreGranted(Activity activity) {
        return false;
    }

    void addSMSBroadcastReceiver(Activity activity) {
        if (this.smsBroadcastReceiver != null) {
            return;
        }
        activity = new IntentFilter();
        activity.setPriority(1000);
        this.smsBroadcastReceiver = new SmsReceiver(this);
        activity.addAction("android.provider.Telephony.SMS_RECEIVED");
    }

    void removeSMSBroadcastReceiver(Activity activity) {
        this.sendSmsPermissionCallBack(false);
        if (this.smsBroadcastReceiver == null) {
            return;
        }
        try {
            activity.unregisterReceiver((BroadcastReceiver)this.smsBroadcastReceiver);
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError("SmsAgent", "S0", exception.getMessage());
        }
        this.smsBroadcastReceiver = null;
    }

    void handleRequestPermissionsResult(Activity activity, int n, String[] stringArray, int[] nArray) {
        switch (n) {
            case 1: {
                if (nArray.length > 0 && nArray[0] == 0) {
                    this.sendSmsPermissionCallBack(true);
                    this.addSMSBroadcastReceiver(activity);
                    AnalyticsUtil.trackEvent(AnalyticsEvent.SMS_PERMISSION_NOW_GRANTED);
                    return;
                }
                this.sendSmsPermissionCallBack(false);
                AnalyticsUtil.trackEvent(AnalyticsEvent.SMS_PERMISSION_NOW_DENIED);
            }
        }
    }

    void sendSmsPermissionCallBack(boolean bl) {
    }

    void postSms(String string, String string2) {
    }
}

