/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import com.razorpay.AnalyticsUtil;
import com.razorpay.BaseUtils;
import com.razorpay.CryptLib;
import org.json.JSONObject;

class SharedPreferenceUtil {
    private static final String NAME_PUBLIC = "rzp_preference_public";
    private static final String NAME_PRIVATE = "rzp_preference_private";
    private static final String NAME_STORAGE_BRIDGE = "rzp_preferences_storage_bridge";
    private static final String KEY_DATA = "data";
    private static final String KEY_IV = "iv";
    private static final String KEY_SDK_VERSION = "sdk_version";
    private static SharedPreferences privatePrefs;
    private static SharedPreferences.Editor privateEditor;

    SharedPreferenceUtil() {
    }

    static SharedPreferences getPrivatePrefs(Context context) {
        if (privatePrefs == null) {
            privatePrefs = context.getSharedPreferences(NAME_PRIVATE, 0);
        }
        return privatePrefs;
    }

    @SuppressLint(value={"CommitPrefEdits"})
    static SharedPreferences.Editor getPrivateEditor(Context context) {
        if (privateEditor == null) {
            privateEditor = SharedPreferenceUtil.getPrivatePrefs(context).edit();
        }
        return privateEditor;
    }

    static SharedPreferences getPublicPrefs(Context context) {
        try {
            return context.getSharedPreferences(NAME_PUBLIC, 0);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            AnalyticsUtil.reportError(exception.getMessage(), "S0", exception2.getMessage());
            return context.getSharedPreferences(NAME_PUBLIC, 0);
        }
    }

    @SuppressLint(value={"CommitPrefEdits"})
    static SharedPreferences.Editor getPublicEditor(Context context) {
        return SharedPreferenceUtil.getPublicPrefs(context).edit();
    }

    static SharedPreferences.Editor getStorageBridgeEditor(Context context) {
        return SharedPreferenceUtil.getStorageBridgePrefs(context).edit();
    }

    static SharedPreferences getStorageBridgePrefs(Context context) {
        return context.getSharedPreferences(NAME_STORAGE_BRIDGE, 0);
    }

    static void handleSdkUpdate(Context context, String string) {
        try {
            String string2 = SharedPreferenceUtil.getValue(context, KEY_SDK_VERSION);
            if (!string.equalsIgnoreCase(string2)) {
                SharedPreferenceUtil.setValue(context, "rzp_config_json", null);
                SharedPreferenceUtil.setValue(context, "rzp_config_version", null);
                SharedPreferenceUtil.setValue(context, KEY_SDK_VERSION, string);
            }
            return;
        }
        catch (NullPointerException nullPointerException) {
            SharedPreferenceUtil.setValue(context, "rzp_config_json", null);
            SharedPreferenceUtil.setValue(context, "rzp_config_version", null);
            SharedPreferenceUtil.setValue(context, KEY_SDK_VERSION, string);
            return;
        }
    }

    static String getProtectedValue(Context object, String object2, String string) {
        try {
            object = SharedPreferenceUtil.getValue((Context)object, (String)object2);
            if (object == null) {
                return null;
            }
            object = new JSONObject((String)object);
            object2 = new CryptLib();
            if (string != null && !string.equals(object.getString(KEY_SDK_VERSION))) {
                return null;
            }
            return ((CryptLib)object2).decrypt(object.getString(KEY_DATA), "", object.getString(KEY_IV));
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception.getMessage(), "S1", ((Throwable)object).getLocalizedMessage());
            return null;
        }
    }

    static void setProtectedValue(Context context, String string, String string2, String string3) {
        try {
            if (string2 == null) {
                SharedPreferenceUtil.removeValue(context, string);
                return;
            }
            String string4 = BaseUtils.getRandomString();
            CryptLib cryptLib = new CryptLib();
            string2 = cryptLib.encrypt(string2, "", string4);
            cryptLib = new JSONObject();
            cryptLib.put(KEY_DATA, string2);
            cryptLib.put(KEY_IV, string4);
            if (string3 != null) {
                cryptLib.put(KEY_SDK_VERSION, string3);
            }
            SharedPreferenceUtil.setValue(context, string, cryptLib.toString());
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            AnalyticsUtil.reportError(exception.getMessage(), "S1", exception2.getLocalizedMessage());
            return;
        }
    }

    static String getValue(Context context, String string) {
        context = SharedPreferenceUtil.getPrivatePrefs(context);
        return context.getString(string, null);
    }

    static void setValue(Context context, String string, String string2) {
        context = SharedPreferenceUtil.getPrivateEditor(context);
        context.putString(string, string2);
        context.commit();
    }

    static void removeValue(Context context, String string) {
        context = SharedPreferenceUtil.getPrivateEditor(context);
        context.remove(string);
        context.commit();
    }
}

