/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.widget.Toast;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsProperty;
import com.razorpay.AnalyticsUtil;
import com.razorpay.AutoOtpUtils;
import com.razorpay.BaseUtils;
import com.razorpay.Callback;
import com.razorpay.CoreConfig;
import com.razorpay.OTP;
import com.razorpay.OtpElfData;
import com.razorpay.Owl;
import com.razorpay.ResourceUtils;
import com.razorpay.ResponseObject;
import com.razorpay.SmsAgent;
import com.razorpay.SmsAgentInterface;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public final class RzpAssist
implements SmsAgentInterface {
    private WebView webview;
    private boolean hasOtpPermission = false;
    private String lastURL = "";
    private String currentLoadingUrl = "";
    private long pageStartTime;
    private boolean isMagic = false;
    private boolean isRazorpayOtpReceived = false;
    private Activity activity;
    private String merchantKey;
    private SmsAgent smsAgent;
    private OtpElfData elfData;
    private JSONObject otpElfPreferences = new JSONObject();
    private JSONObject paymentData = new JSONObject();
    private String paymentId;
    private boolean isRzpAssistEnabled = false;
    private boolean otpRead = false;
    private String sdkType = "standalone";
    private int sdkVersionCode;
    private String sdkVersion;
    String lastSms;
    String message;
    String sender;
    private boolean jsInsertedInCurrentPage = false;

    public RzpAssist(String string, Activity activity, WebView webView, String string2, int n, String string3) {
        if (!CoreConfig.getInstance().isOTPElfEnabled().booleanValue()) {
            return;
        }
        if (string == null || string.isEmpty()) {
            throw new RuntimeException("merchantKey cannot be null or empty");
        }
        this.sdkType = string2;
        this.sdkVersionCode = n;
        this.sdkVersion = string3;
        if (string2.equals("standalone") || string2.equalsIgnoreCase("standard") || string2.equalsIgnoreCase("custom")) {
            AnalyticsUtil.setup((Context)activity, string, string2, n, string3);
        }
        this.webview = webView;
        this.merchantKey = string;
        this.activity = activity;
        this.elfData = new OtpElfData(activity);
        this.elfData.checkForUpdates();
        this.setup();
        AnalyticsUtil.addProperty("OTPElf Version", new AnalyticsProperty(BaseUtils.getLocalVersion(activity, OtpElfData.versionKey), AnalyticsProperty.Scope.ORDER));
    }

    private void setup() {
        this.smsAgent = SmsAgent.getSmsAgentInstance();
        this.smsAgent.registerForCallbacks(this);
        this.smsAgent.takeActionsIfPermissionsAreGranted(this.activity);
        this.webview.addJavascriptInterface((Object)this, "OTPElfBridge");
        this.webview.getSettings().setUseWideViewPort(true);
    }

    final void enableMagic() {
        this.isMagic = true;
    }

    final void setPaymentData(JSONObject jSONObject) {
        this.paymentData = jSONObject;
    }

    public final void setOtpElfPreferences(JSONObject jSONObject) {
        this.otpElfPreferences = jSONObject;
    }

    public final void onPageFinished(WebView webView, String string) {
        long l = System.nanoTime() - this.pageStartTime;
        AnalyticsUtil.trackPageLoadEnd(string, l);
        this.lastURL = string;
        this.currentLoadingUrl = "";
        if (!CoreConfig.getInstance().isOTPElfEnabled().booleanValue()) {
            return;
        }
        if (!this.jsInsertedInCurrentPage) {
            this.handleJsInsertion();
            this.jsInsertedInCurrentPage = true;
        }
    }

    private void handleJsInsertion() {
        try {
            JSONObject jSONObject = CoreConfig.getInstance().getOTPElfSettings();
            jSONObject.put("merchant_key", (Object)this.merchantKey);
            jSONObject.put("otp_permission", this.hasOtpPermission);
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("type", (Object)this.sdkType);
            jSONObject2.put("version", (Object)this.sdkVersion);
            jSONObject2.put("platform", (Object)"android");
            jSONObject2.put("framework", (Object)"native");
            jSONObject2.put("name", (Object)(this.sdkType + "_android_native"));
            jSONObject.put("sdk", (Object)jSONObject2);
            JSONObject jSONObject3 = new JSONObject();
            if (!this.isMagic) {
                jSONObject3.put("type", (Object)"rzpassist");
                jSONObject3.put("version_code", ResourceUtils.getRzpAssistVersionCode());
            } else {
                jSONObject3.put("type", (Object)"magic");
                jSONObject3.put("version_code", ResourceUtils.getMagicVersionCode());
            }
            jSONObject.put("plugin", (Object)jSONObject3);
            jSONObject.put("payment_data", (Object)this.paymentData);
            jSONObject.put("preferences", (Object)this.otpElfPreferences);
            jSONObject3 = new JSONObject();
            jSONObject3.put("package_name", (Object)this.activity.getApplicationContext().getPackageName());
            PackageManager packageManager = this.activity.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(this.activity.getPackageName(), 0);
            jSONObject3.put("app_name", (Object)AnalyticsUtil.returnUndefinedIfNull(packageInfo.applicationInfo.loadLabel(packageManager)));
            jSONObject3.put("platform", (Object)"mobile_sdk");
            jSONObject3.put("os", (Object)"android");
            jSONObject3.put("os_version", (Object)Build.VERSION.RELEASE);
            jSONObject3.put("data_network_type", (Object)BaseUtils.getDataNetworkType((Context)this.activity).getNetworkTypeName());
            jSONObject3.put("framework", (Object)AnalyticsUtil.getFramework());
            jSONObject3.put("library", (Object)"standard");
            jSONObject3.put("sdk", (Object)jSONObject2);
            jSONObject.put("metadata", (Object)jSONObject3);
            this.injectJs("window.__rzp_options = " + jSONObject.toString());
        }
        catch (Exception exception) {}
        RzpAssist rzpAssist = this;
        rzpAssist.injectJs(rzpAssist.elfData.getOtpElfJs());
        AnalyticsUtil.trackEvent(AnalyticsEvent.OTPELF_INJECTED);
        if (this.lastSms != null) {
            this.injectJs(String.format("OTPElf.showOTP('%s','%s')", this.lastSms, this.sender));
            this.lastSms = null;
        }
    }

    public final void onProgressChanged(int n) {
        if (!CoreConfig.getInstance().isOTPElfEnabled().booleanValue()) {
            return;
        }
    }

    public final void onPageStarted(WebView webView, String string) {
        new StringBuilder("RzpAssist onPageStarted: ").append(string);
        AnalyticsUtil.trackPageLoadStart(string);
        this.pageStartTime = System.nanoTime();
        this.currentLoadingUrl = string;
        this.jsInsertedInCurrentPage = false;
    }

    public final void paymentFlowEnd() {
        if (this.sdkType.equals("standalone")) {
            AnalyticsUtil.postData();
        }
        if (!CoreConfig.getInstance().isOTPElfEnabled().booleanValue()) {
            return;
        }
        this.smsAgent.removeSMSBroadcastReceiver(this.activity);
        this.smsAgent.deregisterForCallbacks(this);
    }

    @Override
    public final void postSms(String string, String string2) {
        if (!this.isRzpAssistEnabled) {
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("sender", (Object)string);
            jSONObject.put("message", (Object)string2);
            this.sender = string;
            this.message = string2;
            this.lastSms = jSONObject.toString();
            this.injectJs(String.format("OTPElf.showOTP('%s','%s')", string2, string));
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    @Override
    public final void setSmsPermission(boolean bl) {
        this.setOTPEnabled(bl);
    }

    final void setPaymentId(String string) {
        this.paymentId = string;
    }

    private void postStatsToAPI() {
        try {
            String string = BaseUtils.constructBasicAuth(this.merchantKey);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("Authorization", "Basic " + string);
            hashMap.put("Content-Type", "application/json");
            if (this.paymentId == null) {
                return;
            }
            string = "https://api.razorpay.com/v1/payments/" + this.paymentId + "/metadata";
            JSONObject jSONObject = AutoOtpUtils.createStatsPayload(this.otpRead);
            Owl.post(string, jSONObject.toString(), hashMap, new Callback(){

                @Override
                public void run(ResponseObject responseObject) {
                    new StringBuilder("API Metadata: ").append(responseObject.getResponseResult());
                }
            });
            return;
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError("RzpAssist", "S0", exception.getMessage());
            return;
        }
    }

    private void injectJs(String string) {
        this.webview.loadUrl(String.format("javascript: %s", string));
    }

    final void onRequestPermissionsResult(int n, String[] stringArray, int[] nArray) {
        this.smsAgent.handleRequestPermissionsResult(this.activity, n, stringArray, nArray);
    }

    final String getLastLoadedUrl() {
        return this.lastURL;
    }

    final String getCurrentLoadingUrl() {
        return this.currentLoadingUrl;
    }

    public final void reset() {
        this.postStatsToAPI();
        this.lastURL = "";
        this.currentLoadingUrl = "";
        this.otpRead = false;
    }

    final boolean isRazorpayOtpReceived() {
        return this.isRazorpayOtpReceived;
    }

    final void setOTPEnabled(boolean bl) {
        this.hasOtpPermission = bl;
        AnalyticsUtil.addProperty("otp_autoreading_access", new AnalyticsProperty(bl, AnalyticsProperty.Scope.ORDER));
    }

    final void setRzpAssistEnabled(boolean bl) {
        this.isRzpAssistEnabled = bl;
    }

    @JavascriptInterface
    public final void setUseWideViewPort(final boolean bl) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                RzpAssist.this.webview.getSettings().setUseWideViewPort(bl);
            }
        });
    }

    @JavascriptInterface
    public final void openKeyboard() {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                InputMethodManager inputMethodManager = (InputMethodManager)RzpAssist.this.activity.getSystemService("input_method");
                inputMethodManager.showSoftInput((View)RzpAssist.this.webview, 0);
            }
        });
    }

    @JavascriptInterface
    public final void toast(final String string) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)RzpAssist.this.activity, (CharSequence)string, (int)1).show();
            }
        });
    }

    @JavascriptInterface
    public final void trackEvent(String string, String string2) {
        try {
            AnalyticsEvent analyticsEvent = AnalyticsEvent.JS_EVENT;
            analyticsEvent.setEventName(string);
            string = new JSONObject(string2);
            AnalyticsUtil.trackEvent(analyticsEvent, (JSONObject)string);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    @JavascriptInterface
    public final void trackEvent(String string) {
        AnalyticsEvent analyticsEvent = AnalyticsEvent.JS_EVENT;
        analyticsEvent.setEventName(string);
        AnalyticsUtil.trackEvent(analyticsEvent);
    }

    @JavascriptInterface
    public final void onOtpParsed(final String string) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    Object object = new JSONObject(string);
                    Object object2 = object.getString("otp");
                    String string2 = object.getString("sender");
                    object = object.getString("bank");
                    object = new OTP((String)object2, string2, (String)object);
                    object2 = new HashMap<String, String>();
                    object2.put("sender", ((OTP)object).getSender());
                    if (((OTP)object).getSender().contains("RZRPAY")) {
                        RzpAssist.this.isRazorpayOtpReceived = true;
                        object2.put("razorpay_otp", Boolean.TRUE);
                    } else {
                        object2.put("razorpay_otp", Boolean.FALSE);
                        RzpAssist.this.otpRead = true;
                        AnalyticsUtil.addProperty("payment_otp_received", new AnalyticsProperty(true, AnalyticsProperty.Scope.PAYMENT));
                    }
                    AnalyticsUtil.trackEvent(AnalyticsEvent.OTP_RECEIVED, AnalyticsUtil.getJSONResponse((Map<String, Object>)object2));
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
        });
    }

    @JavascriptInterface
    public final void copyToClipboard(String string) {
        ClipboardManager clipboardManager = (ClipboardManager)this.activity.getSystemService("clipboard");
        string = ClipData.newPlainText((CharSequence)"rzp_clip_data", (CharSequence)string);
        clipboardManager.setPrimaryClip((ClipData)string);
    }
}

