/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.content.Context;
import com.razorpay.AnalyticsUtil;
import com.razorpay.Lumberjack;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.NotNull;

class RazorpayExceptionHandler
implements Thread.UncaughtExceptionHandler {
    Thread.UncaughtExceptionHandler existingHandler;
    Context context;

    RazorpayExceptionHandler(Context context, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.existingHandler = uncaughtExceptionHandler;
        this.context = context;
    }

    static void register(Context context) {
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (!(uncaughtExceptionHandler instanceof RazorpayExceptionHandler)) {
            Thread.setDefaultUncaughtExceptionHandler(new RazorpayExceptionHandler(context, uncaughtExceptionHandler));
        }
    }

    static void unregister() {
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (uncaughtExceptionHandler instanceof RazorpayExceptionHandler) {
            uncaughtExceptionHandler = (RazorpayExceptionHandler)uncaughtExceptionHandler;
            Thread.setDefaultUncaughtExceptionHandler(((RazorpayExceptionHandler)uncaughtExceptionHandler).existingHandler);
        }
    }

    @Override
    public void uncaughtException(@NotNull Thread thread, @NotNull Throwable throwable) {
        Executors.newSingleThreadExecutor().execute(() -> {
            AnalyticsUtil.reportUncaughtException(throwable);
            Lumberjack.saveEventsToPreferences(this.context.getApplicationContext());
            if (this.existingHandler != null) {
                this.existingHandler.uncaughtException(thread, throwable);
            }
        });
    }
}

