/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\n"}, d2={"Lcom/razorpay/PerformanceUtil;", "", "()V", "getPerformanceClass", "", "context", "Landroid/content/Context;", "getPerformanceClassFromRAM", "isLowEndDevice", "", "core_release"})
public final class PerformanceUtil {
    @NotNull
    public static final PerformanceUtil INSTANCE = new PerformanceUtil();

    private PerformanceUtil() {
    }

    @JvmStatic
    public static final int getPerformanceClass(@NotNull Context object) {
        int n;
        Intrinsics.checkNotNullParameter((Object)object, (String)"context");
        try {
            n = Build.VERSION.SDK_INT >= 31 && (n = Build.VERSION.MEDIA_PERFORMANCE_CLASS) != 0 ? n : INSTANCE.getPerformanceClassFromRAM((Context)object);
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            n = 0;
        }
        return n;
    }

    private final int getPerformanceClassFromRAM(Context context) {
        int n;
        try {
            double d;
            Object object = context.getSystemService("activity");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.app.ActivityManager");
            }
            context = (ActivityManager)object;
            ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
            context.getMemoryInfo(memoryInfo);
            double d2 = (double)memoryInfo.totalMem / 1.073741824E9;
            n = d < 2.0 ? 0 : (d2 < 4.0 ? 30 : (d2 < 6.0 ? 31 : 33));
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            n = 0;
        }
        return n;
    }

    @JvmStatic
    public static final boolean isLowEndDevice(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int n = PerformanceUtil.getPerformanceClass(context);
        return n == 0 || n == 30;
    }
}

