/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.app.Activity;
import android.content.Context;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsUtil;
import com.razorpay.BaseUtils;
import com.razorpay.Callback;
import com.razorpay.CoreConfig;
import com.razorpay.GlobalUrlConfig;
import com.razorpay.Owl;
import com.razorpay.R;
import com.razorpay.ResponseObject;

class OtpElfData {
    Activity activity;
    private String otpElfJs;
    public static String versionKey = "otpelf_version";

    OtpElfData(Activity activity) {
        this.activity = activity;
    }

    void checkForUpdates() {
        Owl.get(GlobalUrlConfig.instance().getOtpelfVersionUrl(), new Callback(){

            @Override
            public void run(ResponseObject object) {
                if (((ResponseObject)object).getResponseResult() == null) {
                    return;
                }
                try {
                    object = BaseUtils.getVersionFromJsonString(((ResponseObject)object).getResponseResult(), versionKey);
                    String string = BaseUtils.getLocalVersion(OtpElfData.this.activity, versionKey);
                    if (string.equals(object)) {
                        new StringBuilder("OTPElf on latest version: ").append(string);
                        return;
                    }
                    AnalyticsUtil.trackEvent(AnalyticsEvent.OTPELF_UPDATE_CALLED);
                    OtpElfData.this.updateOtpElf((String)object);
                }
                catch (Exception exception) {
                    AnalyticsUtil.reportError(this.getClass().getName(), "S1", "Could not extract version from server json");
                }
            }
        });
    }

    private void updateOtpElf(final String string) {
        Owl.get(GlobalUrlConfig.instance().getOtpelfJsUrl(), new Callback(){

            @Override
            public void run(ResponseObject responseObject) {
                if (responseObject.getResponseResult() != null) {
                    String string2 = BaseUtils.getVersionedAssetName(string, CoreConfig.getInstance().getOTPElfJsFileName());
                    if (BaseUtils.storeFileInInternal(OtpElfData.this.activity, string2, responseObject.getResponseResult())) {
                        OtpElfData.this.otpElfJs = responseObject.getResponseResult();
                        BaseUtils.updateLocalVersion(OtpElfData.this.activity, versionKey, string);
                        return;
                    }
                    AnalyticsUtil.trackEvent(AnalyticsEvent.OTPELF_LOCAL_SAVE_FAILED);
                }
            }
        });
    }

    String getOtpElfJs() {
        if (this.otpElfJs == null) {
            String string = BaseUtils.getLocalVersion(this.activity, versionKey);
            if (string.equals(BaseUtils.getVersionFromJsonString("{\n  \"hash\" : \"c4171614448e750850bd4daca2c7e8d1\",\n  \"magic_hash\": \"e1ff492228196aa72f4892db1e05624e\"\n}\n", versionKey))) {
                this.otpElfJs = CoreConfig.getOtpelfJsFromFile((Context)this.activity, R.raw.otpelf);
            } else {
                try {
                    this.otpElfJs = BaseUtils.getFileFromInternal(this.activity, CoreConfig.getInstance().getOTPElfJsFileName(), versionKey);
                    if (this.otpElfJs.equals("")) {
                        this.otpElfJs = CoreConfig.getOtpelfJsFromFile((Context)this.activity, R.raw.otpelf);
                    }
                }
                catch (Exception exception) {
                    this.otpElfJs = CoreConfig.getOtpelfJsFromFile((Context)this.activity, R.raw.otpelf);
                }
            }
        }
        return this.otpElfJs;
    }
}

