/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.razorpay.AnalyticsProperty;
import com.razorpay.AnalyticsUtil;
import com.razorpay.BaseConfig;
import com.razorpay.BaseUtils;
import com.razorpay.Callback;
import com.razorpay.CoreConfig;
import com.razorpay.GlobalUrlConfig;
import com.razorpay.GpuInfoUtil;
import com.razorpay.Owl;
import com.razorpay.PerformanceUtil;
import com.razorpay.ResponseObject;
import com.razorpay.SharedPreferenceUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class Lumberjack {
    private static final String SAVED_EVENTS_DATA = "SavedEventsData";
    private static String DEVICE_MANUFACTURER = Build.MANUFACTURER;
    private static String DEVICE_MODEL = Build.MODEL;
    private static String DEVICE_NAME = Build.DEVICE;
    private static String NETWORK_CELLULAR_TYPE;
    private static String NETWORK_CARRIER;
    private static boolean NETWORK_CELLULAR;
    private static boolean NETWORK_BLUETOOTH;
    private static boolean NETWORK_WIFI;
    private static float SCREEN_DENSITY;
    private static int SCREEN_WIDTH;
    private static int SCREEN_HEIGHT;
    private static JSONObject lumberjackPayload;
    private static JSONObject contextJsonData;
    private static boolean isLumberjackInitialized;
    private static String sdkType;
    private static String sdkVersion;
    private static ArrayList<JSONObject> preInitBatch;
    private static Map<String, Object> paymentProperties;
    private static Map<String, Object> orderProperties;

    Lumberjack() {
    }

    private static boolean hasPermission(Context context, String string) {
        return context.checkCallingOrSelfPermission(string) == 0;
    }

    private static CharSequence getUserAgent() {
        return AnalyticsUtil.returnUndefinedIfNull(System.getProperty("http.agent"));
    }

    private static CharSequence getTimeZone() {
        return AnalyticsUtil.returnUndefinedIfNull(TimeZone.getDefault().getID());
    }

    private static void setNetworkDetails(Context context) {
        NETWORK_CELLULAR_TYPE = BaseUtils.getCellularNetworkType(context);
        NETWORK_CARRIER = BaseUtils.getCellularNetworkProviderName(context);
        switch (BaseUtils.getDataNetworkType(context)) {
            case WIFI: {
                NETWORK_WIFI = true;
                return;
            }
            case CELLULAR: {
                NETWORK_CELLULAR = true;
                return;
            }
            case BLUETOOTH: {
                NETWORK_BLUETOOTH = true;
            }
        }
    }

    private static void setDisplayDetails(Context context) {
        context = (WindowManager)BaseUtils.getSystemService(context, "window");
        context = context.getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        context.getMetrics(displayMetrics);
        SCREEN_DENSITY = displayMetrics.density;
        SCREEN_HEIGHT = displayMetrics.heightPixels;
        SCREEN_WIDTH = displayMetrics.widthPixels;
    }

    private static String getTimestamp() {
        return String.valueOf(System.currentTimeMillis() / 1000L);
    }

    private static JSONObject getDeviceDataJson(Context context) throws Exception {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("id", (Object)BaseConfig.getAdvertisingId(context));
        jSONObject.put("manufacturer", (Object)DEVICE_MANUFACTURER);
        jSONObject.put("model", (Object)DEVICE_MODEL);
        jSONObject.put("name", (Object)DEVICE_NAME);
        jSONObject.put("type", (Object)"phone");
        jSONObject.put("version", (Object)("Android" + Build.VERSION.RELEASE));
        jSONObject.put(DEVICE_MANUFACTURER, (Object)Build.MANUFACTURER);
        jSONObject.put(DEVICE_MODEL, (Object)Build.MODEL);
        jSONObject.put("device_size", (Object)(BaseUtils.getDisplayWidth(context) + "w X " + BaseUtils.getDisplayHeight(context) + "h"));
        jSONObject.put("device_resolution", (Object)BaseUtils.getDisplayResolution(context));
        long l = BaseUtils.getTotalRamMB(context);
        jSONObject.put("total_ram_mb", l);
        jSONObject.put("free_ram_mb", BaseUtils.getFreeRamMB(context));
        jSONObject.put("cpu_cores", BaseUtils.getCpuCores());
        jSONObject.put("performance_class", PerformanceUtil.getPerformanceClass(context));
        jSONObject.put("is_low_end_device", PerformanceUtil.isLowEndDevice(context));
        jSONObject.put("power_save_mode", BaseUtils.isPowerSaveMode(context));
        jSONObject.put("battery_level", BaseUtils.getBatteryLevel(context));
        jSONObject.put("is_charging", BaseUtils.isCharging(context));
        jSONObject.put("is_low_ram_device", l <= 4096L);
        jSONObject.put("gpu_renderer", (Object)GpuInfoUtil.getGpuRenderer());
        jSONObject.put("gpu_vendor", (Object)GpuInfoUtil.getGpuVendor());
        return jSONObject;
    }

    private static JSONObject getSdkDataJson() throws Exception {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("version", (Object)sdkVersion);
        jSONObject.put("platform", (Object)"android");
        jSONObject.put("type", (Object)sdkType);
        jSONObject.put("framework", (Object)AnalyticsUtil.getFramework());
        jSONObject.put("name", (Object)(sdkType + "_android_" + AnalyticsUtil.getFramework()));
        return jSONObject;
    }

    private static JSONObject getNetworkDataJson(Context object) throws Exception {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("bluetooth", NETWORK_BLUETOOTH);
        jSONObject.put("carrier", (Object)NETWORK_CARRIER);
        jSONObject.put("cellular", NETWORK_CELLULAR);
        jSONObject.put("cellular_network_type", (Object)NETWORK_CELLULAR_TYPE);
        jSONObject.put("wifi", NETWORK_WIFI);
        jSONObject.put("carrier_network", (Object)BaseUtils.getCarrierOperatorName((Context)object));
        jSONObject.put("network_type", BaseUtils.getNetworkType((Context)object));
        jSONObject.put("ip_address", (Object)BaseUtils.ipAddress);
        jSONObject.put("is_roming", BaseUtils.isNetworkRoaming((Context)object));
        object = BaseUtils.getDeviceAttributes((Context)object);
        jSONObject.put("device_Id", object.get("device_Id"));
        jSONObject.put(DEVICE_MANUFACTURER, object.get(DEVICE_MANUFACTURER));
        jSONObject.put(DEVICE_MODEL, object.get(DEVICE_MODEL));
        return jSONObject;
    }

    private static JSONObject getScreenDataJson() throws Exception {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("density", (double)SCREEN_DENSITY);
        jSONObject.put("width", SCREEN_WIDTH);
        jSONObject.put("height", SCREEN_HEIGHT);
        return jSONObject;
    }

    private static JSONObject getContextDataJson(Context context) throws Exception {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("mode", (Object)AnalyticsUtil.getKeyType());
        jSONObject.put("device", (Object)Lumberjack.getDeviceDataJson(context));
        jSONObject.put("sdk", (Object)Lumberjack.getSdkDataJson());
        jSONObject.put("network", (Object)Lumberjack.getNetworkDataJson(context));
        jSONObject.put("screen", (Object)Lumberjack.getScreenDataJson());
        jSONObject.put("locale", (Object)BaseUtils.getLocale());
        jSONObject.put("timezone", (Object)Lumberjack.getTimeZone());
        jSONObject.put("framework", (Object)(sdkType + "_android_" + AnalyticsUtil.getFramework()));
        jSONObject.put("user_agent", (Object)Lumberjack.getUserAgent());
        jSONObject.put("sdk_session_id", (Object)AnalyticsUtil.getLocalOrderId());
        jSONObject.put("local_order_id", (Object)AnalyticsUtil.getLocalOrderId());
        jSONObject.put("webview_user_agent", (Object)BaseUtils.getWebViewUserAgent(context));
        return jSONObject;
    }

    static void setBaseImportJSON(Context context) {
        try {
            Lumberjack.setNetworkDetails(context);
            Lumberjack.setDisplayDetails(context);
            GpuInfoUtil.loadFromCache(context);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("key", (Object)CoreConfig.getInstance().getLumberjackKey());
            jSONObject.put("events", (Object)new JSONArray());
            contextJsonData = Lumberjack.getContextDataJson(context);
            jSONObject.put("context", (Object)contextJsonData);
            lumberjackPayload = jSONObject;
            Lumberjack.makeSessionApiPostRequest(Lumberjack.getSessionCreatedJson());
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            AnalyticsUtil.reportError(exception.getMessage(), "S0", "Error in creating BaseImportJSON");
            lumberjackPayload = new JSONObject();
            return;
        }
    }

    static void updateGpuInfo() {
        try {
            JSONObject jSONObject;
            if (contextJsonData != null && GpuInfoUtil.isGpuInfoAvailable() && (jSONObject = contextJsonData.optJSONObject("device")) != null) {
                jSONObject.put("gpu_renderer", (Object)GpuInfoUtil.getGpuRenderer());
                jSONObject.put("gpu_vendor", (Object)GpuInfoUtil.getGpuVendor());
                new StringBuilder("GPU info updated: ").append(GpuInfoUtil.getGpuRenderer());
            }
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            AnalyticsUtil.reportError(exception.getMessage(), "S2", "Error updating GPU info in context");
            return;
        }
    }

    private static void addToBatch(JSONObject jSONObject) {
        if (!isLumberjackInitialized) {
            preInitBatch.add(jSONObject);
            return;
        }
        try {
            jSONObject = Lumberjack.addGlobalProperties(jSONObject);
            JSONObject jSONObject2 = lumberjackPayload;
            synchronized (jSONObject2) {
                JSONArray jSONArray = lumberjackPayload.getJSONArray("events");
                jSONArray.put((Object)jSONObject);
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            AnalyticsUtil.reportError(exception.getMessage(), "S0", exception2.getMessage());
        }
    }

    static void addPaymentProperty(String string, Object object) {
        paymentProperties.put(string, object);
    }

    static void addOrderProperty(String string, Object object) {
        orderProperties.put(string, object);
    }

    static JSONObject createBaseTrackEvent(String object) {
        try {
            return new JSONObject("{event: '" + (String)object + "',timestamp: '" + Lumberjack.getTimestamp() + "'}");
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception.getMessage(), "S0", "Error in creating base for trackEvent");
            return null;
        }
    }

    static void trackEvent(String string, Map<String, Object> object) {
        JSONObject jSONObject = new JSONObject();
        for (Map.Entry entry : object.entrySet()) {
            try {
                jSONObject.put((String)entry.getKey(), entry.getValue());
            }
            catch (JSONException jSONException) {
                JSONException jSONException2 = jSONException;
                AnalyticsUtil.reportError(jSONException.getMessage(), "S0", "Error adding analytics property " + (String)entry.getKey() + " to JSONObject");
            }
        }
        Lumberjack.trackEvent(string, jSONObject);
    }

    static void trackEvent(String object, JSONObject jSONObject) {
        try {
            object = Lumberjack.createBaseTrackEvent((String)object);
            if (object == null) {
                object = new JSONObject();
            }
            if (jSONObject == null) {
                jSONObject = new JSONObject();
            }
            jSONObject.put("local_order_id", (Object)AnalyticsUtil.getLocalOrderId());
            jSONObject.put("sdk_session_id", (Object)AnalyticsUtil.getLocalOrderId());
            jSONObject.put("local_payment_id", (Object)AnalyticsUtil.getLocalPaymentId());
            object.put("properties", (Object)jSONObject);
            Lumberjack.addToBatch((JSONObject)object);
            return;
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception.getMessage(), "S0", "Error in adding properties to base json for event tracking");
            return;
        }
    }

    static void trackEvent(String string) {
        Lumberjack.trackEvent(string, new JSONObject());
    }

    static void trackPage(String string, String string2) {
        string = "Viewed " + string + " Page";
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("url", string2);
        Lumberjack.trackEvent(string, hashMap);
    }

    static JSONObject addGlobalProperties(JSONObject jSONObject) {
        try {
            Exception exception;
            JSONObject jSONObject2 = null;
            if (jSONObject.has("properties")) {
                jSONObject2 = jSONObject.getJSONObject("properties");
            }
            if (jSONObject2 == null) {
                jSONObject2 = new JSONObject();
            }
            jSONObject2.put("merchant_app_name", (Object)AnalyticsUtil.MERCHANT_APP_NAME);
            jSONObject2.put("merchant_app_version", (Object)AnalyticsUtil.MERCHANT_APP_VERSION);
            jSONObject2.put("merchant_app_package", (Object)AnalyticsUtil.MERCHANT_APP_NAMESPACE);
            jSONObject2.put("merchant_app_target_sdk", AnalyticsUtil.MERCHANT_APP_TARGET_SDK);
            jSONObject2.put("merchant_app_build", AnalyticsUtil.MERCHANT_APP_BUILD);
            jSONObject2.put("platform", (Object)"mobile_sdk");
            jSONObject2.put("platform_version", (Object)sdkVersion);
            jSONObject2.put("os", (Object)"android");
            jSONObject2.put("os_version", (Object)Build.VERSION.RELEASE);
            jSONObject2.put("library", (Object)AnalyticsUtil.libraryType);
            for (Map.Entry<String, Object> entry : paymentProperties.entrySet()) {
                try {
                    jSONObject2.put(entry.getKey(), entry.getValue());
                }
                catch (Exception exception2) {
                    exception = exception2;
                    AnalyticsUtil.reportError(exception2.getMessage(), "S0", "Error adding analytics property " + entry.getKey() + " to JSONObject");
                }
            }
            for (Map.Entry<String, Object> entry : orderProperties.entrySet()) {
                try {
                    jSONObject2.put(entry.getKey(), entry.getValue());
                }
                catch (Exception exception3) {
                    exception = exception3;
                    AnalyticsUtil.reportError(exception3.getMessage(), "S0", "Error adding analytics property " + entry.getKey() + " to JSONObject");
                }
            }
            jSONObject.put("properties", (Object)jSONObject2);
        }
        catch (Exception exception) {}
        return jSONObject;
    }

    static void postData() {
        JSONObject jSONObject = lumberjackPayload;
        synchronized (jSONObject) {
            lumberjackPayload = Lumberjack.filterPayload(lumberjackPayload);
            Lumberjack.makePostRequest(lumberjackPayload);
        }
        Lumberjack.clearEvents();
    }

    private static void makePostRequest(JSONObject object) {
        if (CoreConfig.getInstance().isLumberJackEnabled().booleanValue()) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("x-identifier", CoreConfig.getInstance().getLumberjackSdkIdentifier());
            hashMap.put("Content-Type", "application/json");
            object = object.toString();
            Owl.post(GlobalUrlConfig.instance().getTrackUrl(), (String)object, hashMap, new Callback(){

                @Override
                public void run(ResponseObject responseObject) {
                    new StringBuilder("Response from lumberjack: ").append(responseObject.getResponseResult());
                }
            });
        }
    }

    private static void clearEvents() {
        try {
            if (lumberjackPayload == null) {
                return;
            }
            JSONObject jSONObject = lumberjackPayload;
            synchronized (jSONObject) {
                lumberjackPayload.put("events", (Object)new JSONArray());
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            AnalyticsUtil.reportError(exception.getMessage(), "S0", exception2.getMessage());
        }
    }

    static void init(Context context, String string, String string2) {
        sdkType = string;
        sdkVersion = string2;
        Lumberjack.setBaseImportJSON(context);
        isLumberjackInitialized = true;
        Lumberjack.addQueuedDataToBatch();
        Lumberjack.transmitSavedEvents(context);
    }

    static void transmitSavedEvents(Context object) {
        String string = SharedPreferenceUtil.getProtectedValue((Context)object, SAVED_EVENTS_DATA, null);
        if (string != null && !string.isEmpty()) {
            try {
                Lumberjack.makePostRequest(new JSONObject(string));
                SharedPreferenceUtil.removeValue((Context)object, SAVED_EVENTS_DATA);
                return;
            }
            catch (Exception exception) {
                object = exception;
                AnalyticsUtil.reportError(exception.getMessage(), "S1", ((Throwable)object).getMessage());
            }
        }
    }

    private static void addQueuedDataToBatch() {
        for (JSONObject jSONObject : preInitBatch) {
            Lumberjack.addToBatch(jSONObject);
        }
        Lumberjack.clearPreInitData();
    }

    private static void clearPreInitData() {
        preInitBatch = new ArrayList();
    }

    private static void addPropertyFromJSONObject(JSONObject object, String string, AnalyticsProperty.Scope scope) {
        try {
            block7: {
                block6: {
                    object = Lumberjack.getValueFromJsonObject((JSONObject)object, string);
                    if (object == null) break block6;
                    if (scope == AnalyticsProperty.Scope.PAYMENT) break block7;
                    if (scope == AnalyticsProperty.Scope.ORDER) {
                        Lumberjack.addOrderProperty(string, object);
                    }
                }
                return;
            }
            Lumberjack.addPaymentProperty(string, object);
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception.getMessage(), "S2", ((Throwable)object).getMessage());
        }
    }

    static Object getValueFromJsonObject(JSONObject object, String string) {
        try {
            return object.get(string);
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception.getMessage(), "S2", ((Throwable)object).getMessage());
            return null;
        }
    }

    static String getStringFromJsonObject(JSONObject object, String string) {
        try {
            return object.getString(string);
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception.getMessage(), "S2", ((Throwable)object).getMessage());
            return null;
        }
    }

    static boolean getBooleanFromJsonObject(JSONObject object, String string) {
        try {
            return object.getBoolean(string);
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception.getMessage(), "S2", ((Throwable)object).getMessage());
            return false;
        }
    }

    static void addAmountToProperties(JSONObject object) {
        try {
            object = Lumberjack.getStringFromJsonObject(object, "amount");
            long l = Long.parseLong((String)object);
            Lumberjack.addOrderProperty("amount", l);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    static void addFrameworkToProperties(JSONObject jSONObject) {
        try {
            Lumberjack.addOrderProperty("framework", jSONObject.has("framework") ? Lumberjack.getStringFromJsonObject(jSONObject, "framework") : "native");
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    static void addFilteredPropertiesFromPayload(JSONObject object) {
        block10: {
            try {
                Lumberjack.addAmountToProperties((JSONObject)object);
                Lumberjack.addFrameworkToProperties((JSONObject)object);
                Lumberjack.addPropertyFromJSONObject((JSONObject)object, "contact", AnalyticsProperty.Scope.ORDER);
                Lumberjack.addPropertyFromJSONObject((JSONObject)object, "email", AnalyticsProperty.Scope.ORDER);
                Lumberjack.addPropertyFromJSONObject((JSONObject)object, "order_id", AnalyticsProperty.Scope.ORDER);
                String string = Lumberjack.getStringFromJsonObject((JSONObject)object, "method");
                if (string == null) {
                    return;
                }
                if (object.has("token")) {
                    string = "saved card";
                }
                Lumberjack.addPaymentProperty("method", string);
                if (string.equals("card")) {
                    if (!AnalyticsUtil.isNullOrEmpty((CharSequence)(object = Lumberjack.getStringFromJsonObject((JSONObject)object, "card[number]"))) && ((String)object).length() >= 6) {
                        object = ((String)object).substring(0, 6);
                        Lumberjack.addPaymentProperty("card_number", object);
                    }
                    break block10;
                }
                if (string.equals("saved card")) {
                    boolean bl = Lumberjack.getBooleanFromJsonObject((JSONObject)object, "razorpay_otp");
                    Lumberjack.addOrderProperty("Checkout Login", "" + !bl);
                    break block10;
                }
                if (string.equals("netbanking")) {
                    Lumberjack.addPropertyFromJSONObject((JSONObject)object, "bank", AnalyticsProperty.Scope.PAYMENT);
                    break block10;
                }
                if (string.equals("wallet")) {
                    Lumberjack.addPropertyFromJSONObject((JSONObject)object, "wallet", AnalyticsProperty.Scope.PAYMENT);
                    break block10;
                }
                if (string.equals("upi")) {
                    Lumberjack.addPaymentProperty("flow", Lumberjack.getStringFromJsonObject((JSONObject)object, "_[flow]"));
                }
                return;
            }
            catch (Exception exception) {
                new StringBuilder("Failed to add props to lumberjack: ").append(exception.getMessage());
                AnalyticsUtil.reportError(exception.getMessage(), "S2", exception.getMessage());
            }
        }
    }

    static void destroy() {
        Lumberjack.clearOrderProperties();
        Lumberjack.clearPaymentProperties();
        Lumberjack.clearEventData();
        isLumberjackInitialized = false;
    }

    static void clearPaymentProperties() {
        paymentProperties = new HashMap<String, Object>();
    }

    static void clearOrderProperties() {
        orderProperties = new HashMap<String, Object>();
    }

    private static void clearEventData() {
        Lumberjack.clearEvents();
        Lumberjack.clearPreInitData();
    }

    static JSONObject filterPayload(JSONObject jSONObject) {
        try {
            JSONArray jSONArray = jSONObject.getJSONArray("events");
            for (int i = 0; i < jSONArray.length(); ++i) {
                jSONArray.put(i, (Object)Lumberjack.filterEvent(jSONArray.getJSONObject(i)));
            }
            jSONObject.put("events", (Object)jSONArray);
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    static JSONObject filterEvent(JSONObject jSONObject) throws JSONException {
        if (jSONObject.has("properties")) {
            JSONObject jSONObject2 = jSONObject.getJSONObject("properties");
            if (jSONObject2.has("url")) {
                String string = jSONObject2.getString("url");
                jSONObject2.put("url", (Object)Lumberjack.filterUrl(string));
            }
            jSONObject.put("properties", (Object)jSONObject2);
        }
        return jSONObject;
    }

    static String filterUrl(String string) {
        if (string.startsWith("data:")) {
            string = "Data present in url";
        }
        return string;
    }

    static JSONObject getLumberjackPayload() {
        return lumberjackPayload;
    }

    static JSONObject getContextPayload() {
        return contextJsonData;
    }

    static ArrayList<JSONObject> getPreInitBatch() {
        return preInitBatch;
    }

    static Map<String, Object> getPaymentProperties() {
        return paymentProperties;
    }

    static Map<String, Object> getOrderProperties() {
        return orderProperties;
    }

    static void saveEventsToPreferences(Context context) {
        JSONObject jSONObject = lumberjackPayload;
        synchronized (jSONObject) {
            Object object = Lumberjack.filterPayload(lumberjackPayload);
            object = object.toString();
            SharedPreferenceUtil.setProtectedValue(context, SAVED_EVENTS_DATA, (String)object, sdkVersion);
            return;
        }
    }

    static JSONObject getSessionCreatedJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("key", (Object)CoreConfig.getInstance().getLumberjackKey());
            JSONArray jSONArray = new JSONArray();
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("name", (Object)"checkout.mobile.sessionCreated.metrics");
            JSONArray jSONArray2 = new JSONArray();
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("type", (Object)"session_created");
            jSONObject3.put("platform", (Object)"android");
            jSONObject3.put("framework", (Object)(sdkType + "_android_" + AnalyticsUtil.getFramework()));
            jSONArray2.put((Object)jSONObject3);
            jSONObject2.put("labels", (Object)jSONArray2);
            jSONArray.put((Object)jSONObject2);
            jSONObject.put("metrics", (Object)jSONArray);
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            AnalyticsUtil.reportError(jSONException.getMessage(), "S0", jSONException2.getLocalizedMessage());
        }
        return jSONObject;
    }

    static JSONObject getSessionErroredJson(String string) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("key", (Object)CoreConfig.getInstance().getLumberjackKey());
            JSONArray jSONArray = new JSONArray();
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("name", (Object)"checkout.mobile.sessionErrored.metrics");
            JSONArray jSONArray2 = new JSONArray();
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("type", (Object)"session_errored");
            jSONObject3.put("platform", (Object)"android");
            jSONObject3.put("framework", (Object)(sdkType + "_android_" + AnalyticsUtil.getFramework()));
            jSONObject3.put("severity", (Object)string);
            jSONArray2.put((Object)jSONObject3);
            jSONObject2.put("labels", (Object)jSONArray2);
            jSONArray.put((Object)jSONObject2);
            jSONObject.put("metrics", (Object)jSONArray);
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            AnalyticsUtil.reportError(jSONException.getMessage(), "S0", jSONException2.getLocalizedMessage());
        }
        return jSONObject;
    }

    static void logVajraCritialError(String string) {
        Lumberjack.makeSessionApiPostRequest(Lumberjack.getSessionErroredJson(string));
    }

    private static void makeSessionApiPostRequest(JSONObject object) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("accept", "application/json");
        hashMap.put("content-type", "applications/json");
        object = object.toString();
        Owl.post("https://lumberjack-metrics.razorpay.com/v1/frontend-metrics", (String)object, hashMap, new Callback(){

            @Override
            public void run(ResponseObject responseObject) {
                new StringBuilder("Response from vjDash: ").append(responseObject.getResponseResult());
            }
        });
    }

    static {
        isLumberjackInitialized = false;
        sdkType = "standalone";
        preInitBatch = new ArrayList();
    }
}

