/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.content.Context;
import android.os.Build;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import com.razorpay.AnalyticsUtil;
import com.razorpay.Lumberjack;
import com.razorpay.SharedPreferenceUtil;

class GpuInfoUtil {
    private static final String KEY_GPU_RENDERER = "gpu_renderer";
    private static final String KEY_GPU_VENDOR = "gpu_vendor";
    private static String gpuRenderer = "unknown";
    private static String gpuVendor = "unknown";
    private static boolean gpuInfoFetched = false;

    GpuInfoUtil() {
    }

    static void loadFromCache(Context object) {
        try {
            String string = SharedPreferenceUtil.getValue(object, KEY_GPU_RENDERER);
            object = SharedPreferenceUtil.getValue(object, KEY_GPU_VENDOR);
            if (string != null && object != null) {
                gpuRenderer = string;
                gpuVendor = object;
                gpuInfoFetched = true;
                new StringBuilder("GPU info loaded from cache: ").append(gpuRenderer).append(" (").append(gpuVendor).append(")");
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private static void saveToCache(Context context) {
        try {
            SharedPreferenceUtil.setValue(context, KEY_GPU_RENDERER, gpuRenderer);
            SharedPreferenceUtil.setValue(context, KEY_GPU_VENDOR, gpuVendor);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    static void extractGpuInfo(WebView object, final Context context) {
        if (gpuInfoFetched || object == null) {
            return;
        }
        try {
            if (Build.VERSION.SDK_INT >= 19) {
                object.evaluateJavascript("(function() {   try {     var canvas = document.createElement('canvas');     var gl = canvas.getContext('webgl') || canvas.getContext('experimental-webgl');     if (gl) {       var debugInfo = gl.getExtension('WEBGL_debug_renderer_info');       if (debugInfo) {         return gl.getParameter(debugInfo.UNMASKED_RENDERER_WEBGL);       }     }   } catch(e) { }   return 'unknown'; })()", (ValueCallback)new ValueCallback<String>(){

                    public void onReceiveValue(String string) {
                        if (string != null && !string.equals("null") && !string.equals("\"unknown\"")) {
                            gpuRenderer = string.replace("\"", "");
                            new StringBuilder("GPU Renderer extracted: ").append(gpuRenderer);
                        }
                    }
                });
                object.evaluateJavascript("(function() {   try {     var canvas = document.createElement('canvas');     var gl = canvas.getContext('webgl') || canvas.getContext('experimental-webgl');     if (gl) {       var debugInfo = gl.getExtension('WEBGL_debug_renderer_info');       if (debugInfo) {         return gl.getParameter(debugInfo.UNMASKED_VENDOR_WEBGL);       }     }   } catch(e) { }   return 'unknown'; })()", (ValueCallback)new ValueCallback<String>(){

                    public void onReceiveValue(String string) {
                        if (string != null && !string.equals("null") && !string.equals("\"unknown\"")) {
                            gpuVendor = string.replace("\"", "");
                            new StringBuilder("GPU Vendor extracted: ").append(gpuVendor);
                            gpuInfoFetched = true;
                            GpuInfoUtil.saveToCache(context);
                            Lumberjack.updateGpuInfo();
                        }
                    }
                });
            }
            return;
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception.getMessage(), "error:exception", "Error extracting GPU info");
            return;
        }
    }

    static String getGpuRenderer() {
        return gpuRenderer;
    }

    static String getGpuVendor() {
        return gpuVendor;
    }

    static boolean isGpuInfoAvailable() {
        return gpuInfoFetched;
    }

    static void reset() {
        gpuRenderer = "unknown";
        gpuVendor = "unknown";
        gpuInfoFetched = false;
    }
}

