/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.content.Context;
import com.razorpay.AnalyticsUtil;
import com.razorpay.CacheEntry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

class CacheManager {
    static File cacheDir;

    CacheManager() {
    }

    static void init(Context context) {
        cacheDir = context.getCacheDir();
    }

    static boolean hasExpired(String string) {
        if (string.equalsIgnoreCase("rzp_payment_preferences")) {
            Object object = new File(cacheDir.getPath(), string);
            if (!((File)object).exists()) {
                return true;
            }
            try {
                if (!((File)object).getAbsolutePath().equalsIgnoreCase(((File)object).getPath() + "/" + string)) {
                    return true;
                }
                object = new FileInputStream((File)object);
                ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)object);
                CacheEntry cacheEntry = (CacheEntry)objectInputStream.readObject();
                ((FileInputStream)object).close();
                objectInputStream.close();
                if (!CacheManager.hasExpired(cacheEntry.expiryTime)) {
                    new StringBuilder("Cache has NOT expired for key ").append(string);
                    return false;
                }
                new StringBuilder("Cache has expired for key ").append(string);
                return true;
            }
            catch (Exception exception) {
                object = exception;
                AnalyticsUtil.reportError(exception.getMessage(), "S2", ((Throwable)object).getMessage());
                return true;
            }
        }
        return true;
    }

    private static boolean hasExpired(long l) {
        return l <= 0L || System.currentTimeMillis() > l;
    }

    static void put(String string, String string2, long l) {
        if (string.equalsIgnoreCase("rzp_payment_preferences")) {
            Object object;
            Object object2 = new File(cacheDir.getPath(), string);
            if (!((File)object2).exists()) {
                try {
                    ((File)object2).createNewFile();
                }
                catch (IOException iOException) {
                    object = iOException;
                    AnalyticsUtil.reportError(iOException.getMessage(), "S1", ((Throwable)object).getMessage());
                }
            }
            try {
                object = new FileOutputStream((File)object2);
                object2 = new ObjectOutputStream((OutputStream)object);
                CacheEntry cacheEntry = new CacheEntry(string2, l + System.currentTimeMillis());
                ((ObjectOutputStream)object2).writeObject(cacheEntry);
                ((ObjectOutputStream)object2).close();
                ((FileOutputStream)object).close();
                String.format("%s stored successfully in cache with expiry time of %d", string, cacheEntry.expiryTime);
                new StringBuilder("Cache value: ").append(string2);
                return;
            }
            catch (Exception exception) {
                object = exception;
                AnalyticsUtil.reportError(exception.getMessage(), "S1", ((Throwable)object).getMessage());
            }
        }
    }

    static void expireKey(String string) {
        CacheManager.put(string, "", -1L);
    }

    static String get(String string) {
        if (string.equalsIgnoreCase("rzp_payment_preferences")) {
            Object object = new File(cacheDir.getPath(), string);
            if (!((File)object).exists()) {
                return null;
            }
            try {
                if (!((File)object).getAbsolutePath().equalsIgnoreCase(((File)object).getPath() + "/" + string)) {
                    return null;
                }
                object = new FileInputStream((File)object);
                ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)object);
                CacheEntry cacheEntry = (CacheEntry)objectInputStream.readObject();
                ((FileInputStream)object).close();
                objectInputStream.close();
                if (CacheManager.hasExpired(cacheEntry.expiryTime)) {
                    CacheManager.purge(string);
                    return null;
                }
                String.format("%s fetched successfully from cache", string);
                return cacheEntry.data;
            }
            catch (Exception exception) {
                object = exception;
                AnalyticsUtil.reportError(exception.getMessage(), "S2", ((Throwable)object).getMessage());
                return null;
            }
        }
        return null;
    }

    static void purge(String object) {
        if (((String)object).equalsIgnoreCase("rzp_payment_preferences")) {
            object = new File(cacheDir.getPath(), (String)object);
            ((File)object).delete();
        }
    }
}

