/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.location.Location;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.http.SslCertificate;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Parcelable;
import android.os.PowerManager;
import android.provider.Settings;
import android.telephony.PhoneStateListener;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.webkit.CookieManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.FileProvider;
import com.razorpay.AdvertisingIdUtil;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsProperty;
import com.razorpay.AnalyticsUtil;
import com.razorpay.BaseConfig;
import com.razorpay.ConfigDroid;
import com.razorpay.CoreConfig;
import com.razorpay.CryptLib;
import com.razorpay.DeeplinkActivity;
import com.razorpay.GpuInfoUtil;
import com.razorpay.NetworkType;
import com.razorpay.R;
import com.razorpay.RzpJSONCallback;
import com.razorpay.SharedPreferenceUtil;
import com.razorpay.StorageBridge;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import proguard.annotation.Keep;
import proguard.annotation.KeepClassMembers;

@Keep
@KeepClassMembers
class BaseUtils {
    private static final String PERMISSION_DISABLED = "permission disabled";
    private static final boolean sWebViewDebuggingEnabled = ConfigDroid.ENABLE_WEBVIEW_DEBUGGING;
    private static boolean isCompatibleWithGooglePay = true;
    private static boolean isGpayCardsUpiRegistered = false;
    private static BaseUtils baseUtils;
    private String paymentId;
    private String orderId;
    static String apiKey;
    private static final ExecutorService ICON_EXECUTOR;
    static String ipAddress;

    BaseUtils() {
    }

    public static BaseUtils getInstance() {
        if (baseUtils != null) {
            return baseUtils;
        }
        baseUtils = new BaseUtils();
        return baseUtils;
    }

    public void setDeeplinkEnabled(Context object, boolean bl) {
        try {
            object.getPackageManager().setComponentEnabledSetting(new ComponentName((Context)object, DeeplinkActivity.class), bl ? 1 : 2, 1);
            return;
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception.getMessage(), "S0", ((Throwable)object).getMessage());
            return;
        }
    }

    public static ArrayList<String> getAppsWithPackageNames(Context context, ArrayList<String> object) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (object == null || ((ArrayList)object).isEmpty()) {
            return arrayList;
        }
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            if (string == null || string.isEmpty() || !BaseUtils.isAppInstalled(context, string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public void setPaymentId(String string) {
        this.paymentId = string;
    }

    public void setOrderId(String string) {
        this.orderId = string;
    }

    public String getMetadata() {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("payment_id", (Object)this.paymentId);
            jSONObject.put("order_id", (Object)this.orderId);
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            jSONException.printStackTrace();
            return null;
        }
    }

    public void clearMetadata() {
        this.paymentId = null;
        this.orderId = null;
    }

    static String constructBasicAuth(String object) throws UnsupportedEncodingException {
        object = (String)object + ":";
        byte[] byArray = ((String)object).getBytes("UTF-8");
        object = byArray;
        object = Base64.encodeToString((byte[])byArray, (int)2);
        return object;
    }

    static boolean hasPermission(Context object, String string) {
        try {
            return 0 == object.checkCallingOrSelfPermission(string);
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception.getMessage(), "S0", ((Throwable)object).getMessage());
            return false;
        }
    }

    static String getKeyId(Context object) {
        try {
            if (apiKey != null) {
                return apiKey;
            }
            object = object.getPackageManager().getApplicationInfo(object.getPackageName(), 128);
            if (object.metaData == null) {
                return null;
            }
            object = object.metaData.getString("com.razorpay.ApiKey");
            return object;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            object = nameNotFoundException;
            AnalyticsUtil.reportError(nameNotFoundException.getMessage(), "S0", object.getMessage());
            return null;
        }
    }

    static HashMap<String, String> getAllPluginsFromManifest(Context object) {
        try {
            object = object.getPackageManager().getApplicationInfo(object.getPackageName(), 128);
            if (object.metaData == null) {
                return null;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Object object2 = object.metaData.keySet();
            object2 = object2.iterator();
            while (object2.hasNext()) {
                Serializable serializable;
                String string = (String)object2.next();
                if (string.contains("com.razorpay.plugin.") && object.metaData.getString(string).equalsIgnoreCase("com.razorpay.RzpGpayMerged")) {
                    try {
                        serializable = Class.forName("com.google.android.apps.nbu.paisa.inapp.client.api.PaymentsClient");
                        if ((serializable = ((Class)serializable).newInstance()) == null) continue;
                        hashMap.put(string, object.metaData.getString(string));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        serializable = classNotFoundException;
                        AnalyticsUtil.reportError(classNotFoundException.getMessage(), "S2", "GooglePay SDK is not included");
                    }
                    catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                        serializable = reflectiveOperationException;
                        reflectiveOperationException.printStackTrace();
                    }
                    continue;
                }
                if (string.contains("com.razorpay.plugin.") && object.metaData.getString(string).equalsIgnoreCase("com.razorpay.RzpGooglePay")) {
                    try {
                        serializable = Class.forName("com.google.android.apps.nbu.paisa.inapp.client.api.PaymentsClient");
                        if ((serializable = ((Class)serializable).newInstance()) == null) continue;
                        hashMap.put(string, object.metaData.getString(string));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        serializable = classNotFoundException;
                        AnalyticsUtil.reportError(classNotFoundException.getMessage(), "S2", "GooglePay SDK is not included");
                    }
                    catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                        serializable = reflectiveOperationException;
                        reflectiveOperationException.printStackTrace();
                    }
                    continue;
                }
                if (!string.contains("com.razorpay.plugin.") || object.metaData.getString(string) == null) continue;
                hashMap.put(string, object.metaData.getString(string));
            }
            return hashMap;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            object = nameNotFoundException;
            AnalyticsUtil.reportError(nameNotFoundException.getMessage(), "S0", object.getMessage());
            return null;
        }
    }

    private static void setBaseWebViewSettings() {
        if (Build.VERSION.SDK_INT >= 19) {
            WebView.setWebContentsDebuggingEnabled((boolean)sWebViewDebuggingEnabled);
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private static void enableJavaScriptInWebView(WebView webView) {
        webView = webView.getSettings();
        webView.setJavaScriptEnabled(true);
    }

    static void setWebViewSettings(final Context context, final WebView webView, boolean bl) {
        BaseUtils.setBaseWebViewSettings();
        BaseUtils.enableJavaScriptInWebView(webView);
        CookieManager.getInstance().setAcceptCookie(true);
        webView.setTag((Object)"razorpay");
        WebSettings webSettings = webView.getSettings();
        webSettings.setDomStorageEnabled(true);
        webSettings.setDatabaseEnabled(true);
        webSettings.setTextZoom(100);
        String string = context.getApplicationContext().getDir("database", 0).getPath();
        if (Build.VERSION.SDK_INT < 19) {
            webSettings.setDatabasePath(string);
        }
        if (Build.VERSION.SDK_INT < 24) {
            webSettings.setGeolocationDatabasePath(string);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            string = CookieManager.getInstance();
            string.setAcceptThirdPartyCookies(webView, true);
        }
        webSettings.setCacheMode(-1);
        if (bl) {
            webSettings.setCacheMode(2);
        }
        webSettings.setSaveFormData(false);
        webView.addJavascriptInterface((Object)new StorageBridge(context), "StorageBridge");
        webSettings.setAllowFileAccess(false);
        webSettings.setAllowFileAccessFromFileURLs(false);
        webSettings.setAllowUniversalAccessFromFileURLs(false);
        webSettings.setAllowContentAccess(false);
        webView.post(new Runnable(){

            @Override
            public void run() {
                GpuInfoUtil.extractGpuInfo(webView, context);
            }
        });
    }

    static boolean hasFeature(Context context, String string) {
        return context.getPackageManager().hasSystemFeature(string);
    }

    static <T> T getSystemService(Context context, String string) {
        return (T)context.getApplicationContext().getSystemService(string);
    }

    static int getNetworkType(Context object) {
        NetworkType networkType = BaseUtils.getDataNetworkType((Context)object);
        if (networkType == NetworkType.WIFI) {
            return 0;
        }
        if (networkType == NetworkType.BLUETOOTH) {
            return 1;
        }
        if (networkType == NetworkType.CELLULAR) {
            if (((String)(object = BaseUtils.getCellularNetworkType((Context)object))).equalsIgnoreCase("2G")) {
                return 2;
            }
            if (((String)object).equalsIgnoreCase("3G")) {
                return 3;
            }
            if (((String)object).equalsIgnoreCase("4G")) {
                return 4;
            }
        }
        return -1;
    }

    @SuppressLint(value={"MissingPermission"})
    static String getCellularNetworkType(Context object) {
        try {
            if (Build.VERSION.SDK_INT >= 24) {
                if ((object = (TelephonyManager)object.getSystemService("phone")) == null) {
                    return "NA";
                }
                int n = object.getDataNetworkType();
                return BaseUtils.mapNetworkTypeToGeneration(n);
            }
            return BaseUtils.getCellularNetworkTypeFromConnectivityManager((Context)object);
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception.getMessage(), "S2", ((Throwable)object).getLocalizedMessage());
            return "NA";
        }
    }

    private static String mapNetworkTypeToGeneration(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return "2G";
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return "3G";
            }
            case 13: {
                return "LTE";
            }
        }
        return "NA";
    }

    private static String getCellularNetworkTypeFromConnectivityManager(Context object) {
        try {
            object = (ConnectivityManager)object.getSystemService("connectivity");
            if (object == null) {
                return "NA";
            }
            if ((object = object.getActiveNetworkInfo()) == null || !object.isConnected()) {
                return "NA";
            }
            if (object.getType() != 0) {
                return "NA";
            }
            int n = object.getSubtype();
            return BaseUtils.mapNetworkTypeToGeneration(n);
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception.getMessage(), "S2", ((Throwable)object).getLocalizedMessage());
            return "NA";
        }
    }

    static String getCellularNetworkProviderName(Context context) {
        if ((context = (TelephonyManager)BaseUtils.getSystemService(context, "phone")) != null) {
            return context.getNetworkOperatorName();
        }
        return "unknown";
    }

    static NetworkType getDataNetworkType(Context context) {
        if (BaseUtils.hasPermission(context, "android.permission.ACCESS_NETWORK_STATE") && (context = (ConnectivityManager)BaseUtils.getSystemService(context, "connectivity")) != null) {
            NetworkInfo networkInfo = context.getNetworkInfo(1);
            if (networkInfo != null && networkInfo.isConnected()) {
                return NetworkType.WIFI;
            }
            networkInfo = context.getNetworkInfo(7);
            if (networkInfo != null && networkInfo.isConnected()) {
                return NetworkType.BLUETOOTH;
            }
            if ((context = context.getNetworkInfo(0)) != null && context.isConnected()) {
                return NetworkType.CELLULAR;
            }
        }
        return NetworkType.UNKNOWN;
    }

    static String getLocale() {
        return Locale.getDefault().getLanguage() + "-" + Locale.getDefault().getCountry();
    }

    static ArrayList<String> jsonStringArrayToArrayList(JSONArray jSONArray) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            arrayList.add(jSONArray.getString(i));
        }
        return arrayList;
    }

    static String getAppBuildType(Context context) {
        if (0 != (context.getApplicationInfo().flags & 2)) {
            return "development";
        }
        return "production";
    }

    static CharSequence getWebViewUserAgent(Context context) {
        try {
            return AnalyticsUtil.returnUndefinedIfNull(new WebView(context).getSettings().getUserAgentString());
        }
        catch (Exception exception) {
            return "undefined";
        }
    }

    static boolean isDeviceHaveCorrectTlsVersion() {
        try {
            String[] stringArray = SSLContext.getDefault().getDefaultSSLParameters();
            stringArray = stringArray.getProtocols();
            if (stringArray == null) {
                return false;
            }
            for (String string : stringArray) {
                if (!string.startsWith("TLS") || string.equalsIgnoreCase("TLSv1")) continue;
                return true;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            NoSuchAlgorithmException noSuchAlgorithmException2 = noSuchAlgorithmException;
            AnalyticsUtil.reportError(noSuchAlgorithmException.getMessage(), "S0", noSuchAlgorithmException2.getMessage());
        }
        return false;
    }

    static void setup() {
        AnalyticsUtil.reset();
    }

    public static double round(double d, int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bigDecimal = new BigDecimal(d);
        bigDecimal = bigDecimal.setScale(n, RoundingMode.HALF_UP);
        return bigDecimal.doubleValue();
    }

    public static String nanoTimeToSecondsString(long l, int n) {
        double d = (double)l / 1.0E9;
        d = BaseUtils.round(d, n);
        return "" + d;
    }

    static boolean isMerchantAppDebuggable(Context context) {
        return 0 != (context.getApplicationInfo().flags & 2);
    }

    static Certificate getX509Certificate(SslCertificate object) {
        object = SslCertificate.saveState((SslCertificate)object);
        byte[] byArray = object.getByteArray("x509-certificate");
        object = byArray;
        if (byArray == null) {
            return null;
        }
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            return certificateFactory.generateCertificate(new ByteArrayInputStream((byte[])object));
        }
        catch (CertificateException certificateException) {
            CertificateException certificateException2 = certificateException;
            AnalyticsUtil.reportError(certificateException.getMessage(), "S0", certificateException2.getLocalizedMessage());
            return null;
        }
    }

    static String makeErrorPayload(String string, String string2) {
        try {
            JSONObject jSONObject = new JSONObject();
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("code", (Object)string);
            jSONObject2.put("description", (Object)string2);
            jSONObject.put("error", (Object)jSONObject2);
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            AnalyticsUtil.reportError(jSONException.getMessage(), "error:exception", jSONException2.getMessage());
            jSONException2.printStackTrace();
            return "{\"error\":{\"code\": \"BAD_REQUEST_ERROR\", \"description\": \"An unknown error occurred.\"}}";
        }
    }

    static PublicKey constructPublicKey(String object) {
        try {
            object = Base64.decode((byte[])((String)object).getBytes(), (int)0);
            object = new X509EncodedKeySpec((byte[])object);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic((KeySpec)object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Boolean isUserRegisteredOnTruePay(Context object) {
        try {
            int n = object.getPackageManager().getComponentEnabledSetting(new ComponentName("com.truecaller", "com.truecaller.truepay.UserRegistered"));
            return n == 1;
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            AnalyticsUtil.reportError(((Throwable)object).getMessage(), "S1", ((Throwable)object).getMessage());
            return Boolean.FALSE;
        }
    }

    static boolean checkUpiRegisteredApp(Context object, String string) {
        switch (string) {
            case "com.google.android.apps.nbu.paisa.user": {
                return isCompatibleWithGooglePay;
            }
        }
        return true;
    }

    static HashSet<String> getSetOfPackageNamesSupportingUpi(Context context) {
        Object object = BaseUtils.getListOfAppsWhichHandleDeepLink(context, "upi://pay");
        HashSet<String> hashSet = new HashSet<String>();
        if (object != null && object.size() > 0) {
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (ResolveInfo)object.next();
                try {
                    hashSet.add(((ResolveInfo)object2).activityInfo.packageName);
                }
                catch (Exception exception) {
                    object2 = exception;
                    AnalyticsUtil.reportError(exception.getMessage(), "S0", ((Throwable)object2).getLocalizedMessage());
                }
            }
        }
        if (hashSet.size() > 0 && !BaseUtils.checkUpiRegisteredApp(context, "com.google.android.apps.nbu.paisa.user")) {
            hashSet.remove("com.google.android.apps.nbu.paisa.user");
        }
        if (hashSet.size() > 0 && !BaseUtils.checkUpiRegisteredApp(context, "com.truecaller")) {
            hashSet.remove("com.truecaller");
        }
        return hashSet;
    }

    static HashSet<String> getSetOfPackageNamesSupportingUpiAutopay(Context object) {
        object = BaseUtils.getListOfAppsWhichHandleDeepLink((Context)object, "upi://mandate");
        HashSet<String> hashSet = new HashSet<String>();
        if (object != null && object.size() > 0) {
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (ResolveInfo)object.next();
                try {
                    hashSet.add(((ResolveInfo)object2).activityInfo.packageName);
                }
                catch (Exception exception) {
                    object2 = exception;
                    AnalyticsUtil.reportError(exception.getMessage(), "S0", ((Throwable)object2).getLocalizedMessage());
                }
            }
        }
        return hashSet;
    }

    static List<ResolveInfo> getListOfAppsWhichHandleDeepLink(Context context, String string) {
        Intent intent = new Intent();
        intent.setData(Uri.parse((String)string));
        return context.getPackageManager().queryIntentActivities(intent, 131072);
    }

    static String getAppNameOfResolveInfo(ResolveInfo resolveInfo, Context context) throws Exception {
        return BaseUtils.getAppNameOfPackageName(resolveInfo.activityInfo.packageName, context);
    }

    static void startActivityForResult(String string, String string2, Activity activity) {
        block6: {
            try {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)string));
                if (string2 != null && !string2.isEmpty()) {
                    intent.setPackage(string2);
                }
                if (string.startsWith("credpay")) {
                    activity.startActivityForResult(intent, 20);
                    break block6;
                }
                if (string.startsWith("truecallersdk://truesdk")) {
                    activity.startActivityForResult(intent, 101);
                    break block6;
                }
                if (string.contains("tngdigital") && "my.com.tngdigital.ewallet".equalsIgnoreCase(string2)) {
                    AnalyticsUtil.trackEvent(AnalyticsEvent.SDK_INTENT_WALLET_APP_REDIRECT);
                    AnalyticsUtil.addProperty("url", new AnalyticsProperty(string, AnalyticsProperty.Scope.PAYMENT));
                    AnalyticsUtil.addProperty("wallet_app_package_name", new AnalyticsProperty(string2, AnalyticsProperty.Scope.PAYMENT));
                    AnalyticsUtil.trackEvent(AnalyticsEvent.SDK_TNG_WALLET_APP_FLOW_START);
                    activity.startActivity(intent);
                    break block6;
                }
                activity.startActivityForResult(intent, 99);
                return;
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                AnalyticsUtil.reportError("BaseUtils", "S2", activityNotFoundException.getMessage());
            }
        }
    }

    static JSONObject getJSONFromIntentData(Intent intent) {
        JSONObject jSONObject = new JSONObject();
        if (intent != null && (intent = intent.getExtras()) != null) {
            Object object = intent.keySet();
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (String)object.next();
                try {
                    jSONObject.put(object2, intent.get(object2));
                }
                catch (JSONException jSONException) {
                    object2 = jSONException;
                    AnalyticsUtil.reportError(jSONException.getMessage(), "error:exception", object2.getLocalizedMessage());
                }
            }
        }
        return jSONObject;
    }

    static String getBase64FromOtherAppsResource(Context object, String string) {
        object = ICON_EXECUTOR.submit(() -> BaseUtils.lambda$getBase64FromOtherAppsResource$0((Context)object, string));
        try {
            return (String)object.get(2L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            object.cancel(true);
            Thread.currentThread().interrupt();
            AnalyticsUtil.reportError(exception.getMessage(), "S0", "Execution error while loading icon for " + string + ": " + exception.getLocalizedMessage());
            return null;
        }
    }

    static String getAppNameOfPackageName(String string, Context object) throws Exception {
        try {
            object = object.getPackageManager();
            ApplicationInfo applicationInfo = object.getApplicationInfo(string, 128);
            int n = applicationInfo.labelRes;
            object = object.getResourcesForApplication(applicationInfo);
            if (n == 0) {
                return applicationInfo.nonLocalizedLabel.toString();
            }
            return object.getString(n);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            object = nameNotFoundException;
            AnalyticsUtil.reportError(nameNotFoundException.getMessage(), "S0", "Error loading app name for " + string + ": " + object.getLocalizedMessage());
            return null;
        }
    }

    static String getBase64FromDrawable(Resources resources, Drawable object) {
        String string;
        resources = BitmapFactory.decodeResource((Resources)resources, (int)R.drawable.rzp_logo);
        if (object != null) {
            if (object instanceof BitmapDrawable) {
                resources = ((BitmapDrawable)object).getBitmap();
            } else {
                resources = Bitmap.createBitmap((int)object.getIntrinsicWidth(), (int)object.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                string = new Canvas((Bitmap)resources);
                object.setBounds(0, 0, string.getWidth(), string.getHeight());
                object.draw((Canvas)string);
            }
        }
        try {
            if (resources != null) {
                string = "data:image/png;base64,";
                object = new ByteArrayOutputStream();
                resources.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)object);
                object = object.toByteArray();
                string = string + Base64.encodeToString((byte[])object, (int)2);
                object = string;
                return object;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
        finally {
            if (resources != null && !resources.isRecycled()) {
                resources.recycle();
            }
        }
    }

    static String getBase64FromResource(Resources object, int n) {
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)object, (int)n);
        if (bitmap == null && (object = object.getDrawable(n)) != null) {
            if (object instanceof BitmapDrawable) {
                bitmap = ((BitmapDrawable)object).getBitmap();
            } else {
                bitmap = Bitmap.createBitmap((int)object.getIntrinsicWidth(), (int)object.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                object.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
                object.draw(canvas);
            }
        }
        try {
            if (bitmap != null) {
                object = "data:image/png;base64,";
                Object object2 = new ByteArrayOutputStream();
                bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)object2);
                object2 = ((ByteArrayOutputStream)object2).toByteArray();
                object = (String)object + Base64.encodeToString((byte[])object2, (int)2);
                return object;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static Object getJsonValue(String object, JSONObject jSONObject, Object object2) {
        try {
            object = BaseUtils.getJsonValue(((String)object).split("\\."), (Object)jSONObject, 0);
            if (object != null) {
                return object;
            }
            return object2;
        }
        catch (Exception exception) {
            return object2;
        }
    }

    @NonNull
    static String getType(String string) {
        int n = -1;
        switch (string.hashCode()) {
            case 111145: {
                if (!string.equals("png")) break;
                n = 0;
                break;
            }
            case 3268712: {
                if (!string.equals("jpeg")) break;
                n = 1;
                break;
            }
            case 105441: {
                if (!string.equals("jpg")) break;
                n = 2;
                break;
            }
            case 102340: {
                if (!string.equals("gif")) break;
                n = 3;
            }
        }
        switch (n) {
            case 0: {
                string = "image/png";
                break;
            }
            case 1: 
            case 2: {
                string = "image/jpeg";
                break;
            }
            case 3: {
                string = "image/gif";
                break;
            }
            default: {
                string = "application/octet-stream";
            }
        }
        return string;
    }

    static void openPdfFile(Activity activity, Uri object) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(object, "application/pdf");
            intent.setFlags(1);
            object = activity.getPackageManager();
            object = object.queryIntentActivities(intent, 0);
            if (object.size() <= 0) {
                Toast.makeText((Context)activity, (CharSequence)"No app found to open PDF", (int)1).show();
                return;
            }
            activity.startActivity(intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            ActivityNotFoundException activityNotFoundException2 = activityNotFoundException;
            activityNotFoundException.getMessage();
        }
    }

    static void openFile(Activity activity, Uri object) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(object);
            intent.setFlags(1);
            object = activity.getPackageManager();
            object = object.queryIntentActivities(intent, 0);
            if (object.isEmpty()) {
                Toast.makeText((Context)activity, (CharSequence)"No app found to open PDF", (int)1).show();
                return;
            }
            activity.startActivity(intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            ActivityNotFoundException activityNotFoundException2 = activityNotFoundException;
            activityNotFoundException.getMessage();
        }
    }

    static void pdfDownloadHelper(Activity activity, String string, String object) {
        FileOutputStream fileOutputStream;
        try {
            fileOutputStream = activity.openFileOutput(string, 0);
            object = Base64.decode((String)object, (int)0);
            fileOutputStream.write((byte[])object);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        object = activity.getFilesDir().toString() + "/" + string + ".pdf";
        object = new File((String)object);
        try {
            Activity activity2 = activity;
            object = FileProvider.getUriForFile((Context)activity2, (String)activity2.getApplicationContext().getPackageName(), (File)object);
            fileOutputStream = new Intent("android.intent.action.CREATE_DOCUMENT");
            fileOutputStream.addCategory("android.intent.category.OPENABLE");
            fileOutputStream.putExtra("android.intent.extra.TITLE", string);
            fileOutputStream.setDataAndType((Uri)object, "application/pdf");
            if (Build.VERSION.SDK_INT >= 26) {
                fileOutputStream.putExtra("android.provider.extra.INITIAL_URI", (Parcelable)Uri.parse((String)"/Documents"));
            }
            activity.startActivityForResult((Intent)fileOutputStream, 77);
            return;
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            return;
        }
    }

    private static Object getJsonValue(String[] stringArray, Object object, int n) {
        while (true) {
            if (n == stringArray.length) {
                return object;
            }
            String string = stringArray[n];
            if (object instanceof JSONObject) {
                object = (JSONObject)object;
                ++n;
                object = object.opt(string);
                continue;
            }
            if (!(object instanceof JSONArray)) break;
            object = (JSONArray)object;
            if (!TextUtils.isDigitsOnly((CharSequence)string)) break;
            int n2 = Integer.parseInt(string);
            ++n;
            object = object.opt(n2);
        }
        return null;
    }

    static String getRandomString() {
        SecureRandom secureRandom = new SecureRandom();
        return new BigInteger(130, secureRandom).toString(32);
    }

    static String getFileFromInternal(Activity object, String string, String charSequence) throws Exception {
        charSequence = BaseUtils.getLocalVersion((Activity)object, (String)charSequence).toString();
        string = BaseUtils.getVersionedAssetName((String)charSequence, string);
        object = object.openFileInput(string);
        object = new BufferedReader(new InputStreamReader((InputStream)object, "UTF-8"));
        charSequence = new StringBuilder();
        while ((string = ((BufferedReader)object).readLine()) != null) {
            ((StringBuilder)charSequence).append(string);
        }
        ((BufferedReader)object).close();
        return BaseUtils.decryptFile(((StringBuilder)charSequence).toString());
    }

    static String decryptFile(String string) {
        try {
            CryptLib cryptLib = new CryptLib();
            String string2 = CryptLib.SHA256("rzpisunitedred", 32);
            string = cryptLib.decrypt(string, string2, "glorygloryunited");
            return string;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            AnalyticsUtil.reportError(exception.getMessage(), "S2", exception2.getLocalizedMessage());
            new StringBuilder("Unable to decrypt file, ").append(exception2.getMessage());
            return null;
        }
    }

    static String getVersionedAssetName(String string, String string2) {
        string = string.replaceAll("\\.", "-");
        return string + "-" + string2;
    }

    static String getLocalVersion(Activity object, String string) {
        if ((object = SharedPreferenceUtil.getValue((Context)object, string)) == null) {
            object = "{\n  \"hash\" : \"c4171614448e750850bd4daca2c7e8d1\",\n  \"magic_hash\": \"e1ff492228196aa72f4892db1e05624e\"\n}\n";
            object = BaseUtils.getVersionFromJsonString("{\n  \"hash\" : \"c4171614448e750850bd4daca2c7e8d1\",\n  \"magic_hash\": \"e1ff492228196aa72f4892db1e05624e\"\n}\n", string);
        }
        return object;
    }

    static String getVersionFromJsonString(String string, String string2) {
        try {
            string = new JSONObject(string);
            if (string2.equalsIgnoreCase("otpelf_version")) {
                return string.getString("hash");
            }
            if (string2.equalsIgnoreCase("magic_version")) {
                return string.getString("magic_hash");
            }
        }
        catch (Exception exception) {}
        return null;
    }

    static void updateLocalVersion(Activity activity, String string, String string2) {
        SharedPreferenceUtil.setValue((Context)activity, string, string2);
    }

    static boolean storeFileInInternal(Activity object, String string, String string2) {
        try {
            object = object.openFileOutput(string, 0);
            ((FileOutputStream)object).write(string2.getBytes());
            ((FileOutputStream)object).close();
            return true;
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception.getMessage(), "S1", "Error in saving file: " + string);
            new StringBuilder("Error in saving file: ").append(string);
            return false;
        }
    }

    static void checkForLatestVersion(Context context, int n) {
        if (CoreConfig.getInstance().isSDKUpdateAlertEnabled() && BaseUtils.isMerchantAppDebuggable(context) && n < CoreConfig.getInstance().getLatestSDKVersionCode()) {
            String string = CoreConfig.getInstance().getUpdateSDKMsg();
            Toast.makeText((Context)context, (CharSequence)string, (int)1).show();
        }
    }

    static int dpToPixels(Context context, int n) {
        context = context.getResources();
        int n2 = (int)TypedValue.applyDimension((int)1, (float)n, (DisplayMetrics)context.getDisplayMetrics());
        return n2;
    }

    static int getDisplayWidth(Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((Activity)context).getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.widthPixels;
    }

    static int getDisplayHeight(Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((Activity)context).getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.heightPixels;
    }

    static HashMap<String, String> getMapFromJSONObject(JSONObject jSONObject) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = jSONObject.getString(string);
                hashMap.put(string, string2);
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            AnalyticsUtil.reportError(exception.getMessage(), "error:exception", exception2.getMessage());
        }
        return hashMap;
    }

    static void setCompatibleWithGooglePay(boolean bl) {
        isCompatibleWithGooglePay = bl;
    }

    static String makeUrlEncodedPayload(JSONObject jSONObject) throws JSONException {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = jSONObject.getString(string);
            stringBuilder.append(String.format("%s=%s&", string, Uri.encode((String)string2)));
        }
        StringBuilder stringBuilder2 = stringBuilder;
        return stringBuilder2.deleteCharAt(stringBuilder2.length() - 1).toString();
    }

    static String installedApps(Context object) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            object = object.getPackageManager();
            object = object.getInstalledApplications(0);
            object = object.iterator();
            while (object.hasNext()) {
                ApplicationInfo applicationInfo = (ApplicationInfo)object.next();
                if ((applicationInfo.flags & 1) != 0) continue;
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(applicationInfo.packageName);
            }
            return stringBuilder.toString();
        }
        catch (Throwable throwable) {
            return "Apps not available";
        }
    }

    static String getAndroidId(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    static String getDisplayResolution(Context context) {
        context = context.getResources().getDisplayMetrics();
        return String.format(Locale.ENGLISH, "%dx%dx%d", context.widthPixels, context.heightPixels, context.densityDpi);
    }

    static long getTotalRamMB(Context object) {
        try {
            object = (ActivityManager)object.getSystemService("activity");
            ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
            object.getMemoryInfo(memoryInfo);
            return memoryInfo.totalMem / 0x100000L;
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception.getMessage(), "error:exception", "Error getting total RAM");
            return -1L;
        }
    }

    static long getFreeRamMB(Context object) {
        try {
            object = (ActivityManager)object.getSystemService("activity");
            ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
            object.getMemoryInfo(memoryInfo);
            return memoryInfo.availMem / 0x100000L;
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception.getMessage(), "error:exception", "Error getting free RAM");
            return -1L;
        }
    }

    static int getCpuCores() {
        try {
            return Runtime.getRuntime().availableProcessors();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            AnalyticsUtil.reportError(exception.getMessage(), "error:exception", "Error getting CPU cores");
            return -1;
        }
    }

    static boolean isPowerSaveMode(Context object) {
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                object = (PowerManager)object.getSystemService("power");
                return object.isPowerSaveMode();
            }
            return false;
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception.getMessage(), "error:exception", "Error checking power save mode");
            return false;
        }
    }

    static int getBatteryLevel(Context context) {
        try {
            IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            context = context.registerReceiver(null, intentFilter);
            if (context != null) {
                int n = context.getIntExtra("level", -1);
                int n2 = context.getIntExtra("scale", -1);
                return (int)((float)n / (float)n2 * 100.0f);
            }
            return -1;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            AnalyticsUtil.reportError(exception.getMessage(), "error:exception", "Error getting battery level");
            return -1;
        }
    }

    static boolean isCharging(Context context) {
        try {
            IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            context = context.registerReceiver(null, intentFilter);
            if (context != null) {
                int n = context.getIntExtra("status", -1);
                return n == 2 || n == 5;
            }
            return false;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            AnalyticsUtil.reportError(exception.getMessage(), "error:exception", "Error checking charging status");
            return false;
        }
    }

    String getSystemFontSize(Context context) {
        return String.valueOf(context.getResources().getConfiguration().fontScale);
    }

    private boolean isMocked(Context context, Location location) {
        return location.isFromMockProvider();
    }

    static boolean isNetworkRoaming(Context context) {
        if ((context = (TelephonyManager)context.getSystemService("phone")) != null) {
            return context.isNetworkRoaming();
        }
        return false;
    }

    static String getCarrierOperatorName(Context context) {
        if ((context = (TelephonyManager)context.getSystemService("phone")) != null) {
            return context.getNetworkOperatorName();
        }
        return PERMISSION_DISABLED;
    }

    static Map<String, String> getDeviceAttributes(Context context) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (context.checkCallingOrSelfPermission("android.permission.READ_PHONE_STATE") == 0) {
            context.getSystemService("phone");
            hashMap.put("device_id", BaseConfig.getAdvertisingId(context));
            hashMap.put("sim_serial_number", PERMISSION_DISABLED);
            hashMap.put("build_unique_id", UUID.randomUUID().toString());
        } else {
            hashMap.put("device_id", PERMISSION_DISABLED);
            hashMap.put("sim_serial_number", PERMISSION_DISABLED);
        }
        hashMap.put("device_manufacturer", Build.MANUFACTURER);
        hashMap.put("device_model", Build.MODEL);
        return hashMap;
    }

    static String getWifiSSID(Context context) {
        if (context.checkCallingOrSelfPermission("android.permission.ACCESS_WIFI_STATE") == 0) {
            context = (WifiManager)context.getApplicationContext().getSystemService("wifi");
            context = context.getConnectionInfo();
            return context.getSSID();
        }
        return PERMISSION_DISABLED;
    }

    static String buildSerial() {
        return Build.SERIAL;
    }

    static void fetchIP(RzpJSONCallback object) {
        object = new Thread(new Runnable((RzpJSONCallback)object){
            final /* synthetic */ RzpJSONCallback val$jsonCallback;
            {
                this.val$jsonCallback = rzpJSONCallback;
            }

            /*
             * Loose catch block
             */
            @Override
            public void run() {
                block12: {
                    try {
                        block11: {
                            HttpURLConnection httpURLConnection = null;
                            try {
                                URL uRL = new URL("https://approvals-api.getsimpl.com/my-ip");
                                httpURLConnection = (HttpsURLConnection)uRL.openConnection();
                                httpURLConnection.setRequestMethod("GET");
                                httpURLConnection.setReadTimeout(150);
                                httpURLConnection.setConnectTimeout(250);
                                if (httpURLConnection.getResponseCode() == 200) {
                                    uRL = BaseUtils.getResponseJson((HttpsURLConnection)httpURLConnection);
                                    this.val$jsonCallback.onResponse((JSONObject)uRL);
                                } else {
                                    this.val$jsonCallback.onResponse(new JSONObject().put("error", (Object)"error"));
                                }
                                if (httpURLConnection == null) break block11;
                            }
                            catch (SocketTimeoutException socketTimeoutException) {
                                this.val$jsonCallback.onResponse(new JSONObject().put("error", (Object)"timeout"));
                                break block12;
                            }
                            catch (Exception exception) {
                                Exception exception2 = exception;
                                AnalyticsUtil.reportError(exception.getMessage(), "S2", exception2.getMessage());
                                break block12;
                                {
                                    catch (Throwable throwable) {
                                        throw throwable;
                                    }
                                }
                            }
                            finally {
                                if (httpURLConnection == null) break block11;
                                httpURLConnection.disconnect();
                            }
                            httpURLConnection.disconnect();
                            break block12;
                        }
                        return;
                    }
                    catch (Exception exception) {
                        Exception exception3 = exception;
                        AnalyticsUtil.reportError(exception.getMessage(), "S2", exception3.getMessage());
                    }
                }
            }
        });
        ((Thread)object).start();
    }

    static void getDeviceParamValues(Context object, RzpJSONCallback rzpJSONCallback) {
        final JSONObject jSONObject = new JSONObject();
        try {
            BaseUtils.fetchIP(new RzpJSONCallback(){

                @Override
                public void onResponse(JSONObject jSONObject) {
                    try {
                        if (jSONObject.getString("ip") != null) {
                            ipAddress = jSONObject.getString("ip");
                        }
                        return;
                    }
                    catch (JSONException jSONException) {
                        return;
                    }
                }
            });
            AdvertisingIdUtil.getId((Context)object, new AdvertisingIdUtil.AdvertisingIdCallback(){
                final /* synthetic */ Context val$context;
                final /* synthetic */ RzpJSONCallback val$jsonCallback;
                {
                    this.val$context = context;
                    this.val$jsonCallback = rzpJSONCallback;
                }

                @Override
                public void onResult(String object) {
                    try {
                        jSONObject.put("advertising_id", object);
                        jSONObject.put("is_roming", BaseUtils.isNetworkRoaming(this.val$context));
                        jSONObject.put("carrier_network", (Object)BaseUtils.getCarrierOperatorName(this.val$context));
                        jSONObject.put("carrier_id", (Object)"null");
                        object = BaseUtils.getDeviceAttributes(this.val$context);
                        jSONObject.put("device_Id", object.get("device_Id"));
                        jSONObject.put("device_manufacturer", object.get("device_manufacturer"));
                        jSONObject.put("device_model", object.get("device_model"));
                        jSONObject.put("serial_number", (Object)BaseUtils.buildSerial());
                        jSONObject.put("ip_address", (Object)ipAddress);
                        jSONObject.put("wifi_ssid", (Object)BaseUtils.getWifiSSID(this.val$context));
                        jSONObject.put("android_id", (Object)BaseUtils.getAndroidId(this.val$context));
                        jSONObject.put("safety_net basic_integrity", (Object)"true");
                        jSONObject.put("safety_net_cts_profile_match", (Object)"null");
                        this.val$jsonCallback.onResponse(jSONObject);
                        return;
                    }
                    catch (JSONException jSONException) {
                        object = jSONException;
                        AnalyticsUtil.reportError(jSONException.getMessage(), "S2", object.getMessage());
                        return;
                    }
                }
            });
            return;
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception.getMessage(), "S2", ((Throwable)object).getMessage());
            return;
        }
    }

    static void getSignalStrength(Context context) {
        MyPhoneStateListener myPhoneStateListener = new MyPhoneStateListener();
        context = (TelephonyManager)context.getSystemService("phone");
        assert (context != null);
        context.listen((PhoneStateListener)myPhoneStateListener, 256);
    }

    private static JSONObject getResponseJson(HttpsURLConnection object) throws IOException, JSONException {
        String string;
        object = new BufferedReader(new InputStreamReader(((URLConnection)object).getInputStream()));
        StringBuilder stringBuilder = new StringBuilder();
        while ((string = ((BufferedReader)object).readLine()) != null) {
            stringBuilder.append(string);
        }
        ((BufferedReader)object).close();
        return new JSONObject(stringBuilder.toString());
    }

    static String getGenericPaymentErrorResponse(String string) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("code", (Object)"BAD_REQUEST_ERROR");
            jSONObject.put("description", (Object)string);
            jSONObject.put("source", (Object)"customer");
            jSONObject.put("step", (Object)"payment_authentication");
            jSONObject.put("reason", (Object)"payload_error");
            return new JSONObject().put("error", (Object)jSONObject).toString();
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            AnalyticsUtil.reportError(jSONException.getMessage(), "S0", jSONException2.getLocalizedMessage());
            return null;
        }
    }

    static String getGenericPaymentErrorResponse(String string, String string2, String string3) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("code", (Object)"BAD_REQUEST_ERROR");
            jSONObject.put("description", (Object)string2);
            jSONObject.put("source", (Object)"customer");
            jSONObject.put("step", (Object)"payment_authentication");
            jSONObject.put("reason", (Object)new JSONObject().put("code", (Object)string).put("description", (Object)string2));
            if (string3 != null) {
                jSONObject.put("metadata", (Object)new JSONObject(string3));
            }
            return new JSONObject().put("error", (Object)jSONObject).toString();
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            AnalyticsUtil.reportError(jSONException.getMessage(), "S0", jSONException2.getLocalizedMessage());
            return null;
        }
    }

    static String getGenericPaymentErrorResponse(String string, String string2) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("code", (Object)"BAD_REQUEST_ERROR");
            jSONObject.put("description", (Object)string);
            jSONObject.put("source", (Object)"customer");
            jSONObject.put("step", (Object)"payment_authentication");
            jSONObject.put("reason", (Object)"payment_error");
            if (string2 != null) {
                jSONObject.put("metadata", (Object)new JSONObject(string2));
            }
            return new JSONObject().put("error", (Object)jSONObject).toString();
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            AnalyticsUtil.reportError(jSONException.getMessage(), "S0", jSONException2.getLocalizedMessage());
            return null;
        }
    }

    static String getPaymentCancelledResponse(String string) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("code", (Object)"BAD_REQUEST_ERROR");
            jSONObject.put("description", (Object)"You may have cancelled the payment or there was a delay in response from the UPI app");
            jSONObject.put("source", (Object)"customer");
            jSONObject.put("step", (Object)"payment_authentication");
            jSONObject.put("reason", (Object)"payment_cancelled");
            if (string != null) {
                if (string.startsWith("pay")) {
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("payment_id", (Object)string);
                    jSONObject.put("metadata", (Object)jSONObject2);
                } else {
                    JSONObject jSONObject3 = new JSONObject(string);
                    jSONObject.put("metadata", (Object)jSONObject3);
                }
            }
            return new JSONObject().put("error", (Object)jSONObject).toString();
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            AnalyticsUtil.reportError(jSONException.getMessage(), "S0", jSONException2.getLocalizedMessage());
            return null;
        }
    }

    public static boolean checkGpayCardsUpiRegistered(@Nullable Activity object, @Nullable String string) {
        if (string == null) {
            return isGpayCardsUpiRegistered;
        }
        try {
            object = new JSONObject(string);
            switch (object.getString("code")) {
                case "google_pay": {
                    return isGpayCardsUpiRegistered;
                }
            }
            return false;
        }
        catch (JSONException jSONException) {
            return false;
        }
    }

    static void setIsGpayCardsUpiRegistered(boolean bl) {
        isGpayCardsUpiRegistered = bl;
    }

    static boolean isAppInstalled(Context context, String string) {
        try {
            context = context.getPackageManager();
            if (Build.VERSION.SDK_INT >= 33) {
                context.getPackageInfo(string, PackageManager.PackageInfoFlags.of((long)0L));
            } else {
                context.getPackageInfo(string, 0);
            }
            return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    private static /* synthetic */ String lambda$getBase64FromOtherAppsResource$0(Context object, String string) throws Exception {
        try {
            object = object.getPackageManager();
            ApplicationInfo applicationInfo = Build.VERSION.SDK_INT >= 33 ? object.getApplicationInfo(string, PackageManager.ApplicationInfoFlags.of((long)0L)) : object.getApplicationInfo(string, 128);
            applicationInfo = object.getResourcesForApplication(applicationInfo);
            object = object.getApplicationIcon(string);
            return BaseUtils.getBase64FromDrawable((Resources)applicationInfo, (Drawable)object);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            object = nameNotFoundException;
            AnalyticsUtil.reportError(nameNotFoundException.getMessage(), "S0", "Error loading app icon for " + string + ": " + object.getLocalizedMessage());
            return null;
        }
    }

    static {
        ICON_EXECUTOR = Executors.newCachedThreadPool();
    }

    public static class MyPhoneStateListener
    extends PhoneStateListener {
        public int signalStrengthValue;

        public void onSignalStrengthsChanged(SignalStrength signalStrength) {
            super.onSignalStrengthsChanged(signalStrength);
            if (signalStrength.isGsm()) {
                if (signalStrength.getGsmSignalStrength() != 99) {
                    this.signalStrengthValue = (signalStrength.getGsmSignalStrength() << 1) - 113;
                    return;
                }
                this.signalStrengthValue = signalStrength.getGsmSignalStrength();
                return;
            }
            this.signalStrengthValue = signalStrength.getCdmaDbm();
        }
    }
}

