/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsProperty;
import com.razorpay.BaseUtils;
import com.razorpay.CoreConfig;
import com.razorpay.Lumberjack;
import com.razorpay.RazorpayExceptionHandler;
import com.razorpay.ResourceUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import proguard.annotation.Keep;
import proguard.annotation.KeepClassMembers;

@Keep
@KeepClassMembers
class AnalyticsUtil {
    private static boolean isAnalyticsInitialized = false;
    static CharSequence MERCHANT_APP_NAME;
    static int MERCHANT_APP_BUILD;
    static CharSequence MERCHANT_APP_VERSION;
    static int MERCHANT_APP_TARGET_SDK;
    static CharSequence MERCHANT_APP_NAMESPACE;
    static String FRAMEWORK;
    static String KEY_TYPE;
    static String BUILD_TYPE;
    private static String localPaymentId;
    private static String localOrderId;
    private static String sdkType;
    private static int sdkVersionCode;
    private static String sdkVersion;
    static String libraryType;
    static int sessionErroredApiCalls;

    AnalyticsUtil() {
    }

    static void setup(Context context, String string, String string2, int n, String string3) {
        sdkType = string2;
        sdkVersionCode = n;
        sdkVersion = string3;
        AnalyticsUtil.setAppDetails(context, string);
        AnalyticsUtil.init(context, string);
    }

    private static void init(Context context, String string) {
        if (context == null) {
            throw new RuntimeException("Context not set");
        }
        if (string == null) {
            throw new RuntimeException("Merchant key not set");
        }
        Lumberjack.init(context, sdkType, sdkVersion);
        Lumberjack.addOrderProperty("merchant_key", string);
        Lumberjack.addOrderProperty("merchant_package", context.getPackageName());
        RazorpayExceptionHandler.register(context);
        isAnalyticsInitialized = true;
    }

    static String getBuildType() {
        return BUILD_TYPE;
    }

    static String getKeyType() {
        return KEY_TYPE;
    }

    static void trackEvent(AnalyticsEvent analyticsEvent) {
        analyticsEvent.getEventName();
        Lumberjack.trackEvent(analyticsEvent.getEventName());
    }

    static void postData() {
        if (isAnalyticsInitialized) {
            Lumberjack.postData();
        }
    }

    static void trackEvent(AnalyticsEvent analyticsEvent, Map<String, Object> map) {
        Lumberjack.trackEvent(analyticsEvent.getEventName(), map);
    }

    static void trackEvent(AnalyticsEvent analyticsEvent, JSONObject jSONObject) {
        analyticsEvent.getEventName();
        Lumberjack.trackEvent(analyticsEvent.getEventName(), jSONObject);
    }

    static void addProperty(String string, AnalyticsProperty analyticsProperty) {
        if (analyticsProperty.scope == AnalyticsProperty.Scope.PAYMENT) {
            Lumberjack.addPaymentProperty(string, analyticsProperty.value);
            return;
        }
        if (analyticsProperty.scope == AnalyticsProperty.Scope.ORDER) {
            Lumberjack.addOrderProperty(string, analyticsProperty.value);
        }
    }

    static void addFilteredPropertiesFromPayload(JSONObject jSONObject) {
        Lumberjack.addFilteredPropertiesFromPayload(jSONObject);
    }

    static String getAppDetail() {
        if (isAnalyticsInitialized) {
            return MERCHANT_APP_NAME + "-" + MERCHANT_APP_VERSION + "-" + MERCHANT_APP_BUILD;
        }
        return null;
    }

    static void trackPage(String string, String string2) {
        Lumberjack.trackPage(string, string2);
    }

    static void reportError(String string, String string2, String string3) {
        AnalyticsUtil.trackEvent(AnalyticsEvent.ERROR_LOGGED, AnalyticsUtil.getJSONErrorResponse(string, AnalyticsUtil.getErrorProperties(string2, string3)));
        if ((string2.equalsIgnoreCase("S0") || string2.equalsIgnoreCase("S1")) && sessionErroredApiCalls <= 0) {
            Lumberjack.logVajraCritialError(string2);
            ++sessionErroredApiCalls;
        }
    }

    static void reportError(AbstractMethodError abstractMethodError, String string, String string2) {
        AnalyticsUtil.trackEvent(AnalyticsEvent.ERROR_LOGGED, AnalyticsUtil.getJSONErrorResponse(null, AnalyticsUtil.getErrorProperties(string, string2)));
        if ((string.equalsIgnoreCase("S0") || string.equalsIgnoreCase("S1")) && sessionErroredApiCalls <= 0) {
            Lumberjack.logVajraCritialError(string);
            ++sessionErroredApiCalls;
        }
    }

    static Map<String, Object> getErrorProperties(String string, String string2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("severity", string);
        hashMap.put("unhandled", Boolean.TRUE);
        hashMap.put("source", "self");
        hashMap.put("stack", "");
        hashMap.put("message", string2);
        return hashMap;
    }

    static JSONObject getAnalyticsDataForCheckout(Context object) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("platform", (Object)"mobile_sdk");
            jSONObject.put("platform_version", (Object)sdkVersion);
            jSONObject.put("os", (Object)"android");
            jSONObject.put("os_version", (Object)Build.VERSION.RELEASE);
            if (ResourceUtils.isTablet((Context)object)) {
                jSONObject.put("device", (Object)"tablet");
            } else {
                jSONObject.put("device", (Object)"mobile");
            }
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception.getLocalizedMessage(), "critical", ((Throwable)object).getMessage());
        }
        return jSONObject;
    }

    static void trackPageLoadStart(String string) {
        AnalyticsEvent analyticsEvent = AnalyticsUtil.isCheckoutUrl(string) ? AnalyticsEvent.CHECKOUT_PAGE_LOAD_START : AnalyticsEvent.PAGE_LOAD_START;
        AnalyticsUtil.trackEvent(analyticsEvent, AnalyticsUtil.getJSONResponse(AnalyticsUtil.getPageLoadStartProperties(string)));
    }

    static Map<String, Object> getPageLoadStartProperties(String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("url", string);
        return hashMap;
    }

    static void trackPageLoadEnd(String string, long l) {
        AnalyticsEvent analyticsEvent = AnalyticsUtil.isCheckoutUrl(string) ? AnalyticsEvent.CHECKOUT_PAGE_LOAD_FINISH : AnalyticsEvent.PAGE_LOAD_FINISH;
        AnalyticsUtil.trackEvent(analyticsEvent, AnalyticsUtil.getJSONResponse(AnalyticsUtil.getPageLoadEndProperties(string, l)));
    }

    static boolean isCheckoutUrl(String string) {
        return string.indexOf(CoreConfig.getInstance().getCheckoutEndpoint()) == 0;
    }

    static Map<String, Object> getPageLoadEndProperties(String string, long l) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("url", string);
        hashMap.put("page_load_time", (double)l / 1.0E9);
        return hashMap;
    }

    static void reset() {
        isAnalyticsInitialized = false;
        localPaymentId = null;
        localOrderId = null;
        Lumberjack.destroy();
    }

    static void setAppDetails(Context context, String string) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            MERCHANT_APP_NAME = AnalyticsUtil.returnUndefinedIfNull(packageInfo.applicationInfo.loadLabel(packageManager));
            MERCHANT_APP_VERSION = AnalyticsUtil.returnUndefinedIfNull(packageInfo.versionName);
            MERCHANT_APP_NAMESPACE = AnalyticsUtil.returnUndefinedIfNull(packageInfo.packageName);
            MERCHANT_APP_TARGET_SDK = packageInfo.applicationInfo.targetSdkVersion;
            MERCHANT_APP_BUILD = packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            PackageManager.NameNotFoundException nameNotFoundException2 = nameNotFoundException;
            AnalyticsUtil.reportError(nameNotFoundException.getMessage(), "S0", nameNotFoundException2.getMessage());
        }
        BUILD_TYPE = BaseUtils.getAppBuildType(context);
        KEY_TYPE = AnalyticsUtil.getKeyType(string);
    }

    static String getKeyType(String string) {
        if (AnalyticsUtil.isNullOrEmpty(string) || string.length() < 8) {
            return null;
        }
        if ((string = string.substring(0, 8)).equals("rzp_live")) {
            return "live";
        }
        if (string.equals("rzp_test")) {
            return "test";
        }
        return null;
    }

    static boolean isNullOrEmpty(CharSequence charSequence) {
        int n;
        if (charSequence == null || charSequence.length() == 0) {
            return true;
        }
        int n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) <= ' '; ++n) {
        }
        while (n2 > n && charSequence.charAt(n2 - 1) <= ' ') {
            --n2;
        }
        return n2 - n == 0;
    }

    static CharSequence returnUndefinedIfNull(CharSequence charSequence) {
        if (AnalyticsUtil.isNullOrEmpty(charSequence)) {
            return "undefined";
        }
        return charSequence;
    }

    static String getLocalPaymentId() {
        if (localPaymentId == null) {
            localPaymentId = AnalyticsUtil.getUniqueId();
        }
        return localPaymentId;
    }

    static String getLocalOrderId() {
        if (localOrderId == null) {
            localOrderId = AnalyticsUtil.getUniqueId();
        }
        return localOrderId;
    }

    static void refreshPaymentSession() {
        localPaymentId = AnalyticsUtil.getUniqueId();
        Lumberjack.clearPaymentProperties();
    }

    static void refreshOrderSession() {
        localOrderId = AnalyticsUtil.getUniqueId();
        localPaymentId = AnalyticsUtil.getUniqueId();
        Lumberjack.clearOrderProperties();
        Lumberjack.clearPaymentProperties();
    }

    static void setLocalOrderId(String string) {
        localOrderId = string;
    }

    static String getUniqueId() {
        long l = (System.currentTimeMillis() - 1388534400000L) * 1000000L;
        long l2 = (long)Math.floor(1.4776336E7 * Math.random());
        String string = AnalyticsUtil.tobase62(l) + AnalyticsUtil.tobase62(l2);
        if (string.length() > 14) {
            string = string.substring(0, 14);
        }
        return string;
    }

    static String tobase62(long l) {
        String[] stringArray = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".split("");
        String string = "";
        while (l > 0L) {
            int n = (int)(l % 62L);
            string = String.valueOf(stringArray[n]) + string;
            l = (long)Math.floor(l / 62L);
        }
        return string;
    }

    static void reportUncaughtException(Throwable serializable) {
        String string = AnalyticsUtil.getStackTrace(serializable);
        serializable = new HashMap<String, Object>(AnalyticsUtil.getErrorProperties("S0", serializable.getMessage()));
        ((HashMap)serializable).put((String)"stackTrace", (Object)AnalyticsUtil.sanitizeStackTrace(string));
        AnalyticsUtil.trackEvent(AnalyticsEvent.ERROR_LOGGED, AnalyticsUtil.getJSONResponse((Map<String, Object>)((Object)serializable)));
    }

    static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        throwable.printStackTrace(printWriter);
        return stringWriter.getBuffer().toString();
    }

    static String sanitizeStackTrace(String stringArray) {
        if (AnalyticsUtil.isNullOrEmpty((CharSequence)stringArray)) {
            return "";
        }
        try {
            stringArray = stringArray.split("\n");
            StringBuilder stringBuilder = new StringBuilder();
            int n = Math.min(stringArray.length, 50);
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                if (string.trim().isEmpty()) continue;
                string = string.replaceAll("\\b[a-zA-Z0-9_-]{32,}\\b", "<token>");
                string = string.replaceAll("[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,}", "<email>");
                string = string.replaceAll("\\b\\d{13,19}\\b", "****");
                string = string.replaceAll("\\b\\d{10,12}\\b", "<phone>");
                if ((string = string.replaceAll("\\b\\d{4,}\\b", "****")).length() > 500) {
                    string = string.substring(0, 497) + "...";
                }
                stringBuilder.append(string).append("\n");
                if (stringBuilder.length() <= 5000) continue;
                stringBuilder.append("... (truncated for size)");
                break;
            }
            return stringBuilder.toString().trim();
        }
        catch (Exception exception) {
            return "Stack trace sanitization failed: " + exception.getClass().getSimpleName();
        }
    }

    static void setFramework(String string) {
        FRAMEWORK = string;
    }

    static String getFramework() {
        if (AnalyticsUtil.isNullOrEmpty(FRAMEWORK)) {
            return "native";
        }
        return FRAMEWORK;
    }

    public static void saveEventsToPreferences(Context context) {
        Lumberjack.saveEventsToPreferences(context);
    }

    public static JSONObject getExtraAnalyticsPayload() {
        return Lumberjack.getContextPayload();
    }

    public static JSONObject getJSONResponse(String string) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("response", (Object)string);
            return jSONObject;
        }
        catch (JSONException jSONException) {
            return new JSONObject();
        }
    }

    public static JSONObject getJSONResponse(Map<String, Object> object) {
        JSONObject jSONObject = new JSONObject();
        for (Map.Entry entry : object.entrySet()) {
            try {
                jSONObject.put((String)entry.getKey(), entry.getValue());
            }
            catch (JSONException jSONException) {
                JSONException jSONException2 = jSONException;
                AnalyticsUtil.reportError(jSONException.getLocalizedMessage(), "S0", "Error adding analytics property " + (String)entry.getKey() + " to JSONObject");
            }
        }
        return jSONObject;
    }

    public static JSONObject getJSONErrorResponse(String string, Map<String, Object> map) {
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = new JSONObject();
        try {
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("severity", map.get("severity"));
            jSONObject3.put("unhandled", map.get("unhandled"));
            jSONObject3.put("source", map.get("source"));
            JSONObject jSONObject4 = new JSONObject();
            if (string != null) {
                jSONObject4.put("stack", (Object)string);
            } else {
                jSONObject4.put("stack", (Object)"AbstractMethodError");
            }
            jSONObject4.put("message", map.get("message"));
            jSONObject4.put("tags", (Object)jSONObject3);
            jSONObject2.put("error", (Object)jSONObject4);
            jSONObject.put("data", (Object)jSONObject2);
            return jSONObject;
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            AnalyticsUtil.reportError(jSONException.getLocalizedMessage(), "S0", "Error adding analytics property " + map.get("message") + " to JSONObject");
            return jSONObject;
        }
    }

    static {
        sdkType = "standealone";
        sessionErroredApiCalls = 0;
    }
}

