/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.telephony.SmsMessage;
import com.razorpay.AnalyticsUtil;
import com.razorpay.Logger;
import com.razorpay.SmsAgent;

public class SmsReceiver
extends BroadcastReceiver {
    private SmsAgent smsAgent;

    SmsReceiver() {
        this.smsAgent = null;
    }

    SmsReceiver(SmsAgent smsAgent) {
        this.smsAgent = smsAgent;
    }

    public void onReceive(Context context, Intent intent) {
        Bundle bundle = intent.getExtras();
        try {
            Object[] pdusObj;
            int i;
            if (bundle != null && (i = 0) < (pdusObj = (Object[])bundle.get("pdus")).length) {
                SmsMessage currentMessage = SmsMessage.createFromPdu((byte[])((byte[])pdusObj[i]));
                String sender = currentMessage.getDisplayOriginatingAddress();
                String message = currentMessage.getDisplayMessageBody();
                if (this.smsAgent != null) {
                    this.smsAgent.postSms(sender, message);
                } else {
                    Intent sendIntent = new Intent("com.razorpay.events.SMS_PROCESSED");
                    sendIntent.putExtra("extra_sender", sender);
                    sendIntent.putExtra("extra_message", message);
                    context.sendBroadcast(sendIntent);
                }
                Logger.i("SmsReceiver senderNum: " + sender + "; message: " + message);
                return;
            }
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "critical", e.getMessage());
            Logger.e("SmsReceiver Exception smsReceiver" + e);
        }
    }
}

