/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.content.Context;
import android.os.Bundle;
import com.razorpay.BaseCheckoutActivity;
import com.razorpay.BaseUtils;
import com.razorpay.CheckoutBridge;
import com.razorpay.CheckoutInteractor;
import com.razorpay.Config;
import com.razorpay.OtpElfCheckoutPresenterImpl;
import com.razorpay.PluginCheckoutBridge;
import com.razorpay.PluginCheckoutInteractor;
import com.razorpay.PluginOtpElfCheckoutPresenterImpl;
import com.razorpay.RzpPlugin;
import com.razorpay.RzpPluginCompatibilityResponse;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

abstract class BaseCheckoutOtpelfActivity
extends BaseCheckoutActivity {
    BaseCheckoutOtpelfActivity() {
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        HashMap<String, String> pluginsMap = BaseUtils.getAllPluginsFromManifest((Context)this);
        if (pluginsMap == null || pluginsMap.size() == 0) {
            this.presenter = new OtpElfCheckoutPresenterImpl(this, this);
            this.checkoutBridgeObject = new CheckoutBridge((CheckoutInteractor)((Object)this.presenter), 1);
            super.onCreate(savedInstanceState);
            return;
        }
        this.presenter = new PluginOtpElfCheckoutPresenterImpl(this, this, pluginsMap);
        this.checkoutBridgeObject = new PluginCheckoutBridge((PluginCheckoutInteractor)((Object)this.presenter), 1);
        super.onCreate(savedInstanceState);
        JSONObject object = new JSONObject();
        try {
            object.put("isAmazonPluginIntegrated", false);
            object.put("isGooglePayPluginIntegrated", false);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        for (String className : pluginsMap.values()) {
            try {
                RzpPlugin pluginClass;
                RzpPluginCompatibilityResponse compatibilityResponse;
                if (pluginsMap.size() > 0 && className.equalsIgnoreCase("com.razorpay.RazorpayAmazon")) {
                    object.put("isAmazonPluginIntegrated", true);
                }
                if (pluginsMap.size() > 0 && className.equalsIgnoreCase("com.razorpay.RzpGooglePay")) {
                    object.put("isGooglePayPluginIntegrated", true);
                }
                if (!(compatibilityResponse = (pluginClass = (RzpPlugin)RzpPlugin.class.getClassLoader().loadClass(className).newInstance()).isCompatible(Config.SDK_TYPE, Config.SDK_VERSION_CODE, Config.SDK_VERSION)).isCompatible()) {
                    this.destroy(7, compatibilityResponse.getErrorMessage());
                    return;
                }
                pluginClass.isRegistered((Context)this);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | JSONException e) {
                e.printStackTrace();
            }
        }
    }
}

