/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.app.Activity;
import android.content.Context;
import android.webkit.WebView;
import com.razorpay.CheckoutPresenterImpl;
import com.razorpay.CheckoutUtils;
import com.razorpay.Config;
import com.razorpay.RzpAssist;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class OtpElfCheckoutPresenterImpl
extends CheckoutPresenterImpl {
    private RzpAssist primaryRzpAssist;
    private RzpAssist secondaryRzpAssist;
    private boolean isSecondaryRzpAssistEnabled = true;

    public OtpElfCheckoutPresenterImpl(Activity activity, CheckoutPresenterImpl.CheckoutView view) {
        super(activity, view);
    }

    @Override
    public void setUpAddOn() {
        this.primaryRzpAssist = new RzpAssist(this.merchantKey, this.activity, this.view.getWebView(1), Config.SDK_TYPE, Config.SDK_VERSION_CODE, Config.SDK_VERSION);
        this.primaryRzpAssist.setRzpAssistEnabled(true);
        this.secondaryRzpAssist = new RzpAssist(this.merchantKey, this.activity, this.view.getWebView(2), Config.SDK_TYPE, Config.SDK_VERSION_CODE, Config.SDK_VERSION);
        this.secondaryRzpAssist.setRzpAssistEnabled(true);
        if (this.checkoutOptions.getOtpElfPreferences() != null && this.primaryRzpAssist != null) {
            this.primaryRzpAssist.setOtpElfPreferences(this.checkoutOptions.getOtpElfPreferences());
        }
        super.setUpAddOn();
    }

    @Override
    protected void enableAddon(JSONObject jsonObject) {
        super.enableAddon(jsonObject);
        try {
            if (jsonObject.has("otpelf")) {
                this.isSecondaryRzpAssistEnabled = jsonObject.getBoolean("otpelf");
                if (this.secondaryRzpAssist != null) {
                    this.secondaryRzpAssist.setRzpAssistEnabled(this.isSecondaryRzpAssistEnabled);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onProgressChanges(int webViewType, int progress) {
        switch (webViewType) {
            case 1: {
                if (this.primaryRzpAssist == null) break;
                this.primaryRzpAssist.onProgressChanged(progress);
                break;
            }
            case 2: {
                if (this.secondaryRzpAssist == null || !this.isSecondaryRzpAssistEnabled) break;
                this.secondaryRzpAssist.onProgressChanged(progress);
            }
        }
        super.onProgressChanges(webViewType, progress);
    }

    @Override
    public void onPageStarted(int webViewType, WebView webView, String url) {
        super.onPageStarted(webViewType, webView, url);
        switch (webViewType) {
            case 1: {
                if (this.primaryRzpAssist == null) break;
                this.primaryRzpAssist.onPageStarted(webView, url);
                break;
            }
            case 2: {
                if (this.secondaryRzpAssist != null && this.isSecondaryRzpAssistEnabled) {
                    this.secondaryRzpAssist.onPageStarted(webView, url);
                }
                if (!this.view.isWebViewVisible(2)) break;
                CheckoutUtils.showLoader((Context)this.activity);
            }
        }
    }

    @Override
    public void onPageFinished(int webViewType, WebView webView, String url) {
        super.onPageFinished(webViewType, webView, url);
        switch (webViewType) {
            case 2: {
                if (this.secondaryRzpAssist != null && this.isSecondaryRzpAssistEnabled) {
                    this.secondaryRzpAssist.onPageFinished(webView, url);
                }
                if (!this.view.isWebViewVisible(2)) break;
                CheckoutUtils.dismissLoader();
            }
        }
    }

    @Override
    protected void primaryWebviewPageFinished(String url, WebView webView) {
        super.primaryWebviewPageFinished(url, webView);
        if (this.primaryRzpAssist != null) {
            this.primaryRzpAssist.onPageFinished(webView, url);
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (this.primaryRzpAssist != null) {
            this.primaryRzpAssist.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    @Override
    protected void addOnFlowEnd() {
        if (this.primaryRzpAssist != null) {
            this.primaryRzpAssist.paymentFlowEnd();
        }
        if (this.secondaryRzpAssist != null) {
            this.secondaryRzpAssist.paymentFlowEnd();
        }
        super.addOnFlowEnd();
    }

    @Override
    public void backPressed(Map<String, Object> props) {
        if (this.primaryRzpAssist != null) {
            props.put("current_loading_url_primary_webview", this.primaryRzpAssist.getCurrentLoadingUrl());
            props.put("last_loaded_url_primary_webview", this.primaryRzpAssist.getLastLoadedUrl());
        }
        if (this.secondaryRzpAssist != null) {
            props.put("current_loading_url_secondary_webview", this.secondaryRzpAssist.getCurrentLoadingUrl());
            props.put("last_loaded_url_secondary_webview", this.secondaryRzpAssist.getLastLoadedUrl());
        }
        super.backPressed(props);
    }

    @Override
    public void setPaymentID(String id2) {
        if (this.primaryRzpAssist != null) {
            this.primaryRzpAssist.setPaymentId(id2);
        }
        super.setPaymentID(id2);
    }

    @Override
    protected void addAnalyticsData(JSONObject jsonData) {
        try {
            if (this.primaryRzpAssist != null) {
                this.primaryRzpAssist.setPaymentData(jsonData);
                jsonData.put("razorpay_otp", this.primaryRzpAssist.isRazorpayOtpReceived());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        super.addAnalyticsData(jsonData);
    }

    @Override
    protected void helpersReset() {
        super.helpersReset();
        if (this.primaryRzpAssist != null) {
            this.primaryRzpAssist.reset();
        }
        if (this.secondaryRzpAssist != null && this.isSecondaryRzpAssistEnabled) {
            this.secondaryRzpAssist.reset();
        }
    }
}

