/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.app.Activity;
import android.content.Context;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.razorpay.ConfigDroid;
import com.razorpay.R;

class ResourceUtils {
    ResourceUtils() {
    }

    static int getMagicVersionCode() {
        return ConfigDroid.MAGIC_VERSION_CODE;
    }

    static boolean isTablet(Context context) {
        return context.getResources().getBoolean(R.bool.isTablet);
    }

    static int dpToPx(Context context, int dp) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)displayMetrics);
    }

    static int getStatusBarHeight(Context context) {
        int result = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    static int getViewHeight(Activity activity) {
        DisplayMetrics metrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        return metrics.heightPixels - ResourceUtils.getStatusBarHeight((Context)activity);
    }

    static int getRzpAssistVersionCode() {
        return ConfigDroid.RZP_ASSIST_VERSION_CODE;
    }
}

