/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.text.TextUtils;
import android.util.Log;
import android.view.WindowManager;
import android.webkit.WebView;
import androidx.core.app.ActivityCompat;
import com.google.android.gms.auth.api.phone.SmsRetriever;
import com.google.android.gms.auth.api.phone.SmsRetrieverClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.tasks.Task;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsProperty;
import com.razorpay.AnalyticsUtil;
import com.razorpay.AppSignatureHelper;
import com.razorpay.AutoReadOtpHelper;
import com.razorpay.BaseUtils;
import com.razorpay.Callback;
import com.razorpay.CardSaving;
import com.razorpay.CheckoutBridge;
import com.razorpay.CheckoutInteractor;
import com.razorpay.CheckoutOptions;
import com.razorpay.CheckoutPresenter;
import com.razorpay.CheckoutUtils;
import com.razorpay.Config;
import com.razorpay.Logger;
import com.razorpay.MagicBase;
import com.razorpay.Owl;
import com.razorpay.R;
import com.razorpay.RazorpayExceptionHandler;
import com.razorpay.ResourceUtils;
import com.razorpay.ResponseObject;
import com.razorpay.RzpJSONCallback;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.json.JSONException;
import org.json.JSONObject;

class CheckoutPresenterImpl
implements CheckoutPresenter,
CheckoutInteractor {
    protected Activity activity;
    protected CheckoutView view;
    String merchantKey;
    CheckoutOptions checkoutOptions;
    private String dashOptions;
    private JSONObject dashOptionsJSON;
    private String checkoutUrl;
    private String checkoutBody;
    private String checkoutContent = "{}";
    private int paymentAttempts = 0;
    private boolean clearHistory;
    private boolean isPaymentSuccessful = false;
    private long preloadCompleteDuration;
    private long preloadAbortDuration;
    private long checkoutLoadStartAt;
    private boolean isTwoWebViewFlow = false;
    private boolean isMagic = false;
    private int merchantLogoResourceId = 0;
    private boolean isActivityCreated = false;
    private Task<Void> loginOtpSmsTask;
    private AutoReadOtpHelper autoReadOtpHelper;
    private boolean sendSmsHash = false;
    private boolean allowRotation = false;
    private String payment_id = null;
    private MagicBase magicBase = null;
    private BroadcastReceiver otpAutoReadBroadcast = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if ("com.google.android.gms.auth.api.phone.SMS_RETRIEVED".equals(intent.getAction())) {
                Bundle extras = intent.getExtras();
                Status status = (Status)extras.get("com.google.android.gms.auth.api.phone.EXTRA_STATUS");
                switch (status.getStatusCode()) {
                    case 0: {
                        String message = (String)extras.get("com.google.android.gms.auth.api.phone.EXTRA_SMS_MESSAGE");
                        Intent smsIntent = new Intent();
                        smsIntent.putExtra("com.google.android.gms.auth.api.phone.EXTRA_SMS_MESSAGE", message);
                        CheckoutPresenterImpl.this.onActivityResultReceived(1001, -1, smsIntent);
                        break;
                    }
                    case 15: {
                        AnalyticsUtil.trackEvent(AnalyticsEvent.AUTO_READ_OTP_SMS_RETRIEVER_API_TIMEOUT);
                    }
                }
            }
        }
    };
    Queue<String> checkoutMessageQueue = new LinkedList<String>();
    private boolean isCheckoutLoaded = false;

    public CheckoutPresenterImpl(Activity activity, CheckoutView view) {
        this.activity = activity;
        this.view = view;
    }

    @Override
    public boolean setOptions(Bundle data, boolean activityRestored) {
        this.isActivityCreated = activityRestored;
        if (data == null) {
            this.destroyActivity(0, this.activity.getResources().getString(R.string.activity_result_invalid_parameters));
            return false;
        }
        this.checkoutOptions = new CheckoutOptions(data.getString("OPTIONS"));
        this.merchantKey = this.checkoutOptions.getMerchantKey();
        this.sendSmsHash = this.checkoutOptions.shouldSendHashForSms();
        this.allowRotation = this.checkoutOptions.allowRotation();
        this.merchantLogoResourceId = data.getInt("IMAGE", 0);
        this.checkoutOptions.modifyMerchantOptions(this.activity, this.merchantLogoResourceId);
        this.checkoutBody = data.getString("BODY");
        CheckoutUtils.addAddons((Context)this.activity, this.merchantKey);
        this.checkoutUrl = CheckoutUtils.getCheckoutUrlWithOptions(this.checkoutOptions);
        if (this.checkoutUrl == null) {
            this.destroyActivity(3, this.activity.getResources().getString(R.string.activity_result_invalid_url));
        }
        try {
            this.dashOptionsJSON = new JSONObject(this.dashOptions);
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "critical", e.getLocalizedMessage());
        }
        if (!activityRestored) {
            String frameworkVersion;
            this.checkoutOptions.logMerchantOptions();
            this.dashOptions = CheckoutUtils.getMerchantOptions((Context)this.activity, this.merchantKey);
            String framework = data.getString("FRAMEWORK");
            if (framework != null) {
                AnalyticsUtil.addProperty("framework", new AnalyticsProperty(framework, AnalyticsProperty.Scope.ORDER));
            }
            if ((frameworkVersion = data.getString("FRAMEWORK_VERSION")) != null) {
                AnalyticsUtil.addProperty("frameworkVersion", new AnalyticsProperty(frameworkVersion, AnalyticsProperty.Scope.ORDER));
            }
            if (data.getBoolean("DISABLE_FULL_SCREEN", false)) {
                CheckoutUtils.disableFullScreenMode(this.activity);
            }
            if (data.containsKey("PRELOAD_COMPLETE_DURATION")) {
                this.preloadCompleteDuration = data.getLong("PRELOAD_COMPLETE_DURATION");
            }
            if (data.containsKey("PRELOAD_ABORT_DURATION")) {
                this.preloadAbortDuration = data.getLong("PRELOAD_ABORT_DURATION");
            }
        } else {
            this.dashOptions = data.getString("DASH_OPTIONS");
            if (data.getBoolean("DISABLE_FULL_SCREEN", false)) {
                CheckoutUtils.disableFullScreenMode(this.activity);
            }
        }
        return true;
    }

    @Override
    public void onActivityResultReceived(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1001) {
            if (resultCode == -1) {
                AnalyticsUtil.trackEvent(AnalyticsEvent.AUTO_READ_OTP_SMS_RETRIEVER_API_RECEIVED_SMS);
                String message = data.getStringExtra("com.google.android.gms.auth.api.phone.EXTRA_SMS_MESSAGE");
                if (this.isCheckoutLoaded) {
                    try {
                        JSONObject sms = new JSONObject();
                        sms.put("sender", (Object)"razorpay");
                        sms.put("message", (Object)message);
                        String lastSms = sms.toString();
                        String otpMessage = String.format("javascript: OTPElf.elfBridge.setSms(%s)", lastSms);
                        this.view.loadUrl(1, otpMessage);
                        AnalyticsUtil.trackEvent(AnalyticsEvent.AUTO_READ_OTP_SMS_RETRIEVER_API_OTP_POPULATION_JS);
                    }
                    catch (JSONException e) {
                        AnalyticsUtil.reportError((Exception)((Object)e), "critical", e.getLocalizedMessage());
                        e.printStackTrace();
                    }
                }
            } else {
                AnalyticsUtil.trackEvent(AnalyticsEvent.AUTO_READ_OTP_SMS_RETRIEVER_API_CONSENT_DECLINED);
            }
        } else if (requestCode == 99) {
            JSONObject jsonObject = BaseUtils.getJSONFromIntentData(data);
            String message = String.format("javascript: upiIntentResponse(%s)", jsonObject.toString());
            this.loadResultToWebView(jsonObject, message);
        } else if (requestCode == 20) {
            JSONObject jsonObject = null;
            try {
                jsonObject = new JSONObject("{'data':" + resultCode + "}");
                jsonObject.put("provider", (Object)"CRED");
                String message = String.format("javascript:externalAppResponse(%s)", jsonObject.toString());
                this.loadResultToWebView(jsonObject, message);
            }
            catch (JSONException e) {
                AnalyticsUtil.reportError((Exception)((Object)e), "critical", e.getMessage());
            }
        }
    }

    private void loadResultToWebView(JSONObject jsonObject, String message) {
        HashMap<String, Object> prop = new HashMap<String, Object>();
        prop.put("result", jsonObject);
        AnalyticsUtil.trackEvent(AnalyticsEvent.NATIVE_INTENT_ONACTIVITY_RESULT, prop);
        if (this.isCheckoutLoaded) {
            this.view.loadUrl(1, message);
        } else {
            if (this.checkoutMessageQueue == null) {
                this.checkoutMessageQueue = new LinkedList<String>();
            }
            this.checkoutMessageQueue.add(message);
        }
    }

    @Override
    public void verifyGPaySdkResponse(String response) {
        String str = String.format("javascript: window.externalSDKResponse(%s)", response);
        if (this.isCheckoutLoaded) {
            this.view.loadUrl(1, str);
        } else {
            if (this.checkoutMessageQueue == null) {
                this.checkoutMessageQueue = new LinkedList<String>();
            }
            this.checkoutMessageQueue.add(str);
        }
    }

    @Override
    public CheckoutOptions getCheckoutOptions() {
        return this.checkoutOptions;
    }

    @Override
    public void setUpAddOn() {
        this.magicBase = new MagicBase(this.activity, this.view.getWebView(2));
    }

    @Override
    public void loadForm(String query) {
        if (this.paymentAttempts != 0) {
            AnalyticsUtil.postData();
        }
        ++this.paymentAttempts;
        AnalyticsUtil.addProperty("payment_attempt", new AnalyticsProperty(this.paymentAttempts, AnalyticsProperty.Scope.ORDER));
        this.clearHistory = true;
        String url = this.checkoutUrl + query;
        url = url.replace(" ", "%20");
        if (this.checkoutBody == null || this.checkoutBody.isEmpty()) {
            this.view.loadUrl(1, url);
        } else {
            this.view.loadDataWithBaseURL(1, url, this.checkoutBody, "text/html", "UTF-8", null);
        }
    }

    @Override
    public void passPrefillToSegment() {
        String contact;
        String email = this.checkoutOptions.getPrefilledEmail();
        if (!TextUtils.isEmpty((CharSequence)email)) {
            AnalyticsUtil.addProperty("email", new AnalyticsProperty(email, AnalyticsProperty.Scope.ORDER));
        }
        if (!TextUtils.isEmpty((CharSequence)(contact = this.checkoutOptions.getPrefilledContact()))) {
            AnalyticsUtil.addProperty("contact", new AnalyticsProperty(contact, AnalyticsProperty.Scope.ORDER));
        }
    }

    @Override
    public void handleCardSaving() {
        AnalyticsUtil.trackEvent(AnalyticsEvent.CARD_SAVING_START);
        CardSaving.fetchDeviceTokenFromOtherAppsIfRequired(this.activity.getApplicationContext());
    }

    @Override
    public void saveInstanceState(Bundle data) {
        if (this.merchantLogoResourceId != 0) {
            data.putString("OPTIONS", this.checkoutOptions.getOptionsWithoutImage());
            data.putInt("IMAGE", this.merchantLogoResourceId);
        } else {
            data.putString("OPTIONS", this.checkoutOptions.getAsString());
        }
        data.putString("DASH_OPTIONS", this.dashOptions);
        if (this.activity.getIntent() != null) {
            data.putBoolean("DISABLE_FULL_SCREEN", this.activity.getIntent().getBooleanExtra("DISABLE_FULL_SCREEN", false));
        }
    }

    @Override
    public void setCheckoutLoadStartAt() {
        this.checkoutLoadStartAt = System.nanoTime();
    }

    @Override
    public void destroyActivity(int resultCode, String result) {
        AnalyticsUtil.addProperty("destroy_resultCode", new AnalyticsProperty(String.valueOf(resultCode), AnalyticsProperty.Scope.ORDER));
        AnalyticsUtil.addProperty("destroy_result", new AnalyticsProperty(result, AnalyticsProperty.Scope.ORDER));
        AnalyticsUtil.trackEvent(AnalyticsEvent.INTERNAL_DESTROY_METHOD_CALLED);
        this.view.destroy(resultCode, result);
    }

    @Override
    public void onCheckoutBackPress() {
        AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_SOFT_BACK_PRESSED);
        this.destroyActivity(0, "" + BaseUtils.getPaymentCancelledResponse(this.payment_id));
    }

    protected void enableAddon(JSONObject jsonObject) {
        try {
            if (jsonObject.has("magic")) {
                this.isMagic = jsonObject.getBoolean("magic");
                if (this.magicBase != null) {
                    this.magicBase.setMagicEnabled(this.isMagic);
                }
                AnalyticsUtil.addProperty("is_magic", new AnalyticsProperty(this.isMagic, AnalyticsProperty.Scope.PAYMENT));
            }
        }
        catch (JSONException e) {
            AnalyticsUtil.reportError((Exception)((Object)e), "critical", e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void invokePopup(final String data) {
        this.isTwoWebViewFlow = true;
        try {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        JSONObject jsonObject = new JSONObject(data);
                        CheckoutPresenterImpl.this.enableAddon(jsonObject);
                        if (jsonObject.has("content")) {
                            String content = jsonObject.getString("content");
                            CheckoutPresenterImpl.this.view.loadDataWithBaseURL(2, "about:blank", content, "text/html", "UTF-8", null);
                        }
                        if (jsonObject.has("url")) {
                            String url = jsonObject.getString("url");
                            CheckoutPresenterImpl.this.view.loadUrl(2, url);
                        }
                        if (jsonObject.has("focus") && !jsonObject.getBoolean("focus")) {
                            CheckoutPresenterImpl.this.view.makeWebViewVisible(1);
                        } else {
                            CheckoutPresenterImpl.this.view.makeWebViewVisible(2);
                        }
                    }
                    catch (Exception e) {
                        AnalyticsUtil.reportError(e, "critical", e.getLocalizedMessage());
                        e.printStackTrace();
                    }
                    AnalyticsUtil.addProperty("two_webview_flow", new AnalyticsProperty(true, AnalyticsProperty.Scope.PAYMENT));
                }
            });
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "critical", e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void fetchCondfig() {
        Config.IS_MAGIC_ENABLED = this.isMagicPresent();
        Config.fetchConfig((Context)this.activity, this.merchantKey);
    }

    @Override
    public boolean isMagicPresent() {
        return false;
    }

    @Override
    public void onProgressChanges(int webViewType, int progress) {
        switch (webViewType) {
            case 1: {
                this.view.showProgressBar(progress);
                break;
            }
            case 2: {
                if (this.magicBase == null || !this.isMagic) break;
                this.magicBase.onProgressChanged(progress);
            }
        }
    }

    @Override
    public void onPageStarted(int webViewType, WebView webView, String url) {
        switch (webViewType) {
            case 1: {
                CheckoutUtils.showLoader((Context)this.activity);
                break;
            }
            case 2: {
                if (this.magicBase == null || !this.isMagic) break;
                this.magicBase.onPageStarted(webView, url);
            }
        }
    }

    @Override
    public void onPageFinished(int webViewType, WebView webView, String url) {
        switch (webViewType) {
            case 1: {
                this.primaryWebviewPageFinished(url, webView);
                break;
            }
            case 2: {
                if (this.magicBase == null || !this.isMagic) break;
                this.magicBase.onPageFinished(webView, url);
            }
        }
    }

    private void sendQueuedMessagesToCheckout() {
        if (this.checkoutMessageQueue != null && !this.checkoutMessageQueue.isEmpty()) {
            for (String message : this.checkoutMessageQueue) {
                this.view.loadUrl(1, message);
            }
            this.checkoutMessageQueue.clear();
        }
    }

    protected void primaryWebviewPageFinished(String url, WebView webview) {
        long pageFinishedAt = System.nanoTime();
        CheckoutUtils.dismissLoader();
        this.view.hideProgressBar();
        BaseUtils.getDeviceParamValues((Context)this.activity, new RzpJSONCallback(){

            @Override
            public void onResponse(JSONObject response) {
                CheckoutPresenterImpl.this.view.loadUrl(1, String.format("javascript: window.getDeviceDetails(%s)", response.toString()));
            }
        });
        if (url.indexOf(this.checkoutUrl) == 0) {
            if (this.paymentAttempts == 1) {
                this.isCheckoutLoaded = true;
                this.sendQueuedMessagesToCheckout();
                HashMap<String, Object> props = new HashMap<String, Object>();
                long checkoutLoadDuration = pageFinishedAt - this.checkoutLoadStartAt;
                props.put("checkout_load_duration", checkoutLoadDuration);
                Logger.d("Checkout loaded in " + BaseUtils.nanoTimeToSecondsString(checkoutLoadDuration, 2) + " sec.");
                if (this.preloadCompleteDuration > 0L) {
                    props.put("preload_finish_duration", this.preloadCompleteDuration);
                    Logger.d("Preload was completed in " + BaseUtils.nanoTimeToSecondsString(this.preloadCompleteDuration, 2) + " sec.");
                } else if (this.preloadAbortDuration > 0L) {
                    props.put("preload_abort_duration", this.preloadAbortDuration);
                    Logger.d("Preload was aborted in " + BaseUtils.nanoTimeToSecondsString(this.preloadAbortDuration, 2) + " sec.");
                }
                long loadTimeShaved = this.preloadCompleteDuration - checkoutLoadDuration;
                if (loadTimeShaved > 0L) {
                    props.put("time_shaved_off", loadTimeShaved);
                    Logger.d("Load time shaved is " + BaseUtils.nanoTimeToSecondsString(loadTimeShaved, 2) + " sec.");
                }
                AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_LOADED, props);
            }
            if (this.clearHistory) {
                this.view.clearWebViewHistory(1);
                this.clearHistory = false;
            }
        }
    }

    @Override
    public String getProgressBarColor() {
        String color = null;
        try {
            if (this.checkoutOptions.getAsJson() == null) {
                throw new Exception("No options defined");
            }
            JSONObject optionsJson = this.checkoutOptions.getAsJson();
            JSONObject theme = optionsJson.getJSONObject("theme");
            color = theme.getString("color");
            Color.parseColor((String)color);
        }
        catch (Exception e) {
            try {
                if (this.dashOptionsJSON == null) {
                    throw new Exception("No dash options defined");
                }
                JSONObject theme = this.dashOptionsJSON.getJSONObject("theme");
                color = theme.getString("color");
                Color.parseColor((String)color);
            }
            catch (Exception e2) {
                AnalyticsUtil.reportError(e2, "error", e2.getMessage());
            }
            AnalyticsUtil.reportError(e, "error", e.getMessage());
        }
        return color;
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
    }

    @Override
    public void sendOtpPermissionCallback(final boolean granted) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("granted", granted);
                    CheckoutPresenterImpl.this.view.loadUrl(1, String.format("javascript: otpPermissionCallback(%s)", jsonObject.toString()));
                }
                catch (Exception e) {
                    AnalyticsUtil.reportError(e, "warning", e.getLocalizedMessage());
                }
            }
        });
    }

    protected void addOnFlowEnd() {
        if (this.magicBase != null) {
            this.magicBase.paymentFlowEnd();
        }
    }

    @Override
    public void cleanUpOnDestroy() {
        this.markPaymentCancelled();
        this.addOnFlowEnd();
        RazorpayExceptionHandler.unregister();
    }

    private void markPaymentCancelled() {
        if (this.payment_id == null || this.isPaymentSuccessful) {
            return;
        }
        try {
            String auth = BaseUtils.constructBasicAuth(this.merchantKey);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Basic " + auth);
            String url = "https://api.razorpay.com/v1/payments/" + this.payment_id + "/cancel?platform=android_sdk";
            Logger.d("Sending cancel request");
            Owl.get(url, headers, new Callback(){

                @Override
                public void run(ResponseObject response) {
                    Logger.d("API Cancel hit: " + response.getResponseResult());
                }
            });
            this.payment_id = null;
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "critical", e.getLocalizedMessage());
            Logger.d("Exception in cancel req", e);
        }
    }

    @Override
    public void backPressed(final Map<String, Object> props) {
        AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_HARD_BACK_PRESSED, props);
        if (CheckoutUtils.isCheckoutUrl(this.view.getWebView(1)) && !this.view.isWebViewVisible(2)) {
            this.view.loadUrl(1, "javascript: window.backPressed ? window.backPressed('onCheckoutBackPress') : CheckoutBridge.onCheckoutBackPress();");
            props.put("in_checkout", "true");
        } else if (!Config.getInstance().isBackButtonAlertEnabled()) {
            this.destroyActivity(0, "BackPressed");
        } else {
            CheckoutUtils.showDialog((Context)this.activity, Config.getInstance().getBackButtonAlertMessage(), Config.getInstance().getBackButtonPositiveText(), Config.getInstance().getBackButtonNegativeText(), new CheckoutUtils.BackButtonDialogCallback(){

                @Override
                public void onPositiveButtonClick() {
                    Logger.d("ALERT Don't cancel");
                    AnalyticsUtil.trackEvent(AnalyticsEvent.ALERT_PAYMENT_CONTINUE, props);
                }

                @Override
                public void onNegativeButtonClick() {
                    Logger.d("ALERT Cancel");
                    AnalyticsUtil.trackEvent(AnalyticsEvent.ALERT_PAYMENT_CANCELLED, props);
                    if (CheckoutPresenterImpl.this.isTwoWebViewFlow) {
                        CheckoutPresenterImpl.this.view.makeWebViewVisible(1);
                        CheckoutPresenterImpl.this.view.loadUrl(2, "about:blank");
                        CheckoutPresenterImpl.this.view.loadUrl(1, "javascript: window.onpaymentcancel()");
                    } else {
                        CheckoutPresenterImpl.this.handleRetry("");
                        CheckoutPresenterImpl.this.markPaymentCancelled();
                    }
                    CheckoutPresenterImpl.this.isTwoWebViewFlow = false;
                }
            });
        }
    }

    @Override
    public void onLoad() {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (CheckoutPresenterImpl.this.checkoutBody == null || CheckoutPresenterImpl.this.checkoutBody.isEmpty()) {
                    CheckoutPresenterImpl.this.view.loadUrl(1, "javascript: CheckoutBridge.setCheckoutBody(document.documentElement.outerHTML)");
                }
                CheckoutPresenterImpl.this.view.loadUrl(1, CheckoutPresenterImpl.this.getHandleMessageFormattedString());
                CheckoutPresenterImpl.this.view.loadUrl(1, String.format("javascript: CheckoutBridge.sendAnalyticsData({data: %s})", AnalyticsUtil.getAnalyticsDataForCheckout((Context)CheckoutPresenterImpl.this.activity).toString()));
            }
        });
        if (Build.VERSION.SDK_INT >= 29 || ActivityCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.RECEIVE_SMS") != 0) {
            if (this.sendSmsHash) {
                SmsRetrieverClient smsRetrieverClient = SmsRetriever.getClient((Activity)this.activity);
                this.loginOtpSmsTask = smsRetrieverClient.startSmsRetriever();
                try {
                    new CountDownTimer(2000L, 1000L){

                        public void onTick(long millisUntilFinished) {
                        }

                        public void onFinish() {
                            try {
                                if (CheckoutPresenterImpl.this.loginOtpSmsTask.isSuccessful()) {
                                    IntentFilter intentFilter = new IntentFilter("com.google.android.gms.auth.api.phone.SMS_RETRIEVED");
                                    CheckoutPresenterImpl.this.activity.registerReceiver(CheckoutPresenterImpl.this.otpAutoReadBroadcast, intentFilter, "com.google.android.gms.auth.api.phone.permission.SEND", null);
                                } else {
                                    CheckoutPresenterImpl.this.startSmsRetrieverForSavedCardsOTP();
                                }
                            }
                            catch (Exception e) {
                                AnalyticsUtil.reportError(e, "error", e.getMessage());
                                CheckoutPresenterImpl.this.startSmsRetrieverForSavedCardsOTP();
                            }
                            catch (AbstractMethodError eab) {
                                AnalyticsUtil.reportError(eab, "error", eab.getMessage());
                                CheckoutPresenterImpl.this.startSmsRetrieverForSavedCardsOTP();
                            }
                        }
                    }.start();
                }
                catch (Exception e) {
                    AnalyticsUtil.reportError(e, "error", e.getMessage());
                    this.startSmsRetrieverForSavedCardsOTP();
                }
            } else {
                this.startSmsRetrieverForSavedCardsOTP();
            }
        }
    }

    private void startSmsRetrieverForSavedCardsOTP() {
        this.loginOtpSmsTask = SmsRetriever.getClient((Activity)this.activity).startSmsUserConsent(null);
        this.autoReadOtpHelper = new AutoReadOtpHelper(this.activity);
        IntentFilter intentFilter = new IntentFilter("com.google.android.gms.auth.api.phone.SMS_RETRIEVED");
        this.activity.registerReceiver((BroadcastReceiver)this.autoReadOtpHelper, intentFilter);
    }

    protected JSONObject getOptionsForHandleMessage() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("options", (Object)this.checkoutOptions.getAsJson());
            jsonObject.put("data", (Object)this.checkoutContent);
            jsonObject.put("id", (Object)AnalyticsUtil.getLocalOrderId());
            jsonObject.put("key_id", (Object)this.merchantKey);
            jsonObject.put("externalSDKs", (Object)new JSONObject());
            if (this.checkoutOptions.shouldSendHashForSms()) {
                AppSignatureHelper appSignatureHelper = new AppSignatureHelper((Context)this.activity);
                jsonObject.put("sms_hash", (Object)appSignatureHelper.getAppSignatures().get(0));
            }
            jsonObject.put("upi_intents_data", (Object)CheckoutUtils.getUpiIntentsDataInJsonArray((Context)this.activity));
            jsonObject.put("uri_data", (Object)CheckoutUtils.getAppIntentDataInJsonArray((Context)this.activity));
            JSONObject metaDataObj = new JSONObject();
            metaDataObj.put("openedAt", System.currentTimeMillis());
            jsonObject.put("metadata", (Object)metaDataObj);
            String deviceToken = CardSaving.getDeviceToken(this.activity.getApplicationContext());
            if (!TextUtils.isEmpty((CharSequence)deviceToken)) {
                jsonObject.put("device_token", (Object)deviceToken);
            }
            jsonObject.put("sdk_popup", true);
            jsonObject.put("magic", true);
            jsonObject.put("network_type", BaseUtils.getNetworkType((Context)this.activity));
            jsonObject.put("activity_recreated", this.isActivityCreated);
        }
        catch (JSONException e) {
            AnalyticsUtil.reportError((Exception)((Object)e), "warning", e.getLocalizedMessage());
        }
        return jsonObject;
    }

    private String getHandleMessageFormattedString() {
        return String.format("javascript: handleMessage(%s)", this.getOptionsForHandleMessage().toString());
    }

    @Override
    public void setAppToken(String appToken) {
        CardSaving.setAppToken((Context)this.activity, appToken);
    }

    @Override
    public void setDeviceToken(String deviceToken) {
        CardSaving.setDeviceToken((Context)this.activity, deviceToken);
    }

    @Override
    public void callNativeIntent(String url, String packageName) {
        BaseUtils.startActivityForResult(url, packageName, this.activity);
        HashMap<String, Object> prop = new HashMap<String, Object>();
        prop.put("url", url == null ? "null" : url);
        prop.put("package_name", packageName == null ? "null" : packageName);
        AnalyticsUtil.trackEvent(AnalyticsEvent.NATIVE_INTENT_CALLED, prop);
    }

    @Override
    public void setPaymentID(String id2) {
        Logger.d("setPaymentID called: " + id2);
        this.payment_id = id2;
        AnalyticsUtil.addProperty("payment_id", new AnalyticsProperty(id2, AnalyticsProperty.Scope.PAYMENT));
        AnalyticsUtil.trackEvent(AnalyticsEvent.PAYMENT_ID_ATTACHED);
    }

    @Override
    public void setCheckoutBody(String body) {
        this.checkoutBody = body;
    }

    @Override
    public void setMerchantOptions(String dashOptions) {
        this.dashOptions = dashOptions;
        try {
            this.dashOptionsJSON = new JSONObject(dashOptions);
        }
        catch (Exception e) {
            Logger.e("Error parsing merchant dash options JSON", e);
            this.dashOptionsJSON = null;
            AnalyticsUtil.reportError(e, "critical", e.getMessage());
        }
        if (this.dashOptionsJSON == null) {
            CheckoutUtils.setMerchantOptions((Context)this.activity, this.merchantKey, null);
        } else {
            CheckoutUtils.setMerchantOptions((Context)this.activity, this.merchantKey, dashOptions);
        }
    }

    protected void addAnalyticsData(JSONObject jsonData) {
        AnalyticsUtil.addFilteredPropertiesFromPayload(jsonData);
    }

    @Override
    public void onSubmit(String data) {
        if (this.paymentAttempts > 1) {
            AnalyticsUtil.refreshPaymentSession();
        }
        if (this.autoReadOtpHelper != null && this.loginOtpSmsTask.isComplete()) {
            try {
                this.activity.unregisterReceiver((BroadcastReceiver)this.autoReadOtpHelper);
            }
            catch (IllegalArgumentException e) {
                AnalyticsUtil.reportError(e, "error", e.getMessage());
            }
        }
        try {
            String wallet;
            JSONObject jsonData = new JSONObject(data);
            this.checkoutContent = data;
            this.addAnalyticsData(jsonData);
            this.savePrefillData(jsonData);
            String method = jsonData.getString("method");
            if (Build.VERSION.SDK_INT >= 29 || ActivityCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.RECEIVE_SMS") != 0) {
                if (method.equalsIgnoreCase("netbanking") || method.equalsIgnoreCase("card")) {
                    Log.d((String)"SMS", (String)"received method as netbanking");
                    Task smsTask = SmsRetriever.getClient((Activity)this.activity).startSmsUserConsent(null);
                    Log.d((String)"SMS", (String)"task started successfully");
                    AutoReadOtpHelper autoReadOtpHelper = new AutoReadOtpHelper(this.activity);
                    IntentFilter intentFilter = new IntentFilter("com.google.android.gms.auth.api.phone.SMS_RETRIEVED");
                    this.activity.registerReceiver((BroadcastReceiver)autoReadOtpHelper, intentFilter);
                    AnalyticsUtil.trackEvent(AnalyticsEvent.AUTO_READ_OTP_SMS_RETRIEVER_API_TASK);
                }
            } else if (!method.equals("card") && method.equals("wallet") && this.checkoutOptions.hasExternalWallet(wallet = jsonData.getString("wallet"))) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("external_wallet", (Object)wallet);
                AnalyticsUtil.addProperty("external_wallet", new AnalyticsProperty(wallet, AnalyticsProperty.Scope.ORDER));
                AnalyticsUtil.trackEvent(AnalyticsEvent.EXTERNAL_WALLET_SELECTED);
                this.onComplete(jsonObject);
            }
            AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_SUBMIT);
            AnalyticsUtil.postData();
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "critical", e.getMessage());
            Logger.e("Error in submit", e);
        }
    }

    protected void onComplete(JSONObject o) {
        try {
            if (o.has("error")) {
                AnalyticsUtil.addProperty("payment_status", new AnalyticsProperty("fail", AnalyticsProperty.Scope.PAYMENT));
                AnalyticsUtil.addProperty("payload", new AnalyticsProperty(o.toString(), AnalyticsProperty.Scope.PAYMENT));
                AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_PAYMENT_COMPLETE);
                if (this.isTwoWebViewFlow) {
                    this.view.makeWebViewVisible(1);
                }
                this.onError(o);
            } else if (o.has("razorpay_fund_account_id")) {
                this.destroyActivity(1, o.toString());
            } else if (o.has("razorpay_payment_id")) {
                String payment_id;
                this.payment_id = payment_id = o.getString("razorpay_payment_id");
                AnalyticsUtil.addProperty("payment_id", new AnalyticsProperty(payment_id, AnalyticsProperty.Scope.PAYMENT));
                AnalyticsUtil.addProperty("payment_status", new AnalyticsProperty("success", AnalyticsProperty.Scope.PAYMENT));
                AnalyticsUtil.addProperty("payload", new AnalyticsProperty(o.toString(), AnalyticsProperty.Scope.PAYMENT));
                AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_PAYMENT_COMPLETE);
                this.isPaymentSuccessful = true;
                this.destroyActivity(1, o.toString());
            } else if (o.has("external_wallet")) {
                this.destroyActivity(4, o.toString());
            } else {
                this.destroyActivity(0, "Post payment parsing error");
            }
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "critical", e.getMessage());
            this.destroyActivity(0, e.getMessage());
        }
        this.isTwoWebViewFlow = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onError(JSONObject o) {
        String errorParam;
        if (this.isTwoWebViewFlow) {
            String str = String.format("javascript: window.onComplete(%s)", o.toString());
            this.view.loadUrl(1, str);
            return;
        }
        String qp = "";
        try {
            if (o.has("error")) {
                qp = qp + (this.checkoutUrl.contains("?") ? "&" : "?");
                if (o.get("error") instanceof JSONObject) {
                    JSONObject error = (JSONObject)o.get("error");
                    qp = qp + "error=" + error.toString();
                }
            }
            errorParam = qp;
        }
        catch (Exception e) {
            String errorParam2;
            try {
                AnalyticsUtil.reportError(e, "critical", e.getMessage());
                errorParam2 = qp;
            }
            catch (Throwable throwable) {
                String errorParam22 = qp;
                this.activity.runOnUiThread(new Runnable(errorParam22){
                    final /* synthetic */ String val$errorParam;
                    {
                        this.val$errorParam = string2;
                    }

                    @Override
                    public void run() {
                        CheckoutPresenterImpl.this.handleRetry(this.val$errorParam);
                    }
                });
                throw throwable;
            }
            this.activity.runOnUiThread(new /* invalid duplicate definition of identical inner class */);
            return;
        }
        this.activity.runOnUiThread(new /* invalid duplicate definition of identical inner class */);
        return;
    }

    private void handleRetry(String errorParam) {
        if (CheckoutUtils.shouldRetryPayment(this.paymentAttempts)) {
            this.helpersReset();
            this.loadForm(errorParam);
        } else {
            this.destroyActivity(0, errorParam);
        }
    }

    protected void helpersReset() {
        Logger.d("helpersReset called");
    }

    private void savePrefillData(JSONObject jsonData) {
        try {
            if (jsonData.has("contact")) {
                CheckoutUtils.setUserContact((Context)this.activity, jsonData.getString("contact"));
                this.checkoutOptions.putPrefill("contact", jsonData.getString("contact"));
            }
            if (jsonData.has("email")) {
                CheckoutUtils.setUserEmail((Context)this.activity, jsonData.getString("email"));
                this.checkoutOptions.putPrefill("email", jsonData.getString("email"));
            }
        }
        catch (JSONException e) {
            Logger.e("Error parsing JSON", e);
        }
    }

    @Override
    public void onFault(String response) {
        this.destroyActivity(3, response);
    }

    @Override
    public void onComplete(String response) {
        final String resp = response;
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    JSONObject o = new JSONObject(resp);
                    Logger.d("oncomplete JavascriptInterface");
                    CheckoutPresenterImpl.this.onComplete(o);
                }
                catch (Exception e) {
                    AnalyticsUtil.reportError(e, "critical", e.getMessage());
                    CheckoutPresenterImpl.this.destroyActivity(0, e.getMessage());
                }
            }
        });
    }

    @Override
    public void setDimensions(final int width, final int height) {
        if (ResourceUtils.isTablet((Context)this.activity)) {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    WindowManager.LayoutParams params = CheckoutPresenterImpl.this.activity.getWindow().getAttributes();
                    Logger.d("SetDimensions called");
                    Logger.d("Height:" + height);
                    Logger.d("Width:" + width);
                    params.height = ResourceUtils.dpToPx((Context)CheckoutPresenterImpl.this.activity, height);
                    params.width = ResourceUtils.dpToPx((Context)CheckoutPresenterImpl.this.activity, width);
                    CheckoutPresenterImpl.this.activity.getWindow().setAttributes(params);
                }
            });
        }
    }

    @Override
    public void onDismiss() {
        this.destroyActivity(0, BaseUtils.getPaymentCancelledResponse(this.payment_id));
    }

    @Override
    public void onDismiss(String response) {
        this.destroyActivity(0, response);
    }

    @Override
    public void requestExtraAnalyticsData() {
        final JSONObject jsonObject = AnalyticsUtil.getExtraAnalyticsPayload();
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    CheckoutPresenterImpl.this.view.loadUrl(1, String.format("javascript: CheckoutBridge.sendExtraAnalyticsData(%s)", jsonObject.toString()));
                }
                catch (Exception e) {
                    AnalyticsUtil.reportError(e, "warning", e.getLocalizedMessage());
                }
            }
        });
    }

    @Override
    public void onError(String message) {
        try {
            this.onError(new JSONObject(message));
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "critical", e.getMessage());
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    CheckoutPresenterImpl.this.helpersReset();
                    CheckoutPresenterImpl.this.loadForm("");
                }
            });
        }
    }

    @Override
    public void relay(String data) {
    }

    @Override
    public void requestOtpPermission() {
    }

    @Override
    public void toast(final String message, final int duration) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                CheckoutPresenterImpl.this.view.showToast(message, duration);
            }
        });
    }

    @Override
    public void showAlertDialog(final String message, final String negativeButtonText, final String positiveButtonText) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                CheckoutUtils.showDialog((Context)CheckoutPresenterImpl.this.activity, message, positiveButtonText, negativeButtonText, new CheckoutUtils.BackButtonDialogCallback(){

                    @Override
                    public void onPositiveButtonClick() {
                        CheckoutPresenterImpl.this.view.loadUrl(1, String.format("javascript: CheckoutBridge.isPositiveButtonClicked({isClicked: %s})", true));
                    }

                    @Override
                    public void onNegativeButtonClick() {
                        CheckoutPresenterImpl.this.view.loadUrl(1, String.format("javascript: CheckoutBridge.isPositiveButtonClicked({isClicked: %s})", false));
                    }
                });
            }
        });
    }

    @Override
    public void sendDataToWebView(final int webViewType, final String data) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                switch (webViewType) {
                    case 1: {
                        CheckoutPresenterImpl.this.view.loadUrl(1, String.format("javascript: handleRelay(%s)", data));
                        break;
                    }
                    case 2: {
                        String url = String.format("javascript: Magic.handleRelay(%s)", data);
                        CheckoutPresenterImpl.this.view.loadUrl(2, url);
                    }
                }
            }
        });
    }

    @Override
    public void checkSmsPermission() {
        this.view.checkSmsPermission();
    }

    @Override
    public void isWebViewSafeOnUI(final int webViewType, final CheckoutBridge.WebViewSafeCheckCallback callback) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                CheckoutPresenterImpl.this.executeWebViewCallback(webViewType, callback);
            }
        });
    }

    private void executeWebViewCallback(int webViewType, CheckoutBridge.WebViewSafeCheckCallback callback) {
        WebView webView = webViewType == 1 ? this.view.getWebView(1) : this.view.getWebView(2);
        String url = webView.getTag().toString();
        try {
            URL urlObject = new URL(url);
            String host = urlObject.getHost();
            if (host != null && host.endsWith("razorpay.com")) {
                callback.secure();
            } else {
                callback.unSecure();
            }
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "critical", e.getLocalizedMessage());
            callback.unSecure();
        }
    }

    @Override
    public void isWebViewSafe(int webViewType, CheckoutBridge.WebViewSafeCheckCallback callback) {
        this.executeWebViewCallback(webViewType, callback);
    }

    @Override
    public boolean isUserRegisteredOnUPI(String packageName) {
        return BaseUtils.checkUpiRegisteredApp((Context)this.activity, packageName);
    }

    @Override
    public boolean isAllowRotation() {
        return this.allowRotation;
    }

    static interface CheckoutView {
        public void loadUrl(int var1, String var2);

        public void loadData(int var1, String var2, String var3, String var4);

        public void loadDataWithBaseURL(int var1, String var2, String var3, String var4, String var5, String var6);

        public void makeWebViewVisible(int var1);

        public boolean isWebViewVisible(int var1);

        public void showToast(String var1, int var2);

        public void destroy(int var1, String var2);

        public void showProgressBar(int var1);

        public void hideProgressBar();

        public void clearWebViewHistory(int var1);

        public WebView getWebView(int var1);

        public void checkSmsPermission();

        public void addJavascriptInterfaceToPrimaryWebview(Object var1, String var2);
    }
}

