/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsProperty;
import com.razorpay.AnalyticsProperty$Q_$2$;
import com.razorpay.B$$J$;
import com.razorpay.BaseUtils;
import com.razorpay.O__Y_;
import com.razorpay.R;
import com.razorpay.l__d$;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;
import proguard.annotation.Keep;
import proguard.annotation.KeepClassMembers;

@Keep
@KeepClassMembers
public class AnalyticsUtil {
    private static boolean isAnalyticsInitialized = false;
    public static CharSequence MERCHANT_APP_NAME;
    public static int MERCHANT_APP_BUILD;
    public static CharSequence MERCHANT_APP_VERSION;
    static CharSequence MERCHANT_APP_NAMESPACE;
    static String KEY_TYPE;
    static String BUILD_TYPE;
    private static String localPaymentId;
    private static String localOrderId;
    private static String sdkType;
    private static int sdkVersionCode;
    private static String sdkVersion;

    AnalyticsUtil() {
    }

    static void setup(Context context, String string, String string2, int n, String string3) {
        sdkType = string2;
        sdkVersionCode = n;
        sdkVersion = string3;
        AnalyticsUtil.setAppDetails(context, string);
        AnalyticsUtil.init(context, string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void init(Context context, String object) {
        if (context == null) {
            throw new RuntimeException("Context not set");
        }
        if (object == null) {
            throw new RuntimeException("Merchant key not set");
        }
        try {
            Object[] objectArray = new Object[3];
            objectArray[2] = sdkVersion;
            objectArray[1] = sdkType;
            objectArray[0] = context;
            ((Class)O__Y_.a_$P$(0, 18, '\u0000')).getDeclaredMethod("R$$r_", Context.class, String.class, String.class).invoke(null, objectArray);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable.getCause();
            if (throwable2 != null) {
                throw throwable2;
            }
            throw throwable;
        }
        try {
            Object[] objectArray = new Object[2];
            objectArray[1] = object;
            objectArray[0] = "merchant_key";
            ((Class)O__Y_.a_$P$(0, 18, '\u0000')).getDeclaredMethod("R$$r_", String.class, Object.class).invoke(null, objectArray);
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable.getCause();
            if (throwable3 != null) {
                throw throwable3;
            }
            throw throwable;
        }
        try {
            Object[] objectArray = new Object[2];
            objectArray[1] = context.getPackageName();
            objectArray[0] = "merchant_package";
            ((Class)O__Y_.a_$P$(0, 18, '\u0000')).getMethod("R$$r_", String.class, Object.class).invoke(null, objectArray);
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable.getCause();
            if (throwable4 != null) {
                throw throwable4;
            }
            throw throwable;
        }
        object = Thread.getDefaultUncaughtExceptionHandler();
        if (!(object instanceof B$$J$)) {
            Thread.setDefaultUncaughtExceptionHandler(new B$$J$(context, (Thread.UncaughtExceptionHandler)object));
        }
        isAnalyticsInitialized = true;
    }

    static String getBuildType() {
        return BUILD_TYPE;
    }

    public static String getKeyType() {
        return KEY_TYPE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void trackEvent(AnalyticsEvent analyticsEvent) {
        try {
            ((Class)O__Y_.a_$P$(0, 18, '\u0000')).getDeclaredMethod("G__G_", String.class).invoke(null, analyticsEvent.getEventName());
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable.getCause();
            if (throwable2 != null) {
                throw throwable2;
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void postData() {
        if (!isAnalyticsInitialized) return;
        try {
            ((Class)O__Y_.a_$P$(0, 18, '\u0000')).getDeclaredMethod("R$$r_", null).invoke(null, null);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable.getCause();
            if (throwable2 == null) throw throwable;
            throw throwable2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void trackEvent(AnalyticsEvent analyticsEvent, Map<String, Object> map) {
        try {
            Object[] objectArray = new Object[2];
            objectArray[1] = map;
            objectArray[0] = analyticsEvent.getEventName();
            ((Class)O__Y_.a_$P$(0, 18, '\u0000')).getDeclaredMethod("G__G_", String.class, Map.class).invoke(null, objectArray);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable.getCause();
            if (throwable2 != null) {
                throw throwable2;
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void trackEvent(AnalyticsEvent analyticsEvent, JSONObject jSONObject) {
        try {
            Object[] objectArray = new Object[2];
            objectArray[1] = jSONObject;
            objectArray[0] = analyticsEvent.getEventName();
            ((Class)O__Y_.a_$P$(0, 18, '\u0000')).getDeclaredMethod("a_$P$", String.class, JSONObject.class).invoke(null, objectArray);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable.getCause();
            if (throwable2 != null) {
                throw throwable2;
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void addProperty(String string, AnalyticsProperty analyticsProperty) {
        if (analyticsProperty.scope == AnalyticsProperty$Q_$2$.G__G_) {
            try {
                Object[] objectArray = new Object[2];
                objectArray[1] = analyticsProperty.value;
                objectArray[0] = string;
                ((Class)O__Y_.a_$P$(0, 18, '\u0000')).getDeclaredMethod("d__1_", String.class, Object.class).invoke(null, objectArray);
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable.getCause();
                if (throwable2 == null) throw throwable;
                throw throwable2;
            }
        }
        if (analyticsProperty.scope != AnalyticsProperty$Q_$2$.d__1_) return;
        try {
            Object[] objectArray = new Object[2];
            objectArray[1] = analyticsProperty.value;
            objectArray[0] = string;
            ((Class)O__Y_.a_$P$(0, 18, '\u0000')).getMethod("R$$r_", String.class, Object.class).invoke(null, objectArray);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable.getCause();
            if (throwable3 == null) throw throwable;
            throw throwable3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void addFilteredPropertiesFromPayload(JSONObject jSONObject) {
        try {
            ((Class)O__Y_.a_$P$(0, 18, '\u0000')).getDeclaredMethod("d__1_", JSONObject.class).invoke(null, jSONObject);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable.getCause();
            if (throwable2 != null) {
                throw throwable2;
            }
            throw throwable;
        }
    }

    static String getAppDetail() {
        if (isAnalyticsInitialized) {
            return MERCHANT_APP_NAME + "-" + MERCHANT_APP_VERSION + "-" + MERCHANT_APP_BUILD;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void trackPage(String string, String string2) {
        try {
            Object[] objectArray = new Object[2];
            objectArray[1] = string2;
            objectArray[0] = string;
            ((Class)O__Y_.a_$P$(0, 18, '\u0000')).getDeclaredMethod("d__1_", String.class, String.class).invoke(null, objectArray);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable.getCause();
            if (throwable2 != null) {
                throw throwable2;
            }
            throw throwable;
        }
    }

    public static void reportError(Exception exception, String string, String string2) {
        AnalyticsUtil.trackEvent(AnalyticsEvent.ERROR_LOGGED, AnalyticsUtil.getErrorProperties(string, string2));
        exception.printStackTrace();
    }

    static void reportError(AbstractMethodError abstractMethodError, String string, String string2) {
        AnalyticsUtil.trackEvent(AnalyticsEvent.ERROR_LOGGED, AnalyticsUtil.getErrorProperties(string, string2));
        abstractMethodError.printStackTrace();
    }

    static Map<String, Object> getErrorProperties(String string, String string2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("error_level", string);
        hashMap.put("error_message", string2);
        return hashMap;
    }

    static JSONObject getAnalyticsDataForCheckout(Context object) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("platform", (Object)"mobile_sdk");
            jSONObject.put("platform_version", (Object)sdkVersion);
            jSONObject.put("os", (Object)"android");
            jSONObject.put("os_version", (Object)Build.VERSION.RELEASE);
            if (object.getResources().getBoolean(R.bool.isTablet)) {
                jSONObject.put("device", (Object)"tablet");
            } else {
                jSONObject.put("device", (Object)"mobile");
            }
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception, "critical", ((Throwable)object).getMessage());
        }
        return jSONObject;
    }

    static void trackPageLoadStart(String string) {
        AnalyticsUtil.trackEvent(AnalyticsUtil.isCheckoutUrl(string) ? AnalyticsEvent.CHECKOUT_PAGE_LOAD_START : AnalyticsEvent.PAGE_LOAD_START, AnalyticsUtil.getPageLoadStartProperties(string));
    }

    static Map<String, Object> getPageLoadStartProperties(String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("url", string);
        return hashMap;
    }

    static void trackPageLoadEnd(String string, long l) {
        AnalyticsUtil.trackEvent(AnalyticsUtil.isCheckoutUrl(string) ? AnalyticsEvent.CHECKOUT_PAGE_LOAD_FINISH : AnalyticsEvent.PAGE_LOAD_FINISH, AnalyticsUtil.getPageLoadEndProperties(string, l));
    }

    static boolean isCheckoutUrl(String string) {
        return string.indexOf(l__d$.L__R$().l_$w$()) == 0;
    }

    static Map<String, Object> getPageLoadEndProperties(String string, long l) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("url", string);
        hashMap.put("page_load_time", (double)l / 1.0E9);
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void reset() {
        isAnalyticsInitialized = false;
        localPaymentId = null;
        localOrderId = null;
        try {
            ((Class)O__Y_.a_$P$(0, 18, '\u0000')).getDeclaredMethod("G__G_", null).invoke(null, null);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable.getCause();
            if (throwable2 != null) {
                throw throwable2;
            }
            throw throwable;
        }
    }

    static void setAppDetails(Context context, String string) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            MERCHANT_APP_NAME = AnalyticsUtil.returnUndefinedIfNull(packageInfo.applicationInfo.loadLabel(packageManager));
            MERCHANT_APP_VERSION = AnalyticsUtil.returnUndefinedIfNull(packageInfo.versionName);
            MERCHANT_APP_NAMESPACE = AnalyticsUtil.returnUndefinedIfNull(packageInfo.packageName);
            MERCHANT_APP_BUILD = packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            PackageManager.NameNotFoundException nameNotFoundException2 = nameNotFoundException;
            AnalyticsUtil.reportError((Exception)((Object)nameNotFoundException), "critical", nameNotFoundException2.getMessage());
        }
        BUILD_TYPE = BaseUtils.getAppBuildType(context);
        KEY_TYPE = AnalyticsUtil.getKeyType(string);
    }

    static String getKeyType(String string) {
        if (AnalyticsUtil.isNullOrEmpty(string)) {
            return null;
        }
        if ((string = string.substring(0, 8)).equals("rzp_live")) {
            return "live";
        }
        if (string.equals("rzp_test")) {
            return "test";
        }
        return null;
    }

    public static boolean isNullOrEmpty(CharSequence charSequence) {
        return TextUtils.isEmpty((CharSequence)charSequence) || TextUtils.getTrimmedLength((CharSequence)charSequence) == 0;
    }

    public static CharSequence returnUndefinedIfNull(CharSequence charSequence) {
        if (AnalyticsUtil.isNullOrEmpty(charSequence)) {
            return "undefined";
        }
        return charSequence;
    }

    public static String getLocalPaymentId() {
        if (localPaymentId == null) {
            localPaymentId = AnalyticsUtil.getUniqueId();
        }
        return localPaymentId;
    }

    public static String getLocalOrderId() {
        if (localOrderId == null) {
            localOrderId = AnalyticsUtil.getUniqueId();
        }
        return localOrderId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void refreshPaymentSession() {
        localPaymentId = AnalyticsUtil.getUniqueId();
        try {
            ((Class)O__Y_.a_$P$(0, 18, '\u0000')).getDeclaredMethod("d__1_", null).invoke(null, null);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable.getCause();
            if (throwable2 != null) {
                throw throwable2;
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void refreshOrderSession() {
        localOrderId = AnalyticsUtil.getUniqueId();
        localPaymentId = AnalyticsUtil.getUniqueId();
        try {
            ((Class)O__Y_.a_$P$(0, 18, '\u0000')).getDeclaredMethod("a_$P$", null).invoke(null, null);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable.getCause();
            if (throwable2 != null) {
                throw throwable2;
            }
            throw throwable;
        }
        try {
            ((Class)O__Y_.a_$P$(0, 18, '\u0000')).getMethod("d__1_", null).invoke(null, null);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable.getCause();
            if (throwable3 != null) {
                throw throwable3;
            }
            throw throwable;
        }
    }

    static void setLocalOrderId(String string) {
        localOrderId = string;
    }

    static String getUniqueId() {
        long l = (System.currentTimeMillis() - 1388534400000L) * 1000000L;
        long l2 = (long)Math.floor(1.4776336E7 * Math.random());
        return AnalyticsUtil.tobase62(l) + AnalyticsUtil.tobase62(l2);
    }

    static String tobase62(long l) {
        String[] stringArray = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".split("");
        String string = "";
        while (l > 0L) {
            int n = (int)(l % 62L);
            string = String.valueOf(stringArray[n]) + string;
            l = (long)Math.floor(l / 62L);
        }
        return string;
    }

    static void reportUncaughtException(Throwable object) {
        object = AnalyticsUtil.getStackTrace((Throwable)object);
        String string = object;
        Log.d((String)"com.razorpay.checkout", (String)string);
        AnalyticsUtil.trackEvent(AnalyticsEvent.ERROR_LOGGED, AnalyticsUtil.getErrorProperties("uncaught", (String)object));
    }

    static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        throwable.printStackTrace(printWriter);
        return ((Object)stringWriter.getBuffer()).toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveEventsToPreferences(Context context) {
        try {
            ((Class)O__Y_.a_$P$(0, 18, '\u0000')).getDeclaredMethod("d__1_", Context.class).invoke(null, context);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable.getCause();
            if (throwable2 != null) {
                throw throwable2;
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JSONObject getExtraAnalyticsPayload() {
        try {
            return (JSONObject)((Class)O__Y_.a_$P$(0, 18, '\u0000')).getDeclaredMethod("Q_$2$", null).invoke(null, null);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable.getCause();
            if (throwable2 != null) {
                throw throwable2;
            }
            throw throwable;
        }
    }

    static {
        sdkType = "standealone";
    }
}

