/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import com.razorpay.B$$Z_;
import com.razorpay.Q__8_;
import com.razorpay.Y_$H_;
import com.razorpay.a$_G$;
import com.razorpay.q$_Y$;
import com.razorpay.q_$J$;
import com.razorpay.r__Q_;
import com.razorpay.v__i_;

class CircularProgressView
extends View {
    private static final float INDETERMINANT_MIN_SWEEP = 15.0f;
    private Context context;
    private Paint paint;
    private int size = 0;
    private RectF bounds;
    private boolean isIndeterminate;
    private boolean autostartAnimation;
    private float currentProgress;
    private float maxProgress;
    private float indeterminateSweep;
    private float indeterminateRotateOffset;
    private int thickness;
    private int color;
    private int animDuration;
    private int animSwoopDuration;
    private int animSyncDuration;
    private int animSteps;
    private float startAngle;
    private float actualProgress;
    private ValueAnimator startAngleRotate;
    private ValueAnimator progressAnimator;
    private AnimatorSet indeterminateAnimator;
    private float initialStartAngle;

    public CircularProgressView(Context context) {
        super(context);
        this.init(null, 0, context);
    }

    public CircularProgressView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(attributeSet, 0, context);
    }

    public CircularProgressView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(attributeSet, n, context);
    }

    protected void init(AttributeSet attributeSet, int n, Context context) {
        this.initAttributes(attributeSet, n, context);
        this.paint = new Paint(1);
        this.updatePaint();
        this.bounds = new RectF();
    }

    private void initAttributes(AttributeSet attributeSet, int n, Context context) {
        this.getResources();
        this.currentProgress = 0.0f;
        this.maxProgress = 100.0f;
        this.thickness = this.convertDPtoInt(context, 3);
        this.isIndeterminate = true;
        this.autostartAnimation = true;
        this.startAngle = this.initialStartAngle = -90.0f;
        this.color = Color.parseColor((String)"#4aa3df");
        this.animDuration = 4000;
        this.animSwoopDuration = 5000;
        this.animSyncDuration = 500;
        this.animSteps = 3;
    }

    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        n = this.getPaddingLeft() + this.getPaddingRight();
        n2 = this.getPaddingTop() + this.getPaddingBottom();
        int n3 = this.getMeasuredWidth() - n;
        int n4 = this.getMeasuredHeight() - n2;
        this.size = n3 < n4 ? n3 : n4;
        CircularProgressView circularProgressView = this;
        circularProgressView.setMeasuredDimension(circularProgressView.size + n, this.size + n2);
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.size = n < n2 ? n : n2;
        this.updateBounds();
    }

    private void updateBounds() {
        int n = this.getPaddingLeft();
        int n2 = this.getPaddingTop();
        this.bounds.set((float)(n + this.thickness), (float)(n2 + this.thickness), (float)(this.size - n - this.thickness), (float)(this.size - n2 - this.thickness));
    }

    private void updatePaint() {
        this.paint.setColor(this.color);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth((float)this.thickness);
        this.paint.setStrokeCap(Paint.Cap.BUTT);
    }

    protected void onDraw(Canvas canvas) {
        float f2;
        super.onDraw(canvas);
        float f3 = f2 = this.isInEditMode() ? this.currentProgress / this.maxProgress * 360.0f : this.actualProgress / this.maxProgress * 360.0f;
        if (!this.isIndeterminate) {
            canvas.drawArc(this.bounds, this.startAngle, f2, false, this.paint);
            return;
        }
        canvas.drawArc(this.bounds, this.startAngle + this.indeterminateRotateOffset, this.indeterminateSweep, false, this.paint);
    }

    public boolean isIndeterminate() {
        return this.isIndeterminate;
    }

    public void setIndeterminate(boolean bl) {
        boolean bl2 = this.isIndeterminate == bl;
        this.isIndeterminate = bl;
        if (bl2) {
            this.resetAnimation();
        }
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setThickness(int n) {
        this.thickness = n;
        this.updatePaint();
        this.updateBounds();
        this.invalidate();
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int n) {
        this.color = n;
        this.updatePaint();
        this.invalidate();
    }

    public float getMaxProgress() {
        return this.maxProgress;
    }

    public void setMaxProgress(float f2) {
        this.maxProgress = f2;
        this.invalidate();
    }

    public float getProgress() {
        return this.currentProgress;
    }

    public void setProgress(float f2) {
        this.currentProgress = f2;
        if (!this.isIndeterminate) {
            if (this.progressAnimator != null && this.progressAnimator.isRunning()) {
                this.progressAnimator.cancel();
            }
            this.progressAnimator = ValueAnimator.ofFloat((float[])new float[]{this.actualProgress, f2});
            this.progressAnimator.setDuration((long)this.animSyncDuration);
            this.progressAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.progressAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new B$$Z_(this));
            this.progressAnimator.start();
        }
        this.invalidate();
    }

    public void startAnimation() {
        this.resetAnimation();
    }

    public void resetAnimation() {
        if (this.startAngleRotate != null && this.startAngleRotate.isRunning()) {
            this.startAngleRotate.cancel();
        }
        if (this.progressAnimator != null && this.progressAnimator.isRunning()) {
            this.progressAnimator.cancel();
        }
        if (this.indeterminateAnimator != null && this.indeterminateAnimator.isRunning()) {
            this.indeterminateAnimator.cancel();
        }
        if (!this.isIndeterminate) {
            this.startAngle = this.initialStartAngle;
            this.startAngleRotate = ValueAnimator.ofFloat((float[])new float[]{this.startAngle, this.startAngle + 360.0f});
            this.startAngleRotate.setDuration((long)this.animSwoopDuration);
            this.startAngleRotate.setInterpolator((TimeInterpolator)new DecelerateInterpolator(2.0f));
            this.startAngleRotate.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new q$_Y$(this));
            this.startAngleRotate.start();
            this.actualProgress = 0.0f;
            this.progressAnimator = ValueAnimator.ofFloat((float[])new float[]{this.actualProgress, this.currentProgress});
            this.progressAnimator.setDuration((long)this.animSyncDuration);
            this.progressAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.progressAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new q_$J$(this));
            this.progressAnimator.start();
            return;
        }
        this.indeterminateSweep = 15.0f;
        this.indeterminateAnimator = new AnimatorSet();
        AnimatorSet animatorSet = null;
        for (int i2 = 0; i2 < this.animSteps; ++i2) {
            AnimatorSet animatorSet2 = this.createIndeterminateAnimator(i2);
            AnimatorSet.Builder builder = this.indeterminateAnimator.play((Animator)animatorSet2);
            if (animatorSet != null) {
                builder.after((Animator)animatorSet);
            }
            animatorSet = animatorSet2;
        }
        this.indeterminateAnimator.addListener((Animator.AnimatorListener)new v__i_(this));
        this.indeterminateAnimator.start();
    }

    public void stopAnimation() {
        if (this.startAngleRotate != null) {
            this.startAngleRotate.cancel();
            this.startAngleRotate = null;
        }
        if (this.progressAnimator != null) {
            this.progressAnimator.cancel();
            this.progressAnimator = null;
        }
        if (this.indeterminateAnimator != null) {
            this.indeterminateAnimator.cancel();
            this.indeterminateAnimator = null;
        }
    }

    private AnimatorSet createIndeterminateAnimator(float f2) {
        float f3 = 360.0f * (float)(this.animSteps - 1) / (float)this.animSteps + 15.0f;
        float f4 = -90.0f + f2 * (f3 - 15.0f);
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{15.0f, f3});
        valueAnimator.setDuration((long)(this.animDuration / this.animSteps / 2));
        valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator(1.0f));
        valueAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new r__Q_(this));
        ValueAnimator valueAnimator2 = ValueAnimator.ofFloat((float[])new float[]{f2 * 720.0f / (float)this.animSteps, (f2 + 0.5f) * 720.0f / (float)this.animSteps});
        valueAnimator2.setDuration((long)(this.animDuration / this.animSteps / 2));
        valueAnimator2.setInterpolator((TimeInterpolator)new LinearInterpolator());
        valueAnimator2.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new a$_G$(this));
        ValueAnimator valueAnimator3 = ValueAnimator.ofFloat((float[])new float[]{f4, f4 + f3 - 15.0f});
        valueAnimator3.setDuration((long)(this.animDuration / this.animSteps / 2));
        valueAnimator3.setInterpolator((TimeInterpolator)new DecelerateInterpolator(1.0f));
        valueAnimator3.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new Q__8_(this, f3, f4));
        ValueAnimator valueAnimator4 = ValueAnimator.ofFloat((float[])new float[]{(f2 + 0.5f) * 720.0f / (float)this.animSteps, (f2 + 1.0f) * 720.0f / (float)this.animSteps});
        valueAnimator4.setDuration((long)(this.animDuration / this.animSteps / 2));
        valueAnimator4.setInterpolator((TimeInterpolator)new LinearInterpolator());
        valueAnimator4.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new Y_$H_(this));
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.play((Animator)valueAnimator).with((Animator)valueAnimator2);
        animatorSet.play((Animator)valueAnimator3).with((Animator)valueAnimator4).after((Animator)valueAnimator2);
        return animatorSet;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.autostartAnimation) {
            this.startAnimation();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stopAnimation();
    }

    public void setVisibility(int n) {
        int n2 = this.getVisibility();
        super.setVisibility(n);
        if (n != n2) {
            if (n == 0) {
                this.resetAnimation();
                return;
            }
            if (n == 8 || n == 4) {
                this.stopAnimation();
            }
        }
    }

    private int convertDPtoInt(Context context, int n) {
        return (int)TypedValue.applyDimension((int)1, (float)n, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    static /* synthetic */ float access$002(CircularProgressView circularProgressView, float f2) {
        circularProgressView.actualProgress = f2;
        return circularProgressView.actualProgress;
    }

    static /* synthetic */ float access$102(CircularProgressView circularProgressView, float f2) {
        circularProgressView.startAngle = f2;
        return circularProgressView.startAngle;
    }

    static /* synthetic */ float access$202(CircularProgressView circularProgressView, float f2) {
        circularProgressView.indeterminateSweep = f2;
        return circularProgressView.indeterminateSweep;
    }

    static /* synthetic */ float access$302(CircularProgressView circularProgressView, float f2) {
        circularProgressView.indeterminateRotateOffset = f2;
        return circularProgressView.indeterminateRotateOffset;
    }

    static /* synthetic */ float access$100(CircularProgressView circularProgressView) {
        return circularProgressView.startAngle;
    }
}

