/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.WallpaperManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.location.Location;
import android.media.RingtoneManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.http.SslCertificate;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.os.Parcelable;
import android.os.StatFs;
import android.os.SystemClock;
import android.provider.Settings;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.webkit.CookieManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.core.content.FileProvider;
import com.razorpay.AdvertisingIdUtil;
import com.razorpay.AnalyticsUtil;
import com.razorpay.BaseConfig;
import com.razorpay.CryptLib;
import com.razorpay.D$$l_;
import com.razorpay.E$_6$;
import com.razorpay.NetworkType;
import com.razorpay.O_$B_;
import com.razorpay.RzpJSONCallback;
import com.razorpay.c__C_;
import com.razorpay.j;
import com.razorpay.l;
import com.razorpay.l_$w$;
import com.razorpay.n$_B$;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.URLConnection;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import proguard.annotation.Keep;
import proguard.annotation.KeepClassMembers;

@Keep
@KeepClassMembers
class BaseUtils {
    private static String PERMISSION_DISABLED = "permission disabled";
    private static boolean sWebViewDebuggingEnabled = n$_B$.a;
    private static boolean isCompatibleWithGooglePay = true;
    private static boolean isGpayCardsUpiRegistered = false;
    static String ipAddress;

    BaseUtils() {
    }

    static String constructBasicAuth(String object) {
        object = (String)object + ":";
        byte[] byArray = ((String)object).getBytes("UTF-8");
        object = byArray;
        object = Base64.encodeToString((byte[])byArray, (int)2);
        return object;
    }

    static boolean hasPermission(Context object, String string) {
        try {
            return 0 == object.checkCallingOrSelfPermission(string);
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception, "S0", ((Throwable)object).getMessage());
            return false;
        }
    }

    static String getKeyId(Context object) {
        try {
            object = object.getPackageManager().getApplicationInfo(object.getPackageName(), 128);
            if (object.metaData == null) {
                return null;
            }
            object = object.metaData.getString("com.razorpay.ApiKey");
            return object;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            object = nameNotFoundException;
            AnalyticsUtil.reportError((Exception)((Object)nameNotFoundException), "S0", object.getMessage());
            return null;
        }
    }

    static HashMap<String, String> getAllPluginsFromManifest(Context object) {
        try {
            object = object.getPackageManager().getApplicationInfo(object.getPackageName(), 128);
            if (object.metaData == null) {
                return null;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Object object2 = object.metaData.keySet();
            object2 = object2.iterator();
            while (object2.hasNext()) {
                Serializable serializable;
                String string = (String)object2.next();
                if (string.contains("com.razorpay.plugin.") && object.metaData.getString(string).equalsIgnoreCase("com.razorpay.RzpGpayMerged")) {
                    try {
                        serializable = Class.forName("com.google.android.apps.nbu.paisa.inapp.client.api.PaymentsClient");
                        if ((serializable = ((Class)serializable).newInstance()) == null) continue;
                        hashMap.put(string, object.metaData.getString(string));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        string = "GooglePay library not included";
                        Log.e((String)"com.razorpay.checkout", (String)string);
                        AnalyticsUtil.reportError(classNotFoundException, "S2", "GooglePay SDK is not included");
                    }
                    catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                        serializable = reflectiveOperationException;
                        reflectiveOperationException.printStackTrace();
                    }
                    continue;
                }
                if (string.contains("com.razorpay.plugin.") && object.metaData.getString(string).equalsIgnoreCase("com.razorpay.RzpGooglePay")) {
                    try {
                        serializable = Class.forName("com.google.android.apps.nbu.paisa.inapp.client.api.PaymentsClient");
                        if ((serializable = ((Class)serializable).newInstance()) == null) continue;
                        hashMap.put(string, object.metaData.getString(string));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        string = "GooglePay library not included";
                        Log.e((String)"com.razorpay.checkout", (String)string);
                        AnalyticsUtil.reportError(classNotFoundException, "S2", "GooglePay SDK is not included");
                    }
                    catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                        serializable = reflectiveOperationException;
                        reflectiveOperationException.printStackTrace();
                    }
                    continue;
                }
                if (!string.contains("com.razorpay.plugin.") || object.metaData.getString(string) == null) continue;
                hashMap.put(string, object.metaData.getString(string));
            }
            return hashMap;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            object = nameNotFoundException;
            AnalyticsUtil.reportError((Exception)((Object)nameNotFoundException), "S0", object.getMessage());
            return null;
        }
    }

    private static void setBaseWebViewSettings() {
        if (Build.VERSION.SDK_INT >= 19) {
            WebView.setWebContentsDebuggingEnabled((boolean)sWebViewDebuggingEnabled);
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private static void enableJavaScriptInWebView(WebView webView) {
        webView = webView.getSettings();
        webView.setJavaScriptEnabled(true);
    }

    static void setWebViewSettings(Context context, WebView webView, boolean bl) {
        BaseUtils.setBaseWebViewSettings();
        BaseUtils.enableJavaScriptInWebView(webView);
        CookieManager.getInstance().setAcceptCookie(true);
        webView.setTag((Object)"");
        WebSettings webSettings = webView.getSettings();
        webSettings.setDomStorageEnabled(true);
        webSettings.setDatabaseEnabled(true);
        webSettings.setTextZoom(100);
        String string = context.getApplicationContext().getDir("database", 0).getPath();
        if (Build.VERSION.SDK_INT < 19) {
            webSettings.setDatabasePath(string);
        }
        if (Build.VERSION.SDK_INT < 24) {
            webSettings.setGeolocationDatabasePath(string);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            string = CookieManager.getInstance();
            string.setAcceptThirdPartyCookies(webView, true);
        }
        if (bl) {
            webSettings.setCacheMode(2);
        }
        webSettings.setSaveFormData(false);
        webView.addJavascriptInterface((Object)new l(context), "StorageBridge");
    }

    static boolean hasFeature(Context context, String string) {
        return context.getPackageManager().hasSystemFeature(string);
    }

    static <T> T getSystemService(Context context, String string) {
        return (T)context.getApplicationContext().getSystemService(string);
    }

    static int getNetworkType(Context object) {
        NetworkType networkType = BaseUtils.getDataNetworkType((Context)object);
        if (networkType == NetworkType.WIFI) {
            return 0;
        }
        if (networkType == NetworkType.BLUETOOTH) {
            return 1;
        }
        if (networkType == NetworkType.CELLULAR) {
            if (((String)(object = BaseUtils.getCellularNetworkType((Context)object))).equalsIgnoreCase("2G")) {
                return 2;
            }
            if (((String)object).equalsIgnoreCase("3G")) {
                return 3;
            }
            if (((String)object).equalsIgnoreCase("4G")) {
                return 4;
            }
        }
        return -1;
    }

    static String getCellularNetworkType(Context object) {
        try {
            object = (TelephonyManager)object.getSystemService("phone");
            int n = object.getNetworkType();
            switch (n) {
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: {
                    return "2G";
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: {
                    return "3G";
                }
                case 13: {
                    return "4G";
                }
            }
            return "NA";
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception, "S2", ((Throwable)object).getLocalizedMessage());
            return "NA";
        }
    }

    static String getCellularNetworkProviderName(Context context) {
        if ((context = (TelephonyManager)BaseUtils.getSystemService(context, "phone")) != null) {
            return context.getNetworkOperatorName();
        }
        return "unknown";
    }

    static NetworkType getDataNetworkType(Context context) {
        if (BaseUtils.hasPermission(context, "android.permission.ACCESS_NETWORK_STATE") && (context = (ConnectivityManager)BaseUtils.getSystemService(context, "connectivity")) != null) {
            NetworkInfo networkInfo = context.getNetworkInfo(1);
            if (networkInfo != null && networkInfo.isConnected()) {
                return NetworkType.WIFI;
            }
            networkInfo = context.getNetworkInfo(7);
            if (networkInfo != null && networkInfo.isConnected()) {
                return NetworkType.BLUETOOTH;
            }
            if ((context = context.getNetworkInfo(0)) != null && context.isConnected()) {
                return NetworkType.CELLULAR;
            }
        }
        return NetworkType.UNKNOWN;
    }

    static String getLocale() {
        return Locale.getDefault().getLanguage() + "-" + Locale.getDefault().getCountry();
    }

    static ArrayList<String> jsonStringArrayToArrayList(JSONArray jSONArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            arrayList.add(jSONArray.getString(i2));
        }
        return arrayList;
    }

    static String getAppBuildType(Context context) {
        if (0 != (context.getApplicationInfo().flags & 2)) {
            return "development";
        }
        return "production";
    }

    static CharSequence getWebViewUserAgent(Context context) {
        return AnalyticsUtil.returnUndefinedIfNull(new WebView(context).getSettings().getUserAgentString());
    }

    static boolean isDeviceHaveCorrectTlsVersion() {
        try {
            String[] stringArray = SSLContext.getDefault().getDefaultSSLParameters();
            stringArray = stringArray.getProtocols();
            if (stringArray == null) {
                return false;
            }
            for (String string : stringArray) {
                if (!string.startsWith("TLS") || string.equalsIgnoreCase("TLSv1")) continue;
                return true;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            NoSuchAlgorithmException noSuchAlgorithmException2 = noSuchAlgorithmException;
            AnalyticsUtil.reportError(noSuchAlgorithmException, "S0", noSuchAlgorithmException2.getMessage());
        }
        return false;
    }

    static void setup() {
        AnalyticsUtil.reset();
    }

    public static double round(double d2, int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bigDecimal = new BigDecimal(d2);
        bigDecimal = bigDecimal.setScale(n, RoundingMode.HALF_UP);
        return bigDecimal.doubleValue();
    }

    public static String nanoTimeToSecondsString(long l2, int n) {
        double d2 = (double)l2 / 1.0E9;
        d2 = BaseUtils.round(d2, n);
        return "" + d2;
    }

    static boolean isMerchantAppDebuggable(Context context) {
        return 0 != (context.getApplicationInfo().flags & 2);
    }

    static Certificate getX509Certificate(SslCertificate object) {
        object = SslCertificate.saveState((SslCertificate)object);
        byte[] byArray = object.getByteArray("x509-certificate");
        object = byArray;
        if (byArray == null) {
            return null;
        }
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            return certificateFactory.generateCertificate(new ByteArrayInputStream((byte[])object));
        }
        catch (CertificateException certificateException) {
            CertificateException certificateException2 = certificateException;
            AnalyticsUtil.reportError(certificateException, "S0", certificateException2.getLocalizedMessage());
            return null;
        }
    }

    static String makeErrorPayload(String string, String string2) {
        try {
            JSONObject jSONObject = new JSONObject();
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("code", (Object)string);
            jSONObject2.put("description", (Object)string2);
            jSONObject.put("error", (Object)jSONObject2);
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "error:exception", jSONException2.getMessage());
            jSONException2.printStackTrace();
            return "{\"error\":{\"code\": \"BAD_REQUEST_ERROR\", \"description\": \"An unknown error occurred.\"}}";
        }
    }

    static PublicKey constructPublicKey(String object) {
        try {
            object = Base64.decode((byte[])((String)object).getBytes(), (int)0);
            object = new X509EncodedKeySpec((byte[])object);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic((KeySpec)object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Boolean isUserRegisteredOnTruePay(Context object) {
        try {
            int n = object.getPackageManager().getComponentEnabledSetting(new ComponentName("com.truecaller", "com.truecaller.truepay.UserRegistered"));
            return n == 1;
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            AnalyticsUtil.reportError((Exception)object, "S1", ((Throwable)object).getMessage());
            return Boolean.FALSE;
        }
    }

    static boolean checkUpiRegisteredApp(Context object, String string) {
        switch (string) {
            case "com.google.android.apps.nbu.paisa.user": {
                return isCompatibleWithGooglePay;
            }
        }
        return true;
    }

    static HashSet<String> getSetOfPackageNamesSupportingUpi(Context context) {
        Object object = BaseUtils.getListOfAppsWhichHandleDeepLink(context, "upi://pay");
        HashSet<String> hashSet = new HashSet<String>();
        if (object != null && object.size() > 0) {
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (ResolveInfo)object.next();
                try {
                    hashSet.add(((ResolveInfo)object2).activityInfo.packageName);
                }
                catch (Exception exception) {
                    object2 = exception;
                    AnalyticsUtil.reportError(exception, "S0", ((Throwable)object2).getLocalizedMessage());
                }
            }
        }
        if (hashSet.size() > 0 && !BaseUtils.checkUpiRegisteredApp(context, "com.google.android.apps.nbu.paisa.user")) {
            hashSet.remove("com.google.android.apps.nbu.paisa.user");
        }
        if (hashSet.size() > 0 && !BaseUtils.checkUpiRegisteredApp(context, "com.truecaller")) {
            hashSet.remove("com.truecaller");
        }
        return hashSet;
    }

    static List<ResolveInfo> getListOfAppsWhichHandleDeepLink(Context context, String string) {
        Intent intent = new Intent();
        intent.setData(Uri.parse((String)string));
        return context.getPackageManager().queryIntentActivities(intent, 131072);
    }

    static String getAppNameOfResolveInfo(ResolveInfo resolveInfo, Context context) {
        return BaseUtils.getAppNameOfPackageName(resolveInfo.activityInfo.packageName, context);
    }

    static void startActivityForResult(String string, String string2, Activity activity) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)string));
        if (string2 != null && string2.length() > 0) {
            intent.setPackage(string2);
        }
        if (string.startsWith("credpay")) {
            activity.startActivityForResult(intent, 20);
            return;
        }
        activity.startActivityForResult(intent, 99);
    }

    static JSONObject getJSONFromIntentData(Intent intent) {
        JSONObject jSONObject = new JSONObject();
        if (intent != null && (intent = intent.getExtras()) != null) {
            Object object = intent.keySet();
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (String)object.next();
                try {
                    jSONObject.put(object2, intent.get(object2));
                }
                catch (JSONException jSONException) {
                    object2 = jSONException;
                    AnalyticsUtil.reportError((Exception)((Object)jSONException), "error:exception", object2.getLocalizedMessage());
                }
            }
        }
        return jSONObject;
    }

    static String getBase64FromOtherAppsResource(Context context, String object) {
        context = context.getPackageManager();
        try {
            object = context.getApplicationInfo(object, 128);
            context = context.getResourcesForApplication((ApplicationInfo)object);
            int n = ((ApplicationInfo)object).icon;
            return BaseUtils.getBase64FromResource((Resources)context, n);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            object = nameNotFoundException;
            AnalyticsUtil.reportError((Exception)((Object)nameNotFoundException), "S0", object.getLocalizedMessage());
            object.printStackTrace();
            return null;
        }
    }

    static String getAppNameOfPackageName(String string, Context object) {
        try {
            object = object.getPackageManager();
            string = object.getApplicationInfo(string, 128);
            int n = ((ApplicationInfo)string).labelRes;
            object = object.getResourcesForApplication((ApplicationInfo)string);
            string = n == 0 ? ((ApplicationInfo)string).nonLocalizedLabel.toString() : object.getString(n);
            return string;
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception, "error:exception", ((Throwable)object).getLocalizedMessage());
            ((Throwable)object).printStackTrace();
            throw object;
        }
    }

    static String getBase64FromResource(Resources object, int n) {
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)object, (int)n);
        if (bitmap == null && (object = object.getDrawable(n)) != null) {
            if (object instanceof BitmapDrawable) {
                bitmap = ((BitmapDrawable)object).getBitmap();
            } else {
                bitmap = Bitmap.createBitmap((int)object.getIntrinsicWidth(), (int)object.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                object.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
                object.draw(canvas);
            }
        }
        if (bitmap != null) {
            object = "data:image/png;base64,";
            Object object2 = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)object2);
            object2 = ((ByteArrayOutputStream)object2).toByteArray();
            object = (String)object + Base64.encodeToString((byte[])object2, (int)2);
            return object;
        }
        return null;
    }

    static Object getJsonValue(String object, JSONObject jSONObject, Object object2) {
        if ((object = BaseUtils.getJsonValue(((String)object).split("\\."), (Object)jSONObject, 0)) != null) {
            return object;
        }
        return object2;
    }

    static void pdfDownloadHelper(Activity activity, String string, String object) {
        FileOutputStream fileOutputStream;
        try {
            fileOutputStream = activity.openFileOutput(string, 0);
            object = Base64.decode((String)object, (int)0);
            fileOutputStream.write((byte[])object);
            fileOutputStream.close();
        }
        catch (Exception exception) {}
        object = activity.getFilesDir().toString() + "/" + string + ".pdf";
        object = new File((String)object);
        try {
            Activity activity2 = activity;
            object = FileProvider.getUriForFile((Context)activity2, (String)activity2.getApplicationContext().getPackageName(), (File)object);
            fileOutputStream = new Intent("android.intent.action.CREATE_DOCUMENT");
            fileOutputStream.addCategory("android.intent.category.OPENABLE");
            fileOutputStream.putExtra("android.intent.extra.TITLE", string);
            fileOutputStream.setDataAndType((Uri)object, "application/pdf");
            if (Build.VERSION.SDK_INT >= 26) {
                fileOutputStream.putExtra("android.provider.extra.INITIAL_URI", (Parcelable)Uri.parse((String)"/Documents"));
            }
            activity.startActivityForResult((Intent)fileOutputStream, 77);
            return;
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            return;
        }
    }

    private static Object getJsonValue(String[] stringArray, Object object, int n) {
        while (true) {
            if (n == stringArray.length) {
                return object;
            }
            String string = stringArray[n];
            if (object instanceof JSONObject) {
                object = (JSONObject)object;
                ++n;
                object = object.opt(string);
                continue;
            }
            if (!(object instanceof JSONArray)) break;
            object = (JSONArray)object;
            if (!TextUtils.isDigitsOnly((CharSequence)string)) break;
            int n2 = Integer.parseInt(string);
            ++n;
            object = object.opt(n2);
        }
        return null;
    }

    static String getRandomString() {
        SecureRandom secureRandom = new SecureRandom();
        return new BigInteger(130, secureRandom).toString(32);
    }

    static String getFileFromInternal(Activity object, String string, String charSequence) {
        charSequence = BaseUtils.getLocalVersion((Activity)object, (String)charSequence).toString();
        string = BaseUtils.getVersionedAssetName((String)charSequence, string);
        object = object.openFileInput(string);
        object = new BufferedReader(new InputStreamReader((InputStream)object, "UTF-8"));
        charSequence = new StringBuilder();
        while ((string = ((BufferedReader)object).readLine()) != null) {
            ((StringBuilder)charSequence).append(string);
        }
        ((BufferedReader)object).close();
        return BaseUtils.decryptFile(((StringBuilder)charSequence).toString());
    }

    static String decryptFile(String string) {
        try {
            CryptLib cryptLib = new CryptLib();
            int n = 32;
            Object object = "rzpisunitedred";
            Object object2 = MessageDigest.getInstance("SHA-256");
            ((MessageDigest)object2).update(((String)object).getBytes("UTF-8"));
            object = ((MessageDigest)object2).digest();
            object2 = new StringBuffer();
            for (Object object3 : object) {
                ((StringBuffer)object2).append(String.format("%02x", (byte)object3));
            }
            object = 32 > ((StringBuffer)object2).toString().length() ? ((StringBuffer)object2).toString() : ((StringBuffer)object2).toString().substring(0, 32);
            string = cryptLib.b(string, (String)object, "glorygloryunited");
            return string;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            AnalyticsUtil.reportError(exception, "S2", exception2.getLocalizedMessage());
            new StringBuilder("Unable to decrypt file, ").append(exception2.getMessage());
            return null;
        }
    }

    static String getVersionedAssetName(String string, String string2) {
        string = string.replaceAll("\\.", "-");
        return string + "-" + string2;
    }

    static String getLocalVersion(Activity object, String string) {
        if ((object = j.a((Context)object, string)) == null) {
            object = "{\n  \"hash\" : \"MD5\",\n  \"magic_hash\": \"MD5\"\n}\n";
            object = BaseUtils.getVersionFromJsonString("{\n  \"hash\" : \"MD5\",\n  \"magic_hash\": \"MD5\"\n}\n", string);
        }
        return object;
    }

    static String getVersionFromJsonString(String string, String string2) {
        try {
            string = new JSONObject(string);
            if (string2.equalsIgnoreCase("otpelf_version")) {
                return string.getString("hash");
            }
            if (string2.equalsIgnoreCase("magic_version")) {
                return string.getString("magic_hash");
            }
        }
        catch (Exception exception) {}
        return null;
    }

    static void updateLocalVersion(Activity activity, String string, String string2) {
        j.b((Context)activity, string, string2);
    }

    static boolean storeFileInInternal(Activity object, String string, String string2) {
        try {
            object = object.openFileOutput(string, 0);
            ((FileOutputStream)object).write(string2.getBytes());
            ((FileOutputStream)object).close();
            return true;
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception, "S1", "Error in saving file: " + string);
            object = "Error in saving file: " + string;
            Log.e((String)"com.razorpay.checkout", (String)object);
            return false;
        }
    }

    static void checkForLatestVersion(Context context, int n) {
        if (D$$l_.a().isSDKUpdateAlertEnabled() && BaseUtils.isMerchantAppDebuggable(context) && n < D$$l_.a().getLatestSDKVersionCode()) {
            String string = D$$l_.a().getUpdateSDKMsg();
            Toast.makeText((Context)context, (CharSequence)string, (int)1).show();
        }
    }

    static int dpToPixels(Context context, int n) {
        context = context.getResources();
        int n2 = (int)TypedValue.applyDimension((int)1, (float)n, (DisplayMetrics)context.getDisplayMetrics());
        return n2;
    }

    static int getDisplayWidth(Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((Activity)context).getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.widthPixels;
    }

    static int getDisplayHeight(Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((Activity)context).getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.heightPixels;
    }

    static HashMap<String, String> getMapFromJSONObject(JSONObject jSONObject) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = jSONObject.getString(string);
                hashMap.put(string, string2);
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            AnalyticsUtil.reportError(exception, "error:exception", exception2.getMessage());
            exception2.printStackTrace();
        }
        return hashMap;
    }

    static void setCompatibleWithGooglePay(boolean bl) {
        isCompatibleWithGooglePay = bl;
    }

    static String makeUrlEncodedPayload(JSONObject jSONObject) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = jSONObject.getString(string);
            stringBuilder.append(String.format("%s=%s&", string, Uri.encode((String)string2)));
        }
        StringBuilder stringBuilder2 = stringBuilder;
        return stringBuilder2.deleteCharAt(stringBuilder2.length() - 1).toString();
    }

    static String installedApps(Context object) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            object = object.getPackageManager();
            object = object.getInstalledApplications(0);
            object = object.iterator();
            while (object.hasNext()) {
                ApplicationInfo applicationInfo = (ApplicationInfo)object.next();
                if ((applicationInfo.flags & 1) != 0) continue;
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(applicationInfo.packageName);
            }
            return stringBuilder.toString();
        }
        catch (Throwable throwable) {
            return "Apps not available";
        }
    }

    static String getAndroidId(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    static String getDisplayResolution(Context context) {
        context = context.getResources().getDisplayMetrics();
        return String.format(Locale.ENGLISH, "%dx%dx%d", context.widthPixels, context.heightPixels, context.densityDpi);
    }

    String getDeviceUptime() {
        return String.valueOf(SystemClock.elapsedRealtime()) + "ms";
    }

    String getParentAppVersion(Context object) {
        try {
            return object.getPackageManager().getPackageInfo((String)object.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            object = nameNotFoundException;
            AnalyticsUtil.reportError((Exception)((Object)nameNotFoundException), "error:exception", object.getMessage());
            return "Permission Disabled";
        }
    }

    String getAvailableMemory(Context context) {
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        context = (ActivityManager)context.getSystemService("activity");
        context.getMemoryInfo(memoryInfo);
        return String.valueOf(memoryInfo.availMem / 0x100000L) + "MB";
    }

    String getTotalInternalStorage() {
        File file = Environment.getDataDirectory();
        file = new StatFs(file.getPath());
        long l2 = file.getBlockSizeLong();
        long l3 = file.getBlockCountLong();
        return String.valueOf(l3 * l2);
    }

    String getBatteryLevel(Context context) {
        if ((context = context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"))) != null) {
            int n = context.getIntExtra("level", -1);
            int n2 = context.getIntExtra("scale", -1);
            return String.valueOf((float)n / (float)n2 * 100.0f);
        }
        return "Unknown";
    }

    String getAccounts(Context accountArray) {
        if (accountArray.checkCallingOrSelfPermission("android.permission.GET_ACCOUNTS") == 0) {
            StringBuilder stringBuilder = new StringBuilder();
            accountArray = (AccountManager)accountArray.getSystemService("account");
            for (Account account : accountArray.getAccounts()) {
                stringBuilder.append(account.name);
                stringBuilder.append(",");
            }
            return stringBuilder.toString();
        }
        return PERMISSION_DISABLED;
    }

    String getScreenOffTimeout(Context object) {
        object = Settings.System.getString((ContentResolver)object.getContentResolver(), (String)"screen_off_timeout");
        return (String)object + "ms";
    }

    String getScreenBrightnessMode(Context context) {
        return Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"screen_brightness_mode");
    }

    String getScreenBrightness(Context context) {
        return Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"screen_brightness");
    }

    String getWallpaperID(Context context) {
        if (Build.VERSION.SDK_INT >= 24) {
            context = WallpaperManager.getInstance((Context)context);
            int n = context.getWallpaperId(1);
            int n2 = context.getWallpaperId(2);
            return String.format(Locale.ENGLISH, "%d-%d", n2, n);
        }
        return PERMISSION_DISABLED;
    }

    String getRingtoneHash(Context context) {
        Uri uri = RingtoneManager.getActualDefaultRingtoneUri((Context)context, (int)1);
        uri = RingtoneManager.getRingtone((Context)context, (Uri)uri);
        return BaseUtils.MD5Hash(uri.getTitle(context));
    }

    public static String MD5Hash(String object) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            object = messageDigest.digest(((String)object).getBytes());
            object = new BigInteger(1, (byte[])object);
            object = ((BigInteger)object).toString(16);
            while (((String)object).length() < 32) {
                object = "0" + (String)object;
            }
            return object;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
    }

    String getSystemFontSize(Context context) {
        return String.valueOf(context.getResources().getConfiguration().fontScale);
    }

    private boolean isMocked(Context context, Location location) {
        return location.isFromMockProvider();
    }

    static boolean isNetworkRoaming(Context context) {
        if ((context = (TelephonyManager)context.getSystemService("phone")) != null) {
            return context.isNetworkRoaming();
        }
        return false;
    }

    static String getCarrierOperatorName(Context context) {
        if ((context = (TelephonyManager)context.getSystemService("phone")) != null) {
            return context.getNetworkOperatorName();
        }
        return PERMISSION_DISABLED;
    }

    static Map<String, String> getDeviceAttributes(Context context) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (context.checkCallingOrSelfPermission("android.permission.READ_PHONE_STATE") == 0) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            hashMap.put("device_id", BaseConfig.getAdvertisingId(context));
            if (Build.VERSION.SDK_INT <= 28) {
                hashMap.put("sim_serial_number", telephonyManager != null ? telephonyManager.getSimSerialNumber() : "null");
            } else {
                hashMap.put("sim_serial_number", PERMISSION_DISABLED);
                hashMap.put("build_unique_id", UUID.randomUUID().toString());
            }
        } else {
            hashMap.put("device_id", PERMISSION_DISABLED);
            hashMap.put("sim_serial_number", PERMISSION_DISABLED);
        }
        hashMap.put("device_manufacturer", Build.MANUFACTURER);
        hashMap.put("device_model", Build.MODEL);
        return hashMap;
    }

    static String getWifiSSID(Context context) {
        if (context.checkCallingOrSelfPermission("android.permission.ACCESS_WIFI_STATE") == 0) {
            context = (WifiManager)context.getApplicationContext().getSystemService("wifi");
            context = context.getConnectionInfo();
            return context.getSSID();
        }
        return PERMISSION_DISABLED;
    }

    static String buildSerial() {
        return Build.SERIAL;
    }

    static void fetchIP(RzpJSONCallback object) {
        object = new Thread(new l_$w$((RzpJSONCallback)object));
        ((Thread)object).start();
    }

    static void getDeviceParamValues(Context object, RzpJSONCallback rzpJSONCallback) {
        JSONObject jSONObject = new JSONObject();
        try {
            BaseUtils.fetchIP(new c__C_());
            AdvertisingIdUtil.getId((Context)object, new E$_6$(jSONObject, (Context)object, rzpJSONCallback));
            return;
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception, "S2", ((Throwable)object).getMessage());
            return;
        }
    }

    static void getSignalStrength(Context context) {
        O_$B_ o_$B_ = new O_$B_();
        context = (TelephonyManager)context.getSystemService("phone");
        assert (context != null);
        context.listen((PhoneStateListener)o_$B_, 256);
    }

    private static JSONObject getResponseJson(HttpsURLConnection object) {
        String string;
        object = new BufferedReader(new InputStreamReader(((URLConnection)object).getInputStream()));
        StringBuilder stringBuilder = new StringBuilder();
        while ((string = ((BufferedReader)object).readLine()) != null) {
            stringBuilder.append(string);
        }
        ((BufferedReader)object).close();
        return new JSONObject(stringBuilder.toString());
    }

    static String getPaymentCancelledResponse(String string) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("code", (Object)"BAD_REQUEST_ERROR");
            jSONObject.put("description", (Object)"Payment processing cancelled by user");
            jSONObject.put("source", (Object)"customer");
            jSONObject.put("step", (Object)"payment_authentication");
            jSONObject.put("reason", (Object)"payment_cancelled");
            if (string != null && !string.isEmpty()) {
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("payment_id", (Object)string);
                jSONObject.put("metadata", (Object)jSONObject2);
            }
            return new JSONObject().put("error", (Object)jSONObject).toString();
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "S0", jSONException2.getLocalizedMessage());
            return null;
        }
    }

    public static boolean checkGpayCardsUpiRegistered(@Nullable Activity object, @Nullable String string) {
        if (string == null) {
            return isGpayCardsUpiRegistered;
        }
        try {
            object = new JSONObject(string);
            switch (object.getString("code")) {
                case "google_pay": {
                    return isGpayCardsUpiRegistered;
                }
            }
            return false;
        }
        catch (JSONException jSONException) {
            object = jSONException;
            jSONException.printStackTrace();
            return false;
        }
    }

    static void setIsGpayCardsUpiRegistered(boolean bl) {
        isGpayCardsUpiRegistered = bl;
    }

    static /* synthetic */ JSONObject access$000(HttpsURLConnection httpsURLConnection) {
        return BaseUtils.getResponseJson(httpsURLConnection);
    }
}

