/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import com.razorpay.AdvertisingIdUtil;
import com.razorpay.BaseUtils;
import com.razorpay.Y$_o$;
import com.razorpay.e_$r$;
import com.razorpay.j;
import com.razorpay.n$_B$;
import com.razorpay.r$_Y_;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

class BaseConfig {
    static final String CONFIG_JSON = "rzp_config_json";
    static final String CONFIG_VERSION = "rzp_config_version";
    static final String ADVERTISING_ID = "advertising_id";
    private String mConfigEndpoint;
    private boolean mConfigEnabled;
    private String mCheckoutEndpoint;
    private String mLumberjackKey;
    private String mLumberjackSdkIdentifier;
    private String mLumberjackEndpoint;
    private boolean mLumberJackEnabled;
    private boolean isOTPElfEnabled;
    private JSONObject mOTPElfSettings;
    private String mOTPElfBaseEndPoint;
    private String mOTPElfVersionFileName;
    private String mOTPElfJsFileName;
    private boolean isMagicEnabled;
    private JSONObject mMagicSettings;
    private String mMagicBaseEndPoint;
    private String mMagicVersionFileName;
    private String mMagicJsFileName;
    private String mPermissionCustomMessage;
    private Boolean mPermissionCustomMessageEnabled;
    private int mSmsPermissionMaxAskCount;
    private int mLatestSDKVersion;
    private String mUpdateSDKMsg;
    private boolean mSDKUpdateAlertEnabled;

    BaseConfig() {
    }

    public void setConfig(JSONObject jSONObject) {
        try {
            this.setUpdateSDKConfig(jSONObject);
            this.setBaseConfig(jSONObject);
            this.setPermissionConfig(jSONObject);
            this.setAnalyticsConfig(jSONObject);
            this.setOtpElfConfig(jSONObject);
            this.setMagicConfig(jSONObject);
            this.setCheckoutBaseConfig(jSONObject);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    static JSONObject getConfig(Context object, int n) {
        Object object2 = BaseConfig.getConfigDataFromPreferences((Context)object);
        JSONObject jSONObject = null;
        try {
            if (object2 == null) {
                object = object.getResources().openRawResource(n);
                StringWriter stringWriter = new StringWriter();
                object2 = new char[1024];
                try {
                    int n2;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object, "UTF-8"));
                    while ((n2 = bufferedReader.read((char[])object2)) != -1) {
                        ((Writer)stringWriter).write((char[])object2, 0, n2);
                    }
                }
                finally {
                    ((InputStream)object).close();
                }
                object2 = ((Object)stringWriter).toString();
            }
            jSONObject = new JSONObject((String)object2);
        }
        catch (Exception exception) {}
        return jSONObject;
    }

    static String getOtpelfJsFromFile(Context object, int n) {
        String string = "";
        try {
            object = object.getResources().openRawResource(n);
            StringWriter stringWriter = new StringWriter();
            char[] cArray = new char[1024];
            try {
                int n2;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object, "UTF-8"));
                while ((n2 = bufferedReader.read(cArray)) != -1) {
                    ((Writer)stringWriter).write(cArray, 0, n2);
                }
            }
            finally {
                ((InputStream)object).close();
            }
            string = ((Object)stringWriter).toString();
        }
        catch (Exception exception) {}
        return string;
    }

    private void setAnalyticsConfig(JSONObject jSONObject) {
        this.mLumberJackEnabled = (Boolean)BaseUtils.getJsonValue("analytics.lumberjack.enable", jSONObject, Boolean.TRUE);
        this.mLumberjackKey = (String)BaseUtils.getJsonValue("analytics.lumberjack.key", jSONObject, "");
        this.mLumberjackEndpoint = (String)BaseUtils.getJsonValue("analytics.lumberjack.end_point", jSONObject, "");
        this.mLumberjackSdkIdentifier = (String)BaseUtils.getJsonValue("analytics.lumberjack.sdk_identifier", jSONObject, "");
    }

    private void setUpdateSDKConfig(JSONObject jSONObject) {
        this.mLatestSDKVersion = (Integer)BaseUtils.getJsonValue("update_sdk_config.latest_version", jSONObject, (Object)1);
        this.mUpdateSDKMsg = (String)BaseUtils.getJsonValue("update_sdk_config.msg", jSONObject, "");
        this.mSDKUpdateAlertEnabled = (Boolean)BaseUtils.getJsonValue("update_sdk_config.enable_alert", jSONObject, Boolean.TRUE);
    }

    private void setBaseConfig(JSONObject jSONObject) {
        this.mConfigEndpoint = (String)BaseUtils.getJsonValue("config_end_point", jSONObject, "");
        this.mConfigEnabled = (Boolean)BaseUtils.getJsonValue("enable", jSONObject, "");
    }

    private void setCheckoutBaseConfig(JSONObject jSONObject) {
        this.setCheckoutEndPoint((String)BaseUtils.getJsonValue("checkout.end_point", jSONObject, ""));
    }

    private void setOtpElfConfig(JSONObject jSONObject) {
        this.isOTPElfEnabled = (Boolean)BaseUtils.getJsonValue("otpelf.enable", jSONObject, Boolean.TRUE);
        this.mOTPElfSettings = (JSONObject)BaseUtils.getJsonValue("otpelf.settings", jSONObject, new JSONObject());
        this.mOTPElfBaseEndPoint = (String)BaseUtils.getJsonValue("otpelf.endpoint", jSONObject, "https://cdn.razorpay.com/static/otpelf/");
        this.mOTPElfVersionFileName = (String)BaseUtils.getJsonValue("otpelf.version_file_name", jSONObject, "version.json");
        this.mOTPElfJsFileName = (String)BaseUtils.getJsonValue("otpelf.js_file_name", jSONObject, "otpelf.js");
    }

    private void setMagicConfig(JSONObject jSONObject) {
        this.isMagicEnabled = (Boolean)BaseUtils.getJsonValue("magic.enable", jSONObject, Boolean.TRUE);
        this.mMagicSettings = (JSONObject)BaseUtils.getJsonValue("magic.settings", jSONObject, new JSONObject());
        this.mMagicBaseEndPoint = (String)BaseUtils.getJsonValue("magic.endpoint", jSONObject, "https://cdn.razorpay.com/static/magic/");
        this.mMagicVersionFileName = (String)BaseUtils.getJsonValue("magic.version_file_name", jSONObject, "version.json");
        this.mMagicJsFileName = (String)BaseUtils.getJsonValue("magic.js_file_name", jSONObject, "magic.js");
    }

    private void setPermissionConfig(JSONObject jSONObject) {
        this.mPermissionCustomMessage = (String)BaseUtils.getJsonValue("permissions.custom_message", jSONObject, "");
        this.mPermissionCustomMessageEnabled = (boolean)((Boolean)BaseUtils.getJsonValue("permissions.enable_custom_message", jSONObject, Boolean.FALSE));
        this.mSmsPermissionMaxAskCount = (Integer)BaseUtils.getJsonValue("permissions.max_ask_count", jSONObject, (Object)0);
    }

    boolean isConfigEnabled() {
        return this.mConfigEnabled;
    }

    String getLumberjackEndpoint() {
        return this.mLumberjackEndpoint;
    }

    String getLumberjackKey() {
        return this.mLumberjackKey;
    }

    Boolean isLumberJackEnabled() {
        return this.mLumberJackEnabled;
    }

    String getConfigEndpoint() {
        return this.mConfigEndpoint;
    }

    int getLatestSDKVersionCode() {
        return this.mLatestSDKVersion;
    }

    String getUpdateSDKMsg() {
        return this.mUpdateSDKMsg;
    }

    boolean isSDKUpdateAlertEnabled() {
        return this.mSDKUpdateAlertEnabled;
    }

    String getPermissionCustomMessage() {
        return this.mPermissionCustomMessage;
    }

    Boolean isPermissionCustomMessageEnabled() {
        return this.mPermissionCustomMessageEnabled;
    }

    int getSmsPermissionMaxAskCount() {
        return this.mSmsPermissionMaxAskCount;
    }

    Boolean isOTPElfEnabled() {
        return this.isOTPElfEnabled;
    }

    JSONObject getOTPElfSettings() {
        return this.mOTPElfSettings;
    }

    String getCheckoutEndpoint() {
        return "https://api.razorpay.com" + this.mCheckoutEndpoint;
    }

    void setCheckoutEndPoint(String string) {
        this.mCheckoutEndpoint = string;
    }

    String getLumberjackSdkIdentifier() {
        return this.mLumberjackSdkIdentifier;
    }

    String getOTPElfBaseEndPoint() {
        return this.mOTPElfBaseEndPoint;
    }

    String getOTPElfJsFileName() {
        return this.mOTPElfJsFileName;
    }

    String getOtpElfVersionUrl() {
        return this.getOTPElfBaseEndPoint() + this.mOTPElfVersionFileName;
    }

    String getOtpElfJsUrl() {
        return this.getOTPElfBaseEndPoint() + this.mOTPElfJsFileName;
    }

    static void fetchConfig(String string, Map<String, String> map, Context context) {
        e_$r$.a(string, map, new r$_Y_(context));
    }

    static void getAdvertisingIdFromUtil(Context context) {
        if (BaseConfig.getAdvertisingId(context) == null) {
            AdvertisingIdUtil.getId(context, new Y$_o$(context));
        }
    }

    protected static Uri.Builder getFetchConfigBuilder(Uri.Builder builder, Context context, String string) {
        builder.appendQueryParameter("merchant_key_id", string).appendQueryParameter("android_version", Build.VERSION.RELEASE).appendQueryParameter("device_id", BaseConfig.getAdvertisingId(context)).appendQueryParameter("device_manufacturer", Build.MANUFACTURER).appendQueryParameter("device_model", Build.MODEL).appendQueryParameter("network_type", BaseUtils.getDataNetworkType(context).getNetworkTypeName()).appendQueryParameter("cellular_network_type", BaseUtils.getCellularNetworkType(context)).appendQueryParameter("cellular_network_provider", BaseUtils.getCellularNetworkProviderName(context)).appendQueryParameter("app_package_name", context.getApplicationContext().getPackageName()).appendQueryParameter("build_type", BaseUtils.getAppBuildType(context)).appendQueryParameter("magic_version_code", String.valueOf(n$_B$.c)).appendQueryParameter("rzpassist_version_code", String.valueOf(n$_B$.b)).appendQueryParameter("webview_user_agent", BaseUtils.getWebViewUserAgent(context).toString());
        return builder;
    }

    protected static String getBaseCurrentConfigVersion(Context object) {
        object = BaseConfig.getConfigVersionFromPreferences(object);
        return object;
    }

    static String getCurrentConfigVersionTag(String object) {
        Object object2 = Pattern.compile("^(\\d+\\.)(\\d+\\.)(\\d+)$");
        object = ((Pattern)object2).matcher((CharSequence)object);
        object2 = null;
        if (((Matcher)object).find()) {
            object2 = ((Matcher)object).replaceFirst("$1$2*");
        }
        return object2;
    }

    private static void setConfigVersionToPreferences(Context context, String string) {
        context = j.b(context);
        context.putString(CONFIG_VERSION, string).apply();
    }

    private static String getConfigVersionFromPreferences(Context context) {
        context = j.a(context);
        return context.getString(CONFIG_VERSION, null);
    }

    private static void saveConfigDataToPreferences(Context context, String string) {
        context = j.b(context);
        context.putString(CONFIG_JSON, string).apply();
    }

    private static String getConfigDataFromPreferences(Context context) {
        context = j.a(context);
        return context.getString(CONFIG_JSON, null);
    }

    private static void setAdvertisingId(Context context, String string) {
        context = j.b(context);
        context.putString(ADVERTISING_ID, string).apply();
    }

    public static String getAdvertisingId(Context context) {
        context = j.a(context);
        return context.getString(ADVERTISING_ID, null);
    }

    public boolean isMagicEnabled() {
        return this.isMagicEnabled;
    }

    public JSONObject getMagicSettings() {
        return this.mMagicSettings;
    }

    String getMagicBaseEndPoint() {
        return this.mMagicBaseEndPoint;
    }

    String getMagicJsFileName() {
        return this.mMagicJsFileName;
    }

    public String getMagicVersionUrl() {
        return this.getMagicBaseEndPoint() + this.mMagicVersionFileName;
    }

    public String getMagicJsUrl() {
        return this.getMagicBaseEndPoint() + this.mMagicJsFileName;
    }

    static String getVersionJSON() {
        return "{\n  \"hash\" : \"MD5\",\n  \"magic_hash\": \"MD5\"\n}\n";
    }

    static String getMagicJs() {
        return "var Magic=function(e){\"use strict\";function t(e){return\"function\"==typeof e}function n(e){return\"string\"==typeof e}function r(e){return e&&\"object\"==typeof e}function o(e,n){if(t(e))return arguments.length>2?e.bind.apply(e,slice(arguments,1)):e.bind(n)}function i(e,t){return Array.prototype.indexOf.call(t,e)}function s(e,t){return-1!==i(e,t)}function a(e,t,n){var r;if(arguments.length<3&&(n=this),e)if(void 0!==e.length)for(r=0;r<e.length;r++)t.call(n,r,e[r]);else for(r in e)e.hasOwnProperty(r)&&t.call(n,r,e[r])}function u(e){return e.replace(/^\\s*/g,\"\").replace(/\\s*$/g,\"\")}function p(e){void 0===e&&(e=\"\");var t=e.split(\"?\")[0];return t=t.split(\";\")[0]}function m(e,t){return t.getAttribute(e)||\"\"}function c(e){return\"hidden\"!==e.getAttribute(\"type\")}function d(e){var t=window.frames[e].frameElement;return\"complete\"===(t.contentDocument||t.contentWindow.document).readyState}function l(e){return te.push(e),te.length}function _(e){for(var t=[],n=arguments.length-1;n-- >0;)t[n]=arguments[n+1];var r=((window.webkit||{}).messageHandlers||{}).OTPElfBridge;if(r)r.postMessage({action:e,params:t});else try{return OTPElfBridge[e].apply(OTPElfBridge,t)}catch(e){}}function f(e){for(var t=[],n=arguments.length-1;n-- >0;)t[n]=arguments[n+1];try{return t=t.map(function(e){return\"object\"==typeof e?JSON.stringify(e):e}),MagicBridge[e].apply(MagicBridge,t)}catch(e){}}function y(){var e=_(\"getFromCustomStorage\",\"OTP.pin\");if(void 0!==e){var t=_(\"getFromCustomStorage\",\"OTP.bank\"),n=_(\"getFromCustomStorage\",\"OTP.sender\");!1===/RZRPAY$/.test(n)&&re(e,n,t),_(\"clearCustomStorage\")}}function b(e){return ue||(window.rzp?(g(window.rzp),ue=!0):window.__rzp_options&&(v(window.__rzp_options),ue=!0)),e?ae[e]:ae}function g(e){var t=ae.plugin.type;switch(e.settings.applicationType){case\"checkout\":t=\"rzpassist\";break;case\"magic\":t=\"magic\"}var n=_(\"isOTPEnabled\")||!1;v({platform:e.settings.platform,merchant_key:e.settings.merchantKey,otp_permission:n,sdk:e.settings.sdk,plugin:{type:t,version_code:e.settings.rzpassist_version_code}})}function h(e){return\"__proto__\"===e||\"constructor\"===e||\"prototype\"===e}function v(e,t,n){if(void 0===n&&(n=ae),e&&!h(e))if(\"object\"==typeof e)for(var r in e)v(r,e[r]);else if(\"object\"==typeof t)for(var r in t)n[e]=n[e]||{},v(r,t[r],n[e]);else n[e]=t}function w(e){var t=k(e);if(!t)return!1;var n=e.index?t.querySelectorAll(e.query)[e.index]:t.querySelector(e.query);return n&&e.condition?!!e.condition(n,window)&&n:n}function k(e){var t=e.frame?window.frames[e.frame]:window;return t=e.form?t.document.forms[e.form]:t.document}function q(e){var t,r=Q.forms;for(var o in r)if(r[o]===e&&(t=o,n(o)))break;return t}function I(e,t){void 0===t&&(t={}),t=Object.assign(t,P()),e=\"otpelf:\"+e,ve?_(\"trackEvent\",e):_(\"trackEvent\",e,JSON.stringify(t))}function S(e){var t=A(e);return!!(e&&t.length>0)&&{view_types:t}}function C(e){var t=S(e);t?I(\"known_page_loaded\",t):Se||x(e)}function x(e){var t=function(e){var t=e.target;if(s(t.nodeName,[\"INPUT\",\"BUTTON\",\"A\"])){Ce||(I(\"unknown_page_loaded\"),Ce=!0);try{var n={};n.element=t.nodeName,n.id=t.id||\"\",n.name=m(\"name\",t),n.value=\"A\"===t.nodeName?t.innerText:t.value;var r=t.form;r&&r.contains(t)&&(n.form_index=q(r)),I(\"bank_page_interaction\",n)}catch(e){}}};document.addEventListener(\"click\",t),document.addEventListener(\"dblclick\",t)}function P(){return{url:location.href,strippedUrl:p(location.href),method:b(\"payment_data\").method,plugin_type:b(\"plugin\").type,plugin_version_code:b(\"plugin\").version_code}}function T(e){for(var t=0;t<xe.length;t++)if(e.match(xe[t].regex))return R(xe[t]),xe[t]}function O(e){for(var t=0;t<xe.length;t++)if(e.match(xe[t].regex))return xe[t].banks||[]}function B(e,t){for(var n=0;n<t.length;n++){var r=e[t[n]],o=w(r);if(!o)return!1;if(!r.bypassVisibility&&!c(o))return!1}return!0}function A(e){if(void 0===e)return[];for(var t=e.view_rules,n=[],r=0;r<t.length;r++)B(e,t[r].elements)&&n.push(t[r].type);return n}function E(e,t){if(e)for(var n=e.view_rules,r=0;r<n.length;r++)if(n[r].type===t)return n[r]}function R(e){e.logged_in_element&&document.querySelector(e.logged_in_element.query)&&I(\"netbanking_user_loggedin\")}function N(e){if(Te[e])return Te[e];for(var t=Pe.specific,n=0,r=t.length;n<r;n++){var o=t[n];if(new RegExp(o.matches.sender+\"$\",\"i\").test(e))return Te[e]=o,o}return null}function D(e){var t=N(e.sender);return t?t.bank:null}function M(e){var t=e.message,n=e.sender;if(!n||!t)return null;var r=N(n);if(r&&new RegExp(r.matches.message).test(e.message)){var o=new RegExp(r.pattern),i=e.message.match(o);if(i&&i.length)return i[0]}return F(e)}function F(e){for(var t=Pe.generic,n=t.textPatterns,r=t.otpPatterns,o=0,i=n.length;o<i;o++)if(new RegExp(n[o],\"i\").test(e.message))for(var s=0,a=r.length;s<a;s++){var u=r[s],p=e.message.match(u);if(p&&p[0])return p[0]}return null}function U(e){se||(se=W()),Oe.push(e)}function W(){return l(function(e){O(location.href);var t=D(e),n=M(e);if(n)for(var r={otp:n,bank:t,sender:e.sender},o=0;o<Oe.length;o++)Oe[o](r)})}function L(e){if(e&&e.check){var t=w(e.check);if(t){t.checked=!0;try{t.dispatchEvent(new Event(\"input\")),t.dispatchEvent(new Event(\"change\"))}catch(e){}}}}function H(e){if(e){if(A(e).indexOf(\"choice\")>=0){var t=E(e,\"choice\");if(\"radio\"!==(t&&(t.choice_type||\"radio\")))return}if(e.choice_submit){var n=w(e.choice_submit);n&&n.click()}}}function Y(e){w(e.otp_choice).click(),H(e),I(\"otp_auth_selected\")}function j(e){w(e.password_choice).click(),H(e),I(\"password_auth_selected\")}function K(e,t){var n=w(e.otp_input);n.value=t;try{n.dispatchEvent(new Event(\"input\")),n.dispatchEvent(new Event(\"change\"))}catch(e){}I(\"bank_otp_autofilled\")}function G(e){var t=w(e.otp_submit);return!!t&&(t.click(),I(\"bank_otp_submitted\"),!0)}function z(e){var t=w(e.proceed_submit);return!!t&&(t.click(),!0)}function V(e){if(!e.resend_otp)return!1;var t=w(e.resend_otp);return!!t&&(t.click(),!0)}function J(e){if(!e||!e.error_message)return null;var t=w(e.error_message);if(t){var n=u(t.innerHTML);return n?n.replace(/<\\/?[^>]+(>|$)/g,\"\"):null}return null}function $(e){function t(t){void 0===t&&(t={}),n.indexOf(\"proceed\")>=0?(Be.emit(\"page_resolved\",n[0]),Be.emit(\"proceed\")):n.indexOf(\"choice\")>=0&&\"choice\"!==t.previous_rule?B(e,e.view_rules[0].elements)?Be.emit(\"page_resolved\",{type:n[0],data:{choices:e.view_rules[0].elements}}):(Be.emit(\"page_resolved\",n[0]||\"unknown\"),Be.emit(\"abort_magic\",Ae.ElementNotFoundOnPage)):Be.emit(\"page_resolved\",t.next_rule||n[0]||\"unknown\");var r=J(e);r&&(!e.false_error_messages||e.false_error_messages.indexOf(r)<0)&&Be.emit(\"error_message\",r)}var n=A(e);Be.on(\"abort_magic\",function(e){void 0===e&&(e=Ae.default),X({action:\"abort_magic\",data:e})}),Be.on(\"page_unload\",function(e){void 0===e&&(e={}),X({action:\"page_unload\",data:e})}),Be.on(\"select_choice\",function(n){var r=n.choice;void 0===r&&(r=\"\");{if(e)return\"password\"===r.toLowerCase()?(j(e),void Be.emit(\"abort_magic\",Ae.PasswordChosen)):void(\"otp\"===r.toLowerCase()?(Y(e),e.choice_otp&&t({previous_rule:\"choice\",next_rule:\"otp\"})):Be.emit(\"abort_magic\",Ae.InvalidChoice));Be.emit(\"abort_magic\",Ae.RuleIsUndefined)}}),Be.on(\"submit_otp\",function(t){var r=t.otp;e?n.indexOf(\"otp\")>=0&&(K(e,r),G(e)):Be.emit(\"abort_magic\",Ae.RuleIsUndefined)}),Be.on(\"resend_otp\",function(){e?V(e)?Be.emit(\"otp_resent\",!0):Be.emit(\"abort_magic\",Ae.FailedToResendOTP):Be.emit(\"abort_magic\",Ae.RuleIsUndefined)}),Be.on(\"otp_resent\",function(e){X({action:\"otp_resent\",data:e})}),Be.on(\"load\",function(){e&&t()}),Be.on(\"page_resolved\",function(t){\"string\"==typeof t&&(t={type:t,otp_permission:b(\"otp_permission\")}),e&&(t.bank=e.banks&&e.banks[0]||\"unknown\"),X({action:\"page_resolved\",data:t})}),Be.on(\"proceed\",function(){e?(L(e),z(e)):Be.emit(\"abort_magic\",Ae.RuleIsUndefined)}),Be.on(\"error_message\",function(e){X({action:\"error_message\",data:e})}),Be.on(\"otp_parsed\",function(e){X({action:\"otp_parsed\",data:e})})}function X(e){return f(\"relay\",e)}var Z=window,Q=Z.document,ee=(Q.documentElement,Q.body,o(Q.querySelector,Q)),te=(o(Q.querySelectorAll,Q),o(Q.getElementById,Q),o(Z.getComputedStyle,Z),[]),ne={setSms:function(e){for(var t=0;t<te.length;t++)te[t](e)}};window.elfBridge=ne;var re=function(e,t,n){var r={message:e,sender:t};ne.setSms(r)},oe={loadCSS:function(e){}},ie=function(){this.listenerPool={}};ie.prototype.on=function(e,n){this.listenerPool[e]||(this.listenerPool[e]=[]);var o,s=this.listenerPool[e];if(t(n))o={callback:n};else{if(!r(n))return!1;o=n}return s.push(o),{remove:function(){var e=i(s,o);e>=0&&s.splice(e,1)}}},ie.prototype.off=function(e){var t=this;e?delete this.listenerPool[e]:a(this.listenerPool,function(e){delete t.listenerPool[e]})},ie.prototype.emit=function(e){for(var t=[],n=arguments.length-1;n-- >0;)t[n]=arguments[n+1];var r=this.listenerPool[e]||[];a(r,function(e){var n=r[e].callback;n&&n.apply(n,t)})};var se,ae={platform:null,merchant_key:null,otp_permission:!1,sdk:{type:null,version_code:null},preferences:{autosubmit_otp:!1,theme_color:\"#168AFA\"},plugin:{type:null,version_code:null},payment_data:{method:null,bank:null,wallet:null,vpa:null,amount:0,razorpay_otp:!1}},ue=!1,pe=[{regex:\"secure4.arcot.com/acspage/cap\",view_rules:[{type:\"otp\",elements:[\"otp_input\",\"otp_submit\"]}],otp_submit:{query:\"button#sendotp\",form:\"0\"},otp_input:{query:\"form[name=passwdForm] input[name=otp]\"},resend_otp:{query:\"a\",condition:function(e){return/resend/i.test(e.href)}},banks:[]},{regex:\"secure7.arcot.com/acspage/cap\",view_rules:[{type:\"otp\",elements:[\"otp_input\",\"otp_submit\"]}],otp_submit:{query:\"button#sendotp\",form:\"0\"},otp_input:{query:\"input#enterPIN\",form:\"0\"},banks:[]},{regex:\"secure5.arcot.com/acspage/cap\",view_rules:[{type:\"choice\",elements:[\"otp_choice\",\"password_choice\"]},{type:\"otp\",elements:[\"otp_input\",\"otp_submit\"]}],otp_submit:{query:\"button#sendotp\",form:\"0\"},otp_input:{query:\"input#otpentrypin\",form:\"0\"},check:{query:\"input#disclaimer\",form:\"0\"},choice_submit:{query:\"button#continue\",form:\"0\"},otp_choice:{query:\"input#otp\",form:\"0\"},password_choice:{query:\"input#static\",form:\"0\"},resend_otp:{query:\"span#resend a\",form:\"0\"},error_message:{query:\"div#info_error span\"},banks:[\"INDB\"]}],me=\"(0.0.0.0|localhost|127.0.0.1):1911\",ce=[{regex:me+\"/proceed\",view_rules:[{type:\"proceed\",elements:[\"proceed_submit\"]}],proceed_submit:{query:\"input[type=submit]\",form:\"0\"},check:{query:\"input#otp\",form:\"0\"},banks:[\"DUMMY\"]},{regex:me+\"/enter_otp\",view_rules:[{type:\"otp\",elements:[\"otp_input\",\"otp_submit\"]}],otp_submit:{query:\"input[type=submit]\",form:\"0\"},otp_input:{query:\"input#otp_input\",form:\"0\"},banks:[\"DUMMY\"]},{regex:me+\"/auth_choice\",view_rules:[{type:\"choice\",elements:[\"otp_choice\",\"password_choice\"]}],otp_choice:{query:\"input#otp_input\",form:\"0\"},password_choice:{query:\"input#password_input\",form:\"0\"},choice_submit:{query:\"input[type=submit]\",form:\"0\"},banks:[\"DUMMY\"]}],de=[{regex:\"netsafe.hdfcbank.com/ACSWeb/jsp/dynamicAuth.jsp\",view_rules:[{type:\"otp\",elements:[\"otp_input\",\"otp_submit\"]}],otp_submit:{query:\"input#cmdSubmit\",form:\"0\"},otp_input:{query:\"input#txtOtpPassword\",form:\"0\"},resend_otp:{query:\"#otpBtnReGen\",form:\"0\"},error_message:{query:\".errorType p:not(.successColor)\"},false_error_messages:\"This is your last attempt to generate the OTP\",banks:[\"HDFC\"]},{regex:\"netsafe.hdfcbank.com/ACSWeb/authJsp/authImprovedHopsTxnPage.jsp\",view_rules:[{type:\"otp\",elements:[\"otp_input\",\"otp_submit\"]}],otp_submit:{query:\"#cmdSubmit\",form:\"0\"},otp_input:{query:\"input#txtOtpPassword\",form:\"0\"},resend_otp:{query:\"#otpBtnReGen\",form:\"0\"},error_message:{query:\"form .errormsg\"},false_error_messages:\"This is your last attempt to generate the OTP\",banks:[\"HDFC\"]},{regex:\"netsafe.hdfcbank.com/ACSWeb/authJsp/authImprovedTxnPage.jsp\",view_rules:[{type:\"choice\",elements:[\"password_choice\",\"otp_choice\"],choice_type:\"button\"},{type:\"otp\",elements:[\"otp_input\",\"otp_submit\"]}],choice_otp:!0,password_choice:{query:\"button#staticAuthOpen\"},otp_choice:{query:\"button#dynamicAuthOpen\"},otp_submit:{query:\"#cmdSubmitDynamic\",form:\"0\"},otp_input:{query:\"input#txtOtpPassword\",form:\"0\"},resend_otp:{query:\"#otpBtnReGen\",form:\"0\"},error_message:{query:\"form .errormsg\"},banks:[\"HDFC\"]},{regex:\"netbanking.hdfcbank.com/netbanking/merchant\",frame:1,view_rules:[{type:\"username\",elements:[\"username_input\"]},{type:\"password\",elements:[\"password_input\"]},{type:\"proceed\",elements:[\"proceed_submit\"]},{type:\"otp\",elements:[\"otp_input\",\"otp_submit\"]}],username_input:{query:\"input[name=fldLoginUserId]\",form:\"0\",frame:1},password_input:{query:\"input[name=fldPassword]\",form:\"0\",frame:1},proceed_submit:{query:\"td.login_tab a\",form:\"0\",frame:1},otp_submit:{query:\"img[alt=Submit]\",form:\"1\"},otp_input:{query:\"input[name=fldOtpToken]\",form:\"1\"},secure_image_input:{query:\"input[name=chkrsastu]\",form:0,frame:1},user_details_form:{query:\"form[name=frmLogin] table table\",form:0,frame:1},logged_in_element:{query:'[alt=\"Continue\"]',form:0,frame:1},banks:[\"HDFC\"]},{regex:\"netbanking.hdfcbank.com/netbanking/(entry|epientry)\",view_rules:[{type:\"username\",elements:[\"username_input\"]},{type:\"password\",elements:[\"password_input\"]},{type:\"proceed\",elements:[\"proceed_submit\"]},{type:\"otp\",elements:[\"otp_input\",\"otp_submit\"]}],username_input:{query:\"input[name=fldLoginUserId]\",form:\"0\"},password_input:{query:\"input[name=fldPassword]\",form:\"0\"},proceed_submit:{query:\"td.login_tab a\",form:\"0\"},otp_submit:{query:\"img[alt=Submit]\",form:\"1\"},otp_input:{query:\"input[name=fldOtpToken]\",form:\"1\"},logged_in_element:{query:'[alt=\"Continue\"]',form:0,frame:1},banks:[\"HDFC\"]},{regex:\"netsafe.hdfcbank.com/ACSWeb/jsp/payerAuthOptions.jsp\",view_rules:[{type:\"choice\",elements:[\"otp_choice\",\"password_choice\"]}],otp_choice:{query:\"input[name=acsRadio]\",form:\"0\",index:1},password_choice:{query:\"input[name=acsRadio]\",form:\"0\"},choice_submit:{query:\"input#submitBtn\",form:\"0\"},banks:[\"HDFC\"]}],le=[{regex:\"https://acs.icicibank.com/acspage/cap\",view_rules:[{type:\"proceed\",elements:[\"try_index_proceed\",\"check\",\"proceed_submit\"]},{type:\"otp\",elements:[\"try_index_otp\",\"otp_input\",\"otp_submit\"]}],try_index_proceed:{query:'input[name=tryIndex][value=\"1\"]',form:\"0\",bypassVisibility:!0},try_index_otp:{query:'input[name=tryIndex]:not([value=\"1\"])',form:\"0\",bypassVisibility:!0},check:{query:\"input[name=otpDestinationOption]\",form:\"0\"},proceed_submit:{query:\"#pwdbaseotppage button[type=submit]\",form:\"0\"},otp_input:{query:\"input#txtAutoOtp\",form:\"0\"},otp_submit:{query:\"#PASSWDPAGE button[type=submit]\",form:\"0\"},banks:[\"ICIC\"]},{regex:\"www.3dsecure.icicibank.com/ACSWeb/EnrollWeb/ICICIBank/server/OtpServer\",view_rules:[{type:\"otp\",elements:[\"otp_input\",\"otp_submit\"]}],otp_submit:{query:\"input#cmdSubmit\",form:\"0\"},otp_input:{query:\"input#txtAutoOtp\",form:\"0\"},resend_otp:{query:\"#link\",form:\"0\"},error_message:{query:\".errorType\"},banks:[\"ICIC\"]},{regex:\"(www.3dsecure.icicibank.com/ACSWeb/EnrollWeb/ICICIBank/server/AccessControlServer|www.3dsecure.icicibank.com/ACSWeb/EnrollWeb/ICICIBank/auth/SCode)\",view_rules:[{type:\"proceed\",elements:[\"proceed_submit\"]},{type:\"otp\",elements:[\"otp_input\",\"otp_submit\"]}],proceed_submit:{query:\"input[name=I1]\",form:\"0\"},check:{query:\"input#otpDestinationOption_toMobile_InputId\",form:\"0\"},otp_submit:{query:\"input#cmdSubmit\",form:\"0\"},otp_input:{query:\"input#txtAutoOtp\",form:\"0\"},resend_otp:{query:\"#link\",form:\"0\"},error_message:{query:\".errorType\"},banks:[\"ICIC\"]},{regex:\"shopping.icicibank.com/corp/(BANKAWAY|Finacle)\",view_rules:[{type:\"username\",elements:[\"username_input\"]},{type:\"password\",elements:[\"password_input\"]},{type:\"proceed\",elements:[\"proceed_submit\"]},{type:\"otp\",elements:[\"otp_input\",\"otp_submit\"]}],username_input:{query:\"input[name='AuthenticationFG.USER_PRINCIPAL']\",form:\"0\"},password_input:{query:\"input[name='AuthenticationFG.ACCESS_CODE']\",form:\"0\"},proceed_submit:{query:\"input#VALIDATE_CREDENTIALS\",form:\"0\"},otp_input:{query:\"input[id='TranRequestManagerFG.ONE_TIME_PASSWORD__']\"},otp_submit:{query:\"input[id='SUBMIT_TRANSACTION']\",form:\"0\"},banks:[\"ICIC\"]},{regex:\"shopping.icicibank.com/corp/AuthenticationController\",view_rules:[{type:\"username\",elements:[\"username_input\"]},{type:\"password\",elements:[\"password_input\"]},{type:\"proceed\",elements:[\"proceed_submit\"]},{type:\"otp\",elements:[\"otp_input\",\"otp_submit\"]}],username_input:{query:\"input[name='AuthenticationFG.USER_PRINCIPAL']\",form:\"0\"},password_input:{query:\"input[name='AuthenticationFG.ACCESS_CODE']\",form:\"0\"},proceed_submit:{query:\"input#VALIDATE_CREDENTIALS\",form:\"0\"},otp_input:{query:\"input[id='TranRequestManagerFG.ONE_TIME_PASSWORD__']\"},otp_submit:{query:\"input[id='SUBMIT_TRANSACTION']\",form:\"0\"},logged_in_element:{query:\"input[name='Action.SUBMIT_TRANSACTION']\",form:\"0\"},banks:[\"ICIC\"]}],_e=[{regex:\"merchant.onlinesbi.com/merchant/smsenablehighsecurity.htm\",view_rules:[{type:\"otp\",elements:[\"otp_input\",\"otp_submit\"]}],otp_submit:{query:\"input#confirmButton\"},otp_input:{query:\"input[name=securityPassword]\"},banks:[\"SBIN\"]},{regex:\"acs([0-9]?).onlinesbi.com/bdacs/SBIValidate/V\",view_rules:[{type:\"otp\",elements:[\"otp_input\",\"otp_submit\"]}],otp_submit:{query:\"#form1 .formInputSection .button.next\"},otp_input:{query:\"input[name=customerotp]\"},resend_otp:{query:\".resendBtn a\"},banks:[\"SBIN\"]},{regex:\"acs([0-9]?).onlinesbi.com/bdacs/SBIValidate/M\",view_rules:[{type:\"otp\",elements:[\"otp_input\",\"otp_submit\"]}],otp_submit:{query:\"#form1 .formInputSection .button.next\"},otp_input:{query:\"input[name=customerpin]\"},resend_otp:{query:\".resendBtn a\"},banks:[\"SBIN\"]},{regex:\"merchant.onlinesbi.com/merchant/(merchantprelogin|loginsubmit).htm\",view_rules:[{type:\"username\",elements:[\"username_input\"]},{type:\"password\",elements:[\"password_input\"]},{type:\"proceed\",elements:[\"proceed_submit\"]}],username_input:{query:\"input#username\",form:\"0\"},password_input:{query:\"input#label2\",form:\"0\"},proceed_submit:{query:\"input\",form:\"0\",index:8},banks:[\"SBIN\"]}],fe=[{regex:\"secure.axisbank.com/(acs-web-axis|ACSWeb)/EnrollWeb/AxisBank/server/OtpServer\",view_rules:[{type:\"otp\",elements:[\"otp_input\",\"otp_submit\"]}],otp_submit:{query:\"div#otp a\",form:\"0\"},otp_input:{query:\"input#otpValue\",form:\"0\"},resend_otp:{query:\"div#otp div.resentOtp a\"},error_message:{query:\"span#errorMsg\"},banks:[\"UTIB\"]},{regex:\"secure.axisbank.com/(acs-web-axis|ACSWeb)/EnrollWeb/AxisBank/server/AccessControlServer\",view_rules:[{type:\"choice\",elements:[\"password_choice\",\"otp_choice\"],choice_type:\"link\"},{type:\"otp\",elements:[\"otp_input\",\"otp_submit\"]}],password_choice:{query:\"a#t1_static\"},otp_choice:{query:\"a#t2_otp\"},choice_otp:!0,otp_input:{query:\"input#otpValue\"},otp_submit:{query:\"#otp a.active, a#changeSubmitButton\"},banks:[\"UTIB\"]},{regex:\"retail.axisbank.co.in/wps/portal/rBanking/AxisSMRetailLogin/axissmretailpage/*\",view_rules:[{type:\"username\",elements:[\"username_input\"]},{type:\"password\",elements:[\"password_input\"]},{type:\"proceed\",elements:[\"proceed_submit\"]},{type:\"otp\",elements:[\"otp_input\",\"otp_submit\"]}],username_input:{query:\"input#loginId\",form:\"0\"},password_input:{query:\"input#newPassword\",form:\"0\"},proceed_submit:{query:\"input[name=SMsubmit]\",form:\"0\"},otp_input:{query:\"input[id=orignipdef]\",form:\"0\"},otp_submit:{query:\"input[value=Confirm]\",form:\"0\"},banks:[\"UTIB\"]},{regex:\"retail.axisbank.co.in/wps/myportal/rBanking/AxisSMRetailLogin/axissmrepayments/*\",view_rules:[{type:\"username\",elements:[\"username_input\"]},{type:\"password\",elements:[\"password_input\"]},{type:\"proceed\",elements:[\"proceed_submit\"]},{type:\"otp\",elements:[\"otp_input\",\"otp_submit\"]}],username_input:{query:\"input#loginId\",form:\"0\"},password_input:{query:\"input#newPassword\",form:\"0\"},proceed_submit:{query:\"input[name=SMsubmit]\",form:\"0\"},otp_input:{query:\"input[id=orignipdef]\",form:\"0\"},otp_submit:{query:\"input[value=Confirm]\",form:\"0\"},logged_in_element:{query:\"input[value=Confirm]\",form:0},banks:[\"UTIB\"]}],ye=[{regex:\"www.kotak.com/.*/ksecLogin\",view_rules:[{type:\"username\",elements:[\"username_input\"]},{type:\"password\",elements:[\"password_input\"]},{type:\"proceed\",elements:[\"proceed_submit\"]}],username_input:{query:\"input#crn\",form:\"0\"},password_input:{query:\"input#pswd\",form:\"0\"},proceed_submit:{query:\"a#secure-login01\",form:\"0\"},banks:[\"KKBK\"]}],be=[{regex:\"https://netbanking.yesbank.co.in/netbanking/merchant\",frame:0,view_rules:[{type:\"username\",elements:[\"username_input\"]},{type:\"password\",elements:[\"password_input\"]},{type:\"proceed\",elements:[\"proceed_submit\"]}],username_input:{query:\"input[name=fldLoginUserId]\",frame:0},password_input:{query:\"input[name=fldPassword]\",frame:0},proceed_submit:{query:\"a[href='javascript:void(0);']:not(.bodylink1)\",frame:0},banks:[\"YESB\"]}],ge=[{regex:\"enstage-sas.com/rupay-web-v1/EnrollWeb/NPCI/server/AcquirerHandler\",view_rules:[{type:\"otp\",elements:[\"otp_input\",\"otp_submit\"]}],otp_submit:{query:'a[onclick=\"javascript:return validateOTP()\"]',form:\"0\"},otp_input:{query:\"input#otpPassword\",form:\"0\",condition:function(e,t){var n=t.document.body.querySelector(\"div.transactionArea\");return!!n&&n.innerText.match(/(One Time Password has been sent)/i)}},resend_otp:{query:'a[href=\"javascript:resendotp()\"]',form:\"0\"},banks:[\"RUPAY\"]}],he=[{regex:\"kvbin.com/B001/merchantenc\",view_rules:[],add_meta:!1,banks:[]}],ve=void 0!==window.rzp,we=(void 0!==window.StorageBridge||window.webkit,[\"razorpay.com\"]),ke=Boolean(we.find(function(e){return location.hostname.endsWith(e)})),qe=0===location.hostname.length,Ie=document.querySelectorAll(\"a\").length>20||document.querySelectorAll(\"video\").length>0,Se=ke||qe||Ie,Ce=!1,xe=[].concat(pe,ce,ge,de,le,_e,fe,ye,be,he),Pe={generic:{textPatterns:[\"\\\\bone.time password\\\\b\",\"\\\\bone.time pin\\\\b\",\"\\\\bone.time code\\\\b\",\"\\\\botp\\\\b\"],otpPatterns:[\"\\\\b[0-9]{6,8}\\\\b\"]},specific:[{matches:{sender:\"KOTAKB\",message:\"One Time Password\"},pattern:\"[0-9]{6}\",bank:\"KKBK\",otp_timeout:60},{matches:{sender:\"(HDFCBK|hdfcbk)\",message:\"OTP is\"},type:{debit:[\"mastercard\",\"visa\"]},pattern:\"[0-9]{6}\",bank:\"HDFC\",otp_timeout:60},{matches:{sender:\"FROMSC\",message:\"Your One-Time Password\"},pattern:\"[0-9]{6}\",bank:\"SYNB\",otp_timeout:60},{matches:{sender:\"ICICIB\",message:\"Your One-Time Password to create a 3D Secure PIN\"},pattern:\"[0-9]{6}\",type:{debit:[\"mastercard\",\"visa\"]},bank:\"ICIC\",otp_timeout:60},{matches:{sender:\"ICICIB\",message:\"Your One Time Password is\"},pattern:\"[0-9]{6}\",type:{credit:[\"mastercard\",\"visa\"]},bank:\"ICIC\",otp_timeout:60},{matches:{sender:\"ICICIB\",message:\"to complete your Internet Banking Transaction\"},pattern:\"[0-9]{6}\",bank:\"ICIC\",otp_timeout:60},{matches:{sender:\"CITIBK\",message:\"Onetime password\"},pattern:\"[0-9]{6}\",bank:\"CITI\",otp_timeout:60},{matches:{sender:\"SBICRD\",message:\"OTP for trxn\"},pattern:\"[0-9]{6}\",bank:\"SBIN\",otp_timeout:60},{matches:{sender:\"SBIINB\",message:\"TP for transaction\"},pattern:\"[0-9]{8}\",bank:\"SBIN\",otp_timeout:60},{matches:{sender:\"(SBIACS|SBIOTP)\",message:\"One Time Password\"},pattern:\"[0-9]{6}\",type:{debit:[\"mastercard\",\"visa\"]},bank:\"SBIN\",otp_timeout:60},{matches:{sender:\"HSBCIN\",message:\"Onetime password\"},pattern:\"[0-9]{6}\",bank:\"HSBC\",otp_timeout:60},{matches:{sender:\"AXISBK\",message:\"your NETSECURE code is\"},pattern:\"[0-9]{8}\",bank:\"UTIB\",otp_timeout:50},{matches:{sender:\"PNBACS\",message:\"Your One Time Password\"},type:{debit:[\"mastercard\"]},pattern:\"[0-9]{6}\",bank:\"PUNB\",otp_timeout:50},{matches:{sender:\"INDBNK\",message:\"One Time Password for Online transaction\"},pattern:\"(?<![0-9])[0-9]{6}(?![0-9])\",bank:\"IDIB\"},{matches:{sender:\"FCHRGE\",message:\"is your OTP login\"},pattern:\"[0-9]{4}\",bank:\"FRCHG\"},{matches:{sender:\"DUMMY\",message:\"Your OTP for the transaction\"},pattern:\"[0-9]{6}\",bank:\"DUMMY\"}]},Te={},Oe=[],Be=new ie,Ae={default:{code:0,message:\"Something went wrong!\"},RuleIsUndefined:{code:1,message:\"Rule is undefined.\"},PasswordChosen:{code:2,message:\"Password is chosen.\"},InvalidChoice:{code:4,message:\"Choice is invalid.\"},FailedToResendOTP:{code:5,message:\"Failed to resend OTP.\"},ElementNotFoundOnPage:{code:6,message:\"Element was not found on the page.\"}},Ee=location.href.startsWith(\"https://api.razorpay.com/v1/checkout\"),Re=function(e){Be.emit(\"load\");var t=A(e);C(e),e&&t.length?ve&&y():e||Be.emit(\"page_resolved\",\"unknown\")},Ne=window.onbeforeunload?\"beforeunload\":\"unload\";window.addEventListener(Ne,function(e){Be.emit(\"page_unload\")});var De=function(e){e&&e.frame?(d(e.frame)&&Re(e),window.frames[e.frame].frameElement.addEventListener(\"load\",function(t){Re(e)})):Re(e)};return function(){var e=T(location.href);$(e),De(e),U(function(e){Be.emit(\"otp_parsed\",e)}),Ee&&l(function(e){window.handleOTP&&window.handleOTP(e.message)})}(),e.elfBridge=ne,e.showOTP=re,e.view=oe,e.handleRelay=function(e){\"string\"==typeof e&&(e=JSON.parse(e));var t=e.action,n=e.data;switch(t){case\"select_choice\":case\"submit_otp\":case\"resend_otp\":Be.emit(t,n)}},e.getElementByRule=w,e.getParentByRule=k,e.getRuleByElement=function(e){var t,n=e.nodeName.toLowerCase(),r=m(\"id\",e),o=m(\"name\",e),s=e.form;if(r)n+=\"#\"+r;else if(o){var a=\"[name=\"+o+\"]\";try{ee(n+a),n+=a}catch(e){}}var u={query:n};return s&&s.contains(e)&&void 0!==(t=q(s))&&(u.form=t),void 0!==t&&s.querySelector(n)!==e&&(u.index=i(e,s.querySelectorAll(n))),u},e.getFormIndex=q,e}({});\n";
    }

    static /* synthetic */ void access$000(Context context, String string) {
        BaseConfig.saveConfigDataToPreferences(context, string);
    }

    static /* synthetic */ void access$100(Context context, String string) {
        BaseConfig.setConfigVersionToPreferences(context, string);
    }

    static /* synthetic */ void access$200(Context context, String string) {
        BaseConfig.setAdvertisingId(context, string);
    }
}

