/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.TextUtils;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsProperty;
import com.razorpay.AnalyticsProperty$Scope;
import com.razorpay.BaseUtils;
import com.razorpay.D$$l_;
import com.razorpay.U$$U$;
import com.razorpay.U_$B$;
import com.razorpay.X$_8_;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import proguard.annotation.Keep;
import proguard.annotation.KeepClassMembers;

@Keep
@KeepClassMembers
class AnalyticsUtil {
    private static boolean isAnalyticsInitialized = false;
    static CharSequence MERCHANT_APP_NAME;
    static int MERCHANT_APP_BUILD;
    static CharSequence MERCHANT_APP_VERSION;
    static CharSequence MERCHANT_APP_NAMESPACE;
    static String FRAMEWORK;
    static String KEY_TYPE;
    static String BUILD_TYPE;
    private static String localPaymentId;
    private static String localOrderId;
    private static String sdkType;
    private static int sdkVersionCode;
    private static String sdkVersion;
    static String libraryType;
    static int sessionErroredApiCalls;

    AnalyticsUtil() {
    }

    static void setup(Context context, String string, String string2, int n, String string3) {
        sdkType = string2;
        sdkVersionCode = n;
        sdkVersion = string3;
        AnalyticsUtil.setAppDetails(context, string);
        AnalyticsUtil.init(context, string);
    }

    private static void init(Context context, String string) {
        if (context == null) {
            throw new RuntimeException("Context not set");
        }
        if (string == null) {
            throw new RuntimeException("Merchant key not set");
        }
        U$$U$.a(context, sdkType, sdkVersion);
        U$$U$.b("merchant_key", (Object)string);
        U$$U$.b("merchant_package", (Object)context.getPackageName());
        X$_8_.a(context);
        isAnalyticsInitialized = true;
    }

    static String getBuildType() {
        return BUILD_TYPE;
    }

    static String getKeyType() {
        return KEY_TYPE;
    }

    static void trackEvent(AnalyticsEvent analyticsEvent) {
        U$$U$.a(analyticsEvent.getEventName());
    }

    static void postData() {
        if (isAnalyticsInitialized) {
            U$$U$.a();
        }
    }

    static void trackEvent(AnalyticsEvent analyticsEvent, Map<String, Object> map) {
        U$$U$.a(analyticsEvent.getEventName(), map);
    }

    static void trackEvent(AnalyticsEvent analyticsEvent, JSONObject jSONObject) {
        U$$U$.a(analyticsEvent.getEventName(), jSONObject);
    }

    static void addProperty(String string, AnalyticsProperty analyticsProperty) {
        if (analyticsProperty.scope == AnalyticsProperty$Scope.PAYMENT) {
            U$$U$.a(string, analyticsProperty.value);
            return;
        }
        if (analyticsProperty.scope == AnalyticsProperty$Scope.ORDER) {
            U$$U$.b(string, analyticsProperty.value);
        }
    }

    static void addFilteredPropertiesFromPayload(JSONObject jSONObject) {
        U$$U$.a(jSONObject);
    }

    static String getAppDetail() {
        if (isAnalyticsInitialized) {
            return MERCHANT_APP_NAME + "-" + MERCHANT_APP_VERSION + "-" + MERCHANT_APP_BUILD;
        }
        return null;
    }

    static void trackPage(String string, String string2) {
        U$$U$.a(string, string2);
    }

    static void reportError(Exception exception, String string, String string2) {
        AnalyticsUtil.trackEvent(AnalyticsEvent.ERROR_LOGGED, AnalyticsUtil.getJSONErrorResponse(AnalyticsUtil.getErrorProperties(string, string2)));
        if ((string.equalsIgnoreCase("S0") || string.equalsIgnoreCase("S1")) && sessionErroredApiCalls <= 0) {
            U$$U$.b(string);
            ++sessionErroredApiCalls;
        }
    }

    static void reportError(AbstractMethodError abstractMethodError, String string, String string2) {
        AnalyticsUtil.trackEvent(AnalyticsEvent.ERROR_LOGGED, AnalyticsUtil.getJSONErrorResponse(AnalyticsUtil.getErrorProperties(string, string2)));
        if ((string.equalsIgnoreCase("S0") || string.equalsIgnoreCase("S1")) && sessionErroredApiCalls <= 0) {
            U$$U$.b(string);
            ++sessionErroredApiCalls;
        }
    }

    static Map<String, Object> getErrorProperties(String string, String string2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("severity", string);
        hashMap.put("unhandled", Boolean.TRUE);
        hashMap.put("source", "self");
        hashMap.put("stack", "");
        hashMap.put("message", string2);
        return hashMap;
    }

    static JSONObject getAnalyticsDataForCheckout(Context object) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("platform", (Object)"mobile_sdk");
            jSONObject.put("platform_version", (Object)sdkVersion);
            jSONObject.put("os", (Object)"android");
            jSONObject.put("os_version", (Object)Build.VERSION.RELEASE);
            if (U_$B$.a((Context)object)) {
                jSONObject.put("device", (Object)"tablet");
            } else {
                jSONObject.put("device", (Object)"mobile");
            }
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception, "critical", ((Throwable)object).getMessage());
        }
        return jSONObject;
    }

    static void trackPageLoadStart(String string) {
        AnalyticsEvent analyticsEvent = AnalyticsUtil.isCheckoutUrl(string) ? AnalyticsEvent.CHECKOUT_PAGE_LOAD_START : AnalyticsEvent.PAGE_LOAD_START;
        AnalyticsUtil.trackEvent(analyticsEvent, AnalyticsUtil.getJSONResponse(AnalyticsUtil.getPageLoadStartProperties(string)));
    }

    static Map<String, Object> getPageLoadStartProperties(String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("url", string);
        return hashMap;
    }

    static void trackPageLoadEnd(String string, long l2) {
        AnalyticsEvent analyticsEvent = AnalyticsUtil.isCheckoutUrl(string) ? AnalyticsEvent.CHECKOUT_PAGE_LOAD_FINISH : AnalyticsEvent.PAGE_LOAD_FINISH;
        AnalyticsUtil.trackEvent(analyticsEvent, AnalyticsUtil.getJSONResponse(AnalyticsUtil.getPageLoadEndProperties(string, l2)));
    }

    static boolean isCheckoutUrl(String string) {
        return string.indexOf(D$$l_.a().getCheckoutEndpoint()) == 0;
    }

    static Map<String, Object> getPageLoadEndProperties(String string, long l2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("url", string);
        hashMap.put("page_load_time", (double)l2 / 1.0E9);
        return hashMap;
    }

    static void reset() {
        isAnalyticsInitialized = false;
        localPaymentId = null;
        localOrderId = null;
        U$$U$.b();
    }

    static void setAppDetails(Context context, String string) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            MERCHANT_APP_NAME = AnalyticsUtil.returnUndefinedIfNull(packageInfo.applicationInfo.loadLabel(packageManager));
            MERCHANT_APP_VERSION = AnalyticsUtil.returnUndefinedIfNull(packageInfo.versionName);
            MERCHANT_APP_NAMESPACE = AnalyticsUtil.returnUndefinedIfNull(packageInfo.packageName);
            MERCHANT_APP_BUILD = packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            PackageManager.NameNotFoundException nameNotFoundException2 = nameNotFoundException;
            AnalyticsUtil.reportError((Exception)((Object)nameNotFoundException), "S0", nameNotFoundException2.getMessage());
        }
        BUILD_TYPE = BaseUtils.getAppBuildType(context);
        KEY_TYPE = AnalyticsUtil.getKeyType(string);
    }

    static String getKeyType(String string) {
        if (AnalyticsUtil.isNullOrEmpty(string)) {
            return null;
        }
        if ((string = string.substring(0, 8)).equals("rzp_live")) {
            return "live";
        }
        if (string.equals("rzp_test")) {
            return "test";
        }
        return null;
    }

    static boolean isNullOrEmpty(CharSequence charSequence) {
        return TextUtils.isEmpty((CharSequence)charSequence) || TextUtils.getTrimmedLength((CharSequence)charSequence) == 0;
    }

    static CharSequence returnUndefinedIfNull(CharSequence charSequence) {
        if (AnalyticsUtil.isNullOrEmpty(charSequence)) {
            return "undefined";
        }
        return charSequence;
    }

    static String getLocalPaymentId() {
        if (localPaymentId == null) {
            localPaymentId = AnalyticsUtil.getUniqueId();
        }
        return localPaymentId;
    }

    static String getLocalOrderId() {
        if (localOrderId == null) {
            localOrderId = AnalyticsUtil.getUniqueId();
        }
        return localOrderId;
    }

    static void refreshPaymentSession() {
        localPaymentId = AnalyticsUtil.getUniqueId();
        U$$U$.c();
    }

    static void refreshOrderSession() {
        localOrderId = AnalyticsUtil.getUniqueId();
        localPaymentId = AnalyticsUtil.getUniqueId();
        U$$U$.d();
        U$$U$.c();
    }

    static void setLocalOrderId(String string) {
        localOrderId = string;
    }

    static String getUniqueId() {
        long l2 = (System.currentTimeMillis() - 1388534400000L) * 1000000L;
        long l3 = (long)Math.floor(1.4776336E7 * Math.random());
        return AnalyticsUtil.tobase62(l2) + AnalyticsUtil.tobase62(l3);
    }

    static String tobase62(long l2) {
        String[] stringArray = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".split("");
        String string = "";
        while (l2 > 0L) {
            int n = (int)(l2 % 62L);
            string = String.valueOf(stringArray[n]) + string;
            l2 = (long)Math.floor(l2 / 62L);
        }
        return string;
    }

    static void reportUncaughtException(Throwable object) {
        object = AnalyticsUtil.getStackTrace((Throwable)object);
        AnalyticsUtil.trackEvent(AnalyticsEvent.ERROR_LOGGED, AnalyticsUtil.getJSONResponse(AnalyticsUtil.getErrorProperties("S0", (String)object)));
    }

    static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        throwable.printStackTrace(printWriter);
        return stringWriter.getBuffer().toString();
    }

    static void setFramework(String string) {
        FRAMEWORK = string;
    }

    static String getFramework() {
        if (AnalyticsUtil.isNullOrEmpty(FRAMEWORK)) {
            return "native";
        }
        return FRAMEWORK;
    }

    public static void saveEventsToPreferences(Context context) {
        U$$U$.a(context);
    }

    public static JSONObject getExtraAnalyticsPayload() {
        return U$$U$.e();
    }

    public static JSONObject getJSONResponse(String string) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("response", (Object)string);
            return jSONObject;
        }
        catch (JSONException jSONException) {
            return new JSONObject();
        }
    }

    public static JSONObject getJSONResponse(Map<String, Object> object) {
        JSONObject jSONObject = new JSONObject();
        for (Map.Entry entry : object.entrySet()) {
            try {
                jSONObject.put((String)entry.getKey(), entry.getValue());
            }
            catch (JSONException jSONException) {
                JSONException jSONException2 = jSONException;
                AnalyticsUtil.reportError((Exception)((Object)jSONException), "S0", "Error adding analytics property " + (String)entry.getKey() + " to JSONObject");
            }
        }
        return jSONObject;
    }

    public static JSONObject getJSONErrorResponse(Map<String, Object> map) {
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = new JSONObject();
        try {
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("severity", map.get("severity"));
            jSONObject3.put("unhandled", map.get("unhandled"));
            jSONObject3.put("source", map.get("source"));
            JSONObject jSONObject4 = new JSONObject();
            jSONObject4.put("stack", (Object)"");
            jSONObject4.put("message", map.get("message"));
            jSONObject4.put("tags", (Object)jSONObject3);
            jSONObject2.put("error", (Object)jSONObject4);
            jSONObject.put("data", (Object)jSONObject2);
            return jSONObject;
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "S0", "Error adding analytics property " + map.get("message") + " to JSONObject");
            return jSONObject;
        }
    }

    static {
        sdkType = "standealone";
        sessionErroredApiCalls = 0;
    }
}

