/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.net.Uri;
import android.text.TextUtils;
import com.razorpay.AnalyticsUtil;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RzpGpayUtilMerged {
    private static final String GOOGLE_PAY = "GOOGLE_PAY";
    private static final String GPAY_INAPP = "gpay_inapp";
    private static final String GPAY_MERGED = "gpay_merged";

    static JSONObject getIsReadyToPayRequest() {
        try {
            JSONObject jSONObject = RzpGpayUtilMerged.getBaseRequest();
            jSONObject.put("allowedPaymentMethods", (Object)new JSONArray().put((Object)RzpGpayUtilMerged.getBaseUPIPaymentMethod()));
            return jSONObject;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "error:exception", jSONException.getMessage());
            return null;
        }
    }

    static JSONObject getCardsIsReadyToPayRequest() {
        try {
            JSONObject jSONObject = RzpGpayUtilMerged.getBaseRequest();
            jSONObject.put("allowedPaymentMethods", (Object)new JSONArray().put((Object)RzpGpayUtilMerged.getBaseCardPaymentMethod()));
            return jSONObject;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "error:exception", jSONException.getMessage());
            return null;
        }
    }

    private static JSONObject getBaseRequest() {
        try {
            return new JSONObject().put("apiVersion", 2).put("apiVersionMinor", 0);
        }
        catch (JSONException jSONException) {
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "error:exception", jSONException.getMessage());
            jSONException.printStackTrace();
            return null;
        }
    }

    private static JSONObject getBaseCardPaymentMethod() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("type", (Object)"CARD");
            jSONObject.put("parameters", (Object)new JSONObject().put("allowedCardNetworks", (Object)RzpGpayUtilMerged.getAllowedCardNetworks()));
            return jSONObject;
        }
        catch (JSONException jSONException) {
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "error:exception", jSONException.getLocalizedMessage());
            jSONException.printStackTrace();
            return null;
        }
    }

    private static JSONArray getAllowedCardNetworks() {
        return new JSONArray().put((Object)"MASTERCARD").put((Object)"VISA");
    }

    private static JSONObject getBaseUPIPaymentMethod() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("type", (Object)"UPI");
            return jSONObject;
        }
        catch (JSONException jSONException) {
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "error:exception", jSONException.getMessage());
            jSONException.printStackTrace();
            return null;
        }
    }

    public static String getPaymentRequestData(String string2, JSONObject jSONObject) {
        try {
            JSONObject jSONObject2 = RzpGpayUtilMerged.getUpiData(string2);
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("apiVersion", 2);
            jSONObject3.put("apiVersionMinor", 0);
            JSONObject jSONObject4 = new JSONObject();
            jSONObject4.put("totalPriceStatus", (Object)"FINAL");
            long l = jSONObject.getLong("amount");
            BigDecimal bigDecimal = new BigDecimal(String.valueOf(l));
            BigDecimal bigDecimal2 = new BigDecimal(100);
            BigDecimal bigDecimal3 = bigDecimal.divide(bigDecimal2);
            jSONObject4.put("totalPrice", (Object)bigDecimal3.toPlainString());
            String string3 = jSONObject.getString("currency");
            jSONObject4.put("currencyCode", (Object)string3);
            jSONObject4.put("transactionNote", jSONObject2.get("description"));
            jSONObject3.put("transactionInfo", (Object)jSONObject4);
            JSONArray jSONArray = new JSONArray();
            JSONObject jSONObject5 = new JSONObject();
            jSONObject5.put("type", (Object)"UPI");
            JSONObject jSONObject6 = new JSONObject();
            jSONObject6.put("payeeVpa", jSONObject2.get("address"));
            jSONObject6.put("payeeName", jSONObject2.get("name"));
            jSONObject6.put("mcc", jSONObject2.get("mc"));
            jSONObject6.put("transactionReferenceId", jSONObject2.get("transactionRefId"));
            jSONObject5.put("parameters", (Object)jSONObject6);
            JSONObject jSONObject7 = new JSONObject();
            jSONObject7.put("type", (Object)"DIRECT");
            jSONObject5.put("tokenizationSpecification", (Object)jSONObject7);
            jSONArray.put((Object)jSONObject5);
            jSONObject3.put("allowedPaymentMethods", (Object)jSONArray);
            return jSONObject3.toString();
        }
        catch (JSONException jSONException) {
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "error:exception", jSONException.getMessage());
            jSONException.printStackTrace();
            return null;
        }
    }

    static JSONObject getUpiData(String string2) {
        JSONObject jSONObject;
        block13: {
            jSONObject = new JSONObject();
            try {
                Object object;
                String string3;
                if (string2.startsWith("upi://")) {
                    string3 = string2;
                } else {
                    object = new JSONObject(string2);
                    JSONObject jSONObject2 = new JSONObject(object.getString("data"));
                    string3 = jSONObject2.getString("intent_url");
                }
                if (!string3.contains("//")) break block13;
                string3 = string3.replaceFirst("upi://", "http://");
                try {
                    object = RzpGpayUtilMerged.splitQuery(new URL(string3));
                    if (!TextUtils.isEmpty((CharSequence)((CharSequence)object.get("pa")))) {
                        jSONObject.put("address", object.get("pa"));
                    }
                    if (!TextUtils.isEmpty((CharSequence)((CharSequence)object.get("pn")))) {
                        jSONObject.put("name", object.get("pn"));
                    }
                    if (!TextUtils.isEmpty((CharSequence)((CharSequence)object.get("am")))) {
                        jSONObject.put("amount", object.get("am"));
                    }
                    if (!TextUtils.isEmpty((CharSequence)((CharSequence)object.get("tn")))) {
                        jSONObject.put("description", object.get("tn"));
                    }
                    if (!TextUtils.isEmpty((CharSequence)((CharSequence)object.get("tr")))) {
                        jSONObject.put("transactionRefId", object.get("tr"));
                    }
                    if (!TextUtils.isEmpty((CharSequence)((CharSequence)object.get("mc")))) {
                        jSONObject.put("mc", object.get("mc"));
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    AnalyticsUtil.reportError(unsupportedEncodingException, "critical", unsupportedEncodingException.getLocalizedMessage());
                    unsupportedEncodingException.printStackTrace();
                }
                catch (MalformedURLException malformedURLException) {
                    AnalyticsUtil.reportError(malformedURLException, "warning", malformedURLException.getLocalizedMessage());
                    malformedURLException.printStackTrace();
                }
            }
            catch (JSONException jSONException) {
                AnalyticsUtil.reportError((Exception)((Object)jSONException), "error:exception", jSONException.getMessage());
                jSONException.printStackTrace();
            }
        }
        return jSONObject;
    }

    private static Map<String, String> splitQuery(URL uRL) {
        String[] stringArray;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        String string2 = uRL.getQuery();
        for (String string3 : stringArray = string2.split("&")) {
            int n = string3.indexOf("=");
            linkedHashMap.put(URLDecoder.decode(string3.substring(0, n), "UTF-8"), URLDecoder.decode(string3.substring(n + 1), "UTF-8"));
        }
        return linkedHashMap;
    }

    static String makeExternalSDKPayload(JSONObject jSONObject) {
        try {
            JSONObject jSONObject2 = new JSONObject();
            jSONObject.put("type", (Object)GPAY_INAPP);
            jSONObject2.put("apiResponse", (Object)jSONObject);
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("provider", (Object)GOOGLE_PAY);
            jSONObject3.put("data", (Object)jSONObject2);
            return jSONObject3.toString();
        }
        catch (JSONException jSONException) {
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "error:exception", jSONException.getMessage());
            jSONException.printStackTrace();
            return "";
        }
    }

    static String makeMergedExternalSDKPayload(JSONObject jSONObject) {
        try {
            JSONObject jSONObject2 = new JSONObject();
            jSONObject.put("type", (Object)GPAY_MERGED);
            jSONObject2.put("apiResponse", (Object)jSONObject);
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("provider", (Object)GOOGLE_PAY);
            jSONObject3.put("data", (Object)jSONObject2);
            return jSONObject3.toString();
        }
        catch (JSONException jSONException) {
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "error:exception", jSONException.getMessage());
            jSONException.printStackTrace();
            return "";
        }
    }

    static String makeApiPayload(JSONObject jSONObject) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = jSONObject.getString(string2);
            stringBuilder.append(String.format("%s=%s&", string2, Uri.encode((String)string3)));
        }
        return stringBuilder.deleteCharAt(stringBuilder.length() - 1).toString();
    }

    static String makeErrorPayload(String string2, String string3) {
        try {
            JSONObject jSONObject = new JSONObject();
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("code", (Object)string2);
            jSONObject2.put("description", (Object)string3);
            jSONObject.put("error", (Object)jSONObject2);
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "error:exception", jSONException.getMessage());
            jSONException.printStackTrace();
            return "{\"error\":{\"code\": \"BAD_REQUEST_ERROR\", \"description\": \"An unknown error occurred.\"}}";
        }
    }

    static String makeMergedExternalSDKErrorPayload(JSONObject jSONObject, int n, String string2) {
        JSONObject jSONObject2 = new JSONObject();
        JSONObject jSONObject3 = new JSONObject();
        try {
            jSONObject3.put("type", (Object)GPAY_MERGED);
            jSONObject3.put("description", (Object)string2);
            jSONObject2.put("apiResponse", (Object)jSONObject3);
            JSONObject jSONObject4 = new JSONObject();
            jSONObject4.put("provider", (Object)GOOGLE_PAY);
            jSONObject4.put("resultCode", n);
            jSONObject4.put("data", (Object)jSONObject2);
            return jSONObject4.toString();
        }
        catch (JSONException jSONException) {
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "error:exception", jSONException.getMessage());
            return RzpGpayUtilMerged.makeExceptionErrorPayload(jSONObject.has("bundle"));
        }
    }

    static String makeExceptionErrorPayload(boolean bl) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("provider", (Object)GOOGLE_PAY);
            jSONObject.put("resultCode", (Object)"1");
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("type", (Object)GPAY_MERGED);
            jSONObject2.put("description", (Object)"Something went wrong please try again.");
            jSONObject.put("data", (Object)jSONObject2);
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return "{\"provider\":\"GOOGLE_PAY\",\"resultCode\":\"1\",\"data\":{\"apiResponse\":{\"type\":\"gpay_merged\",\"description\":\"Something went wrong. Please try again\"}}}";
        }
    }
}

