/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.NonNull;
import com.google.android.apps.nbu.paisa.inapp.client.api.PaymentsClient;
import com.google.android.apps.nbu.paisa.inapp.client.api.Wallet;
import com.google.android.apps.nbu.paisa.inapp.client.api.WalletUtils;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsUtil;
import com.razorpay.BaseUtils;
import com.razorpay.Callback;
import com.razorpay.O_$B_;
import com.razorpay.ResponseObject;
import com.razorpay.RzpGpayUtilMerged;
import com.razorpay.RzpInternalCallback;
import com.razorpay.RzpPlugin;
import com.razorpay.RzpPluginCompatibilityResponse;
import com.razorpay.RzpPluginRegisterCallback;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Objects;
import org.json.JSONException;
import org.json.JSONObject;

class RzpGpayMerged
implements OnCompleteListener<Boolean>,
RzpPlugin {
    private PaymentsClient mPaymentClient;
    private static int LOAD_PAYMENT_DATA_REQUEST_CODE = 1;
    private RzpInternalCallback rzpInternalCallback;
    private JSONObject apiResponse;
    private boolean isUpiOnly = false;
    private Task<Boolean> cardsTask = null;
    private Task<Boolean> upiTask = null;
    private RzpPluginRegisterCallback registerCallback;

    RzpGpayMerged() {
    }

    @Override
    public RzpPluginCompatibilityResponse isCompatible(String string2, int n, String string3) {
        if (string2.equalsIgnoreCase("customui") && n > 27) {
            return new RzpPluginCompatibilityResponse(true, null);
        }
        if (string2.equalsIgnoreCase("checkout") && n > 18) {
            return new RzpPluginCompatibilityResponse(true, null);
        }
        String string4 = string2.equalsIgnoreCase("customui") ? "Razorpay's GooglePay plugin requires a min SDK Version 3.8.8 Please update." : (string2.equalsIgnoreCase("checkout") ? "Razorpay's GooglePay plugin requires a min SDK Version 1.5.6 Please update." : "Incompatible Razorpay sdk version. Please update the base sdk");
        return new RzpPluginCompatibilityResponse(false, string4);
    }

    @Override
    public boolean doesHandlePayload(String string2, JSONObject jSONObject, Activity activity) {
        try {
            if (jSONObject != null && jSONObject.has("method") && jSONObject.getString("method").equalsIgnoreCase("upi") && jSONObject.getString("_[app]").equalsIgnoreCase("com.google.android.apps.nbu.paisa.user")) {
                return true;
            }
            if (jSONObject != null && jSONObject.has("type") && jSONObject.getString("type").equalsIgnoreCase("application") && jSONObject.getString("application_name").equalsIgnoreCase("google_pay")) {
                return true;
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return false;
        }
        return false;
    }

    @Override
    public void processPayment(String string2, final JSONObject jSONObject, final Activity activity, RzpInternalCallback rzpInternalCallback) {
        try {
            this.rzpInternalCallback = rzpInternalCallback;
            this.mPaymentClient = Wallet.getPaymentsClient();
            AnalyticsUtil.trackEvent(AnalyticsEvent.GOOGLEPAY_PROCESS_PAYMENT_CALLED);
            if (jSONObject.has("type") && jSONObject.getString("type").equalsIgnoreCase("application")) {
                this.apiResponse = jSONObject;
                JSONObject jSONObject2 = jSONObject.getJSONObject("request").getJSONArray("content").getJSONObject(0);
                try {
                    this.mPaymentClient.loadPaymentData(activity, jSONObject2.toString(), LOAD_PAYMENT_DATA_REQUEST_CODE);
                }
                catch (Exception exception) {
                    AnalyticsUtil.reportError(exception, "critical", exception.getMessage());
                    this.genericOnPaymentFailure("BAD_REQUEST", 1, "An internal error has occured");
                }
                return;
            }
            if (jSONObject.has("url_data")) {
                this.isUpiOnly = true;
                try {
                    String string3 = jSONObject.get("url_data").toString();
                    try {
                        this.apiResponse = RzpGpayUtilMerged.getUpiData(string3);
                        this.mPaymentClient.loadPaymentData(activity, RzpGpayUtilMerged.getPaymentRequestData(string3, jSONObject), LOAD_PAYMENT_DATA_REQUEST_CODE);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        this.genericOnPaymentFailure("BAD_REQUEST_ERROR", 1, "An internal error has occurred");
                    }
                }
                catch (Exception exception) {
                    AnalyticsUtil.reportError(exception, "error:exception", exception.getMessage());
                    this.genericOnPaymentFailure("BAD_REQUEST_ERROR", 1, "An internal error has occurred");
                }
                return;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("Content-Type", "application/x-www-form-urlencoded");
            O_$B_.a("https://api.razorpay.com/v1/payments/create/ajax", RzpGpayUtilMerged.makeApiPayload(jSONObject), hashMap, new Callback(){

                @Override
                public void run(ResponseObject responseObject) {
                    try {
                        RzpGpayMerged.this.isUpiOnly = true;
                        RzpGpayMerged.this.apiResponse = new JSONObject(responseObject.getResponseResult());
                        JSONObject jSONObject2 = new JSONObject(responseObject.getResponseResult());
                        if (responseObject.getResponseCode() >= 400) {
                            RzpGpayMerged.this.genericOnPaymentFailure("BAD_REQUEST_ERROR", 1, "An error occurred while fetching payment details from API.");
                        }
                        if (jSONObject2.has("error")) {
                            AnalyticsUtil.trackEvent(AnalyticsEvent.GOOGLEPAY_PROCESS_PAYMENT_PAYLOAD_ERROR);
                            RzpGpayMerged.this.genericOnPaymentFailure("BAD_REQUEST_ERROR", 1, jSONObject2.toString());
                            return;
                        }
                        AnalyticsUtil.trackEvent(AnalyticsEvent.GOOGLEPAY_PROCESS_PAYMENT_CALLED);
                        RzpGpayMerged.this.mPaymentClient.loadPaymentData(activity, RzpGpayUtilMerged.getPaymentRequestData(responseObject.getResponseResult(), jSONObject), LOAD_PAYMENT_DATA_REQUEST_CODE);
                    }
                    catch (Exception exception) {
                        AnalyticsUtil.reportError(exception, "critical", exception.getMessage());
                        RzpGpayMerged.this.genericOnPaymentFailure("BAD_REQUEST_ERROR", 1, "An internal error has occurred.");
                    }
                }
            });
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError(exception, "error:exception", exception.getMessage());
            this.genericOnPaymentFailure("BAD_REQUEST_ERROR", 1, "An internal error has occurred.");
        }
    }

    @Override
    public void onActivityResult(String string2, int n, int n2, Intent intent) {
        if (n == LOAD_PAYMENT_DATA_REQUEST_CODE) {
            switch (n2) {
                case -1: {
                    AnalyticsUtil.trackEvent(AnalyticsEvent.GOOGLEPAY_PAYMENT_CALLBACK_SUCCESS);
                    String string3 = WalletUtils.getPaymentDataFromIntent((Intent)intent);
                    this.processPaymentResponse(string3);
                    break;
                }
                case 1: {
                    int n3 = intent.getIntExtra("errorCode", 8);
                    this.handleResultStatusCode(n3);
                    break;
                }
                case 0: {
                    AnalyticsUtil.trackEvent(AnalyticsEvent.GOOGLEPAY_PAYMENT_CALLBACK_CANCELLED);
                    this.genericOnPaymentFailure("BAD_REQUEST_ERROR", 0, "Payment canceled.");
                }
            }
        }
    }

    private void handleResultStatusCode(int n) {
        switch (n) {
            case 409: {
                this.genericOnPaymentFailure("BAD_REQUEST_ERROR", 1, "There is a problem with your Google Pay account.");
                break;
            }
            case 405: {
                this.genericOnPaymentFailure("BAD_REQUEST_ERROR", 1, "There is a problem with merchant's account.");
                break;
            }
            default: {
                this.genericOnPaymentFailure("BAD_REQUEST_ERROR", 1, "An internal error has occurred");
            }
        }
    }

    @Override
    public void isRegistered(Context context, RzpPluginRegisterCallback rzpPluginRegisterCallback) {
        this.registerCallback = rzpPluginRegisterCallback;
        AnalyticsUtil.trackEvent(AnalyticsEvent.GOOGLEPAY_CHECK_REGISTER_CALLED);
        try {
            this.mPaymentClient = Wallet.getPaymentsClient();
            AnalyticsUtil.trackEvent(AnalyticsEvent.GOOGLEPAY_PAYMENT_IS_REGISTERED_CALLED);
            this.upiTask = this.mPaymentClient.isReadyToPay(context, Objects.requireNonNull(RzpGpayUtilMerged.getIsReadyToPayRequest()).toString());
            this.cardsTask = this.mPaymentClient.isReadyToPay(context, Objects.requireNonNull(RzpGpayUtilMerged.getCardsIsReadyToPayRequest()).toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            AnalyticsUtil.reportError(noSuchAlgorithmException, "error:exception", noSuchAlgorithmException.getMessage());
        }
        Objects.requireNonNull(this.cardsTask).addOnCompleteListener((OnCompleteListener)this);
        Objects.requireNonNull(this.upiTask).addOnCompleteListener((OnCompleteListener)this);
    }

    @Override
    public void isRegistered(Context context) {
        Task task = null;
        Task task2 = null;
        this.mPaymentClient = Wallet.getPaymentsClient();
        AnalyticsUtil.trackEvent(AnalyticsEvent.GOOGLEPAY_CHECK_REGISTER_CALLED);
        try {
            AnalyticsUtil.trackEvent(AnalyticsEvent.GOOGLEPAY_PAYMENT_IS_REGISTERED_CALLED);
            task = this.mPaymentClient.isReadyToPay(context, Objects.requireNonNull(RzpGpayUtilMerged.getIsReadyToPayRequest()).toString());
            task2 = this.mPaymentClient.isReadyToPay(context, Objects.requireNonNull(RzpGpayUtilMerged.getCardsIsReadyToPayRequest()).toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            AnalyticsUtil.reportError(noSuchAlgorithmException, "error:exception", noSuchAlgorithmException.getMessage());
        }
        ((Task)Objects.requireNonNull(task2)).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Boolean>(){

            public void onComplete(@NonNull Task<Boolean> task) {
                boolean bl = (Boolean)task.getResult();
                BaseUtils.setIsGpayCardsUpiRegistered(bl);
            }
        });
        Objects.requireNonNull(task).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Boolean>(){

            public void onComplete(@NonNull Task<Boolean> task) {
                boolean bl = (Boolean)task.getResult();
                BaseUtils.setCompatibleWithGooglePay(bl);
            }
        });
    }

    private void processPaymentResponse(String string2) {
        AnalyticsUtil.trackEvent(AnalyticsEvent.GOOGLEPAY_VERIFY_PAYMENT_CALLED);
        if (RzpGpayMerged.verifyPaymentResponse(string2)) {
            AnalyticsUtil.trackEvent(AnalyticsEvent.GOOGLEPAY_VERIFY_PAYMENT_SUCCESS_CALLED);
            this.genericOnPaymentSuccess();
        } else {
            AnalyticsUtil.trackEvent(AnalyticsEvent.GOOGLEPAY_VERIFY_PAYMENT_ERROR_CALLED);
            this.genericOnPaymentFailure("BAD_REQUEST_ERROR", 1, "Payment was not successful.");
        }
    }

    private static boolean verifyPaymentResponse(String string2) {
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.getJSONObject("paymentMethodData").getJSONObject("tokenizationData").getString("token");
            if (string3 == null) {
                AnalyticsUtil.trackEvent(AnalyticsEvent.GOOGLEPAY_VERIFY_PAYMENT_EXCEPTION);
                return false;
            }
            JSONObject jSONObject2 = new JSONObject(string3);
            JSONObject jSONObject3 = new JSONObject(jSONObject2.getString("signedMessage"));
            String string4 = jSONObject3.getJSONObject("paymentMethodDetails").getString("status");
            return string4 != null && string4.equals("SUCCESS");
        }
        catch (JSONException jSONException) {
            AnalyticsUtil.trackEvent(AnalyticsEvent.GOOGLEPAY_VERIFY_PAYMENT_EXCEPTION);
            return false;
        }
    }

    private void genericOnPaymentSuccess() {
        if (this.isUpiOnly) {
            this.rzpInternalCallback.onPaymentSuccess(RzpGpayUtilMerged.makeExternalSDKPayload(this.apiResponse));
        } else {
            this.rzpInternalCallback.onPaymentSuccess(RzpGpayUtilMerged.makeMergedExternalSDKPayload(this.apiResponse));
        }
    }

    private void genericOnPaymentFailure(String string2, int n, String string3) {
        if (this.isUpiOnly) {
            this.rzpInternalCallback.onPaymentError(5, RzpGpayUtilMerged.makeErrorPayload(string2, string3));
        } else {
            this.rzpInternalCallback.onPaymentError(5, RzpGpayUtilMerged.makeMergedExternalSDKErrorPayload(this.apiResponse, n, string3));
        }
    }

    public void onComplete(@NonNull Task<Boolean> task) {
        boolean bl = (Boolean)task.getResult();
        if (task.equals(this.cardsTask)) {
            BaseUtils.setIsGpayCardsUpiRegistered(bl);
            this.registerCallback.onResponse(bl);
        } else {
            BaseUtils.setCompatibleWithGooglePay(bl);
        }
    }
}

