/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.widget.Toast;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsProperty;
import com.razorpay.AnalyticsUtil;
import com.razorpay.B$$W$;
import com.razorpay.BaseUtils;
import com.razorpay.Callback;
import com.razorpay.G__G_;
import com.razorpay.J$_0_;
import com.razorpay.K$$z$;
import com.razorpay.OTP;
import com.razorpay.O_$B_;
import com.razorpay.OtpElfData;
import com.razorpay.ResponseObject;
import com.razorpay.SmsAgentInterface;
import com.razorpay.b__J_;
import java.util.HashMap;
import org.json.JSONObject;

public final class RzpAssist
implements SmsAgentInterface {
    private WebView webview;
    private boolean hasOtpPermission = false;
    private String lastURL = "";
    private String currentLoadingUrl = "";
    private long pageStartTime;
    private boolean isMagic = false;
    private boolean isRazorpayOtpReceived = false;
    private Activity activity;
    private String merchantKey;
    private K$$z$ smsAgent;
    private OtpElfData elfData;
    private JSONObject otpElfPreferences = new JSONObject();
    private JSONObject paymentData = new JSONObject();
    private String paymentId;
    private boolean isRzpAssistEnabled = false;
    private boolean otpRead = false;
    private String sdkType = "standalone";
    private int sdkVersionCode;
    private String sdkVersion;
    String lastSms;
    String message;
    String sender;
    private boolean jsInsertedInCurrentPage = false;

    public RzpAssist(String string2, Activity activity, WebView webView, String string3, int n, String string4) {
        if (!b__J_.a().isOTPElfEnabled().booleanValue()) {
            return;
        }
        if (string2 == null || string2.isEmpty()) {
            throw new RuntimeException("merchantKey cannot be null or empty");
        }
        this.sdkType = string3;
        this.sdkVersionCode = n;
        this.sdkVersion = string4;
        B$$W$.b("OTPElf Constructor");
        if (string3.equals("standalone")) {
            AnalyticsUtil.setup((Context)activity, string2, string3, n, string4);
        }
        this.webview = webView;
        this.merchantKey = string2;
        this.activity = activity;
        this.elfData = new OtpElfData(activity);
        this.elfData.checkForUpdates();
        this.setup();
        AnalyticsUtil.addProperty("OTPElf Version", new AnalyticsProperty(BaseUtils.getLocalVersion(activity, OtpElfData.versionKey), AnalyticsProperty.Scope.ORDER));
    }

    private void setup() {
        this.smsAgent = K$$z$.a();
        this.smsAgent.a(this);
        this.smsAgent.a(this.activity);
        this.webview.addJavascriptInterface((Object)this, "OTPElfBridge");
        this.webview.getSettings().setUseWideViewPort(true);
    }

    void enableMagic() {
        this.isMagic = true;
    }

    void setPaymentData(JSONObject jSONObject) {
        this.paymentData = jSONObject;
    }

    public void setOtpElfPreferences(JSONObject jSONObject) {
        this.otpElfPreferences = jSONObject;
    }

    public void onPageFinished(WebView webView, String string2) {
        long l = System.nanoTime() - this.pageStartTime;
        AnalyticsUtil.trackPageLoadEnd(string2, l);
        this.lastURL = string2;
        this.currentLoadingUrl = "";
        if (!b__J_.a().isOTPElfEnabled().booleanValue()) {
            return;
        }
        if (!this.jsInsertedInCurrentPage) {
            this.handleJsInsertion();
            this.jsInsertedInCurrentPage = true;
        }
    }

    private void handleJsInsertion() {
        try {
            JSONObject jSONObject = b__J_.a().getOTPElfSettings();
            jSONObject.put("merchant_key", (Object)this.merchantKey);
            jSONObject.put("otp_permission", this.hasOtpPermission);
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("type", (Object)this.sdkType);
            jSONObject2.put("version", (Object)this.sdkVersion);
            jSONObject.put("sdk", (Object)jSONObject2);
            JSONObject jSONObject3 = new JSONObject();
            if (!this.isMagic) {
                B$$W$.b("not magic");
                jSONObject3.put("type", (Object)"rzpassist");
                jSONObject3.put("version_code", J$_0_.b());
            } else {
                B$$W$.b("This is Magic");
                jSONObject3.put("type", (Object)"magic");
                jSONObject3.put("version_code", J$_0_.a());
            }
            jSONObject.put("plugin", (Object)jSONObject3);
            jSONObject.put("payment_data", (Object)this.paymentData);
            jSONObject.put("preferences", (Object)this.otpElfPreferences);
            JSONObject jSONObject4 = new JSONObject();
            jSONObject4.put("package_name", (Object)this.activity.getApplicationContext().getPackageName());
            PackageManager packageManager = this.activity.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(this.activity.getPackageName(), 0);
            jSONObject4.put("app_name", (Object)AnalyticsUtil.returnUndefinedIfNull(packageInfo.applicationInfo.loadLabel(packageManager)));
            jSONObject4.put("platform", (Object)"mobile_sdk");
            jSONObject4.put("os", (Object)"android");
            jSONObject4.put("os_version", (Object)Build.VERSION.RELEASE);
            jSONObject4.put("data_network_type", (Object)BaseUtils.getDataNetworkType((Context)this.activity).getNetworkTypeName());
            jSONObject4.put("framework", (Object)AnalyticsUtil.getFramework());
            jSONObject4.put("library", (Object)"standard");
            jSONObject4.put("sdk", (Object)jSONObject2);
            jSONObject.put("metadata", (Object)jSONObject4);
            this.injectJs("window.__rzp_options = " + jSONObject.toString());
        }
        catch (Exception exception) {
            B$$W$.b("Unable to load otpelf settings", exception);
        }
        this.injectJs(this.elfData.getOtpElfJs());
        if (this.lastSms != null) {
            this.injectJs(String.format("OTPElf.showOTP('%s','%s')", this.lastSms, this.sender));
            this.lastSms = null;
        }
    }

    public void onProgressChanged(int n) {
        if (!b__J_.a().isOTPElfEnabled().booleanValue()) {
            return;
        }
    }

    public void onPageStarted(WebView webView, String string2) {
        B$$W$.b("RzpAssist onPageStarted: " + string2);
        AnalyticsUtil.trackPageLoadStart(string2);
        this.pageStartTime = System.nanoTime();
        this.currentLoadingUrl = string2;
        this.jsInsertedInCurrentPage = false;
    }

    public void paymentFlowEnd() {
        if (this.sdkType.equals("standalone")) {
            AnalyticsUtil.postData();
        }
        if (!b__J_.a().isOTPElfEnabled().booleanValue()) {
            return;
        }
        this.smsAgent.c(this.activity);
        this.smsAgent.b(this);
    }

    @Override
    public void postSms(String string2, String string3) {
        if (!this.isRzpAssistEnabled) {
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("sender", (Object)string2);
            jSONObject.put("message", (Object)string3);
            this.sender = string2;
            this.message = string3;
            this.lastSms = jSONObject.toString();
            this.injectJs(String.format("OTPElf.showOTP('%s','%s')", string3, string2));
        }
        catch (Exception exception) {
            B$$W$.b("Exception", exception);
        }
    }

    @Override
    public void setSmsPermission(boolean bl) {
        this.setOTPEnabled(bl);
    }

    void setPaymentId(String string2) {
        this.paymentId = string2;
    }

    private void postStatsToAPI() {
        try {
            String string2 = BaseUtils.constructBasicAuth(this.merchantKey);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("Authorization", "Basic " + string2);
            hashMap.put("Content-Type", "application/json");
            if (this.paymentId == null) {
                return;
            }
            String string3 = "https://api.razorpay.com/v1/payments/" + this.paymentId + "/metadata";
            B$$W$.b("Sending Stats Request");
            JSONObject jSONObject = G__G_.a(this.otpRead);
            B$$W$.b("PAYLOAD");
            B$$W$.b(jSONObject.toString());
            B$$W$.b(string3);
            O_$B_.a(string3, jSONObject.toString(), hashMap, new Callback(){

                @Override
                public void run(ResponseObject responseObject) {
                    B$$W$.b("API Metadata: " + responseObject.getResponseResult());
                }
            });
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError(exception, "critical", exception.getMessage());
        }
    }

    private void injectJs(String string2) {
        this.webview.loadUrl(String.format("javascript: %s", string2));
    }

    void onRequestPermissionsResult(int n, String[] stringArray, int[] nArray) {
        this.smsAgent.a(this.activity, n, stringArray, nArray);
    }

    String getLastLoadedUrl() {
        return this.lastURL;
    }

    String getCurrentLoadingUrl() {
        return this.currentLoadingUrl;
    }

    public final void reset() {
        this.postStatsToAPI();
        this.lastURL = "";
        this.currentLoadingUrl = "";
        this.otpRead = false;
    }

    boolean isRazorpayOtpReceived() {
        return this.isRazorpayOtpReceived;
    }

    void setOTPEnabled(boolean bl) {
        this.hasOtpPermission = bl;
        AnalyticsUtil.addProperty("otp_autoreading_access", new AnalyticsProperty(bl, AnalyticsProperty.Scope.ORDER));
    }

    void setRzpAssistEnabled(boolean bl) {
        this.isRzpAssistEnabled = bl;
    }

    @JavascriptInterface
    public final void setUseWideViewPort(final boolean bl) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                RzpAssist.this.webview.getSettings().setUseWideViewPort(bl);
            }
        });
    }

    @JavascriptInterface
    public final void openKeyboard() {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                InputMethodManager inputMethodManager = (InputMethodManager)RzpAssist.this.activity.getSystemService("input_method");
                inputMethodManager.showSoftInput((View)RzpAssist.this.webview, 0);
            }
        });
    }

    @JavascriptInterface
    public final void toast(final String string2) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)RzpAssist.this.activity, (CharSequence)string2, (int)1).show();
            }
        });
    }

    @JavascriptInterface
    public void trackEvent(String string2, String string3) {
        try {
            AnalyticsEvent analyticsEvent = AnalyticsEvent.JS_EVENT;
            analyticsEvent.setEventName(string2);
            JSONObject jSONObject = new JSONObject(string3);
            AnalyticsUtil.trackEvent(analyticsEvent, jSONObject);
        }
        catch (Exception exception) {
            B$$W$.b("Error in tracking JS Event", exception);
        }
    }

    @JavascriptInterface
    public final void trackEvent(String string2) {
        AnalyticsEvent analyticsEvent = AnalyticsEvent.JS_EVENT;
        analyticsEvent.setEventName(string2);
        AnalyticsUtil.trackEvent(analyticsEvent);
    }

    @JavascriptInterface
    public void onOtpParsed(final String string2) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    JSONObject jSONObject = new JSONObject(string2);
                    String string22 = jSONObject.getString("otp");
                    String string3 = jSONObject.getString("sender");
                    String string4 = jSONObject.getString("bank");
                    OTP oTP = new OTP(string22, string3, string4);
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("sender", oTP.a());
                    if (oTP.a().contains("RZRPAY")) {
                        RzpAssist.this.isRazorpayOtpReceived = true;
                        hashMap.put("razorpay_otp", true);
                    } else {
                        hashMap.put("razorpay_otp", false);
                        RzpAssist.this.otpRead = true;
                        AnalyticsUtil.addProperty("payment_otp_received", new AnalyticsProperty(true, AnalyticsProperty.Scope.PAYMENT));
                    }
                    AnalyticsUtil.trackEvent(AnalyticsEvent.OTP_RECEIVED, hashMap);
                }
                catch (Exception exception) {
                    B$$W$.b("Error in parsing json", exception);
                }
            }
        });
    }

    @JavascriptInterface
    public void copyToClipboard(String string2) {
        ClipboardManager clipboardManager = (ClipboardManager)this.activity.getSystemService("clipboard");
        ClipData clipData = ClipData.newPlainText((CharSequence)"rzp_clip_data", (CharSequence)string2);
        clipboardManager.setPrimaryClip(clipData);
    }
}

