/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.text.TextUtils;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsProperty;
import com.razorpay.AnalyticsUtil;
import com.razorpay.B$$W$;
import com.razorpay.BaseUtils;
import com.razorpay.CheckoutUtils;
import com.razorpay.D$_X_;
import com.razorpay.ExternalWalletListener;
import com.razorpay.PaymentData;
import com.razorpay.PaymentResultListener;
import com.razorpay.PaymentResultWithDataListener;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class Checkout
extends Fragment {
    public static final int NETWORK_ERROR = 2;
    public static final int INVALID_OPTIONS = 3;
    public static final int PAYMENT_CANCELED = 0;
    public static final int TLS_ERROR = 6;
    public static final int INCOMPATIBLE_PLUGIN = 7;
    public static final int RZP_REQUEST_CODE = 62442;
    static final int PAYMENT_SUCCESS = 1;
    static final int EXTERNAL_WALLET = 4;
    static final int INTEGRATION_ONE = 1;
    static final int INTEGRATION_TWO = 2;
    static final int INTEGRATION_THREE = 3;
    static final String EVENT_CALLBACK_DNE = "dne";
    static final String EVENT_CALLBACK_THREW_ERROR = "threw_error";
    @SuppressLint(value={"StaticFieldLeak"})
    private static WebView sPreloadView;
    private static long sPreloadCompleteDuration;
    private static long sPreloadAbortDuration;
    private static boolean sPreloadFailed;
    private String key;
    private JSONObject options;
    private Activity merchantActivity;
    private String merchantClassName;
    private boolean disableFullScreen;
    private int checkoutImage;
    private static PaymentData paymentData;
    private boolean isMethodOverridden;

    @Deprecated
    public final void setPublicKey(String string2) {
        this.key = string2;
    }

    public final void setImage(int n) {
        this.checkoutImage = n;
    }

    public final void setKeyID(String string2) {
        this.setPublicKey(string2);
    }

    public final void setFullScreenDisable(boolean bl) {
        this.disableFullScreen = bl;
    }

    public final void open(Activity activity, JSONObject jSONObject) {
        if (TextUtils.isEmpty((CharSequence)this.key)) {
            this.key = BaseUtils.getKeyId((Context)activity);
        }
        D$_X_.getAdvertisingIdFromUtil((Context)activity);
        if (TextUtils.isEmpty((CharSequence)this.key)) {
            throw new RuntimeException("Please set your Razorpay API key in AndroidManifest.xml");
        }
        if (jSONObject == null || jSONObject.length() == 0) {
            throw new RuntimeException("Checkout options cannot be null or empty");
        }
        try {
            jSONObject.put("key", (Object)this.key);
        }
        catch (JSONException jSONException) {
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "warning", jSONException.getMessage());
        }
        Checkout.abortPreloadIfRequired();
        this.options = jSONObject;
        this.merchantClassName = activity.getClass().getName();
        this.merchantActivity = activity;
        activity.getFragmentManager().beginTransaction().add((Fragment)this, null).commitAllowingStateLoss();
    }

    public static void preload(Context context) {
        sPreloadCompleteDuration = 0L;
        sPreloadAbortDuration = 0L;
        sPreloadFailed = false;
        context = context.getApplicationContext();
        sPreloadView = new WebView(context);
        BaseUtils.setWebViewSettings(context, sPreloadView, false);
        sPreloadView.setWebViewClient(new WebViewClient(){
            long pageStartAt;

            public void onPageStarted(WebView webView, String string2, Bitmap bitmap) {
                this.pageStartAt = System.nanoTime();
                if (sPreloadView == null) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("error_location", "Checkout->Preload()->onPageStarted");
                    AnalyticsUtil.trackEvent(AnalyticsEvent.WEB_VIEW_UNEXPECTED_NULL, hashMap);
                    return;
                }
                sPreloadView.setTag((Object)this.pageStartAt);
                B$$W$.b("Preload started!");
            }

            public void onReceivedError(WebView webView, int n, String string2, String string3) {
                B$$W$.b("onReceivedError OLD while pre-loading!");
                Checkout.failPreload();
            }

            public void onReceivedError(WebView webView, WebResourceRequest webResourceRequest, WebResourceError webResourceError) {
                super.onReceivedError(webView, webResourceRequest, webResourceError);
                B$$W$.b("onReceivedError NEW while pre-loading!");
                Checkout.failPreload();
            }

            public void onPageFinished(WebView webView, String string2) {
                long l = System.nanoTime();
                if (!sPreloadFailed) {
                    sPreloadCompleteDuration = l - this.pageStartAt;
                    String string3 = "Preload finished in " + BaseUtils.nanoTimeToSecondsString(sPreloadCompleteDuration, 2) + " sec.";
                    B$$W$.b(string3);
                }
                Checkout.destroyPreloadView();
            }
        });
        sPreloadView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView webView, int n) {
                B$$W$.b("Preload progress: " + n);
            }
        });
        sPreloadView.loadUrl("https://api.razorpay.com/v1/checkout/public");
    }

    private static void failPreload() {
        sPreloadFailed = true;
    }

    private static void destroyPreloadView() {
        try {
            sPreloadView.stopLoading();
        }
        catch (Exception exception) {
            // empty catch block
        }
        sPreloadView = null;
    }

    private static void abortPreloadIfRequired() {
        long l = System.nanoTime();
        try {
            if (sPreloadView != null) {
                long l2 = (Long)sPreloadView.getTag();
                sPreloadAbortDuration = l - l2;
                String string2 = "Preload aborted in " + BaseUtils.nanoTimeToSecondsString(sPreloadAbortDuration, 2) + " sec.";
                B$$W$.b(string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Checkout.destroyPreloadView();
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        if (this.options != null) {
            Intent intent = new Intent();
            intent.setComponent(new ComponentName(this.getActivity().getPackageName(), "com.razorpay.CheckoutActivity"));
            if (sPreloadCompleteDuration > 0L) {
                intent.putExtra("PRELOAD_COMPLETE_DURATION", sPreloadCompleteDuration);
            } else if (sPreloadAbortDuration > 0L) {
                intent.putExtra("PRELOAD_ABORT_DURATION", sPreloadAbortDuration);
            }
            intent.putExtra("OPTIONS", this.options.toString());
            intent.putExtra("IMAGE", this.checkoutImage);
            intent.putExtra("DISABLE_FULL_SCREEN", this.disableFullScreen);
            this.options = null;
            this.startActivityForResult(intent, 62442);
        }
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        if (n != 62442) {
            return;
        }
        this.merchantActivity = this.getActivity();
        this.merchantClassName = this.merchantActivity.getClass().getName();
        String string2 = Checkout.getPaymentResult(intent);
        if (string2 == null) {
            string2 = "Payment Error";
        } else if (string2.contains("cancelled")) {
            string2 = BaseUtils.getPaymentCancelledResponse("");
        }
        Checkout.trackOnActivityResultEvent(n2, string2);
        Checkout.createPaymentData(this.merchantActivity, string2);
        if (n2 == 1) {
            this.handleOnSuccess();
        } else if (n2 == 4) {
            this.handleExternalWalletSelected();
        } else {
            this.handleOnError(n2, string2);
        }
        try {
            this.getActivity().getFragmentManager().beginTransaction().remove((Fragment)this).commit();
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError(exception, "error", exception.getMessage());
        }
    }

    private void handleExternalWalletSelected() {
        if (this.getActivity() instanceof ExternalWalletListener) {
            try {
                ExternalWalletListener externalWalletListener = (ExternalWalletListener)this.getActivity();
                String string2 = paymentData.getExternalWallet();
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    externalWalletListener.onExternalWalletSelected(string2, paymentData);
                    AnalyticsUtil.trackEvent(AnalyticsEvent.MERCHANT_EXTERNAL_WALLET_SELECTED_CALLED);
                    AnalyticsUtil.postData();
                }
            }
            catch (Exception exception) {
                Checkout.handleMerchantCallbackError(this.merchantActivity, 4, EVENT_CALLBACK_THREW_ERROR, exception);
            }
        } else {
            Checkout.handleMerchantCallbackError(this.merchantActivity, 4, EVENT_CALLBACK_DNE, new Exception());
        }
    }

    private void handleOnError(int n, String string2) {
        this.isMethodOverridden = true;
        this.onError(n, string2);
        if (this.isMethodOverridden) {
            Checkout.trackIntegrationType(n, 1);
        }
    }

    private void handleOnSuccess() {
        String string2 = paymentData.getPaymentId();
        if (string2 != null) {
            this.isMethodOverridden = true;
            this.onSuccess(string2);
        }
        if (this.isMethodOverridden) {
            Checkout.trackIntegrationType(1, 1);
        }
    }

    public void onSuccess(String string2) {
        this.isMethodOverridden = false;
        boolean bl = this.handleOnSuccessViaInterface(string2);
        if (!bl) {
            this.handleOnSuccessViaReflection(string2);
        }
    }

    public void onError(int n, String string2) {
        this.isMethodOverridden = false;
        boolean bl = this.handleOnErrorViaInterface(n, string2);
        if (!bl) {
            this.handleOnErrorViaReflection(n, string2);
        }
    }

    private void handleOnErrorViaReflection(int n, String string2) {
        Method method = null;
        try {
            method = this.getMerchantClassMethod("onPaymentError", Integer.TYPE, String.class);
        }
        catch (Exception exception) {
            Checkout.handleMerchantCallbackError(this.merchantActivity, n, EVENT_CALLBACK_DNE, exception);
        }
        try {
            this.invokeMethod(method, n, string2);
            Checkout.trackIntegrationType(n, 2);
        }
        catch (Exception exception) {
            Checkout.handleMerchantCallbackError(this.merchantActivity, n, EVENT_CALLBACK_THREW_ERROR, exception);
        }
    }

    private boolean handleOnErrorViaInterface(int n, String string2) {
        if (this.getActivity() instanceof PaymentResultListener) {
            try {
                PaymentResultListener paymentResultListener = (PaymentResultListener)this.getActivity();
                paymentResultListener.onPaymentError(n, string2);
                Checkout.trackIntegrationType(n, 3);
            }
            catch (Exception exception) {
                Checkout.handleMerchantCallbackError(this.merchantActivity, n, EVENT_CALLBACK_THREW_ERROR, exception);
            }
            return true;
        }
        if (this.getActivity() instanceof PaymentResultWithDataListener) {
            try {
                PaymentResultWithDataListener paymentResultWithDataListener = (PaymentResultWithDataListener)this.getActivity();
                paymentResultWithDataListener.onPaymentError(n, string2, paymentData);
                Checkout.trackIntegrationType(n, 3);
            }
            catch (Exception exception) {
                Checkout.handleMerchantCallbackError(this.merchantActivity, n, EVENT_CALLBACK_THREW_ERROR, exception);
            }
            return true;
        }
        return false;
    }

    private boolean handleOnSuccessViaInterface(String string2) {
        if (this.getActivity() instanceof PaymentResultListener) {
            try {
                PaymentResultListener paymentResultListener = (PaymentResultListener)this.getActivity();
                paymentResultListener.onPaymentSuccess(string2);
                Checkout.trackIntegrationType(1, 3);
            }
            catch (Exception exception) {
                Checkout.handleMerchantCallbackError(this.merchantActivity, 1, EVENT_CALLBACK_THREW_ERROR, exception);
            }
            return true;
        }
        if (this.getActivity() instanceof PaymentResultWithDataListener) {
            try {
                PaymentResultWithDataListener paymentResultWithDataListener = (PaymentResultWithDataListener)this.getActivity();
                paymentResultWithDataListener.onPaymentSuccess(string2, paymentData);
                Checkout.trackIntegrationType(1, 3);
            }
            catch (Exception exception) {
                Checkout.handleMerchantCallbackError(this.merchantActivity, 1, EVENT_CALLBACK_THREW_ERROR, exception);
            }
            return true;
        }
        return false;
    }

    private void handleOnSuccessViaReflection(String string2) {
        Method method = null;
        try {
            method = this.getMerchantClassMethod("onPaymentSuccess", String.class);
        }
        catch (Exception exception) {
            Checkout.handleMerchantCallbackError(this.merchantActivity, 1, EVENT_CALLBACK_DNE, exception);
        }
        try {
            this.invokeMethod(method, string2);
            Checkout.trackIntegrationType(1, 2);
        }
        catch (Exception exception) {
            Checkout.handleMerchantCallbackError(this.merchantActivity, 1, EVENT_CALLBACK_THREW_ERROR, exception);
        }
    }

    private void invokeMethod(Method method, Object ... objectArray) {
        if (method == null) {
            return;
        }
        method.invoke((Object)this.merchantActivity, objectArray);
    }

    private Method getMerchantClassMethod(String string2, Class ... classArray) {
        Class<?> clazz = Class.forName(this.merchantClassName);
        Method method = clazz.getMethod(string2, classArray);
        return method;
    }

    private static void trackIntegrationType(int n, int n2) {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("integration_type", Integer.toString(n2));
            if (n == 1) {
                AnalyticsUtil.trackEvent(AnalyticsEvent.MERCHANT_ON_SUCCESS_CALLED, hashMap);
            } else {
                AnalyticsUtil.trackEvent(AnalyticsEvent.MERCHANT_ON_ERROR_CALLED, hashMap);
            }
            AnalyticsUtil.postData();
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError(exception, "warning", exception.getMessage());
        }
    }

    private static void trackOnActivityResultEvent(int n, String string2) {
        try {
            AnalyticsUtil.addProperty("onActivityResult result", new AnalyticsProperty(string2, AnalyticsProperty.Scope.ORDER));
            AnalyticsUtil.addProperty("onActivityResult resultCode", new AnalyticsProperty(String.valueOf(n), AnalyticsProperty.Scope.ORDER));
            if (n == 1) {
                AnalyticsUtil.trackEvent(AnalyticsEvent.CALLING_ON_SUCCESS);
            } else if (n == 4) {
                AnalyticsUtil.trackEvent(AnalyticsEvent.CALLING_EXTERNAL_WALLET_SELECTED);
            } else {
                AnalyticsUtil.trackEvent(AnalyticsEvent.CALLING_ON_ERROR);
            }
            AnalyticsUtil.postData();
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError(exception, "warning", exception.getMessage());
        }
    }

    private static void handleMerchantCallbackError(Activity activity, int n, String string2, Exception exception) {
        String string3;
        String string4;
        if (n == 1) {
            string4 = "onPaymentSuccess";
            string3 = "success";
        } else if (n == 4) {
            string4 = "onExternalWalletSelected";
            string3 = "redirected";
        } else {
            string4 = "onPaymentError";
            string3 = "error";
        }
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("event_details", exception.getMessage());
            hashMap.put("event_type", exception.getMessage());
            hashMap.put("payment_status", string3);
            AnalyticsUtil.trackEvent(AnalyticsEvent.HANDOVER_ERROR, hashMap);
            AnalyticsUtil.postData();
        }
        catch (Exception exception2) {
            AnalyticsUtil.reportError(exception2, "error", exception2.getMessage());
        }
        if (string2.equals(EVENT_CALLBACK_DNE)) {
            if (n == 4) {
                Toast.makeText((Context)activity, (CharSequence)"Error: ExternalWalletListener probably not implemented in your activity", (int)0).show();
            } else {
                Toast.makeText((Context)activity, (CharSequence)("Error: " + string4 + " probably not implemented in your activity"), (int)0).show();
            }
        } else if (string2.equals(EVENT_CALLBACK_THREW_ERROR)) {
            Toast.makeText((Context)activity, (CharSequence)("Your " + string4 + " method is throwing an error. Wrap the entire code of the method inside a try catch."), (int)0).show();
        }
        AnalyticsUtil.reportError(exception, "error", exception.getMessage());
    }

    private static void createPaymentData(Activity activity, String string2) {
        paymentData = new PaymentData();
        paymentData.setUserContact(CheckoutUtils.b((Context)activity));
        paymentData.setUserEmail(CheckoutUtils.a((Context)activity));
        try {
            JSONObject jSONObject = new JSONObject(string2);
            paymentData.setData(jSONObject);
            if (jSONObject.has("razorpay_payment_id")) {
                paymentData.setPaymentId(jSONObject.getString("razorpay_payment_id"));
            }
            if (jSONObject.has("razorpay_order_id")) {
                paymentData.setOrderId(jSONObject.getString("razorpay_order_id"));
            }
            if (jSONObject.has("razorpay_signature")) {
                paymentData.setSignature(jSONObject.getString("razorpay_signature"));
            }
            if (jSONObject.has("external_wallet")) {
                paymentData.setExternalWallet(jSONObject.getString("external_wallet"));
            }
        }
        catch (JSONException jSONException) {
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "error", jSONException.getMessage());
        }
    }

    public static void handleActivityResult(Activity activity, int n, int n2, Intent intent, PaymentResultWithDataListener paymentResultWithDataListener, ExternalWalletListener externalWalletListener) {
        if (n != 62442) {
            return;
        }
        String string2 = Checkout.getPaymentResult(intent);
        if (string2 == null) {
            string2 = "Payment Error";
        }
        if (string2.contains("cancelled")) {
            string2 = BaseUtils.getPaymentCancelledResponse("");
        }
        Checkout.createPaymentData(activity, string2);
        Checkout.trackOnActivityResultEvent(n2, string2);
        if (n2 == 1) {
            try {
                String string3 = paymentData.getPaymentId();
                paymentResultWithDataListener.onPaymentSuccess(string3, paymentData);
            }
            catch (Exception exception) {
                Checkout.handleMerchantCallbackError(activity, n2, EVENT_CALLBACK_THREW_ERROR, exception);
            }
        } else if (n2 == 4) {
            if (externalWalletListener != null) {
                try {
                    externalWalletListener.onExternalWalletSelected(paymentData.getExternalWallet(), paymentData);
                }
                catch (Exception exception) {
                    Checkout.handleMerchantCallbackError(activity, n2, EVENT_CALLBACK_THREW_ERROR, exception);
                }
            }
        } else {
            try {
                paymentResultWithDataListener.onPaymentError(n2, string2, paymentData);
            }
            catch (Exception exception) {
                Checkout.handleMerchantCallbackError(activity, n2, EVENT_CALLBACK_THREW_ERROR, exception);
            }
        }
    }

    public static void clearUserData(Context context) {
        CheckoutUtils.f(context);
    }

    private static String getPaymentResult(Intent intent) {
        Bundle bundle;
        if (intent != null && (bundle = intent.getExtras()) != null) {
            return bundle.getString("RESULT");
        }
        return null;
    }
}

