/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.WebView;
import androidx.core.app.ActivityCompat;
import com.google.android.gms.auth.api.phone.SmsRetriever;
import com.google.android.gms.tasks.Task;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsProperty;
import com.razorpay.AnalyticsProperty$Scope;
import com.razorpay.AnalyticsUtil;
import com.razorpay.AppSignatureHelper;
import com.razorpay.AutoReadOtpHelper;
import com.razorpay.BaseUtils;
import com.razorpay.CheckoutBridge$WebViewSafeCheckCallback;
import com.razorpay.CheckoutInteractor;
import com.razorpay.CheckoutPresenter;
import com.razorpay.CheckoutPresenterImpl$CheckoutView;
import com.razorpay.CheckoutUtils;
import com.razorpay.E$_q$;
import com.razorpay.G$_X_;
import com.razorpay.G_$8_;
import com.razorpay.J__A$;
import com.razorpay.J__n_;
import com.razorpay.L_$k$;
import com.razorpay.M$$8$;
import com.razorpay.N_$R$;
import com.razorpay.O$_M$;
import com.razorpay.O_$v$;
import com.razorpay.Q$$2_;
import com.razorpay.R;
import com.razorpay.T_$Z$;
import com.razorpay.Y_$H_;
import com.razorpay.b$_f_;
import com.razorpay.c$_2_;
import com.razorpay.c__h$;
import com.razorpay.d__1_;
import com.razorpay.d__B_;
import com.razorpay.d__w$;
import com.razorpay.f$_G$;
import com.razorpay.h;
import com.razorpay.k__c$;
import com.razorpay.n__T$;
import com.razorpay.p$_5$;
import com.razorpay.x_$Q_;
import com.razorpay.z$_w$;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.json.JSONException;
import org.json.JSONObject;

class CheckoutPresenterImpl
implements CheckoutInteractor,
CheckoutPresenter {
    protected Activity activity;
    protected CheckoutPresenterImpl$CheckoutView view;
    String merchantKey;
    x_$Q_ checkoutOptions;
    private String dashOptions;
    private JSONObject dashOptionsJSON;
    private String checkoutUrl;
    private String checkoutContent = "{}";
    private int paymentAttempts = 0;
    private boolean clearHistory;
    private boolean isPaymentSuccessful = false;
    private long preloadCompleteDuration;
    private long preloadAbortDuration;
    private long checkoutLoadStartAt;
    private boolean isTwoWebViewFlow = false;
    private boolean isMagic = false;
    private int merchantLogoResourceId = 0;
    private boolean isActivityCreated = false;
    private Task<Void> loginOtpSmsTask;
    private AutoReadOtpHelper autoReadOtpHelper;
    private boolean sendSmsHash = false;
    private boolean allowRotation = false;
    private String payment_id = null;
    private M$$8$ magicBase = null;
    private BroadcastReceiver otpAutoReadBroadcast = new n__T$(this);
    Queue<String> checkoutMessageQueue = new LinkedList<String>();
    private boolean isCheckoutLoaded = false;

    public CheckoutPresenterImpl(Activity activity, CheckoutPresenterImpl$CheckoutView checkoutPresenterImpl$CheckoutView) {
        this.activity = activity;
        this.view = checkoutPresenterImpl$CheckoutView;
    }

    @Override
    public boolean setOptions(Bundle bundle, boolean bl) {
        this.isActivityCreated = bl;
        if (bundle == null) {
            this.destroyActivity(0, this.activity.getResources().getString(R.string.activity_result_invalid_parameters));
            return false;
        }
        this.checkoutOptions = new x_$Q_(bundle.getString("OPTIONS"));
        Object object = this.checkoutOptions.d();
        if (object.has("retry")) {
            Y_$H_.a().a((JSONObject)object);
        }
        this.merchantKey = this.checkoutOptions.a();
        this.sendSmsHash = this.checkoutOptions.b();
        this.allowRotation = this.checkoutOptions.c();
        this.merchantLogoResourceId = bundle.getInt("IMAGE", 0);
        this.checkoutOptions.a(this.activity, this.merchantLogoResourceId);
        String string2 = this.merchantKey;
        object = this.activity;
        AnalyticsUtil.setup((Context)object, string2, Y_$H_.a, Y_$H_.c, Y_$H_.b);
        object = this.checkoutOptions;
        string2 = "https://api.razorpay.com/v1/checkout/public";
        string2 = CheckoutUtils.a("https://api.razorpay.com/v1/checkout/public", "version", Y_$H_.b);
        Map<String, String> object22 = Y_$H_.a().g();
        ArrayList<String> arrayList = object22.keySet();
        for (String string3 : arrayList) {
            string2 = CheckoutUtils.a(string2, string3, object22.get(string3));
        }
        arrayList = Y_$H_.a().h();
        for (String string4 : arrayList) {
            if (!((x_$Q_)object).a(string4)) continue;
            string2 = CheckoutUtils.a(string2, string4, (String)((x_$Q_)object).c(string4));
        }
        object = "Modified Url: " + string2;
        Log.d((String)"com.razorpay.checkout", (String)object);
        this.checkoutUrl = string2;
        if (this.checkoutUrl == null) {
            this.destroyActivity(3, this.activity.getResources().getString(R.string.activity_result_invalid_url));
        }
        try {
            this.dashOptionsJSON = new JSONObject(this.dashOptions);
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception, "critical", ((Throwable)object).getLocalizedMessage());
        }
        if (!bl) {
            String string3;
            this.checkoutOptions.g();
            string2 = this.merchantKey;
            object = this.activity;
            SharedPreferences sharedPreferences = h.a((Context)object);
            this.dashOptions = sharedPreferences.getString("pref_merchant_options_" + string2, null);
            object = bundle.getString("FRAMEWORK");
            if (object != null) {
                AnalyticsUtil.addProperty("framework", new AnalyticsProperty((String)object, AnalyticsProperty$Scope.ORDER));
            }
            if ((string3 = bundle.getString("FRAMEWORK_VERSION")) != null) {
                AnalyticsUtil.addProperty("frameworkVersion", new AnalyticsProperty(string3, AnalyticsProperty$Scope.ORDER));
            }
            if (bundle.getBoolean("DISABLE_FULL_SCREEN", false)) {
                CheckoutUtils.a(this.activity);
            }
            if (bundle.containsKey("PRELOAD_COMPLETE_DURATION")) {
                this.preloadCompleteDuration = bundle.getLong("PRELOAD_COMPLETE_DURATION");
            }
            if (bundle.containsKey("PRELOAD_ABORT_DURATION")) {
                this.preloadAbortDuration = bundle.getLong("PRELOAD_ABORT_DURATION");
            }
        } else {
            this.dashOptions = bundle.getString("DASH_OPTIONS");
            if (bundle.getBoolean("DISABLE_FULL_SCREEN", false)) {
                CheckoutUtils.a(this.activity);
            }
        }
        return true;
    }

    @Override
    public void onActivityResultReceived(int n, int n2, Intent intent) {
        block9: {
            if (n == 1001) {
                if (n2 == -1) {
                    AnalyticsUtil.trackEvent(AnalyticsEvent.AUTO_READ_OTP_SMS_RETRIEVER_API_RECEIVED_SMS);
                    String string2 = intent.getStringExtra("com.google.android.gms.auth.api.phone.EXTRA_SMS_MESSAGE");
                    if (this.isCheckoutLoaded) {
                        try {
                            JSONObject jSONObject = new JSONObject();
                            jSONObject.put("sender", (Object)"razorpay");
                            jSONObject.put("message", (Object)string2);
                            string2 = jSONObject.toString();
                            string2 = String.format("javascript: OTPElf.elfBridge.setSms(%s)", string2);
                            this.view.loadUrl(1, string2);
                            AnalyticsUtil.trackEvent(AnalyticsEvent.AUTO_READ_OTP_SMS_RETRIEVER_API_OTP_POPULATION_JS);
                            break block9;
                        }
                        catch (JSONException jSONException) {
                            JSONException jSONException2 = jSONException;
                            AnalyticsUtil.reportError((Exception)((Object)jSONException), "critical", jSONException2.getLocalizedMessage());
                            jSONException2.printStackTrace();
                        }
                    }
                    return;
                }
                AnalyticsUtil.trackEvent(AnalyticsEvent.AUTO_READ_OTP_SMS_RETRIEVER_API_CONSENT_DECLINED);
                return;
            }
            if (n == 99) {
                JSONObject jSONObject = BaseUtils.getJSONFromIntentData(intent);
                String string3 = String.format("javascript: upiIntentResponse(%s)", jSONObject.toString());
                this.loadResultToWebView(jSONObject, string3);
                return;
            }
            if (n == 20) {
                try {
                    JSONObject jSONObject = new JSONObject("{'data':" + n2 + "}");
                    jSONObject.put("provider", (Object)"CRED");
                    String string4 = String.format("javascript:externalAppResponse(%s)", jSONObject.toString());
                    this.loadResultToWebView(jSONObject, string4);
                    return;
                }
                catch (JSONException jSONException) {
                    JSONException jSONException3 = jSONException;
                    AnalyticsUtil.reportError((Exception)((Object)jSONException), "critical", jSONException3.getMessage());
                }
            }
        }
    }

    private void loadResultToWebView(JSONObject jSONObject, String string2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("result", jSONObject);
        AnalyticsUtil.trackEvent(AnalyticsEvent.NATIVE_INTENT_ONACTIVITY_RESULT, hashMap);
        if (this.isCheckoutLoaded) {
            this.view.loadUrl(1, string2);
            return;
        }
        if (this.checkoutMessageQueue == null) {
            this.checkoutMessageQueue = new LinkedList<String>();
        }
        this.checkoutMessageQueue.add(string2);
    }

    @Override
    public void verifyGPaySdkResponse(String string2) {
        string2 = String.format("javascript: window.externalSDKResponse(%s)", string2);
        if (this.isCheckoutLoaded) {
            this.view.loadUrl(1, string2);
            return;
        }
        if (this.checkoutMessageQueue == null) {
            this.checkoutMessageQueue = new LinkedList<String>();
        }
        this.checkoutMessageQueue.add(string2);
    }

    @Override
    public String getSdkPlugins() {
        HashMap<String, String> hashMap = BaseUtils.getAllPluginsFromManifest((Context)this.activity);
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("isAmazonPluginIntegrated", false);
            jSONObject.put("isGooglePayPluginIntegrated", false);
            if (hashMap == null || hashMap.size() == 0) {
                return jSONObject.toString();
            }
            for (String string2 : hashMap.values()) {
                if (hashMap.size() > 0 && string2.equalsIgnoreCase("com.razorpay.RazorpayAmazon")) {
                    jSONObject.put("isAmazonPluginIntegrated", true);
                }
                if (hashMap.size() <= 0 || !string2.equalsIgnoreCase("com.razorpay.RzpGpayMerged")) continue;
                jSONObject.put("isGooglePayPluginIntegrated", true);
            }
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "critical", jSONException2.getLocalizedMessage());
            jSONException2.printStackTrace();
        }
        return jSONObject.toString();
    }

    @Override
    public void onCheckoutRendered() {
        AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_RENDERED_COMPLETE);
    }

    @Override
    public x_$Q_ getCheckoutOptions() {
        return this.checkoutOptions;
    }

    @Override
    public void setUpAddOn() {
        this.magicBase = new M$$8$(this.activity, this.view.getWebView(2));
    }

    @Override
    public void loadForm(String string2) {
        if (this.paymentAttempts != 0) {
            AnalyticsUtil.postData();
        }
        ++this.paymentAttempts;
        AnalyticsUtil.addProperty("payment_attempt", new AnalyticsProperty(this.paymentAttempts, AnalyticsProperty$Scope.ORDER));
        this.clearHistory = true;
        string2 = this.checkoutUrl + string2;
        string2 = string2.replace(" ", "%20");
        this.view.loadUrl(1, string2);
    }

    @Override
    public void passPrefillToSegment() {
        String string2 = this.checkoutOptions.j();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            AnalyticsUtil.addProperty("email", new AnalyticsProperty(string2, AnalyticsProperty$Scope.ORDER));
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = this.checkoutOptions.i()))) {
            AnalyticsUtil.addProperty("contact", new AnalyticsProperty(string2, AnalyticsProperty$Scope.ORDER));
        }
    }

    @Override
    public void handleCardSaving() {
        AnalyticsUtil.trackEvent(AnalyticsEvent.CARD_SAVING_START);
        f$_G$.a(this.activity.getApplicationContext());
    }

    @Override
    public void saveInstanceState(Bundle bundle) {
        if (this.merchantLogoResourceId != 0) {
            bundle.putString("OPTIONS", this.checkoutOptions.h());
            bundle.putInt("IMAGE", this.merchantLogoResourceId);
        } else {
            bundle.putString("OPTIONS", this.checkoutOptions.e());
        }
        bundle.putString("DASH_OPTIONS", this.dashOptions);
        if (this.activity.getIntent() != null) {
            bundle.putBoolean("DISABLE_FULL_SCREEN", this.activity.getIntent().getBooleanExtra("DISABLE_FULL_SCREEN", false));
        }
    }

    @Override
    public void setCheckoutLoadStartAt() {
        this.checkoutLoadStartAt = System.nanoTime();
    }

    @Override
    public void destroyActivity(int n, String string2) {
        AnalyticsUtil.addProperty("destroy_resultCode", new AnalyticsProperty(String.valueOf(n), AnalyticsProperty$Scope.ORDER));
        AnalyticsUtil.addProperty("destroy_result", new AnalyticsProperty(string2, AnalyticsProperty$Scope.ORDER));
        AnalyticsUtil.trackEvent(AnalyticsEvent.INTERNAL_DESTROY_METHOD_CALLED);
        this.view.destroy(n, string2);
    }

    @Override
    public void onCheckoutBackPress() {
        AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_SOFT_BACK_PRESSED);
        this.destroyActivity(0, BaseUtils.getPaymentCancelledResponse(this.payment_id));
    }

    protected void enableAddon(JSONObject object) {
        try {
            if (object.has("magic")) {
                this.isMagic = object.getBoolean("magic");
                if (this.magicBase != null) {
                    boolean bl = this.isMagic;
                    object = this.magicBase;
                    this.magicBase.c = bl;
                }
                AnalyticsUtil.addProperty("is_magic", new AnalyticsProperty(this.isMagic, AnalyticsProperty$Scope.PAYMENT));
            }
            return;
        }
        catch (JSONException jSONException) {
            object = jSONException;
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "critical", object.getLocalizedMessage());
            object.printStackTrace();
            return;
        }
    }

    @Override
    public void invokePopup(String object) {
        this.isTwoWebViewFlow = true;
        try {
            this.activity.runOnUiThread((Runnable)new b$_f_(this, (String)object));
            return;
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception, "critical", ((Throwable)object).getLocalizedMessage());
            ((Throwable)object).printStackTrace();
            return;
        }
    }

    @Override
    public void fetchCondfig() {
        Y_$H_.d = this.isMagicPresent();
        Y_$H_.a((Context)this.activity, this.merchantKey);
    }

    @Override
    public boolean isMagicPresent() {
        return false;
    }

    @Override
    public void onProgressChanges(int n, int n2) {
        switch (n) {
            case 1: {
                this.view.showProgressBar(n2);
            }
        }
    }

    @Override
    public void onPageStarted(int n, WebView webView, String string2) {
        switch (n) {
            case 1: {
                CheckoutUtils.e((Context)this.activity);
                return;
            }
            case 2: {
                if (this.magicBase == null || !this.isMagic) break;
                M$$8$ m$$8$ = this.magicBase;
                this.magicBase.d = false;
            }
        }
    }

    @Override
    public void onPageFinished(int n, WebView webView, String string2) {
        switch (n) {
            case 1: {
                this.primaryWebviewPageFinished(string2, webView);
                return;
            }
            case 2: {
                if (this.magicBase == null || !this.isMagic) break;
                this.magicBase.a();
            }
        }
    }

    private void sendQueuedMessagesToCheckout() {
        if (this.checkoutMessageQueue != null && !this.checkoutMessageQueue.isEmpty()) {
            for (String string2 : this.checkoutMessageQueue) {
                this.view.loadUrl(1, string2);
            }
            this.checkoutMessageQueue.clear();
        }
    }

    protected void primaryWebviewPageFinished(String object, WebView object2) {
        long l = System.nanoTime();
        CheckoutUtils.a();
        this.view.hideProgressBar();
        BaseUtils.getDeviceParamValues((Context)this.activity, new k__c$(this));
        if (((String)object).indexOf(this.checkoutUrl) == 0) {
            if (this.paymentAttempts == 1) {
                this.isCheckoutLoaded = true;
                this.sendQueuedMessagesToCheckout();
                object = new HashMap();
                long l2 = l - this.checkoutLoadStartAt;
                object.put("checkout_load_duration", l2);
                object2 = "Checkout loaded in " + BaseUtils.nanoTimeToSecondsString(l2, 2) + " sec.";
                Log.d((String)"com.razorpay.checkout", (String)object2);
                if (this.preloadCompleteDuration > 0L) {
                    object.put("preload_finish_duration", this.preloadCompleteDuration);
                    object2 = "Preload was completed in " + BaseUtils.nanoTimeToSecondsString(this.preloadCompleteDuration, 2) + " sec.";
                    Log.d((String)"com.razorpay.checkout", (String)object2);
                } else if (this.preloadAbortDuration > 0L) {
                    object.put("preload_abort_duration", this.preloadAbortDuration);
                    object2 = "Preload was aborted in " + BaseUtils.nanoTimeToSecondsString(this.preloadAbortDuration, 2) + " sec.";
                    Log.d((String)"com.razorpay.checkout", (String)object2);
                }
                long l3 = this.preloadCompleteDuration - l2;
                if (l3 > 0L) {
                    object.put("time_shaved_off", l3);
                    object2 = "Load time shaved is " + BaseUtils.nanoTimeToSecondsString(l3, 2) + " sec.";
                    Log.d((String)"com.razorpay.checkout", (String)object2);
                }
                AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_LOADED, (Map<String, Object>)object);
            }
            if (this.clearHistory) {
                this.view.clearWebViewHistory(1);
                this.clearHistory = false;
            }
        }
    }

    @Override
    public String getProgressBarColor() {
        String string2 = null;
        try {
            if (this.checkoutOptions.d() == null) {
                throw new Exception("No options defined");
            }
            JSONObject jSONObject = this.checkoutOptions.d();
            JSONObject jSONObject2 = jSONObject.getJSONObject("theme");
            string2 = jSONObject2.getString("color");
            Color.parseColor((String)string2);
        }
        catch (Exception exception) {
            try {
                if (this.dashOptionsJSON == null) {
                    throw new Exception("No dash options defined");
                }
                JSONObject jSONObject = this.dashOptionsJSON.getJSONObject("theme");
                string2 = jSONObject.getString("color");
                Color.parseColor((String)string2);
            }
            catch (Exception exception2) {
                Exception exception3 = exception2;
                AnalyticsUtil.reportError(exception2, "error", exception3.getMessage());
            }
            AnalyticsUtil.reportError(exception, "error", exception.getMessage());
        }
        return string2;
    }

    @Override
    public void onRequestPermissionsResult(int n, String[] stringArray, int[] nArray) {
    }

    @Override
    public void sendOtpPermissionCallback(boolean bl) {
        this.activity.runOnUiThread((Runnable)new N_$R$(this, bl));
    }

    protected void addOnFlowEnd() {
        if (this.magicBase != null) {
            M$$8$ m$$8$ = this.magicBase;
            m$$8$.b.b(m$$8$);
            m$$8$.b.c((Activity)m$$8$.a);
        }
    }

    @Override
    public void cleanUpOnDestroy() {
        this.markPaymentCancelled();
        this.addOnFlowEnd();
        d__B_.a();
    }

    private void markPaymentCancelled() {
        if (this.payment_id == null || this.isPaymentSuccessful) {
            return;
        }
        try {
            String string2 = BaseUtils.constructBasicAuth(this.merchantKey);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("Authorization", "Basic " + string2);
            string2 = "https://api.razorpay.com/v1/payments/" + this.payment_id + "/cancel?platform=android_sdk";
            String string3 = "Sending cancel request";
            Log.d((String)"com.razorpay.checkout", (String)string3);
            p$_5$.a(string2, hashMap, new c__h$(this));
            this.payment_id = null;
            return;
        }
        catch (Exception exception) {
            Object object = exception;
            AnalyticsUtil.reportError(exception, "critical", ((Throwable)object).getLocalizedMessage());
            Exception exception2 = object;
            object = "Exception in cancel req";
            Log.d((String)"com.razorpay.checkout", (String)object, (Throwable)exception2);
            return;
        }
    }

    @Override
    public void backPressed(Map<String, Object> map) {
        AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_HARD_BACK_PRESSED, map);
        Object object = this.view.getWebView(1);
        object = object.getTag() == null ? "" : object.getTag().toString();
        if (object.contains(Y_$H_.a().getCheckoutEndpoint()) && !this.view.isWebViewVisible(2)) {
            this.view.loadUrl(1, "javascript: window.backPressed ? window.backPressed('onCheckoutBackPress') : CheckoutBridge.onCheckoutBackPress();");
            map.put("in_checkout", "true");
            return;
        }
        if (!Y_$H_.a().k()) {
            this.destroyActivity(0, "BackPressed");
            return;
        }
        CheckoutUtils.a((Context)this.activity, Y_$H_.a().l(), Y_$H_.a().j(), Y_$H_.a().i(), new Q$$2_(this, map));
    }

    @Override
    public void onLoad() {
        this.activity.runOnUiThread((Runnable)new d__w$(this));
        if (Build.VERSION.SDK_INT >= 29 || ActivityCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.RECEIVE_SMS") != 0) {
            if (this.sendSmsHash) {
                Object object = SmsRetriever.getClient((Activity)this.activity);
                this.loginOtpSmsTask = object.startSmsRetriever();
                try {
                    new O$_M$(this, 2000L, 1000L).start();
                }
                catch (Exception exception) {
                    object = exception;
                    AnalyticsUtil.reportError(exception, "error", ((Throwable)object).getMessage());
                    this.startSmsRetrieverForSavedCardsOTP();
                    return;
                }
            } else {
                this.startSmsRetrieverForSavedCardsOTP();
            }
        }
    }

    private void startSmsRetrieverForSavedCardsOTP() {
        this.loginOtpSmsTask = SmsRetriever.getClient((Activity)this.activity).startSmsUserConsent(null);
        this.autoReadOtpHelper = new AutoReadOtpHelper(this.activity);
        IntentFilter intentFilter = new IntentFilter("com.google.android.gms.auth.api.phone.SMS_RETRIEVED");
        this.activity.registerReceiver((BroadcastReceiver)this.autoReadOtpHelper, intentFilter);
    }

    protected JSONObject getOptionsForHandleMessage() {
        JSONObject jSONObject = new JSONObject();
        try {
            Object object;
            jSONObject.put("options", (Object)this.checkoutOptions.d());
            jSONObject.put("data", (Object)this.checkoutContent);
            jSONObject.put("id", (Object)AnalyticsUtil.getLocalOrderId());
            jSONObject.put("key_id", (Object)this.merchantKey);
            jSONObject.put("externalSDKs", (Object)new JSONObject());
            if (this.checkoutOptions.b()) {
                object = new AppSignatureHelper((Context)this.activity);
                jSONObject.put("sms_hash", (Object)object.getAppSignatures().get(0));
            }
            jSONObject.put("upi_intents_data", (Object)CheckoutUtils.c((Context)this.activity));
            jSONObject.put("uri_data", (Object)CheckoutUtils.d((Context)this.activity));
            object = new JSONObject();
            object.put("openedAt", System.currentTimeMillis());
            jSONObject.put("metadata", object);
            object = f$_G$.b(this.activity.getApplicationContext());
            if (!TextUtils.isEmpty((CharSequence)object)) {
                jSONObject.put("device_token", object);
            }
            jSONObject.put("sdk_popup", true);
            jSONObject.put("magic", true);
            jSONObject.put("network_type", BaseUtils.getNetworkType((Context)this.activity));
            jSONObject.put("activity_recreated", this.isActivityCreated);
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "warning", jSONException2.getLocalizedMessage());
        }
        return jSONObject;
    }

    private String getHandleMessageFormattedString() {
        return String.format("javascript: handleMessage(%s)", this.getOptionsForHandleMessage().toString());
    }

    @Override
    public void setAppToken(String string2) {
        String string3 = string2;
        string2 = this.activity;
        string2 = h.b((Context)string2);
        string2.putString("rzp_app_token", string3).apply();
    }

    @Override
    public void setDeviceToken(String string2) {
        f$_G$.a((Context)this.activity, string2);
    }

    @Override
    public void callNativeIntent(String string2, String string3) {
        BaseUtils.startActivityForResult(string2, string3, this.activity);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("url", string2 == null ? "null" : string2);
        hashMap.put("package_name", string3 == null ? "null" : string3);
        AnalyticsUtil.trackEvent(AnalyticsEvent.NATIVE_INTENT_CALLED, hashMap);
    }

    @Override
    public void setPaymentID(String string2) {
        String string3 = "setPaymentID called: " + string2;
        Log.d((String)"com.razorpay.checkout", (String)string3);
        this.payment_id = string2;
        AnalyticsUtil.addProperty("payment_id", new AnalyticsProperty(string2, AnalyticsProperty$Scope.PAYMENT));
        AnalyticsUtil.trackEvent(AnalyticsEvent.PAYMENT_ID_ATTACHED);
    }

    @Override
    public void setMerchantOptions(String string2) {
        this.dashOptions = string2;
        try {
            this.dashOptionsJSON = new JSONObject(string2);
        }
        catch (Exception exception) {
            d__1_.a("Error parsing merchant dash options JSON", exception);
            this.dashOptionsJSON = null;
            AnalyticsUtil.reportError(exception, "critical", exception.getMessage());
        }
        if (this.dashOptionsJSON == null) {
            CheckoutUtils.a((Context)this.activity, this.merchantKey, null);
            return;
        }
        CheckoutUtils.a((Context)this.activity, this.merchantKey, string2);
    }

    protected void addAnalyticsData(JSONObject jSONObject) {
        AnalyticsUtil.addFilteredPropertiesFromPayload(jSONObject);
    }

    @Override
    public void onSubmit(String string2) {
        Object object;
        if (this.paymentAttempts > 1) {
            AnalyticsUtil.refreshPaymentSession();
        }
        if (this.autoReadOtpHelper != null && this.loginOtpSmsTask.isComplete()) {
            try {
                this.activity.unregisterReceiver((BroadcastReceiver)this.autoReadOtpHelper);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                object = illegalArgumentException;
                AnalyticsUtil.reportError(illegalArgumentException, "error", object.getMessage());
            }
        }
        try {
            object = new JSONObject(string2);
            this.checkoutContent = string2;
            this.addAnalyticsData((JSONObject)object);
            this.savePrefillData((JSONObject)object);
            string2 = object.getString("method");
            if (Build.VERSION.SDK_INT >= 29 || ActivityCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.RECEIVE_SMS") != 0) {
                if (string2.equalsIgnoreCase("netbanking") || string2.equalsIgnoreCase("card")) {
                    Log.d((String)"SMS", (String)"received method as netbanking");
                    SmsRetriever.getClient((Activity)this.activity).startSmsUserConsent(null);
                    Log.d((String)"SMS", (String)"task started successfully");
                    object = new AutoReadOtpHelper(this.activity);
                    string2 = new IntentFilter("com.google.android.gms.auth.api.phone.SMS_RETRIEVED");
                    this.activity.registerReceiver((BroadcastReceiver)object, (IntentFilter)string2);
                    AnalyticsUtil.trackEvent(AnalyticsEvent.AUTO_READ_OTP_SMS_RETRIEVER_API_TASK);
                }
            } else if (!string2.equals("card") && string2.equals("wallet") && this.checkoutOptions.b(string2 = object.getString("wallet"))) {
                object = new JSONObject();
                object.put("external_wallet", string2);
                AnalyticsUtil.addProperty("external_wallet", new AnalyticsProperty(string2, AnalyticsProperty$Scope.ORDER));
                AnalyticsUtil.trackEvent(AnalyticsEvent.EXTERNAL_WALLET_SELECTED);
                this.onComplete((JSONObject)object);
            }
            AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_SUBMIT);
            AnalyticsUtil.postData();
            return;
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception, "critical", object.getMessage());
            d__1_.a("Error in submit", object);
            return;
        }
    }

    protected void onComplete(JSONObject jSONObject) {
        try {
            if (jSONObject.has("error")) {
                AnalyticsUtil.addProperty("payment_status", new AnalyticsProperty("fail", AnalyticsProperty$Scope.PAYMENT));
                AnalyticsUtil.addProperty("payload", new AnalyticsProperty(jSONObject.toString(), AnalyticsProperty$Scope.PAYMENT));
                AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_PAYMENT_COMPLETE);
                if (this.isTwoWebViewFlow) {
                    this.view.makeWebViewVisible(1);
                }
                this.onError(jSONObject);
            } else if (jSONObject.has("razorpay_fund_account_id")) {
                this.destroyActivity(1, jSONObject.toString());
            } else if (jSONObject.has("razorpay_payment_id")) {
                String string2;
                this.payment_id = string2 = jSONObject.getString("razorpay_payment_id");
                AnalyticsUtil.addProperty("payment_id", new AnalyticsProperty(string2, AnalyticsProperty$Scope.PAYMENT));
                AnalyticsUtil.addProperty("payment_status", new AnalyticsProperty("success", AnalyticsProperty$Scope.PAYMENT));
                AnalyticsUtil.addProperty("payload", new AnalyticsProperty(jSONObject.toString(), AnalyticsProperty$Scope.PAYMENT));
                AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_PAYMENT_COMPLETE);
                this.isPaymentSuccessful = true;
                this.destroyActivity(1, jSONObject.toString());
            } else if (jSONObject.has("external_wallet")) {
                this.destroyActivity(4, jSONObject.toString());
            } else {
                this.destroyActivity(0, "Post payment parsing error");
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            AnalyticsUtil.reportError(exception, "critical", exception2.getMessage());
            this.destroyActivity(0, exception2.getMessage());
        }
        this.isTwoWebViewFlow = false;
    }

    protected void onError(JSONObject object) {
        if (this.isTwoWebViewFlow) {
            object = String.format("javascript: window.onComplete(%s)", object.toString());
            this.view.loadUrl(1, (String)object);
            return;
        }
        this.activity.runOnUiThread((Runnable)new G$_X_(this, (JSONObject)object));
    }

    private void handleRetry(String string2) {
        int n = this.paymentAttempts;
        int n2 = Y_$H_.a().f();
        if (Y_$H_.a().e() && (n2 == -1 || n2 > n)) {
            try {
                JSONObject jSONObject = new JSONObject(string2);
                if (jSONObject.has("error")) {
                    string2 = string2 + (this.checkoutUrl.contains("?") ? "&" : "?");
                    if (jSONObject.get("error") instanceof JSONObject) {
                        jSONObject = (JSONObject)jSONObject.get("error");
                        string2 = string2 + "error=" + jSONObject.toString();
                    }
                }
                this.helpersReset();
                this.loadForm(string2);
                return;
            }
            catch (Exception exception) {
                this.destroyActivity(0, string2);
                AnalyticsUtil.reportError(exception, "critical", exception.getMessage());
                return;
            }
        }
        this.destroyActivity(0, string2);
    }

    protected void helpersReset() {
        String string2 = "helpersReset called";
        Log.d((String)"com.razorpay.checkout", (String)string2);
    }

    private void savePrefillData(JSONObject jSONObject) {
        try {
            if (jSONObject.has("contact")) {
                CheckoutUtils.b((Context)this.activity, jSONObject.getString("contact"));
                this.checkoutOptions.a("contact", jSONObject.getString("contact"));
            }
            if (jSONObject.has("email")) {
                CheckoutUtils.a((Context)this.activity, jSONObject.getString("email"));
                this.checkoutOptions.a("email", jSONObject.getString("email"));
            }
            return;
        }
        catch (JSONException jSONException) {
            d__1_.a("Error parsing JSON", jSONException);
            return;
        }
    }

    @Override
    public void onFault(String string2) {
        this.destroyActivity(3, string2);
    }

    @Override
    public void onComplete(String string2) {
        this.activity.runOnUiThread((Runnable)new O_$v$(this, string2));
    }

    @Override
    public void setDimensions(int n, int n2) {
        if (G_$8_.a((Context)this.activity)) {
            this.activity.runOnUiThread((Runnable)new E$_q$(this, n2, n));
        }
    }

    @Override
    public void onDismiss() {
        this.destroyActivity(0, BaseUtils.getPaymentCancelledResponse(this.payment_id));
    }

    @Override
    public void onDismiss(String string2) {
        this.destroyActivity(0, string2);
    }

    @Override
    public void requestExtraAnalyticsData() {
        JSONObject jSONObject = AnalyticsUtil.getExtraAnalyticsPayload();
        this.activity.runOnUiThread((Runnable)new c$_2_(this, jSONObject));
    }

    @Override
    public void onError(String object) {
        try {
            this.onError(new JSONObject((String)object));
            return;
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception, "critical", ((Throwable)object).getMessage());
            this.activity.runOnUiThread((Runnable)new J__A$(this));
            return;
        }
    }

    @Override
    public void relay(String string2) {
    }

    @Override
    public void requestOtpPermission() {
    }

    @Override
    public void toast(String string2, int n) {
        this.activity.runOnUiThread((Runnable)new L_$k$(this, string2, n));
    }

    @Override
    public void showAlertDialog(String string2, String string3, String string4) {
        this.activity.runOnUiThread((Runnable)new T_$Z$(this, string2, string4, string3));
    }

    @Override
    public void sendDataToWebView(int n, String string2) {
        this.activity.runOnUiThread((Runnable)new J__n_(this, n, string2));
    }

    @Override
    public void checkSmsPermission() {
        this.view.checkSmsPermission();
    }

    @Override
    public void isWebViewSafeOnUI(int n, CheckoutBridge$WebViewSafeCheckCallback checkoutBridge$WebViewSafeCheckCallback) {
        this.activity.runOnUiThread((Runnable)new z$_w$(this, n, checkoutBridge$WebViewSafeCheckCallback));
    }

    private void executeWebViewCallback(int n, CheckoutBridge$WebViewSafeCheckCallback checkoutBridge$WebViewSafeCheckCallback) {
        Object object = n == 1 ? this.view.getWebView(1) : this.view.getWebView(2);
        object = object.getTag().toString();
        try {
            object = new URL((String)object);
            object = ((URL)object).getHost();
            if (object == null || !((String)object).endsWith("razorpay.com")) {
                checkoutBridge$WebViewSafeCheckCallback.unSecure();
                return;
            }
            checkoutBridge$WebViewSafeCheckCallback.secure();
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception, "critical", ((Throwable)object).getLocalizedMessage());
            checkoutBridge$WebViewSafeCheckCallback.unSecure();
        }
    }

    @Override
    public void isWebViewSafe(int n, CheckoutBridge$WebViewSafeCheckCallback checkoutBridge$WebViewSafeCheckCallback) {
        this.executeWebViewCallback(n, checkoutBridge$WebViewSafeCheckCallback);
    }

    @Override
    public boolean isUserRegisteredOnUPI(String string2) {
        return BaseUtils.checkUpiRegisteredApp((Context)this.activity, string2);
    }

    @Override
    public boolean isUserRegistered(String string2) {
        return BaseUtils.checkGpayCardsUpiRegistered(this.activity, string2);
    }

    @Override
    public boolean isAllowRotation() {
        return this.allowRotation;
    }

    static /* synthetic */ boolean access$000(CheckoutPresenterImpl checkoutPresenterImpl) {
        return checkoutPresenterImpl.isTwoWebViewFlow;
    }

    static /* synthetic */ void access$100(CheckoutPresenterImpl checkoutPresenterImpl, String string) {
        checkoutPresenterImpl.handleRetry(string);
    }

    static /* synthetic */ void access$200(CheckoutPresenterImpl checkoutPresenterImpl) {
        checkoutPresenterImpl.markPaymentCancelled();
    }

    static /* synthetic */ boolean access$002(CheckoutPresenterImpl checkoutPresenterImpl, boolean bl) {
        checkoutPresenterImpl.isTwoWebViewFlow = bl;
        return checkoutPresenterImpl.isTwoWebViewFlow;
    }

    static /* synthetic */ String access$300(CheckoutPresenterImpl checkoutPresenterImpl) {
        return checkoutPresenterImpl.getHandleMessageFormattedString();
    }

    static /* synthetic */ Task access$400(CheckoutPresenterImpl checkoutPresenterImpl) {
        return checkoutPresenterImpl.loginOtpSmsTask;
    }

    static /* synthetic */ BroadcastReceiver access$500(CheckoutPresenterImpl checkoutPresenterImpl) {
        return checkoutPresenterImpl.otpAutoReadBroadcast;
    }

    static /* synthetic */ void access$600(CheckoutPresenterImpl checkoutPresenterImpl) {
        checkoutPresenterImpl.startSmsRetrieverForSavedCardsOTP();
    }

    static /* synthetic */ void access$700(CheckoutPresenterImpl checkoutPresenterImpl, int n, CheckoutBridge$WebViewSafeCheckCallback checkoutBridge$WebViewSafeCheckCallback) {
        checkoutPresenterImpl.executeWebViewCallback(n, checkoutBridge$WebViewSafeCheckCallback);
    }
}

