/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.app.Activity;
import android.content.Intent;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsUtil;
import com.razorpay.CheckoutPresenterImpl;
import com.razorpay.E$_6$;
import com.razorpay.PluginCheckoutInteractor;
import com.razorpay.RzpInternalCallback;
import com.razorpay.RzpPlugin;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class PluginOtpElfCheckoutPresenterImpl
extends E$_6$
implements PluginCheckoutInteractor {
    private HashMap<String, String> pluginsMap;
    private boolean isExtRzpPluginActive = false;
    private RzpPlugin extActiveRzpPluginInstance;
    private final RzpInternalCallback rzpInternalCallback = new RzpInternalCallback(){

        @Override
        public void onPaymentSuccess(String string2) {
            try {
                JSONObject jSONObject = new JSONObject(string2);
                if (jSONObject.has("provider") && jSONObject.getString("provider").equals("GOOGLE_PAY")) {
                    PluginOtpElfCheckoutPresenterImpl.this.verifyGPayResponse(string2);
                    return;
                }
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("response", string2);
                AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_PLUGIN_INTERNAL_CALLBACK_SUCCESS, hashMap);
                PluginOtpElfCheckoutPresenterImpl.this.onComplete(string2);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_PLUGIN_INTERNAL_CALLBACK_ERROR);
            }
        }

        @Override
        public void onPaymentError(int n, String string2) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("response", string2);
            hashMap.put("code", n);
            AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_PLUGIN_INTERNAL_CALLBACK_ERROR, hashMap);
            try {
                JSONObject jSONObject = new JSONObject(string2);
                PluginOtpElfCheckoutPresenterImpl.this.onComplete(jSONObject.toString());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_PLUGIN_INTERNAL_CALLBACK_ERROR_EXCEPTION);
                PluginOtpElfCheckoutPresenterImpl.this.onComplete(string2);
            }
        }
    };

    public PluginOtpElfCheckoutPresenterImpl(Activity activity, CheckoutPresenterImpl.CheckoutView checkoutView, HashMap<String, String> hashMap) {
        super(activity, checkoutView);
        this.pluginsMap = hashMap;
    }

    @Override
    public void processPayment(String string2) {
        JSONObject jSONObject;
        if (this.pluginsMap == null || this.pluginsMap.size() == 0) {
            return;
        }
        try {
            jSONObject = new JSONObject(string2);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("data", string2);
            AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_PLUGIN_CALLING_PROCESS_PAYMENT_EXCEPTION, hashMap);
            jSONException.printStackTrace();
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("data", string2);
        AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_PLUGIN_CALLING_PROCESS_PAYMENT, hashMap);
        for (String string3 : this.pluginsMap.values()) {
            try {
                RzpPlugin rzpPlugin = (RzpPlugin)RzpPlugin.class.getClassLoader().loadClass(string3).newInstance();
                if (!rzpPlugin.doesHandlePayload(this.merchantKey, jSONObject, this.activity)) continue;
                this.isExtRzpPluginActive = true;
                this.extActiveRzpPluginInstance = rzpPlugin;
                rzpPlugin.processPayment(this.merchantKey, jSONObject, this.activity, this.rzpInternalCallback);
                return;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                AnalyticsUtil.reportError(reflectiveOperationException, "critical", reflectiveOperationException.getLocalizedMessage());
                reflectiveOperationException.printStackTrace();
            }
        }
    }

    @Override
    public void verifyGPayResponse(String string2) {
        super.verifyGPaySdkResponse(string2);
    }

    @Override
    protected JSONObject getOptionsForHandleMessage() {
        JSONObject jSONObject = super.getOptionsForHandleMessage();
        JSONObject jSONObject2 = new JSONObject();
        try {
            for (String string2 : this.pluginsMap.keySet()) {
                int n = "com.razorpay.plugin.".length();
                int n2 = string2.length();
                jSONObject2.put(string2.substring(n, n2), true);
            }
            jSONObject.put("external_sdks", (Object)jSONObject2);
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError(exception, "error", exception.getLocalizedMessage());
            exception.printStackTrace();
        }
        return jSONObject;
    }

    @Override
    protected void onError(JSONObject jSONObject) {
        AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_PLUGIN_ON_ERROR_CALLED, jSONObject);
        if (this.isExtRzpPluginActive) {
            String string2 = String.format("javascript: window.onComplete(%s)", jSONObject.toString());
            this.view.loadUrl(1, string2);
            this.isExtRzpPluginActive = false;
        } else {
            super.onError(jSONObject);
        }
    }

    @Override
    public void onActivityResultReceived(int n, int n2, Intent intent) {
        if (this.isExtRzpPluginActive) {
            this.extActiveRzpPluginInstance.onActivityResult(this.merchantKey, n, n2, intent);
        } else {
            super.onActivityResultReceived(n, n2, intent);
        }
    }
}

