/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.text.TextUtils;
import android.util.Log;
import android.view.WindowManager;
import android.webkit.WebView;
import androidx.core.app.ActivityCompat;
import com.google.android.gms.auth.api.phone.SmsRetriever;
import com.google.android.gms.auth.api.phone.SmsRetrieverClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.tasks.Task;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsProperty;
import com.razorpay.AnalyticsUtil;
import com.razorpay.AppSignatureHelper;
import com.razorpay.AutoReadOtpHelper;
import com.razorpay.B$$W$;
import com.razorpay.BaseUtils;
import com.razorpay.Callback;
import com.razorpay.CheckoutBridge;
import com.razorpay.CheckoutInteractor;
import com.razorpay.CheckoutPresenter;
import com.razorpay.CheckoutUtils;
import com.razorpay.D$_X_;
import com.razorpay.J$_0_;
import com.razorpay.O_$B_;
import com.razorpay.Q_$2$;
import com.razorpay.R;
import com.razorpay.R$$r_;
import com.razorpay.ResponseObject;
import com.razorpay.RzpJSONCallback;
import com.razorpay.Y$_o$;
import com.razorpay.g__v_;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.json.JSONException;
import org.json.JSONObject;

class CheckoutPresenterImpl
implements CheckoutInteractor,
CheckoutPresenter {
    protected Activity activity;
    protected CheckoutView view;
    String merchantKey;
    Q_$2$ checkoutOptions;
    private String dashOptions;
    private JSONObject dashOptionsJSON;
    private String checkoutUrl;
    private String checkoutContent = "{}";
    private int paymentAttempts = 0;
    private boolean clearHistory;
    private boolean isPaymentSuccessful = false;
    private long preloadCompleteDuration;
    private long preloadAbortDuration;
    private long checkoutLoadStartAt;
    private boolean isTwoWebViewFlow = false;
    private boolean isMagic = false;
    private int merchantLogoResourceId = 0;
    private boolean isActivityCreated = false;
    private Task<Void> loginOtpSmsTask;
    private AutoReadOtpHelper autoReadOtpHelper;
    private boolean sendSmsHash = false;
    private boolean allowRotation = false;
    private String payment_id = null;
    private Y$_o$ magicBase = null;
    private BroadcastReceiver otpAutoReadBroadcast = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if ("com.google.android.gms.auth.api.phone.SMS_RETRIEVED".equals(intent.getAction())) {
                Bundle bundle = intent.getExtras();
                Status status = (Status)bundle.get("com.google.android.gms.auth.api.phone.EXTRA_STATUS");
                switch (status.getStatusCode()) {
                    case 0: {
                        String string2 = (String)bundle.get("com.google.android.gms.auth.api.phone.EXTRA_SMS_MESSAGE");
                        Intent intent2 = new Intent();
                        intent2.putExtra("com.google.android.gms.auth.api.phone.EXTRA_SMS_MESSAGE", string2);
                        CheckoutPresenterImpl.this.onActivityResultReceived(1001, -1, intent2);
                        break;
                    }
                    case 15: {
                        AnalyticsUtil.trackEvent(AnalyticsEvent.AUTO_READ_OTP_SMS_RETRIEVER_API_TIMEOUT);
                    }
                }
            }
        }
    };
    Queue<String> checkoutMessageQueue = new LinkedList<String>();
    private boolean isCheckoutLoaded = false;

    public CheckoutPresenterImpl(Activity activity, CheckoutView checkoutView) {
        this.activity = activity;
        this.view = checkoutView;
    }

    @Override
    public boolean setOptions(Bundle bundle, boolean bl) {
        this.isActivityCreated = bl;
        if (bundle == null) {
            this.destroyActivity(0, this.activity.getResources().getString(R.string.activity_result_invalid_parameters));
            return false;
        }
        this.checkoutOptions = new Q_$2$(bundle.getString("OPTIONS"));
        JSONObject jSONObject = this.checkoutOptions.d();
        if (jSONObject.has("retry")) {
            D$_X_.a().a(jSONObject);
        }
        this.merchantKey = this.checkoutOptions.a();
        this.sendSmsHash = this.checkoutOptions.b();
        this.allowRotation = this.checkoutOptions.c();
        this.merchantLogoResourceId = bundle.getInt("IMAGE", 0);
        this.checkoutOptions.a(this.activity, this.merchantLogoResourceId);
        CheckoutUtils.a((Context)this.activity, this.merchantKey);
        this.checkoutUrl = CheckoutUtils.a(this.checkoutOptions);
        if (this.checkoutUrl == null) {
            this.destroyActivity(3, this.activity.getResources().getString(R.string.activity_result_invalid_url));
        }
        try {
            this.dashOptionsJSON = new JSONObject(this.dashOptions);
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError(exception, "critical", exception.getLocalizedMessage());
        }
        if (!bl) {
            String string2;
            this.checkoutOptions.h();
            this.dashOptions = CheckoutUtils.c((Context)this.activity, this.merchantKey);
            String string3 = bundle.getString("FRAMEWORK");
            if (string3 != null) {
                AnalyticsUtil.addProperty("framework", new AnalyticsProperty(string3, AnalyticsProperty.Scope.ORDER));
            }
            if ((string2 = bundle.getString("FRAMEWORK_VERSION")) != null) {
                AnalyticsUtil.addProperty("frameworkVersion", new AnalyticsProperty(string2, AnalyticsProperty.Scope.ORDER));
            }
            if (bundle.getBoolean("DISABLE_FULL_SCREEN", false)) {
                CheckoutUtils.a(this.activity);
            }
            if (bundle.containsKey("PRELOAD_COMPLETE_DURATION")) {
                this.preloadCompleteDuration = bundle.getLong("PRELOAD_COMPLETE_DURATION");
            }
            if (bundle.containsKey("PRELOAD_ABORT_DURATION")) {
                this.preloadAbortDuration = bundle.getLong("PRELOAD_ABORT_DURATION");
            }
        } else {
            this.dashOptions = bundle.getString("DASH_OPTIONS");
            if (bundle.getBoolean("DISABLE_FULL_SCREEN", false)) {
                CheckoutUtils.a(this.activity);
            }
        }
        return true;
    }

    @Override
    public void onActivityResultReceived(int n, int n2, Intent intent) {
        if (n == 1001) {
            if (n2 == -1) {
                AnalyticsUtil.trackEvent(AnalyticsEvent.AUTO_READ_OTP_SMS_RETRIEVER_API_RECEIVED_SMS);
                String string2 = intent.getStringExtra("com.google.android.gms.auth.api.phone.EXTRA_SMS_MESSAGE");
                if (this.isCheckoutLoaded) {
                    try {
                        JSONObject jSONObject = new JSONObject();
                        jSONObject.put("sender", (Object)"razorpay");
                        jSONObject.put("message", (Object)string2);
                        String string3 = jSONObject.toString();
                        String string4 = String.format("javascript: OTPElf.elfBridge.setSms(%s)", string3);
                        this.view.loadUrl(1, string4);
                        AnalyticsUtil.trackEvent(AnalyticsEvent.AUTO_READ_OTP_SMS_RETRIEVER_API_OTP_POPULATION_JS);
                    }
                    catch (JSONException jSONException) {
                        AnalyticsUtil.reportError((Exception)((Object)jSONException), "critical", jSONException.getLocalizedMessage());
                        jSONException.printStackTrace();
                    }
                }
            } else {
                AnalyticsUtil.trackEvent(AnalyticsEvent.AUTO_READ_OTP_SMS_RETRIEVER_API_CONSENT_DECLINED);
            }
        } else if (n == 99) {
            JSONObject jSONObject = BaseUtils.getJSONFromIntentData(intent);
            String string5 = String.format("javascript: upiIntentResponse(%s)", jSONObject.toString());
            this.loadResultToWebView(jSONObject, string5);
        } else if (n == 20) {
            JSONObject jSONObject = null;
            try {
                jSONObject = new JSONObject("{'data':" + n2 + "}");
                jSONObject.put("provider", (Object)"CRED");
                String string6 = String.format("javascript:externalAppResponse(%s)", jSONObject.toString());
                this.loadResultToWebView(jSONObject, string6);
            }
            catch (JSONException jSONException) {
                AnalyticsUtil.reportError((Exception)((Object)jSONException), "critical", jSONException.getMessage());
            }
        }
    }

    private void loadResultToWebView(JSONObject jSONObject, String string2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("result", jSONObject);
        AnalyticsUtil.trackEvent(AnalyticsEvent.NATIVE_INTENT_ONACTIVITY_RESULT, hashMap);
        if (this.isCheckoutLoaded) {
            this.view.loadUrl(1, string2);
        } else {
            if (this.checkoutMessageQueue == null) {
                this.checkoutMessageQueue = new LinkedList<String>();
            }
            this.checkoutMessageQueue.add(string2);
        }
    }

    @Override
    public void verifyGPaySdkResponse(String string2) {
        String string3 = String.format("javascript: window.externalSDKResponse(%s)", string2);
        if (this.isCheckoutLoaded) {
            this.view.loadUrl(1, string3);
        } else {
            if (this.checkoutMessageQueue == null) {
                this.checkoutMessageQueue = new LinkedList<String>();
            }
            this.checkoutMessageQueue.add(string3);
        }
    }

    @Override
    public String getSdkPlugins() {
        HashMap<String, String> hashMap = BaseUtils.getAllPluginsFromManifest((Context)this.activity);
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("isAmazonPluginIntegrated", false);
            jSONObject.put("isGooglePayPluginIntegrated", false);
            if (hashMap == null || hashMap.size() == 0) {
                return jSONObject.toString();
            }
            for (String string2 : hashMap.values()) {
                if (hashMap.size() > 0 && string2.equalsIgnoreCase("com.razorpay.RazorpayAmazon")) {
                    jSONObject.put("isAmazonPluginIntegrated", true);
                }
                if (hashMap.size() <= 0 || !string2.equalsIgnoreCase("com.razorpay.RzpGooglePay")) continue;
                jSONObject.put("isGooglePayPluginIntegrated", true);
            }
        }
        catch (JSONException jSONException) {
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "critical", jSONException.getLocalizedMessage());
            jSONException.printStackTrace();
        }
        return jSONObject.toString();
    }

    @Override
    public void onCheckoutRendered() {
        AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_RENDERED_COMPLETE);
    }

    @Override
    public Q_$2$ getCheckoutOptions() {
        return this.checkoutOptions;
    }

    @Override
    public void setUpAddOn() {
        this.magicBase = new Y$_o$(this.activity, this.view.getWebView(2));
    }

    @Override
    public void loadForm(String string2) {
        if (this.paymentAttempts != 0) {
            AnalyticsUtil.postData();
        }
        ++this.paymentAttempts;
        AnalyticsUtil.addProperty("payment_attempt", new AnalyticsProperty(this.paymentAttempts, AnalyticsProperty.Scope.ORDER));
        this.clearHistory = true;
        String string3 = this.checkoutUrl + string2;
        string3 = string3.replace(" ", "%20");
        this.view.loadUrl(1, string3);
    }

    @Override
    public void passPrefillToSegment() {
        String string2;
        String string3 = this.checkoutOptions.k();
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            AnalyticsUtil.addProperty("email", new AnalyticsProperty(string3, AnalyticsProperty.Scope.ORDER));
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = this.checkoutOptions.j()))) {
            AnalyticsUtil.addProperty("contact", new AnalyticsProperty(string2, AnalyticsProperty.Scope.ORDER));
        }
    }

    @Override
    public void handleCardSaving() {
        AnalyticsUtil.trackEvent(AnalyticsEvent.CARD_SAVING_START);
        R$$r_.b(this.activity.getApplicationContext());
    }

    @Override
    public void saveInstanceState(Bundle bundle) {
        if (this.merchantLogoResourceId != 0) {
            bundle.putString("OPTIONS", this.checkoutOptions.i());
            bundle.putInt("IMAGE", this.merchantLogoResourceId);
        } else {
            bundle.putString("OPTIONS", this.checkoutOptions.e());
        }
        bundle.putString("DASH_OPTIONS", this.dashOptions);
        if (this.activity.getIntent() != null) {
            bundle.putBoolean("DISABLE_FULL_SCREEN", this.activity.getIntent().getBooleanExtra("DISABLE_FULL_SCREEN", false));
        }
    }

    @Override
    public void setCheckoutLoadStartAt() {
        this.checkoutLoadStartAt = System.nanoTime();
    }

    @Override
    public void destroyActivity(int n, String string2) {
        AnalyticsUtil.addProperty("destroy_resultCode", new AnalyticsProperty(String.valueOf(n), AnalyticsProperty.Scope.ORDER));
        AnalyticsUtil.addProperty("destroy_result", new AnalyticsProperty(string2, AnalyticsProperty.Scope.ORDER));
        AnalyticsUtil.trackEvent(AnalyticsEvent.INTERNAL_DESTROY_METHOD_CALLED);
        this.view.destroy(n, string2);
    }

    @Override
    public void onCheckoutBackPress() {
        AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_SOFT_BACK_PRESSED);
        this.destroyActivity(0, "" + BaseUtils.getPaymentCancelledResponse(this.payment_id));
    }

    protected void enableAddon(JSONObject jSONObject) {
        try {
            if (jSONObject.has("magic")) {
                this.isMagic = jSONObject.getBoolean("magic");
                if (this.magicBase != null) {
                    this.magicBase.a(this.isMagic);
                }
                AnalyticsUtil.addProperty("is_magic", new AnalyticsProperty(this.isMagic, AnalyticsProperty.Scope.PAYMENT));
            }
        }
        catch (JSONException jSONException) {
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "critical", jSONException.getLocalizedMessage());
            jSONException.printStackTrace();
        }
    }

    @Override
    public void invokePopup(final String string2) {
        this.isTwoWebViewFlow = true;
        try {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String string22;
                        JSONObject jSONObject = new JSONObject(string2);
                        CheckoutPresenterImpl.this.enableAddon(jSONObject);
                        if (jSONObject.has("content")) {
                            string22 = jSONObject.getString("content");
                            CheckoutPresenterImpl.this.view.loadDataWithBaseURL(2, "about:blank", string22, "text/html", "UTF-8", null);
                        }
                        if (jSONObject.has("url")) {
                            string22 = jSONObject.getString("url");
                            CheckoutPresenterImpl.this.view.loadUrl(2, string22);
                        }
                        if (jSONObject.has("focus") && !jSONObject.getBoolean("focus")) {
                            CheckoutPresenterImpl.this.view.makeWebViewVisible(1);
                        } else {
                            CheckoutPresenterImpl.this.view.makeWebViewVisible(2);
                        }
                    }
                    catch (Exception exception) {
                        AnalyticsUtil.reportError(exception, "critical", exception.getLocalizedMessage());
                        exception.printStackTrace();
                    }
                    AnalyticsUtil.addProperty("two_webview_flow", new AnalyticsProperty(true, AnalyticsProperty.Scope.PAYMENT));
                }
            });
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError(exception, "critical", exception.getLocalizedMessage());
            exception.printStackTrace();
        }
    }

    @Override
    public void fetchCondfig() {
        D$_X_.f = this.isMagicPresent();
        D$_X_.a((Context)this.activity, this.merchantKey);
    }

    @Override
    public boolean isMagicPresent() {
        return false;
    }

    @Override
    public void onProgressChanges(int n, int n2) {
        switch (n) {
            case 1: {
                this.view.showProgressBar(n2);
                break;
            }
            case 2: {
                if (this.magicBase == null || !this.isMagic) break;
                this.magicBase.a(n2);
            }
        }
    }

    @Override
    public void onPageStarted(int n, WebView webView, String string2) {
        switch (n) {
            case 1: {
                CheckoutUtils.e((Context)this.activity);
                break;
            }
            case 2: {
                if (this.magicBase == null || !this.isMagic) break;
                this.magicBase.b(webView, string2);
            }
        }
    }

    @Override
    public void onPageFinished(int n, WebView webView, String string2) {
        switch (n) {
            case 1: {
                this.primaryWebviewPageFinished(string2, webView);
                break;
            }
            case 2: {
                if (this.magicBase == null || !this.isMagic) break;
                this.magicBase.a(webView, string2);
            }
        }
    }

    private void sendQueuedMessagesToCheckout() {
        if (this.checkoutMessageQueue != null && !this.checkoutMessageQueue.isEmpty()) {
            for (String string2 : this.checkoutMessageQueue) {
                this.view.loadUrl(1, string2);
            }
            this.checkoutMessageQueue.clear();
        }
    }

    protected void primaryWebviewPageFinished(String string2, WebView webView) {
        long l = System.nanoTime();
        CheckoutUtils.a();
        this.view.hideProgressBar();
        BaseUtils.getDeviceParamValues((Context)this.activity, new RzpJSONCallback(){

            @Override
            public void onResponse(JSONObject jSONObject) {
                CheckoutPresenterImpl.this.view.loadUrl(1, String.format("javascript: window.getDeviceDetails(%s)", jSONObject.toString()));
            }
        });
        if (string2.indexOf(this.checkoutUrl) == 0) {
            if (this.paymentAttempts == 1) {
                this.isCheckoutLoaded = true;
                this.sendQueuedMessagesToCheckout();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                long l2 = l - this.checkoutLoadStartAt;
                hashMap.put("checkout_load_duration", l2);
                B$$W$.b("Checkout loaded in " + BaseUtils.nanoTimeToSecondsString(l2, 2) + " sec.");
                if (this.preloadCompleteDuration > 0L) {
                    hashMap.put("preload_finish_duration", this.preloadCompleteDuration);
                    B$$W$.b("Preload was completed in " + BaseUtils.nanoTimeToSecondsString(this.preloadCompleteDuration, 2) + " sec.");
                } else if (this.preloadAbortDuration > 0L) {
                    hashMap.put("preload_abort_duration", this.preloadAbortDuration);
                    B$$W$.b("Preload was aborted in " + BaseUtils.nanoTimeToSecondsString(this.preloadAbortDuration, 2) + " sec.");
                }
                long l3 = this.preloadCompleteDuration - l2;
                if (l3 > 0L) {
                    hashMap.put("time_shaved_off", l3);
                    B$$W$.b("Load time shaved is " + BaseUtils.nanoTimeToSecondsString(l3, 2) + " sec.");
                }
                AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_LOADED, hashMap);
            }
            if (this.clearHistory) {
                this.view.clearWebViewHistory(1);
                this.clearHistory = false;
            }
        }
    }

    @Override
    public String getProgressBarColor() {
        String string2 = null;
        try {
            if (this.checkoutOptions.d() == null) {
                throw new Exception("No options defined");
            }
            JSONObject jSONObject = this.checkoutOptions.d();
            JSONObject jSONObject2 = jSONObject.getJSONObject("theme");
            string2 = jSONObject2.getString("color");
            Color.parseColor((String)string2);
        }
        catch (Exception exception) {
            try {
                if (this.dashOptionsJSON == null) {
                    throw new Exception("No dash options defined");
                }
                JSONObject jSONObject = this.dashOptionsJSON.getJSONObject("theme");
                string2 = jSONObject.getString("color");
                Color.parseColor((String)string2);
            }
            catch (Exception exception2) {
                AnalyticsUtil.reportError(exception2, "error", exception2.getMessage());
            }
            AnalyticsUtil.reportError(exception, "error", exception.getMessage());
        }
        return string2;
    }

    @Override
    public void onRequestPermissionsResult(int n, String[] stringArray, int[] nArray) {
    }

    @Override
    public void sendOtpPermissionCallback(final boolean bl) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("granted", bl);
                    CheckoutPresenterImpl.this.view.loadUrl(1, String.format("javascript: otpPermissionCallback(%s)", jSONObject.toString()));
                }
                catch (Exception exception) {
                    AnalyticsUtil.reportError(exception, "warning", exception.getLocalizedMessage());
                }
            }
        });
    }

    protected void addOnFlowEnd() {
        if (this.magicBase != null) {
            this.magicBase.a();
        }
    }

    @Override
    public void cleanUpOnDestroy() {
        this.markPaymentCancelled();
        this.addOnFlowEnd();
        g__v_.a();
    }

    private void markPaymentCancelled() {
        if (this.payment_id == null || this.isPaymentSuccessful) {
            return;
        }
        try {
            String string2 = BaseUtils.constructBasicAuth(this.merchantKey);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("Authorization", "Basic " + string2);
            String string3 = "https://api.razorpay.com/v1/payments/" + this.payment_id + "/cancel?platform=android_sdk";
            B$$W$.b("Sending cancel request");
            O_$B_.a(string3, hashMap, new Callback(){

                @Override
                public void run(ResponseObject responseObject) {
                    B$$W$.b("API Cancel hit: " + responseObject.getResponseResult());
                }
            });
            this.payment_id = null;
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError(exception, "critical", exception.getLocalizedMessage());
            B$$W$.a("Exception in cancel req", exception);
        }
    }

    @Override
    public void backPressed(final Map<String, Object> map) {
        AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_HARD_BACK_PRESSED, map);
        if (CheckoutUtils.a(this.view.getWebView(1)) && !this.view.isWebViewVisible(2)) {
            this.view.loadUrl(1, "javascript: window.backPressed ? window.backPressed('onCheckoutBackPress') : CheckoutBridge.onCheckoutBackPress();");
            map.put("in_checkout", "true");
        } else if (!D$_X_.a().k()) {
            this.destroyActivity(0, "BackPressed");
        } else {
            CheckoutUtils.a((Context)this.activity, D$_X_.a().l(), D$_X_.a().j(), D$_X_.a().i(), new CheckoutUtils.BackButtonDialogCallback(){

                @Override
                public void onPositiveButtonClick() {
                    B$$W$.b("ALERT Don't cancel");
                    AnalyticsUtil.trackEvent(AnalyticsEvent.ALERT_PAYMENT_CONTINUE, map);
                }

                @Override
                public void onNegativeButtonClick() {
                    B$$W$.b("ALERT Cancel");
                    AnalyticsUtil.trackEvent(AnalyticsEvent.ALERT_PAYMENT_CANCELLED, map);
                    if (CheckoutPresenterImpl.this.isTwoWebViewFlow) {
                        CheckoutPresenterImpl.this.view.makeWebViewVisible(1);
                        CheckoutPresenterImpl.this.view.loadUrl(2, "about:blank");
                        CheckoutPresenterImpl.this.view.loadUrl(1, "javascript: window.onpaymentcancel()");
                    } else {
                        CheckoutPresenterImpl.this.handleRetry("");
                        CheckoutPresenterImpl.this.markPaymentCancelled();
                    }
                    CheckoutPresenterImpl.this.isTwoWebViewFlow = false;
                }
            });
        }
    }

    @Override
    public void onLoad() {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                CheckoutPresenterImpl.this.view.loadUrl(1, CheckoutPresenterImpl.this.getHandleMessageFormattedString());
                CheckoutPresenterImpl.this.view.loadUrl(1, String.format("javascript: CheckoutBridge.sendAnalyticsData({data: %s})", AnalyticsUtil.getAnalyticsDataForCheckout((Context)CheckoutPresenterImpl.this.activity).toString()));
            }
        });
        if (Build.VERSION.SDK_INT >= 29 || ActivityCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.RECEIVE_SMS") != 0) {
            if (this.sendSmsHash) {
                SmsRetrieverClient smsRetrieverClient = SmsRetriever.getClient((Activity)this.activity);
                this.loginOtpSmsTask = smsRetrieverClient.startSmsRetriever();
                try {
                    new CountDownTimer(2000L, 1000L){

                        public void onTick(long l) {
                        }

                        public void onFinish() {
                            try {
                                if (CheckoutPresenterImpl.this.loginOtpSmsTask.isSuccessful()) {
                                    IntentFilter intentFilter = new IntentFilter("com.google.android.gms.auth.api.phone.SMS_RETRIEVED");
                                    CheckoutPresenterImpl.this.activity.registerReceiver(CheckoutPresenterImpl.this.otpAutoReadBroadcast, intentFilter, "com.google.android.gms.auth.api.phone.permission.SEND", null);
                                } else {
                                    CheckoutPresenterImpl.this.startSmsRetrieverForSavedCardsOTP();
                                }
                            }
                            catch (Exception exception) {
                                AnalyticsUtil.reportError(exception, "error", exception.getMessage());
                                CheckoutPresenterImpl.this.startSmsRetrieverForSavedCardsOTP();
                            }
                            catch (AbstractMethodError abstractMethodError) {
                                AnalyticsUtil.reportError(abstractMethodError, "error", abstractMethodError.getMessage());
                                CheckoutPresenterImpl.this.startSmsRetrieverForSavedCardsOTP();
                            }
                        }
                    }.start();
                }
                catch (Exception exception) {
                    AnalyticsUtil.reportError(exception, "error", exception.getMessage());
                    this.startSmsRetrieverForSavedCardsOTP();
                }
            } else {
                this.startSmsRetrieverForSavedCardsOTP();
            }
        }
    }

    private void startSmsRetrieverForSavedCardsOTP() {
        this.loginOtpSmsTask = SmsRetriever.getClient((Activity)this.activity).startSmsUserConsent(null);
        this.autoReadOtpHelper = new AutoReadOtpHelper(this.activity);
        IntentFilter intentFilter = new IntentFilter("com.google.android.gms.auth.api.phone.SMS_RETRIEVED");
        this.activity.registerReceiver((BroadcastReceiver)this.autoReadOtpHelper, intentFilter);
    }

    protected JSONObject getOptionsForHandleMessage() {
        JSONObject jSONObject = new JSONObject();
        try {
            AppSignatureHelper appSignatureHelper;
            jSONObject.put("options", (Object)this.checkoutOptions.d());
            jSONObject.put("data", (Object)this.checkoutContent);
            jSONObject.put("id", (Object)AnalyticsUtil.getLocalOrderId());
            jSONObject.put("key_id", (Object)this.merchantKey);
            jSONObject.put("externalSDKs", (Object)new JSONObject());
            if (this.checkoutOptions.b()) {
                appSignatureHelper = new AppSignatureHelper((Context)this.activity);
                jSONObject.put("sms_hash", (Object)appSignatureHelper.getAppSignatures().get(0));
            }
            jSONObject.put("upi_intents_data", (Object)CheckoutUtils.c((Context)this.activity));
            jSONObject.put("uri_data", (Object)CheckoutUtils.d((Context)this.activity));
            appSignatureHelper = new JSONObject();
            appSignatureHelper.put("openedAt", System.currentTimeMillis());
            jSONObject.put("metadata", (Object)appSignatureHelper);
            String string2 = R$$r_.c(this.activity.getApplicationContext());
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                jSONObject.put("device_token", (Object)string2);
            }
            jSONObject.put("sdk_popup", true);
            jSONObject.put("magic", true);
            jSONObject.put("network_type", BaseUtils.getNetworkType((Context)this.activity));
            jSONObject.put("activity_recreated", this.isActivityCreated);
        }
        catch (JSONException jSONException) {
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "warning", jSONException.getLocalizedMessage());
        }
        return jSONObject;
    }

    private String getHandleMessageFormattedString() {
        return String.format("javascript: handleMessage(%s)", this.getOptionsForHandleMessage().toString());
    }

    @Override
    public void setAppToken(String string2) {
        R$$r_.a((Context)this.activity, string2);
    }

    @Override
    public void setDeviceToken(String string2) {
        R$$r_.b((Context)this.activity, string2);
    }

    @Override
    public void callNativeIntent(String string2, String string3) {
        BaseUtils.startActivityForResult(string2, string3, this.activity);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("url", string2 == null ? "null" : string2);
        hashMap.put("package_name", string3 == null ? "null" : string3);
        AnalyticsUtil.trackEvent(AnalyticsEvent.NATIVE_INTENT_CALLED, hashMap);
    }

    @Override
    public void setPaymentID(String string2) {
        B$$W$.b("setPaymentID called: " + string2);
        this.payment_id = string2;
        AnalyticsUtil.addProperty("payment_id", new AnalyticsProperty(string2, AnalyticsProperty.Scope.PAYMENT));
        AnalyticsUtil.trackEvent(AnalyticsEvent.PAYMENT_ID_ATTACHED);
    }

    @Override
    public void setMerchantOptions(String string2) {
        this.dashOptions = string2;
        try {
            this.dashOptionsJSON = new JSONObject(string2);
        }
        catch (Exception exception) {
            B$$W$.b("Error parsing merchant dash options JSON", exception);
            this.dashOptionsJSON = null;
            AnalyticsUtil.reportError(exception, "critical", exception.getMessage());
        }
        if (this.dashOptionsJSON == null) {
            CheckoutUtils.a((Context)this.activity, this.merchantKey, null);
        } else {
            CheckoutUtils.a((Context)this.activity, this.merchantKey, string2);
        }
    }

    protected void addAnalyticsData(JSONObject jSONObject) {
        AnalyticsUtil.addFilteredPropertiesFromPayload(jSONObject);
    }

    @Override
    public void onSubmit(String string2) {
        if (this.paymentAttempts > 1) {
            AnalyticsUtil.refreshPaymentSession();
        }
        if (this.autoReadOtpHelper != null && this.loginOtpSmsTask.isComplete()) {
            try {
                this.activity.unregisterReceiver((BroadcastReceiver)this.autoReadOtpHelper);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                AnalyticsUtil.reportError(illegalArgumentException, "error", illegalArgumentException.getMessage());
            }
        }
        try {
            String string3;
            JSONObject jSONObject = new JSONObject(string2);
            this.checkoutContent = string2;
            this.addAnalyticsData(jSONObject);
            this.savePrefillData(jSONObject);
            String string4 = jSONObject.getString("method");
            if (Build.VERSION.SDK_INT >= 29 || ActivityCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.RECEIVE_SMS") != 0) {
                if (string4.equalsIgnoreCase("netbanking") || string4.equalsIgnoreCase("card")) {
                    Log.d((String)"SMS", (String)"received method as netbanking");
                    Task task = SmsRetriever.getClient((Activity)this.activity).startSmsUserConsent(null);
                    Log.d((String)"SMS", (String)"task started successfully");
                    AutoReadOtpHelper autoReadOtpHelper = new AutoReadOtpHelper(this.activity);
                    IntentFilter intentFilter = new IntentFilter("com.google.android.gms.auth.api.phone.SMS_RETRIEVED");
                    this.activity.registerReceiver((BroadcastReceiver)autoReadOtpHelper, intentFilter);
                    AnalyticsUtil.trackEvent(AnalyticsEvent.AUTO_READ_OTP_SMS_RETRIEVER_API_TASK);
                }
            } else if (!string4.equals("card") && string4.equals("wallet") && this.checkoutOptions.b(string3 = jSONObject.getString("wallet"))) {
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("external_wallet", (Object)string3);
                AnalyticsUtil.addProperty("external_wallet", new AnalyticsProperty(string3, AnalyticsProperty.Scope.ORDER));
                AnalyticsUtil.trackEvent(AnalyticsEvent.EXTERNAL_WALLET_SELECTED);
                this.onComplete(jSONObject2);
            }
            AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_SUBMIT);
            AnalyticsUtil.postData();
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError(exception, "critical", exception.getMessage());
            B$$W$.b("Error in submit", exception);
        }
    }

    protected void onComplete(JSONObject jSONObject) {
        try {
            if (jSONObject.has("error")) {
                AnalyticsUtil.addProperty("payment_status", new AnalyticsProperty("fail", AnalyticsProperty.Scope.PAYMENT));
                AnalyticsUtil.addProperty("payload", new AnalyticsProperty(jSONObject.toString(), AnalyticsProperty.Scope.PAYMENT));
                AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_PAYMENT_COMPLETE);
                if (this.isTwoWebViewFlow) {
                    this.view.makeWebViewVisible(1);
                }
                this.onError(jSONObject);
            } else if (jSONObject.has("razorpay_fund_account_id")) {
                this.destroyActivity(1, jSONObject.toString());
            } else if (jSONObject.has("razorpay_payment_id")) {
                String string2;
                this.payment_id = string2 = jSONObject.getString("razorpay_payment_id");
                AnalyticsUtil.addProperty("payment_id", new AnalyticsProperty(string2, AnalyticsProperty.Scope.PAYMENT));
                AnalyticsUtil.addProperty("payment_status", new AnalyticsProperty("success", AnalyticsProperty.Scope.PAYMENT));
                AnalyticsUtil.addProperty("payload", new AnalyticsProperty(jSONObject.toString(), AnalyticsProperty.Scope.PAYMENT));
                AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_PAYMENT_COMPLETE);
                this.isPaymentSuccessful = true;
                this.destroyActivity(1, jSONObject.toString());
            } else if (jSONObject.has("external_wallet")) {
                this.destroyActivity(4, jSONObject.toString());
            } else {
                this.destroyActivity(0, "Post payment parsing error");
            }
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError(exception, "critical", exception.getMessage());
            this.destroyActivity(0, exception.getMessage());
        }
        this.isTwoWebViewFlow = false;
    }

    protected void onError(final JSONObject jSONObject) {
        if (this.isTwoWebViewFlow) {
            String string2 = String.format("javascript: window.onComplete(%s)", jSONObject.toString());
            this.view.loadUrl(1, string2);
        } else {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    CheckoutPresenterImpl.this.handleRetry(jSONObject.toString());
                }
            });
        }
    }

    private void handleRetry(String string2) {
        if (CheckoutUtils.a(this.paymentAttempts)) {
            try {
                JSONObject jSONObject = new JSONObject(string2);
                if (jSONObject.has("error")) {
                    string2 = string2 + (this.checkoutUrl.contains("?") ? "&" : "?");
                    if (jSONObject.get("error") instanceof JSONObject) {
                        JSONObject jSONObject2 = (JSONObject)jSONObject.get("error");
                        string2 = string2 + "error=" + jSONObject2.toString();
                    }
                }
                this.helpersReset();
                this.loadForm(string2);
            }
            catch (Exception exception) {
                this.destroyActivity(0, string2);
                AnalyticsUtil.reportError(exception, "critical", exception.getMessage());
            }
        } else {
            this.destroyActivity(0, string2);
        }
    }

    protected void helpersReset() {
        B$$W$.b("helpersReset called");
    }

    private void savePrefillData(JSONObject jSONObject) {
        try {
            if (jSONObject.has("contact")) {
                CheckoutUtils.d((Context)this.activity, jSONObject.getString("contact"));
                this.checkoutOptions.a("contact", jSONObject.getString("contact"));
            }
            if (jSONObject.has("email")) {
                CheckoutUtils.b((Context)this.activity, jSONObject.getString("email"));
                this.checkoutOptions.a("email", jSONObject.getString("email"));
            }
        }
        catch (JSONException jSONException) {
            B$$W$.b("Error parsing JSON", jSONException);
        }
    }

    @Override
    public void onFault(String string2) {
        this.destroyActivity(3, string2);
    }

    @Override
    public void onComplete(String string2) {
        final String string3 = string2;
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    JSONObject jSONObject = new JSONObject(string3);
                    B$$W$.b("oncomplete JavascriptInterface");
                    CheckoutPresenterImpl.this.onComplete(jSONObject);
                }
                catch (Exception exception) {
                    AnalyticsUtil.reportError(exception, "critical", exception.getMessage());
                    CheckoutPresenterImpl.this.destroyActivity(0, exception.getMessage());
                }
            }
        });
    }

    @Override
    public void setDimensions(final int n, final int n2) {
        if (J$_0_.a((Context)this.activity)) {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    WindowManager.LayoutParams layoutParams = CheckoutPresenterImpl.this.activity.getWindow().getAttributes();
                    B$$W$.b("SetDimensions called");
                    B$$W$.b("Height:" + n2);
                    B$$W$.b("Width:" + n);
                    layoutParams.height = J$_0_.a((Context)CheckoutPresenterImpl.this.activity, n2);
                    layoutParams.width = J$_0_.a((Context)CheckoutPresenterImpl.this.activity, n);
                    CheckoutPresenterImpl.this.activity.getWindow().setAttributes(layoutParams);
                }
            });
        }
    }

    @Override
    public void onDismiss() {
        this.destroyActivity(0, BaseUtils.getPaymentCancelledResponse(this.payment_id));
    }

    @Override
    public void onDismiss(String string2) {
        this.destroyActivity(0, string2);
    }

    @Override
    public void requestExtraAnalyticsData() {
        final JSONObject jSONObject = AnalyticsUtil.getExtraAnalyticsPayload();
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    CheckoutPresenterImpl.this.view.loadUrl(1, String.format("javascript: CheckoutBridge.sendExtraAnalyticsData(%s)", jSONObject.toString()));
                }
                catch (Exception exception) {
                    AnalyticsUtil.reportError(exception, "warning", exception.getLocalizedMessage());
                }
            }
        });
    }

    @Override
    public void onError(String string2) {
        try {
            this.onError(new JSONObject(string2));
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError(exception, "critical", exception.getMessage());
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    CheckoutPresenterImpl.this.helpersReset();
                    CheckoutPresenterImpl.this.loadForm("");
                }
            });
        }
    }

    @Override
    public void relay(String string2) {
    }

    @Override
    public void requestOtpPermission() {
    }

    @Override
    public void toast(final String string2, final int n) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                CheckoutPresenterImpl.this.view.showToast(string2, n);
            }
        });
    }

    @Override
    public void showAlertDialog(final String string2, final String string3, final String string4) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                CheckoutUtils.a((Context)CheckoutPresenterImpl.this.activity, string2, string4, string3, new CheckoutUtils.BackButtonDialogCallback(){

                    @Override
                    public void onPositiveButtonClick() {
                        CheckoutPresenterImpl.this.view.loadUrl(1, String.format("javascript: CheckoutBridge.isPositiveButtonClicked({isClicked: %s})", true));
                    }

                    @Override
                    public void onNegativeButtonClick() {
                        CheckoutPresenterImpl.this.view.loadUrl(1, String.format("javascript: CheckoutBridge.isPositiveButtonClicked({isClicked: %s})", false));
                    }
                });
            }
        });
    }

    @Override
    public void sendDataToWebView(final int n, final String string2) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                switch (n) {
                    case 1: {
                        CheckoutPresenterImpl.this.view.loadUrl(1, String.format("javascript: handleRelay(%s)", string2));
                        break;
                    }
                    case 2: {
                        String string22 = String.format("javascript: Magic.handleRelay(%s)", string2);
                        CheckoutPresenterImpl.this.view.loadUrl(2, string22);
                    }
                }
            }
        });
    }

    @Override
    public void checkSmsPermission() {
        this.view.checkSmsPermission();
    }

    @Override
    public void isWebViewSafeOnUI(final int n, final CheckoutBridge.WebViewSafeCheckCallback webViewSafeCheckCallback) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                CheckoutPresenterImpl.this.executeWebViewCallback(n, webViewSafeCheckCallback);
            }
        });
    }

    private void executeWebViewCallback(int n, CheckoutBridge.WebViewSafeCheckCallback webViewSafeCheckCallback) {
        WebView webView = n == 1 ? this.view.getWebView(1) : this.view.getWebView(2);
        String string2 = webView.getTag().toString();
        try {
            URL uRL = new URL(string2);
            String string3 = uRL.getHost();
            if (string3 != null && string3.endsWith("razorpay.com")) {
                webViewSafeCheckCallback.secure();
            } else {
                webViewSafeCheckCallback.unSecure();
            }
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError(exception, "critical", exception.getLocalizedMessage());
            webViewSafeCheckCallback.unSecure();
        }
    }

    @Override
    public void isWebViewSafe(int n, CheckoutBridge.WebViewSafeCheckCallback webViewSafeCheckCallback) {
        this.executeWebViewCallback(n, webViewSafeCheckCallback);
    }

    @Override
    public boolean isUserRegisteredOnUPI(String string2) {
        return BaseUtils.checkUpiRegisteredApp((Context)this.activity, string2);
    }

    @Override
    public boolean isAllowRotation() {
        return this.allowRotation;
    }

    static interface CheckoutView {
        public void loadUrl(int var1, String var2);

        public void loadData(int var1, String var2, String var3, String var4);

        public void loadDataWithBaseURL(int var1, String var2, String var3, String var4, String var5, String var6);

        public void makeWebViewVisible(int var1);

        public boolean isWebViewVisible(int var1);

        public void showToast(String var1, int var2);

        public void destroy(int var1, String var2);

        public void showProgressBar(int var1);

        public void hideProgressBar();

        public void clearWebViewHistory(int var1);

        public WebView getWebView(int var1);

        public void checkSmsPermission();

        public void addJavascriptInterfaceToPrimaryWebview(Object var1, String var2);
    }
}

