/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.util.Base64;
import android.util.Log;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;

public class AppSignatureHelper
extends ContextWrapper {
    public static final String TAG = AppSignatureHelper.class.getSimpleName();
    public static final int NUM_HASHED_BYTES = 9;
    public static final int NUM_BASE64_CHAR = 11;

    public AppSignatureHelper(Context context) {
        super(context);
    }

    public ArrayList<String> getAppSignatures() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string2 = this.getPackageName();
            Signature[] signatureArray = this.getPackageManager().getPackageInfo((String)string2, (int)64).signatures;
            int n = this.getPackageManager().getPackageInfo((String)string2, (int)64).signatures.length;
            for (int i = 0; i < n; ++i) {
                Object object = signatureArray[i];
                if ((object = AppSignatureHelper.Q_$2$(string2, object.toCharsString())) == null) continue;
                ((AbstractCollection)arrayList).add(String.format("%s", object));
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e((String)TAG, (String)"Unable to find package to obtain hash.", (Throwable)nameNotFoundException);
        }
        return arrayList;
    }

    private static String Q_$2$(String string2, String string3) {
        string3 = string2 + " " + string3;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(string3.getBytes(StandardCharsets.UTF_8));
            string3 = Base64.encodeToString((byte[])Arrays.copyOfRange(messageDigest.digest(), 0, 9), (int)3).substring(0, 11);
            Log.d((String)TAG, (String)String.format("pkg: %s -- hash: %s", string2, string3));
            return string3;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.e((String)TAG, (String)"hash:NoSuchAlgorithm", (Throwable)noSuchAlgorithmException);
            return null;
        }
    }
}

