/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.http.SslCertificate;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.webkit.CookieManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.Toast;
import com.razorpay.AnalyticsUtil;
import com.razorpay.I$_n_;
import com.razorpay.J$$A_;
import com.razorpay.J$_0_;
import com.razorpay.L__R$;
import com.razorpay.g__v_;
import com.razorpay.x_$Q_;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.net.ssl.SSLContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import proguard.annotation.Keep;
import proguard.annotation.KeepClassMembers;

@Keep
@KeepClassMembers
public class BaseUtils {
    private static boolean sWebViewDebuggingEnabled = J$_0_.a_$P$;
    private static boolean isCompatibleWithGooglePay = true;

    BaseUtils() {
    }

    static String constructBasicAuth(String string2) throws UnsupportedEncodingException {
        return Base64.encodeToString((byte[])(string2 + ":").getBytes("UTF-8"), (int)2);
    }

    static boolean hasPermission(Context object, String string2) {
        try {
            return 0 == object.checkCallingOrSelfPermission(string2);
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception, "critical", ((Throwable)object).getMessage());
            return false;
        }
    }

    static String getKeyId(Context object) {
        try {
            object = object.getPackageManager().getApplicationInfo(object.getPackageName(), 128);
            if (((PackageItemInfo)object).metaData == null) {
                return null;
            }
            return ((PackageItemInfo)object).metaData.getString("com.razorpay.ApiKey");
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            object = nameNotFoundException;
            AnalyticsUtil.reportError((Exception)((Object)nameNotFoundException), "critical", ((Throwable)object).getMessage());
            return null;
        }
    }

    static HashMap<String, String> getAllPluginsFromManifest(Context object) {
        try {
            object = object.getPackageManager().getApplicationInfo(object.getPackageName(), 128);
            if (((PackageItemInfo)object).metaData == null) {
                return null;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string2 : ((PackageItemInfo)object).metaData.keySet()) {
                if (!string2.contains("com.razorpay.plugin.") || ((PackageItemInfo)object).metaData.getString(string2) == null) continue;
                ((AbstractMap)hashMap).put(string2, ((PackageItemInfo)object).metaData.getString(string2));
            }
            return hashMap;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            object = nameNotFoundException;
            AnalyticsUtil.reportError((Exception)((Object)nameNotFoundException), "critical", ((Throwable)object).getMessage());
            return null;
        }
    }

    private static void setBaseWebViewSettings() {
        if (Build.VERSION.SDK_INT >= 19) {
            WebView.setWebContentsDebuggingEnabled((boolean)sWebViewDebuggingEnabled);
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private static void enableJavaScriptInWebView(WebView webView) {
        webView.getSettings().setJavaScriptEnabled(true);
    }

    static void setWebViewSettings(Context context, WebView webView, boolean bl) {
        BaseUtils.setBaseWebViewSettings();
        BaseUtils.enableJavaScriptInWebView(webView);
        CookieManager.getInstance().setAcceptCookie(true);
        webView.setTag((Object)"");
        WebSettings webSettings = webView.getSettings();
        webSettings.setDomStorageEnabled(true);
        webSettings.setDatabaseEnabled(true);
        webSettings.setTextZoom(100);
        String string2 = context.getApplicationContext().getDir("database", 0).getPath();
        if (Build.VERSION.SDK_INT < 19) {
            webSettings.setDatabasePath(string2);
        }
        if (Build.VERSION.SDK_INT < 24) {
            webSettings.setGeolocationDatabasePath(string2);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            CookieManager.getInstance().setAcceptThirdPartyCookies(webView, true);
        }
        if (bl) {
            webSettings.setCacheMode(2);
        }
        webSettings.setSaveFormData(false);
        webView.addJavascriptInterface((Object)new x_$Q_(context), "StorageBridge");
    }

    static boolean hasFeature(Context context, String string2) {
        return context.getPackageManager().hasSystemFeature(string2);
    }

    public static <T> T getSystemService(Context context, String string2) {
        return (T)context.getApplicationContext().getSystemService(string2);
    }

    public static String getDeviceId(Context object) {
        String string2 = Settings.Secure.getString((ContentResolver)object.getContentResolver(), (String)"android_id");
        if (!(AnalyticsUtil.isNullOrEmpty(string2) || "9774d56d682e549c".equals(string2) || "unknown".equals(string2) || "000000000000000".equals(string2))) {
            return string2;
        }
        if (!AnalyticsUtil.isNullOrEmpty(Build.SERIAL)) {
            return Build.SERIAL;
        }
        if (BaseUtils.hasPermission(object, "android.permission.READ_PHONE_STATE") && BaseUtils.hasFeature(object, "android.hardware.telephony") && !AnalyticsUtil.isNullOrEmpty((CharSequence)(object = ((TelephonyManager)BaseUtils.getSystemService(object, "phone")).getDeviceId()))) {
            return object;
        }
        return ((Object)UUID.randomUUID()).toString();
    }

    static int getNetworkType(Context object) {
        J$$A_ j$$A_ = BaseUtils.getDataNetworkType((Context)object);
        if (j$$A_ == J$$A_.G__G_) {
            return 0;
        }
        if (j$$A_ == J$$A_.Q_$2$) {
            return 1;
        }
        if (j$$A_ == J$$A_.d__1_) {
            if (((String)(object = BaseUtils.getCellularNetworkType((Context)object))).equalsIgnoreCase("2G")) {
                return 2;
            }
            if (((String)object).equalsIgnoreCase("3G")) {
                return 3;
            }
            if (((String)object).equalsIgnoreCase("4G")) {
                return 4;
            }
        }
        return -1;
    }

    public static String getCellularNetworkType(Context context) {
        try {
            switch (((TelephonyManager)context.getSystemService("phone")).getNetworkType()) {
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: {
                    return "2G";
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: {
                    return "3G";
                }
                case 13: {
                    return "4G";
                }
            }
            return "NA";
        }
        catch (Exception exception) {
            return "NA";
        }
    }

    public static String getCellularNetworkProviderName(Context context) {
        if ((context = (TelephonyManager)BaseUtils.getSystemService(context, "phone")) != null) {
            return context.getNetworkOperatorName();
        }
        return "unknown";
    }

    public static J$$A_ getDataNetworkType(Context context) {
        if (BaseUtils.hasPermission(context, "android.permission.ACCESS_NETWORK_STATE") && (context = (ConnectivityManager)BaseUtils.getSystemService(context, "connectivity")) != null) {
            NetworkInfo networkInfo = context.getNetworkInfo(1);
            if (networkInfo != null && networkInfo.isConnected()) {
                return J$$A_.G__G_;
            }
            networkInfo = context.getNetworkInfo(7);
            if (networkInfo != null && networkInfo.isConnected()) {
                return J$$A_.Q_$2$;
            }
            if ((context = context.getNetworkInfo(0)) != null && context.isConnected()) {
                return J$$A_.d__1_;
            }
        }
        return J$$A_.R$$r_;
    }

    public static String getLocale() {
        return Locale.getDefault().getLanguage() + "-" + Locale.getDefault().getCountry();
    }

    static ArrayList<String> jsonStringArrayToArrayList(JSONArray jSONArray) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            ((AbstractCollection)arrayList).add(jSONArray.getString(i));
        }
        return arrayList;
    }

    static String getAppBuildType(Context context) {
        if (0 != (context.getApplicationInfo().flags & 2)) {
            return "development";
        }
        return "production";
    }

    public static CharSequence getWebViewUserAgent(Context context) {
        return AnalyticsUtil.returnUndefinedIfNull(new WebView(context).getSettings().getUserAgentString());
    }

    static boolean isDeviceHaveCorrectTlsVersion() {
        try {
            String[] stringArray = SSLContext.getDefault().getDefaultSSLParameters().getProtocols();
            if (stringArray == null) {
                return false;
            }
            for (String string2 : stringArray) {
                if (!string2.startsWith("TLS") || string2.equalsIgnoreCase("TLSv1")) continue;
                return true;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        return false;
    }

    static void setup() {
        AnalyticsUtil.reset();
    }

    public static double round(double d, int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        return ((Number)new BigDecimal(d).setScale(n, RoundingMode.HALF_UP)).doubleValue();
    }

    public static String nanoTimeToSecondsString(long l, int n) {
        return String.valueOf(BaseUtils.round((double)l / 1.0E9, n));
    }

    static boolean isMerchantAppDebuggable(Context context) {
        return 0 != (context.getApplicationInfo().flags & 2);
    }

    static Certificate getX509Certificate(SslCertificate object) {
        byte[] byArray = SslCertificate.saveState((SslCertificate)object).getByteArray("x509-certificate");
        object = byArray;
        if (byArray == null) {
            return null;
        }
        try {
            return CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream((byte[])object));
        }
        catch (CertificateException certificateException) {
            return null;
        }
    }

    static PublicKey constructPublicKey(String object) {
        try {
            object = Base64.decode((byte[])((String)object).getBytes(), (int)0);
            object = new X509EncodedKeySpec((byte[])object);
            return KeyFactory.getInstance("RSA").generatePublic((KeySpec)object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Boolean isUserRegisteredOnTruePay(Context object) {
        try {
            return object.getPackageManager().getComponentEnabledSetting(new ComponentName("com.truecaller", "com.truecaller.truepay.UserRegistered")) == 1;
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            AnalyticsUtil.reportError((Exception)object, "error", ((Throwable)object).getMessage());
            return Boolean.FALSE;
        }
    }

    static boolean checkUpiRegisteredApp(Context context, String string2) {
        int n = -1;
        switch (string2.hashCode()) {
            case -1974907610: {
                if (!string2.equals("com.truecaller")) break;
                n = 0;
                break;
            }
            case 1170339061: {
                if (!string2.equals("com.google.android.apps.nbu.paisa.user")) break;
                n = 1;
            }
        }
        switch (n) {
            case 0: {
                return BaseUtils.isUserRegisteredOnTruePay(context);
            }
            case 1: {
                return isCompatibleWithGooglePay;
            }
        }
        return true;
    }

    static HashSet<String> getSetOfPackageNamesSupportingUpi(Context context) {
        Object object = BaseUtils.getListOfAppsWhichHandleDeepLink(context, "upi://pay");
        HashSet<String> hashSet = new HashSet<String>();
        if (object != null && object.size() > 0) {
            object = object.iterator();
            while (object.hasNext()) {
                ResolveInfo resolveInfo = (ResolveInfo)object.next();
                try {
                    ((AbstractCollection)hashSet).add(resolveInfo.activityInfo.packageName);
                }
                catch (Exception exception) {}
            }
        }
        if (((AbstractCollection)hashSet).size() > 0 && !BaseUtils.checkUpiRegisteredApp(context, "com.google.android.apps.nbu.paisa.user")) {
            ((AbstractCollection)hashSet).remove("com.google.android.apps.nbu.paisa.user");
        }
        if (((AbstractCollection)hashSet).size() > 0 && !BaseUtils.checkUpiRegisteredApp(context, "com.truecaller")) {
            ((AbstractCollection)hashSet).remove("com.truecaller");
        }
        return hashSet;
    }

    static List<ResolveInfo> getListOfAppsWhichHandleDeepLink(Context context, String string2) {
        Intent intent = new Intent();
        intent.setData(Uri.parse((String)string2));
        return context.getPackageManager().queryIntentActivities(intent, 131072);
    }

    static String getAppNameOfResolveInfo(ResolveInfo resolveInfo, Context context) throws Exception {
        return BaseUtils.getAppNameOfPackageName(resolveInfo.activityInfo.packageName, context);
    }

    static void startActivityForResult(String string2, String string3, Activity activity) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)string2));
        if (string3 != null && string3.length() > 0) {
            intent.setPackage(string3);
        }
        activity.startActivityForResult(intent, 99);
    }

    static JSONObject getJSONFromIntentData(Intent intent) {
        JSONObject jSONObject = new JSONObject();
        if (intent != null && (intent = intent.getExtras()) != null) {
            for (String string2 : intent.keySet()) {
                try {
                    jSONObject.put(string2, intent.get(string2));
                }
                catch (JSONException jSONException) {}
            }
        }
        return jSONObject;
    }

    static String getBase64FromOtherAppsResource(Context context, String string2) {
        context = context.getPackageManager();
        try {
            string2 = context.getApplicationInfo(string2, 128);
            context = context.getResourcesForApplication((ApplicationInfo)string2);
            int n = ((PackageItemInfo)string2).icon;
            return BaseUtils.getBase64FromResource((Resources)context, n);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return null;
        }
    }

    static String getAppNameOfPackageName(String string2, Context object) throws Exception {
        try {
            object = object.getPackageManager();
            string2 = object.getApplicationInfo(string2, 128);
            int n = ((PackageItemInfo)string2).labelRes;
            object = object.getResourcesForApplication((ApplicationInfo)string2);
            if (n == 0) {
                return ((PackageItemInfo)string2).nonLocalizedLabel.toString();
            }
            return object.getString(n);
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            throw object;
        }
    }

    static String getBase64FromResource(Resources object, int n) {
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)object, (int)n);
        if (bitmap == null && (object = object.getDrawable(n)) != null) {
            if (object instanceof BitmapDrawable) {
                bitmap = ((BitmapDrawable)object).getBitmap();
            } else {
                bitmap = Bitmap.createBitmap((int)object.getIntrinsicWidth(), (int)object.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                object.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
                object.draw(canvas);
            }
        }
        if (bitmap != null) {
            object = "data:image/png;base64,";
            Object object2 = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)object2);
            object2 = ((ByteArrayOutputStream)object2).toByteArray();
            return (String)object + Base64.encodeToString((byte[])object2, (int)2);
        }
        return null;
    }

    static Object getJsonValue(String object, JSONObject jSONObject, Object object2) {
        if ((object = BaseUtils.getJsonValue(((String)object).split("\\."), (Object)jSONObject, 0)) != null) {
            return object;
        }
        return object2;
    }

    private static Object getJsonValue(String[] stringArray, Object object, int n) {
        while (true) {
            if (n == stringArray.length) {
                return object;
            }
            String string2 = stringArray[n];
            if (object instanceof JSONObject) {
                object = (JSONObject)object;
                ++n;
                object = object.opt(string2);
                continue;
            }
            if (!(object instanceof JSONArray)) break;
            object = (JSONArray)object;
            if (!TextUtils.isDigitsOnly((CharSequence)string2)) break;
            int n2 = Integer.parseInt(string2);
            ++n;
            object = object.opt(n2);
        }
        return null;
    }

    static String getRandomString() {
        SecureRandom secureRandom = new SecureRandom();
        return new BigInteger(130, secureRandom).toString(32);
    }

    public static String getFileFromInternal(Activity object, String string2, String charSequence) throws Exception {
        string2 = BaseUtils.getVersionedAssetName(BaseUtils.getLocalVersion((Activity)object, (String)charSequence).toString(), string2);
        object = object.openFileInput(string2);
        object = new BufferedReader(new InputStreamReader((InputStream)object, "UTF-8"));
        charSequence = new StringBuilder();
        while ((string2 = ((BufferedReader)object).readLine()) != null) {
            ((StringBuilder)charSequence).append(string2);
        }
        ((Reader)object).close();
        return BaseUtils.decryptFile(charSequence.toString());
    }

    static String decryptFile(String string2) {
        try {
            L__R$ l__R$ = new L__R$();
            Object object = "";
            Object object2 = MessageDigest.getInstance("SHA-256");
            ((MessageDigest)object2).update(((String)object).getBytes("UTF-8"));
            object = ((MessageDigest)object2).digest();
            object2 = new StringBuffer();
            for (Object object3 : object) {
                ((StringBuffer)object2).append(String.format("%02x", (byte)object3));
            }
            object = 32 > object2.toString().length() ? object2.toString() : object2.toString().substring(0, 32);
            return l__R$.G__G_(string2, (String)object, "");
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            AnalyticsUtil.reportError(exception, "error", "Unable to decrypt file");
            exception2.getMessage();
            return null;
        }
    }

    static String getVersionedAssetName(String string2, String string3) {
        string2 = string2.replaceAll("\\.", "-");
        return string2 + "-" + string3;
    }

    public static String getLocalVersion(Activity object, String string2) {
        if ((object = I$_n_.d__1_((Context)object, string2)) == null) {
            object = BaseUtils.getVersionFromJsonString("{\n  \"hash\" : \"16565edfe9c329601df37b0b192dc37d\",\n  \"magic_hash\": \"2857cecd8038a38d3ebb5adcb6920738\"\n}\n", string2);
        }
        return object;
    }

    public static String getVersionFromJsonString(String string2, String string3) {
        try {
            string2 = new JSONObject(string2);
            if (string3.equalsIgnoreCase("otpelf_version")) {
                return string2.getString("hash");
            }
            if (string3.equalsIgnoreCase("magic_version")) {
                return string2.getString("magic_hash");
            }
        }
        catch (Exception exception) {}
        return null;
    }

    static void updateLocalVersion(Activity activity, String string2, String string3) {
        I$_n_.G__G_((Context)activity, string2, string3);
    }

    static boolean storeFileInInternal(Activity object, String string2, String string3) {
        try {
            object = object.openFileOutput(string2, 0);
            ((OutputStream)object).write(string3.getBytes());
            ((OutputStream)object).close();
            return true;
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError(exception, "error", "Error in saving file: ".concat(String.valueOf(string2)));
            return false;
        }
    }

    static void checkForLatestVersion(Context context, int n) {
        if (g__v_.f$_G$().B$$W$() && BaseUtils.isMerchantAppDebuggable(context) && n < g__v_.f$_G$().E$_j$()) {
            String string2 = g__v_.f$_G$().b__J_();
            Toast.makeText((Context)context, (CharSequence)string2, (int)1).show();
        }
    }

    static int dpToPixels(Context context, int n) {
        context = context.getResources();
        return (int)TypedValue.applyDimension((int)1, (float)n, (DisplayMetrics)context.getDisplayMetrics());
    }

    static int getDisplayWidth(Activity activity) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.widthPixels;
    }

    static int getDisplayHeight(Activity activity) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.heightPixels;
    }

    static HashMap<String, String> getMapFromJSONObject(JSONObject jSONObject) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                String string3 = jSONObject.getString(string2);
                ((AbstractMap)hashMap).put(string2, string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashMap;
    }

    static void setCompatibleWithGooglePay(boolean bl) {
        isCompatibleWithGooglePay = bl;
    }

    static String makeUrlEncodedPayload(JSONObject jSONObject) throws JSONException {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = jSONObject.getString(string2);
            stringBuilder.append(String.format("%s=%s&", string2, Uri.encode((String)string3)));
        }
        StringBuilder stringBuilder2 = stringBuilder;
        return ((Object)stringBuilder2.deleteCharAt(stringBuilder2.length() - 1)).toString();
    }
}

